/**
 * This file was auto-generated by Fern from our API Definition.
 */

package com.langfuse.client.resources.projects.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.langfuse.client.core.ObjectMappers;
import java.lang.Object;
import java.lang.String;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(
    builder = CreateApiKeyRequest.Builder.class
)
public final class CreateApiKeyRequest {
  private final Optional<String> note;

  private final Map<String, Object> additionalProperties;

  private CreateApiKeyRequest(Optional<String> note, Map<String, Object> additionalProperties) {
    this.note = note;
    this.additionalProperties = additionalProperties;
  }

  /**
   * @return Optional note for the API key
   */
  @JsonProperty("note")
  public Optional<String> getNote() {
    return note;
  }

  @java.lang.Override
  public boolean equals(Object other) {
    if (this == other) return true;
    return other instanceof CreateApiKeyRequest && equalTo((CreateApiKeyRequest) other);
  }

  @JsonAnyGetter
  public Map<String, Object> getAdditionalProperties() {
    return this.additionalProperties;
  }

  private boolean equalTo(CreateApiKeyRequest other) {
    return note.equals(other.note);
  }

  @java.lang.Override
  public int hashCode() {
    return Objects.hash(this.note);
  }

  @java.lang.Override
  public String toString() {
    return ObjectMappers.stringify(this);
  }

  public static Builder builder() {
    return new Builder();
  }

  @JsonIgnoreProperties(
      ignoreUnknown = true
  )
  public static final class Builder {
    private Optional<String> note = Optional.empty();

    @JsonAnySetter
    private Map<String, Object> additionalProperties = new HashMap<>();

    private Builder() {
    }

    public Builder from(CreateApiKeyRequest other) {
      note(other.getNote());
      return this;
    }

    @JsonSetter(
        value = "note",
        nulls = Nulls.SKIP
    )
    public Builder note(Optional<String> note) {
      this.note = note;
      return this;
    }

    public Builder note(String note) {
      this.note = Optional.ofNullable(note);
      return this;
    }

    public CreateApiKeyRequest build() {
      return new CreateApiKeyRequest(note, additionalProperties);
    }
  }
}
