/**
 * This file was auto-generated by Fern from our API Definition.
 */

package com.langfuse.client.resources.projects.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.langfuse.client.core.ObjectMappers;
import java.lang.Object;
import java.lang.String;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(
    builder = ApiKeyList.Builder.class
)
public final class ApiKeyList {
  private final List<ApiKeySummary> apiKeys;

  private final Map<String, Object> additionalProperties;

  private ApiKeyList(List<ApiKeySummary> apiKeys, Map<String, Object> additionalProperties) {
    this.apiKeys = apiKeys;
    this.additionalProperties = additionalProperties;
  }

  @JsonProperty("apiKeys")
  public List<ApiKeySummary> getApiKeys() {
    return apiKeys;
  }

  @java.lang.Override
  public boolean equals(Object other) {
    if (this == other) return true;
    return other instanceof ApiKeyList && equalTo((ApiKeyList) other);
  }

  @JsonAnyGetter
  public Map<String, Object> getAdditionalProperties() {
    return this.additionalProperties;
  }

  private boolean equalTo(ApiKeyList other) {
    return apiKeys.equals(other.apiKeys);
  }

  @java.lang.Override
  public int hashCode() {
    return Objects.hash(this.apiKeys);
  }

  @java.lang.Override
  public String toString() {
    return ObjectMappers.stringify(this);
  }

  public static Builder builder() {
    return new Builder();
  }

  @JsonIgnoreProperties(
      ignoreUnknown = true
  )
  public static final class Builder {
    private List<ApiKeySummary> apiKeys = new ArrayList<>();

    @JsonAnySetter
    private Map<String, Object> additionalProperties = new HashMap<>();

    private Builder() {
    }

    public Builder from(ApiKeyList other) {
      apiKeys(other.getApiKeys());
      return this;
    }

    @JsonSetter(
        value = "apiKeys",
        nulls = Nulls.SKIP
    )
    public Builder apiKeys(List<ApiKeySummary> apiKeys) {
      this.apiKeys.clear();
      this.apiKeys.addAll(apiKeys);
      return this;
    }

    public Builder addApiKeys(ApiKeySummary apiKeys) {
      this.apiKeys.add(apiKeys);
      return this;
    }

    public Builder addAllApiKeys(List<ApiKeySummary> apiKeys) {
      this.apiKeys.addAll(apiKeys);
      return this;
    }

    public ApiKeyList build() {
      return new ApiKeyList(apiKeys, additionalProperties);
    }
  }
}
