/**
 * This file was auto-generated by Fern from our API Definition.
 */

package com.langfuse.client.resources.projects.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.langfuse.client.core.ObjectMappers;
import java.lang.Integer;
import java.lang.Object;
import java.lang.String;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(
    builder = Project.Builder.class
)
public final class Project {
  private final String id;

  private final String name;

  private final Map<String, Object> metadata;

  private final Optional<Integer> retentionDays;

  private final Map<String, Object> additionalProperties;

  private Project(String id, String name, Map<String, Object> metadata,
      Optional<Integer> retentionDays, Map<String, Object> additionalProperties) {
    this.id = id;
    this.name = name;
    this.metadata = metadata;
    this.retentionDays = retentionDays;
    this.additionalProperties = additionalProperties;
  }

  @JsonProperty("id")
  public String getId() {
    return id;
  }

  @JsonProperty("name")
  public String getName() {
    return name;
  }

  /**
   * @return Metadata for the project
   */
  @JsonProperty("metadata")
  public Map<String, Object> getMetadata() {
    return metadata;
  }

  /**
   * @return Number of days to retain data. Null or 0 means no retention. Omitted if no retention is configured.
   */
  @JsonProperty("retentionDays")
  public Optional<Integer> getRetentionDays() {
    return retentionDays;
  }

  @java.lang.Override
  public boolean equals(Object other) {
    if (this == other) return true;
    return other instanceof Project && equalTo((Project) other);
  }

  @JsonAnyGetter
  public Map<String, Object> getAdditionalProperties() {
    return this.additionalProperties;
  }

  private boolean equalTo(Project other) {
    return id.equals(other.id) && name.equals(other.name) && metadata.equals(other.metadata) && retentionDays.equals(other.retentionDays);
  }

  @java.lang.Override
  public int hashCode() {
    return Objects.hash(this.id, this.name, this.metadata, this.retentionDays);
  }

  @java.lang.Override
  public String toString() {
    return ObjectMappers.stringify(this);
  }

  public static IdStage builder() {
    return new Builder();
  }

  public interface IdStage {
    NameStage id(@NotNull String id);

    Builder from(Project other);
  }

  public interface NameStage {
    _FinalStage name(@NotNull String name);
  }

  public interface _FinalStage {
    Project build();

    _FinalStage metadata(Map<String, Object> metadata);

    _FinalStage putAllMetadata(Map<String, Object> metadata);

    _FinalStage metadata(String key, Object value);

    _FinalStage retentionDays(Optional<Integer> retentionDays);

    _FinalStage retentionDays(Integer retentionDays);
  }

  @JsonIgnoreProperties(
      ignoreUnknown = true
  )
  public static final class Builder implements IdStage, NameStage, _FinalStage {
    private String id;

    private String name;

    private Optional<Integer> retentionDays = Optional.empty();

    private Map<String, Object> metadata = new LinkedHashMap<>();

    @JsonAnySetter
    private Map<String, Object> additionalProperties = new HashMap<>();

    private Builder() {
    }

    @java.lang.Override
    public Builder from(Project other) {
      id(other.getId());
      name(other.getName());
      metadata(other.getMetadata());
      retentionDays(other.getRetentionDays());
      return this;
    }

    @java.lang.Override
    @JsonSetter("id")
    public NameStage id(@NotNull String id) {
      this.id = Objects.requireNonNull(id, "id must not be null");
      return this;
    }

    @java.lang.Override
    @JsonSetter("name")
    public _FinalStage name(@NotNull String name) {
      this.name = Objects.requireNonNull(name, "name must not be null");
      return this;
    }

    /**
     * <p>Number of days to retain data. Null or 0 means no retention. Omitted if no retention is configured.</p>
     * @return Reference to {@code this} so that method calls can be chained together.
     */
    @java.lang.Override
    public _FinalStage retentionDays(Integer retentionDays) {
      this.retentionDays = Optional.ofNullable(retentionDays);
      return this;
    }

    @java.lang.Override
    @JsonSetter(
        value = "retentionDays",
        nulls = Nulls.SKIP
    )
    public _FinalStage retentionDays(Optional<Integer> retentionDays) {
      this.retentionDays = retentionDays;
      return this;
    }

    /**
     * <p>Metadata for the project</p>
     * @return Reference to {@code this} so that method calls can be chained together.
     */
    @java.lang.Override
    public _FinalStage metadata(String key, Object value) {
      this.metadata.put(key, value);
      return this;
    }

    /**
     * <p>Metadata for the project</p>
     * @return Reference to {@code this} so that method calls can be chained together.
     */
    @java.lang.Override
    public _FinalStage putAllMetadata(Map<String, Object> metadata) {
      this.metadata.putAll(metadata);
      return this;
    }

    @java.lang.Override
    @JsonSetter(
        value = "metadata",
        nulls = Nulls.SKIP
    )
    public _FinalStage metadata(Map<String, Object> metadata) {
      this.metadata.clear();
      this.metadata.putAll(metadata);
      return this;
    }

    @java.lang.Override
    public Project build() {
      return new Project(id, name, metadata, retentionDays, additionalProperties);
    }
  }
}
