/**
 * This file was auto-generated by Fern from our API Definition.
 */

package com.langfuse.client.resources.prompts.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.langfuse.client.core.ObjectMappers;
import java.lang.Integer;
import java.lang.Object;
import java.lang.String;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(
    builder = PromptMeta.Builder.class
)
public final class PromptMeta {
  private final String name;

  private final List<Integer> versions;

  private final List<String> labels;

  private final List<String> tags;

  private final OffsetDateTime lastUpdatedAt;

  private final Object lastConfig;

  private final Map<String, Object> additionalProperties;

  private PromptMeta(String name, List<Integer> versions, List<String> labels, List<String> tags,
      OffsetDateTime lastUpdatedAt, Object lastConfig, Map<String, Object> additionalProperties) {
    this.name = name;
    this.versions = versions;
    this.labels = labels;
    this.tags = tags;
    this.lastUpdatedAt = lastUpdatedAt;
    this.lastConfig = lastConfig;
    this.additionalProperties = additionalProperties;
  }

  @JsonProperty("name")
  public String getName() {
    return name;
  }

  @JsonProperty("versions")
  public List<Integer> getVersions() {
    return versions;
  }

  @JsonProperty("labels")
  public List<String> getLabels() {
    return labels;
  }

  @JsonProperty("tags")
  public List<String> getTags() {
    return tags;
  }

  @JsonProperty("lastUpdatedAt")
  public OffsetDateTime getLastUpdatedAt() {
    return lastUpdatedAt;
  }

  /**
   * @return Config object of the most recent prompt version that matches the filters (if any are provided)
   */
  @JsonProperty("lastConfig")
  public Object getLastConfig() {
    return lastConfig;
  }

  @java.lang.Override
  public boolean equals(Object other) {
    if (this == other) return true;
    return other instanceof PromptMeta && equalTo((PromptMeta) other);
  }

  @JsonAnyGetter
  public Map<String, Object> getAdditionalProperties() {
    return this.additionalProperties;
  }

  private boolean equalTo(PromptMeta other) {
    return name.equals(other.name) && versions.equals(other.versions) && labels.equals(other.labels) && tags.equals(other.tags) && lastUpdatedAt.equals(other.lastUpdatedAt) && lastConfig.equals(other.lastConfig);
  }

  @java.lang.Override
  public int hashCode() {
    return Objects.hash(this.name, this.versions, this.labels, this.tags, this.lastUpdatedAt, this.lastConfig);
  }

  @java.lang.Override
  public String toString() {
    return ObjectMappers.stringify(this);
  }

  public static NameStage builder() {
    return new Builder();
  }

  public interface NameStage {
    LastUpdatedAtStage name(@NotNull String name);

    Builder from(PromptMeta other);
  }

  public interface LastUpdatedAtStage {
    LastConfigStage lastUpdatedAt(@NotNull OffsetDateTime lastUpdatedAt);
  }

  public interface LastConfigStage {
    _FinalStage lastConfig(Object lastConfig);
  }

  public interface _FinalStage {
    PromptMeta build();

    _FinalStage versions(List<Integer> versions);

    _FinalStage addVersions(Integer versions);

    _FinalStage addAllVersions(List<Integer> versions);

    _FinalStage labels(List<String> labels);

    _FinalStage addLabels(String labels);

    _FinalStage addAllLabels(List<String> labels);

    _FinalStage tags(List<String> tags);

    _FinalStage addTags(String tags);

    _FinalStage addAllTags(List<String> tags);
  }

  @JsonIgnoreProperties(
      ignoreUnknown = true
  )
  public static final class Builder implements NameStage, LastUpdatedAtStage, LastConfigStage, _FinalStage {
    private String name;

    private OffsetDateTime lastUpdatedAt;

    private Object lastConfig;

    private List<String> tags = new ArrayList<>();

    private List<String> labels = new ArrayList<>();

    private List<Integer> versions = new ArrayList<>();

    @JsonAnySetter
    private Map<String, Object> additionalProperties = new HashMap<>();

    private Builder() {
    }

    @java.lang.Override
    public Builder from(PromptMeta other) {
      name(other.getName());
      versions(other.getVersions());
      labels(other.getLabels());
      tags(other.getTags());
      lastUpdatedAt(other.getLastUpdatedAt());
      lastConfig(other.getLastConfig());
      return this;
    }

    @java.lang.Override
    @JsonSetter("name")
    public LastUpdatedAtStage name(@NotNull String name) {
      this.name = Objects.requireNonNull(name, "name must not be null");
      return this;
    }

    @java.lang.Override
    @JsonSetter("lastUpdatedAt")
    public LastConfigStage lastUpdatedAt(@NotNull OffsetDateTime lastUpdatedAt) {
      this.lastUpdatedAt = Objects.requireNonNull(lastUpdatedAt, "lastUpdatedAt must not be null");
      return this;
    }

    /**
     * <p>Config object of the most recent prompt version that matches the filters (if any are provided)</p>
     * @return Reference to {@code this} so that method calls can be chained together.
     */
    @java.lang.Override
    @JsonSetter("lastConfig")
    public _FinalStage lastConfig(Object lastConfig) {
      this.lastConfig = lastConfig;
      return this;
    }

    @java.lang.Override
    public _FinalStage addAllTags(List<String> tags) {
      this.tags.addAll(tags);
      return this;
    }

    @java.lang.Override
    public _FinalStage addTags(String tags) {
      this.tags.add(tags);
      return this;
    }

    @java.lang.Override
    @JsonSetter(
        value = "tags",
        nulls = Nulls.SKIP
    )
    public _FinalStage tags(List<String> tags) {
      this.tags.clear();
      this.tags.addAll(tags);
      return this;
    }

    @java.lang.Override
    public _FinalStage addAllLabels(List<String> labels) {
      this.labels.addAll(labels);
      return this;
    }

    @java.lang.Override
    public _FinalStage addLabels(String labels) {
      this.labels.add(labels);
      return this;
    }

    @java.lang.Override
    @JsonSetter(
        value = "labels",
        nulls = Nulls.SKIP
    )
    public _FinalStage labels(List<String> labels) {
      this.labels.clear();
      this.labels.addAll(labels);
      return this;
    }

    @java.lang.Override
    public _FinalStage addAllVersions(List<Integer> versions) {
      this.versions.addAll(versions);
      return this;
    }

    @java.lang.Override
    public _FinalStage addVersions(Integer versions) {
      this.versions.add(versions);
      return this;
    }

    @java.lang.Override
    @JsonSetter(
        value = "versions",
        nulls = Nulls.SKIP
    )
    public _FinalStage versions(List<Integer> versions) {
      this.versions.clear();
      this.versions.addAll(versions);
      return this;
    }

    @java.lang.Override
    public PromptMeta build() {
      return new PromptMeta(name, versions, labels, tags, lastUpdatedAt, lastConfig, additionalProperties);
    }
  }
}
