/**
 * This file was auto-generated by Fern from our API Definition.
 */

package com.langfuse.client.resources.scim.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.langfuse.client.core.ObjectMappers;
import java.lang.Object;
import java.lang.String;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(
    builder = BulkConfig.Builder.class
)
public final class BulkConfig {
  private final boolean supported;

  private final int maxOperations;

  private final int maxPayloadSize;

  private final Map<String, Object> additionalProperties;

  private BulkConfig(boolean supported, int maxOperations, int maxPayloadSize,
      Map<String, Object> additionalProperties) {
    this.supported = supported;
    this.maxOperations = maxOperations;
    this.maxPayloadSize = maxPayloadSize;
    this.additionalProperties = additionalProperties;
  }

  @JsonProperty("supported")
  public boolean getSupported() {
    return supported;
  }

  @JsonProperty("maxOperations")
  public int getMaxOperations() {
    return maxOperations;
  }

  @JsonProperty("maxPayloadSize")
  public int getMaxPayloadSize() {
    return maxPayloadSize;
  }

  @java.lang.Override
  public boolean equals(Object other) {
    if (this == other) return true;
    return other instanceof BulkConfig && equalTo((BulkConfig) other);
  }

  @JsonAnyGetter
  public Map<String, Object> getAdditionalProperties() {
    return this.additionalProperties;
  }

  private boolean equalTo(BulkConfig other) {
    return supported == other.supported && maxOperations == other.maxOperations && maxPayloadSize == other.maxPayloadSize;
  }

  @java.lang.Override
  public int hashCode() {
    return Objects.hash(this.supported, this.maxOperations, this.maxPayloadSize);
  }

  @java.lang.Override
  public String toString() {
    return ObjectMappers.stringify(this);
  }

  public static SupportedStage builder() {
    return new Builder();
  }

  public interface SupportedStage {
    MaxOperationsStage supported(boolean supported);

    Builder from(BulkConfig other);
  }

  public interface MaxOperationsStage {
    MaxPayloadSizeStage maxOperations(int maxOperations);
  }

  public interface MaxPayloadSizeStage {
    _FinalStage maxPayloadSize(int maxPayloadSize);
  }

  public interface _FinalStage {
    BulkConfig build();
  }

  @JsonIgnoreProperties(
      ignoreUnknown = true
  )
  public static final class Builder implements SupportedStage, MaxOperationsStage, MaxPayloadSizeStage, _FinalStage {
    private boolean supported;

    private int maxOperations;

    private int maxPayloadSize;

    @JsonAnySetter
    private Map<String, Object> additionalProperties = new HashMap<>();

    private Builder() {
    }

    @java.lang.Override
    public Builder from(BulkConfig other) {
      supported(other.getSupported());
      maxOperations(other.getMaxOperations());
      maxPayloadSize(other.getMaxPayloadSize());
      return this;
    }

    @java.lang.Override
    @JsonSetter("supported")
    public MaxOperationsStage supported(boolean supported) {
      this.supported = supported;
      return this;
    }

    @java.lang.Override
    @JsonSetter("maxOperations")
    public MaxPayloadSizeStage maxOperations(int maxOperations) {
      this.maxOperations = maxOperations;
      return this;
    }

    @java.lang.Override
    @JsonSetter("maxPayloadSize")
    public _FinalStage maxPayloadSize(int maxPayloadSize) {
      this.maxPayloadSize = maxPayloadSize;
      return this;
    }

    @java.lang.Override
    public BulkConfig build() {
      return new BulkConfig(supported, maxOperations, maxPayloadSize, additionalProperties);
    }
  }
}
