/**
 * This file was auto-generated by Fern from our API Definition.
 */

package com.langfuse.client.resources.scim.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.langfuse.client.core.ObjectMappers;
import java.lang.Object;
import java.lang.String;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(
    builder = ResourceTypesResponse.Builder.class
)
public final class ResourceTypesResponse {
  private final List<String> schemas;

  private final int totalResults;

  private final List<ResourceType> resources;

  private final Map<String, Object> additionalProperties;

  private ResourceTypesResponse(List<String> schemas, int totalResults,
      List<ResourceType> resources, Map<String, Object> additionalProperties) {
    this.schemas = schemas;
    this.totalResults = totalResults;
    this.resources = resources;
    this.additionalProperties = additionalProperties;
  }

  @JsonProperty("schemas")
  public List<String> getSchemas() {
    return schemas;
  }

  @JsonProperty("totalResults")
  public int getTotalResults() {
    return totalResults;
  }

  @JsonProperty("Resources")
  public List<ResourceType> getResources() {
    return resources;
  }

  @java.lang.Override
  public boolean equals(Object other) {
    if (this == other) return true;
    return other instanceof ResourceTypesResponse && equalTo((ResourceTypesResponse) other);
  }

  @JsonAnyGetter
  public Map<String, Object> getAdditionalProperties() {
    return this.additionalProperties;
  }

  private boolean equalTo(ResourceTypesResponse other) {
    return schemas.equals(other.schemas) && totalResults == other.totalResults && resources.equals(other.resources);
  }

  @java.lang.Override
  public int hashCode() {
    return Objects.hash(this.schemas, this.totalResults, this.resources);
  }

  @java.lang.Override
  public String toString() {
    return ObjectMappers.stringify(this);
  }

  public static TotalResultsStage builder() {
    return new Builder();
  }

  public interface TotalResultsStage {
    _FinalStage totalResults(int totalResults);

    Builder from(ResourceTypesResponse other);
  }

  public interface _FinalStage {
    ResourceTypesResponse build();

    _FinalStage schemas(List<String> schemas);

    _FinalStage addSchemas(String schemas);

    _FinalStage addAllSchemas(List<String> schemas);

    _FinalStage resources(List<ResourceType> resources);

    _FinalStage addResources(ResourceType resources);

    _FinalStage addAllResources(List<ResourceType> resources);
  }

  @JsonIgnoreProperties(
      ignoreUnknown = true
  )
  public static final class Builder implements TotalResultsStage, _FinalStage {
    private int totalResults;

    private List<ResourceType> resources = new ArrayList<>();

    private List<String> schemas = new ArrayList<>();

    @JsonAnySetter
    private Map<String, Object> additionalProperties = new HashMap<>();

    private Builder() {
    }

    @java.lang.Override
    public Builder from(ResourceTypesResponse other) {
      schemas(other.getSchemas());
      totalResults(other.getTotalResults());
      resources(other.getResources());
      return this;
    }

    @java.lang.Override
    @JsonSetter("totalResults")
    public _FinalStage totalResults(int totalResults) {
      this.totalResults = totalResults;
      return this;
    }

    @java.lang.Override
    public _FinalStage addAllResources(List<ResourceType> resources) {
      this.resources.addAll(resources);
      return this;
    }

    @java.lang.Override
    public _FinalStage addResources(ResourceType resources) {
      this.resources.add(resources);
      return this;
    }

    @java.lang.Override
    @JsonSetter(
        value = "Resources",
        nulls = Nulls.SKIP
    )
    public _FinalStage resources(List<ResourceType> resources) {
      this.resources.clear();
      this.resources.addAll(resources);
      return this;
    }

    @java.lang.Override
    public _FinalStage addAllSchemas(List<String> schemas) {
      this.schemas.addAll(schemas);
      return this;
    }

    @java.lang.Override
    public _FinalStage addSchemas(String schemas) {
      this.schemas.add(schemas);
      return this;
    }

    @java.lang.Override
    @JsonSetter(
        value = "schemas",
        nulls = Nulls.SKIP
    )
    public _FinalStage schemas(List<String> schemas) {
      this.schemas.clear();
      this.schemas.addAll(schemas);
      return this;
    }

    @java.lang.Override
    public ResourceTypesResponse build() {
      return new ResourceTypesResponse(schemas, totalResults, resources, additionalProperties);
    }
  }
}
