/**
 * This file was auto-generated by Fern from our API Definition.
 */

package com.langfuse.client.resources.scim.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.langfuse.client.core.ObjectMappers;
import java.lang.Object;
import java.lang.String;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(
    builder = SchemasResponse.Builder.class
)
public final class SchemasResponse {
  private final List<String> schemas;

  private final int totalResults;

  private final List<SchemaResource> resources;

  private final Map<String, Object> additionalProperties;

  private SchemasResponse(List<String> schemas, int totalResults, List<SchemaResource> resources,
      Map<String, Object> additionalProperties) {
    this.schemas = schemas;
    this.totalResults = totalResults;
    this.resources = resources;
    this.additionalProperties = additionalProperties;
  }

  @JsonProperty("schemas")
  public List<String> getSchemas() {
    return schemas;
  }

  @JsonProperty("totalResults")
  public int getTotalResults() {
    return totalResults;
  }

  @JsonProperty("Resources")
  public List<SchemaResource> getResources() {
    return resources;
  }

  @java.lang.Override
  public boolean equals(Object other) {
    if (this == other) return true;
    return other instanceof SchemasResponse && equalTo((SchemasResponse) other);
  }

  @JsonAnyGetter
  public Map<String, Object> getAdditionalProperties() {
    return this.additionalProperties;
  }

  private boolean equalTo(SchemasResponse other) {
    return schemas.equals(other.schemas) && totalResults == other.totalResults && resources.equals(other.resources);
  }

  @java.lang.Override
  public int hashCode() {
    return Objects.hash(this.schemas, this.totalResults, this.resources);
  }

  @java.lang.Override
  public String toString() {
    return ObjectMappers.stringify(this);
  }

  public static TotalResultsStage builder() {
    return new Builder();
  }

  public interface TotalResultsStage {
    _FinalStage totalResults(int totalResults);

    Builder from(SchemasResponse other);
  }

  public interface _FinalStage {
    SchemasResponse build();

    _FinalStage schemas(List<String> schemas);

    _FinalStage addSchemas(String schemas);

    _FinalStage addAllSchemas(List<String> schemas);

    _FinalStage resources(List<SchemaResource> resources);

    _FinalStage addResources(SchemaResource resources);

    _FinalStage addAllResources(List<SchemaResource> resources);
  }

  @JsonIgnoreProperties(
      ignoreUnknown = true
  )
  public static final class Builder implements TotalResultsStage, _FinalStage {
    private int totalResults;

    private List<SchemaResource> resources = new ArrayList<>();

    private List<String> schemas = new ArrayList<>();

    @JsonAnySetter
    private Map<String, Object> additionalProperties = new HashMap<>();

    private Builder() {
    }

    @java.lang.Override
    public Builder from(SchemasResponse other) {
      schemas(other.getSchemas());
      totalResults(other.getTotalResults());
      resources(other.getResources());
      return this;
    }

    @java.lang.Override
    @JsonSetter("totalResults")
    public _FinalStage totalResults(int totalResults) {
      this.totalResults = totalResults;
      return this;
    }

    @java.lang.Override
    public _FinalStage addAllResources(List<SchemaResource> resources) {
      this.resources.addAll(resources);
      return this;
    }

    @java.lang.Override
    public _FinalStage addResources(SchemaResource resources) {
      this.resources.add(resources);
      return this;
    }

    @java.lang.Override
    @JsonSetter(
        value = "Resources",
        nulls = Nulls.SKIP
    )
    public _FinalStage resources(List<SchemaResource> resources) {
      this.resources.clear();
      this.resources.addAll(resources);
      return this;
    }

    @java.lang.Override
    public _FinalStage addAllSchemas(List<String> schemas) {
      this.schemas.addAll(schemas);
      return this;
    }

    @java.lang.Override
    public _FinalStage addSchemas(String schemas) {
      this.schemas.add(schemas);
      return this;
    }

    @java.lang.Override
    @JsonSetter(
        value = "schemas",
        nulls = Nulls.SKIP
    )
    public _FinalStage schemas(List<String> schemas) {
      this.schemas.clear();
      this.schemas.addAll(schemas);
      return this;
    }

    @java.lang.Override
    public SchemasResponse build() {
      return new SchemasResponse(schemas, totalResults, resources, additionalProperties);
    }
  }
}
