/**
 * This file was auto-generated by Fern from our API Definition.
 */

package com.langfuse.client.resources.scim.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.langfuse.client.core.ObjectMappers;
import java.lang.Object;
import java.lang.String;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(
    builder = ScimUser.Builder.class
)
public final class ScimUser {
  private final List<String> schemas;

  private final String id;

  private final String userName;

  private final ScimName name;

  private final List<ScimEmail> emails;

  private final UserMeta meta;

  private final Map<String, Object> additionalProperties;

  private ScimUser(List<String> schemas, String id, String userName, ScimName name,
      List<ScimEmail> emails, UserMeta meta, Map<String, Object> additionalProperties) {
    this.schemas = schemas;
    this.id = id;
    this.userName = userName;
    this.name = name;
    this.emails = emails;
    this.meta = meta;
    this.additionalProperties = additionalProperties;
  }

  @JsonProperty("schemas")
  public List<String> getSchemas() {
    return schemas;
  }

  @JsonProperty("id")
  public String getId() {
    return id;
  }

  @JsonProperty("userName")
  public String getUserName() {
    return userName;
  }

  @JsonProperty("name")
  public ScimName getName() {
    return name;
  }

  @JsonProperty("emails")
  public List<ScimEmail> getEmails() {
    return emails;
  }

  @JsonProperty("meta")
  public UserMeta getMeta() {
    return meta;
  }

  @java.lang.Override
  public boolean equals(Object other) {
    if (this == other) return true;
    return other instanceof ScimUser && equalTo((ScimUser) other);
  }

  @JsonAnyGetter
  public Map<String, Object> getAdditionalProperties() {
    return this.additionalProperties;
  }

  private boolean equalTo(ScimUser other) {
    return schemas.equals(other.schemas) && id.equals(other.id) && userName.equals(other.userName) && name.equals(other.name) && emails.equals(other.emails) && meta.equals(other.meta);
  }

  @java.lang.Override
  public int hashCode() {
    return Objects.hash(this.schemas, this.id, this.userName, this.name, this.emails, this.meta);
  }

  @java.lang.Override
  public String toString() {
    return ObjectMappers.stringify(this);
  }

  public static IdStage builder() {
    return new Builder();
  }

  public interface IdStage {
    UserNameStage id(@NotNull String id);

    Builder from(ScimUser other);
  }

  public interface UserNameStage {
    NameStage userName(@NotNull String userName);
  }

  public interface NameStage {
    MetaStage name(@NotNull ScimName name);
  }

  public interface MetaStage {
    _FinalStage meta(@NotNull UserMeta meta);
  }

  public interface _FinalStage {
    ScimUser build();

    _FinalStage schemas(List<String> schemas);

    _FinalStage addSchemas(String schemas);

    _FinalStage addAllSchemas(List<String> schemas);

    _FinalStage emails(List<ScimEmail> emails);

    _FinalStage addEmails(ScimEmail emails);

    _FinalStage addAllEmails(List<ScimEmail> emails);
  }

  @JsonIgnoreProperties(
      ignoreUnknown = true
  )
  public static final class Builder implements IdStage, UserNameStage, NameStage, MetaStage, _FinalStage {
    private String id;

    private String userName;

    private ScimName name;

    private UserMeta meta;

    private List<ScimEmail> emails = new ArrayList<>();

    private List<String> schemas = new ArrayList<>();

    @JsonAnySetter
    private Map<String, Object> additionalProperties = new HashMap<>();

    private Builder() {
    }

    @java.lang.Override
    public Builder from(ScimUser other) {
      schemas(other.getSchemas());
      id(other.getId());
      userName(other.getUserName());
      name(other.getName());
      emails(other.getEmails());
      meta(other.getMeta());
      return this;
    }

    @java.lang.Override
    @JsonSetter("id")
    public UserNameStage id(@NotNull String id) {
      this.id = Objects.requireNonNull(id, "id must not be null");
      return this;
    }

    @java.lang.Override
    @JsonSetter("userName")
    public NameStage userName(@NotNull String userName) {
      this.userName = Objects.requireNonNull(userName, "userName must not be null");
      return this;
    }

    @java.lang.Override
    @JsonSetter("name")
    public MetaStage name(@NotNull ScimName name) {
      this.name = Objects.requireNonNull(name, "name must not be null");
      return this;
    }

    @java.lang.Override
    @JsonSetter("meta")
    public _FinalStage meta(@NotNull UserMeta meta) {
      this.meta = Objects.requireNonNull(meta, "meta must not be null");
      return this;
    }

    @java.lang.Override
    public _FinalStage addAllEmails(List<ScimEmail> emails) {
      this.emails.addAll(emails);
      return this;
    }

    @java.lang.Override
    public _FinalStage addEmails(ScimEmail emails) {
      this.emails.add(emails);
      return this;
    }

    @java.lang.Override
    @JsonSetter(
        value = "emails",
        nulls = Nulls.SKIP
    )
    public _FinalStage emails(List<ScimEmail> emails) {
      this.emails.clear();
      this.emails.addAll(emails);
      return this;
    }

    @java.lang.Override
    public _FinalStage addAllSchemas(List<String> schemas) {
      this.schemas.addAll(schemas);
      return this;
    }

    @java.lang.Override
    public _FinalStage addSchemas(String schemas) {
      this.schemas.add(schemas);
      return this;
    }

    @java.lang.Override
    @JsonSetter(
        value = "schemas",
        nulls = Nulls.SKIP
    )
    public _FinalStage schemas(List<String> schemas) {
      this.schemas.clear();
      this.schemas.addAll(schemas);
      return this;
    }

    @java.lang.Override
    public ScimUser build() {
      return new ScimUser(schemas, id, userName, name, emails, meta, additionalProperties);
    }
  }
}
