/**
 * This file was auto-generated by Fern from our API Definition.
 */

package com.langfuse.client.resources.scim.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.langfuse.client.core.ObjectMappers;
import java.lang.Object;
import java.lang.String;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(
    builder = ScimUsersListResponse.Builder.class
)
public final class ScimUsersListResponse {
  private final List<String> schemas;

  private final int totalResults;

  private final int startIndex;

  private final int itemsPerPage;

  private final List<ScimUser> resources;

  private final Map<String, Object> additionalProperties;

  private ScimUsersListResponse(List<String> schemas, int totalResults, int startIndex,
      int itemsPerPage, List<ScimUser> resources, Map<String, Object> additionalProperties) {
    this.schemas = schemas;
    this.totalResults = totalResults;
    this.startIndex = startIndex;
    this.itemsPerPage = itemsPerPage;
    this.resources = resources;
    this.additionalProperties = additionalProperties;
  }

  @JsonProperty("schemas")
  public List<String> getSchemas() {
    return schemas;
  }

  @JsonProperty("totalResults")
  public int getTotalResults() {
    return totalResults;
  }

  @JsonProperty("startIndex")
  public int getStartIndex() {
    return startIndex;
  }

  @JsonProperty("itemsPerPage")
  public int getItemsPerPage() {
    return itemsPerPage;
  }

  @JsonProperty("Resources")
  public List<ScimUser> getResources() {
    return resources;
  }

  @java.lang.Override
  public boolean equals(Object other) {
    if (this == other) return true;
    return other instanceof ScimUsersListResponse && equalTo((ScimUsersListResponse) other);
  }

  @JsonAnyGetter
  public Map<String, Object> getAdditionalProperties() {
    return this.additionalProperties;
  }

  private boolean equalTo(ScimUsersListResponse other) {
    return schemas.equals(other.schemas) && totalResults == other.totalResults && startIndex == other.startIndex && itemsPerPage == other.itemsPerPage && resources.equals(other.resources);
  }

  @java.lang.Override
  public int hashCode() {
    return Objects.hash(this.schemas, this.totalResults, this.startIndex, this.itemsPerPage, this.resources);
  }

  @java.lang.Override
  public String toString() {
    return ObjectMappers.stringify(this);
  }

  public static TotalResultsStage builder() {
    return new Builder();
  }

  public interface TotalResultsStage {
    StartIndexStage totalResults(int totalResults);

    Builder from(ScimUsersListResponse other);
  }

  public interface StartIndexStage {
    ItemsPerPageStage startIndex(int startIndex);
  }

  public interface ItemsPerPageStage {
    _FinalStage itemsPerPage(int itemsPerPage);
  }

  public interface _FinalStage {
    ScimUsersListResponse build();

    _FinalStage schemas(List<String> schemas);

    _FinalStage addSchemas(String schemas);

    _FinalStage addAllSchemas(List<String> schemas);

    _FinalStage resources(List<ScimUser> resources);

    _FinalStage addResources(ScimUser resources);

    _FinalStage addAllResources(List<ScimUser> resources);
  }

  @JsonIgnoreProperties(
      ignoreUnknown = true
  )
  public static final class Builder implements TotalResultsStage, StartIndexStage, ItemsPerPageStage, _FinalStage {
    private int totalResults;

    private int startIndex;

    private int itemsPerPage;

    private List<ScimUser> resources = new ArrayList<>();

    private List<String> schemas = new ArrayList<>();

    @JsonAnySetter
    private Map<String, Object> additionalProperties = new HashMap<>();

    private Builder() {
    }

    @java.lang.Override
    public Builder from(ScimUsersListResponse other) {
      schemas(other.getSchemas());
      totalResults(other.getTotalResults());
      startIndex(other.getStartIndex());
      itemsPerPage(other.getItemsPerPage());
      resources(other.getResources());
      return this;
    }

    @java.lang.Override
    @JsonSetter("totalResults")
    public StartIndexStage totalResults(int totalResults) {
      this.totalResults = totalResults;
      return this;
    }

    @java.lang.Override
    @JsonSetter("startIndex")
    public ItemsPerPageStage startIndex(int startIndex) {
      this.startIndex = startIndex;
      return this;
    }

    @java.lang.Override
    @JsonSetter("itemsPerPage")
    public _FinalStage itemsPerPage(int itemsPerPage) {
      this.itemsPerPage = itemsPerPage;
      return this;
    }

    @java.lang.Override
    public _FinalStage addAllResources(List<ScimUser> resources) {
      this.resources.addAll(resources);
      return this;
    }

    @java.lang.Override
    public _FinalStage addResources(ScimUser resources) {
      this.resources.add(resources);
      return this;
    }

    @java.lang.Override
    @JsonSetter(
        value = "Resources",
        nulls = Nulls.SKIP
    )
    public _FinalStage resources(List<ScimUser> resources) {
      this.resources.clear();
      this.resources.addAll(resources);
      return this;
    }

    @java.lang.Override
    public _FinalStage addAllSchemas(List<String> schemas) {
      this.schemas.addAll(schemas);
      return this;
    }

    @java.lang.Override
    public _FinalStage addSchemas(String schemas) {
      this.schemas.add(schemas);
      return this;
    }

    @java.lang.Override
    @JsonSetter(
        value = "schemas",
        nulls = Nulls.SKIP
    )
    public _FinalStage schemas(List<String> schemas) {
      this.schemas.clear();
      this.schemas.addAll(schemas);
      return this;
    }

    @java.lang.Override
    public ScimUsersListResponse build() {
      return new ScimUsersListResponse(schemas, totalResults, startIndex, itemsPerPage, resources, additionalProperties);
    }
  }
}
