/**
 * This file was auto-generated by Fern from our API Definition.
 */

package com.langfuse.client.resources.scorev2.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.langfuse.client.core.ObjectMappers;
import java.lang.Double;
import java.lang.Integer;
import java.lang.Object;
import java.lang.String;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import com.langfuse.client.resources.commons.types.ScoreDataType;
import com.langfuse.client.resources.commons.types.ScoreSource;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(
    builder = GetScoresRequest.Builder.class
)
public final class GetScoresRequest {
  private final Optional<Integer> page;

  private final Optional<Integer> limit;

  private final Optional<String> userId;

  private final Optional<String> name;

  private final Optional<OffsetDateTime> fromTimestamp;

  private final Optional<OffsetDateTime> toTimestamp;

  private final Optional<String> environment;

  private final Optional<ScoreSource> source;

  private final Optional<String> operator;

  private final Optional<Double> value;

  private final Optional<String> scoreIds;

  private final Optional<String> configId;

  private final Optional<String> queueId;

  private final Optional<ScoreDataType> dataType;

  private final Optional<String> traceTags;

  private final Map<String, Object> additionalProperties;

  private GetScoresRequest(Optional<Integer> page, Optional<Integer> limit, Optional<String> userId,
      Optional<String> name, Optional<OffsetDateTime> fromTimestamp,
      Optional<OffsetDateTime> toTimestamp, Optional<String> environment,
      Optional<ScoreSource> source, Optional<String> operator, Optional<Double> value,
      Optional<String> scoreIds, Optional<String> configId, Optional<String> queueId,
      Optional<ScoreDataType> dataType, Optional<String> traceTags,
      Map<String, Object> additionalProperties) {
    this.page = page;
    this.limit = limit;
    this.userId = userId;
    this.name = name;
    this.fromTimestamp = fromTimestamp;
    this.toTimestamp = toTimestamp;
    this.environment = environment;
    this.source = source;
    this.operator = operator;
    this.value = value;
    this.scoreIds = scoreIds;
    this.configId = configId;
    this.queueId = queueId;
    this.dataType = dataType;
    this.traceTags = traceTags;
    this.additionalProperties = additionalProperties;
  }

  /**
   * @return Page number, starts at 1.
   */
  @JsonProperty("page")
  public Optional<Integer> getPage() {
    return page;
  }

  /**
   * @return Limit of items per page. If you encounter api issues due to too large page sizes, try to reduce the limit.
   */
  @JsonProperty("limit")
  public Optional<Integer> getLimit() {
    return limit;
  }

  /**
   * @return Retrieve only scores with this userId associated to the trace.
   */
  @JsonProperty("userId")
  public Optional<String> getUserId() {
    return userId;
  }

  /**
   * @return Retrieve only scores with this name.
   */
  @JsonProperty("name")
  public Optional<String> getName() {
    return name;
  }

  /**
   * @return Optional filter to only include scores created on or after a certain datetime (ISO 8601)
   */
  @JsonProperty("fromTimestamp")
  public Optional<OffsetDateTime> getFromTimestamp() {
    return fromTimestamp;
  }

  /**
   * @return Optional filter to only include scores created before a certain datetime (ISO 8601)
   */
  @JsonProperty("toTimestamp")
  public Optional<OffsetDateTime> getToTimestamp() {
    return toTimestamp;
  }

  /**
   * @return Optional filter for scores where the environment is one of the provided values.
   */
  @JsonProperty("environment")
  public Optional<String> getEnvironment() {
    return environment;
  }

  /**
   * @return Retrieve only scores from a specific source.
   */
  @JsonProperty("source")
  public Optional<ScoreSource> getSource() {
    return source;
  }

  /**
   * @return Retrieve only scores with &lt;operator&gt; value.
   */
  @JsonProperty("operator")
  public Optional<String> getOperator() {
    return operator;
  }

  /**
   * @return Retrieve only scores with &lt;operator&gt; value.
   */
  @JsonProperty("value")
  public Optional<Double> getValue() {
    return value;
  }

  /**
   * @return Comma-separated list of score IDs to limit the results to.
   */
  @JsonProperty("scoreIds")
  public Optional<String> getScoreIds() {
    return scoreIds;
  }

  /**
   * @return Retrieve only scores with a specific configId.
   */
  @JsonProperty("configId")
  public Optional<String> getConfigId() {
    return configId;
  }

  /**
   * @return Retrieve only scores with a specific annotation queueId.
   */
  @JsonProperty("queueId")
  public Optional<String> getQueueId() {
    return queueId;
  }

  /**
   * @return Retrieve only scores with a specific dataType.
   */
  @JsonProperty("dataType")
  public Optional<ScoreDataType> getDataType() {
    return dataType;
  }

  /**
   * @return Only scores linked to traces that include all of these tags will be returned.
   */
  @JsonProperty("traceTags")
  public Optional<String> getTraceTags() {
    return traceTags;
  }

  @java.lang.Override
  public boolean equals(Object other) {
    if (this == other) return true;
    return other instanceof GetScoresRequest && equalTo((GetScoresRequest) other);
  }

  @JsonAnyGetter
  public Map<String, Object> getAdditionalProperties() {
    return this.additionalProperties;
  }

  private boolean equalTo(GetScoresRequest other) {
    return page.equals(other.page) && limit.equals(other.limit) && userId.equals(other.userId) && name.equals(other.name) && fromTimestamp.equals(other.fromTimestamp) && toTimestamp.equals(other.toTimestamp) && environment.equals(other.environment) && source.equals(other.source) && operator.equals(other.operator) && value.equals(other.value) && scoreIds.equals(other.scoreIds) && configId.equals(other.configId) && queueId.equals(other.queueId) && dataType.equals(other.dataType) && traceTags.equals(other.traceTags);
  }

  @java.lang.Override
  public int hashCode() {
    return Objects.hash(this.page, this.limit, this.userId, this.name, this.fromTimestamp, this.toTimestamp, this.environment, this.source, this.operator, this.value, this.scoreIds, this.configId, this.queueId, this.dataType, this.traceTags);
  }

  @java.lang.Override
  public String toString() {
    return ObjectMappers.stringify(this);
  }

  public static Builder builder() {
    return new Builder();
  }

  @JsonIgnoreProperties(
      ignoreUnknown = true
  )
  public static final class Builder {
    private Optional<Integer> page = Optional.empty();

    private Optional<Integer> limit = Optional.empty();

    private Optional<String> userId = Optional.empty();

    private Optional<String> name = Optional.empty();

    private Optional<OffsetDateTime> fromTimestamp = Optional.empty();

    private Optional<OffsetDateTime> toTimestamp = Optional.empty();

    private Optional<String> environment = Optional.empty();

    private Optional<ScoreSource> source = Optional.empty();

    private Optional<String> operator = Optional.empty();

    private Optional<Double> value = Optional.empty();

    private Optional<String> scoreIds = Optional.empty();

    private Optional<String> configId = Optional.empty();

    private Optional<String> queueId = Optional.empty();

    private Optional<ScoreDataType> dataType = Optional.empty();

    private Optional<String> traceTags = Optional.empty();

    @JsonAnySetter
    private Map<String, Object> additionalProperties = new HashMap<>();

    private Builder() {
    }

    public Builder from(GetScoresRequest other) {
      page(other.getPage());
      limit(other.getLimit());
      userId(other.getUserId());
      name(other.getName());
      fromTimestamp(other.getFromTimestamp());
      toTimestamp(other.getToTimestamp());
      environment(other.getEnvironment());
      source(other.getSource());
      operator(other.getOperator());
      value(other.getValue());
      scoreIds(other.getScoreIds());
      configId(other.getConfigId());
      queueId(other.getQueueId());
      dataType(other.getDataType());
      traceTags(other.getTraceTags());
      return this;
    }

    @JsonSetter(
        value = "page",
        nulls = Nulls.SKIP
    )
    public Builder page(Optional<Integer> page) {
      this.page = page;
      return this;
    }

    public Builder page(Integer page) {
      this.page = Optional.ofNullable(page);
      return this;
    }

    @JsonSetter(
        value = "limit",
        nulls = Nulls.SKIP
    )
    public Builder limit(Optional<Integer> limit) {
      this.limit = limit;
      return this;
    }

    public Builder limit(Integer limit) {
      this.limit = Optional.ofNullable(limit);
      return this;
    }

    @JsonSetter(
        value = "userId",
        nulls = Nulls.SKIP
    )
    public Builder userId(Optional<String> userId) {
      this.userId = userId;
      return this;
    }

    public Builder userId(String userId) {
      this.userId = Optional.ofNullable(userId);
      return this;
    }

    @JsonSetter(
        value = "name",
        nulls = Nulls.SKIP
    )
    public Builder name(Optional<String> name) {
      this.name = name;
      return this;
    }

    public Builder name(String name) {
      this.name = Optional.ofNullable(name);
      return this;
    }

    @JsonSetter(
        value = "fromTimestamp",
        nulls = Nulls.SKIP
    )
    public Builder fromTimestamp(Optional<OffsetDateTime> fromTimestamp) {
      this.fromTimestamp = fromTimestamp;
      return this;
    }

    public Builder fromTimestamp(OffsetDateTime fromTimestamp) {
      this.fromTimestamp = Optional.ofNullable(fromTimestamp);
      return this;
    }

    @JsonSetter(
        value = "toTimestamp",
        nulls = Nulls.SKIP
    )
    public Builder toTimestamp(Optional<OffsetDateTime> toTimestamp) {
      this.toTimestamp = toTimestamp;
      return this;
    }

    public Builder toTimestamp(OffsetDateTime toTimestamp) {
      this.toTimestamp = Optional.ofNullable(toTimestamp);
      return this;
    }

    @JsonSetter(
        value = "environment",
        nulls = Nulls.SKIP
    )
    public Builder environment(Optional<String> environment) {
      this.environment = environment;
      return this;
    }

    public Builder environment(String environment) {
      this.environment = Optional.ofNullable(environment);
      return this;
    }

    @JsonSetter(
        value = "source",
        nulls = Nulls.SKIP
    )
    public Builder source(Optional<ScoreSource> source) {
      this.source = source;
      return this;
    }

    public Builder source(ScoreSource source) {
      this.source = Optional.ofNullable(source);
      return this;
    }

    @JsonSetter(
        value = "operator",
        nulls = Nulls.SKIP
    )
    public Builder operator(Optional<String> operator) {
      this.operator = operator;
      return this;
    }

    public Builder operator(String operator) {
      this.operator = Optional.ofNullable(operator);
      return this;
    }

    @JsonSetter(
        value = "value",
        nulls = Nulls.SKIP
    )
    public Builder value(Optional<Double> value) {
      this.value = value;
      return this;
    }

    public Builder value(Double value) {
      this.value = Optional.ofNullable(value);
      return this;
    }

    @JsonSetter(
        value = "scoreIds",
        nulls = Nulls.SKIP
    )
    public Builder scoreIds(Optional<String> scoreIds) {
      this.scoreIds = scoreIds;
      return this;
    }

    public Builder scoreIds(String scoreIds) {
      this.scoreIds = Optional.ofNullable(scoreIds);
      return this;
    }

    @JsonSetter(
        value = "configId",
        nulls = Nulls.SKIP
    )
    public Builder configId(Optional<String> configId) {
      this.configId = configId;
      return this;
    }

    public Builder configId(String configId) {
      this.configId = Optional.ofNullable(configId);
      return this;
    }

    @JsonSetter(
        value = "queueId",
        nulls = Nulls.SKIP
    )
    public Builder queueId(Optional<String> queueId) {
      this.queueId = queueId;
      return this;
    }

    public Builder queueId(String queueId) {
      this.queueId = Optional.ofNullable(queueId);
      return this;
    }

    @JsonSetter(
        value = "dataType",
        nulls = Nulls.SKIP
    )
    public Builder dataType(Optional<ScoreDataType> dataType) {
      this.dataType = dataType;
      return this;
    }

    public Builder dataType(ScoreDataType dataType) {
      this.dataType = Optional.ofNullable(dataType);
      return this;
    }

    @JsonSetter(
        value = "traceTags",
        nulls = Nulls.SKIP
    )
    public Builder traceTags(Optional<String> traceTags) {
      this.traceTags = traceTags;
      return this;
    }

    public Builder traceTags(String traceTags) {
      this.traceTags = Optional.ofNullable(traceTags);
      return this;
    }

    public GetScoresRequest build() {
      return new GetScoresRequest(page, limit, userId, name, fromTimestamp, toTimestamp, environment, source, operator, value, scoreIds, configId, queueId, dataType, traceTags, additionalProperties);
    }
  }
}
