/**
 * This file was auto-generated by Fern from our API Definition.
 */

package com.langfuse.client.resources.trace.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.langfuse.client.core.ObjectMappers;
import java.lang.Object;
import java.lang.String;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(
    builder = DeleteTracesRequest.Builder.class
)
public final class DeleteTracesRequest {
  private final List<String> traceIds;

  private final Map<String, Object> additionalProperties;

  private DeleteTracesRequest(List<String> traceIds, Map<String, Object> additionalProperties) {
    this.traceIds = traceIds;
    this.additionalProperties = additionalProperties;
  }

  /**
   * @return List of trace IDs to delete
   */
  @JsonProperty("traceIds")
  public List<String> getTraceIds() {
    return traceIds;
  }

  @java.lang.Override
  public boolean equals(Object other) {
    if (this == other) return true;
    return other instanceof DeleteTracesRequest && equalTo((DeleteTracesRequest) other);
  }

  @JsonAnyGetter
  public Map<String, Object> getAdditionalProperties() {
    return this.additionalProperties;
  }

  private boolean equalTo(DeleteTracesRequest other) {
    return traceIds.equals(other.traceIds);
  }

  @java.lang.Override
  public int hashCode() {
    return Objects.hash(this.traceIds);
  }

  @java.lang.Override
  public String toString() {
    return ObjectMappers.stringify(this);
  }

  public static Builder builder() {
    return new Builder();
  }

  @JsonIgnoreProperties(
      ignoreUnknown = true
  )
  public static final class Builder {
    private List<String> traceIds = new ArrayList<>();

    @JsonAnySetter
    private Map<String, Object> additionalProperties = new HashMap<>();

    private Builder() {
    }

    public Builder from(DeleteTracesRequest other) {
      traceIds(other.getTraceIds());
      return this;
    }

    @JsonSetter(
        value = "traceIds",
        nulls = Nulls.SKIP
    )
    public Builder traceIds(List<String> traceIds) {
      this.traceIds.clear();
      this.traceIds.addAll(traceIds);
      return this;
    }

    public Builder addTraceIds(String traceIds) {
      this.traceIds.add(traceIds);
      return this;
    }

    public Builder addAllTraceIds(List<String> traceIds) {
      this.traceIds.addAll(traceIds);
      return this;
    }

    public DeleteTracesRequest build() {
      return new DeleteTracesRequest(traceIds, additionalProperties);
    }
  }
}
