/**
 * This file was auto-generated by Fern from our API Definition.
 */

package com.langfuse.client.resources.trace.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.langfuse.client.core.ObjectMappers;
import java.lang.Integer;
import java.lang.Object;
import java.lang.String;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(
    builder = GetTracesRequest.Builder.class
)
public final class GetTracesRequest {
  private final Optional<Integer> page;

  private final Optional<Integer> limit;

  private final Optional<String> userId;

  private final Optional<String> name;

  private final Optional<String> sessionId;

  private final Optional<OffsetDateTime> fromTimestamp;

  private final Optional<OffsetDateTime> toTimestamp;

  private final Optional<String> orderBy;

  private final Optional<String> tags;

  private final Optional<String> version;

  private final Optional<String> release;

  private final Optional<String> environment;

  private final Optional<String> fields;

  private final Map<String, Object> additionalProperties;

  private GetTracesRequest(Optional<Integer> page, Optional<Integer> limit, Optional<String> userId,
      Optional<String> name, Optional<String> sessionId, Optional<OffsetDateTime> fromTimestamp,
      Optional<OffsetDateTime> toTimestamp, Optional<String> orderBy, Optional<String> tags,
      Optional<String> version, Optional<String> release, Optional<String> environment,
      Optional<String> fields, Map<String, Object> additionalProperties) {
    this.page = page;
    this.limit = limit;
    this.userId = userId;
    this.name = name;
    this.sessionId = sessionId;
    this.fromTimestamp = fromTimestamp;
    this.toTimestamp = toTimestamp;
    this.orderBy = orderBy;
    this.tags = tags;
    this.version = version;
    this.release = release;
    this.environment = environment;
    this.fields = fields;
    this.additionalProperties = additionalProperties;
  }

  /**
   * @return Page number, starts at 1
   */
  @JsonProperty("page")
  public Optional<Integer> getPage() {
    return page;
  }

  /**
   * @return Limit of items per page. If you encounter api issues due to too large page sizes, try to reduce the limit.
   */
  @JsonProperty("limit")
  public Optional<Integer> getLimit() {
    return limit;
  }

  @JsonProperty("userId")
  public Optional<String> getUserId() {
    return userId;
  }

  @JsonProperty("name")
  public Optional<String> getName() {
    return name;
  }

  @JsonProperty("sessionId")
  public Optional<String> getSessionId() {
    return sessionId;
  }

  /**
   * @return Optional filter to only include traces with a trace.timestamp on or after a certain datetime (ISO 8601)
   */
  @JsonProperty("fromTimestamp")
  public Optional<OffsetDateTime> getFromTimestamp() {
    return fromTimestamp;
  }

  /**
   * @return Optional filter to only include traces with a trace.timestamp before a certain datetime (ISO 8601)
   */
  @JsonProperty("toTimestamp")
  public Optional<OffsetDateTime> getToTimestamp() {
    return toTimestamp;
  }

  /**
   * @return Format of the string [field].[asc/desc]. Fields: id, timestamp, name, userId, release, version, public, bookmarked, sessionId. Example: timestamp.asc
   */
  @JsonProperty("orderBy")
  public Optional<String> getOrderBy() {
    return orderBy;
  }

  /**
   * @return Only traces that include all of these tags will be returned.
   */
  @JsonProperty("tags")
  public Optional<String> getTags() {
    return tags;
  }

  /**
   * @return Optional filter to only include traces with a certain version.
   */
  @JsonProperty("version")
  public Optional<String> getVersion() {
    return version;
  }

  /**
   * @return Optional filter to only include traces with a certain release.
   */
  @JsonProperty("release")
  public Optional<String> getRelease() {
    return release;
  }

  /**
   * @return Optional filter for traces where the environment is one of the provided values.
   */
  @JsonProperty("environment")
  public Optional<String> getEnvironment() {
    return environment;
  }

  /**
   * @return Comma-separated list of fields to include in the response. Available field groups are 'core' (always included), 'io' (input, output, metadata), 'scores', 'observations', 'metrics'. If not provided, all fields are included. Example: 'core,scores,metrics'
   */
  @JsonProperty("fields")
  public Optional<String> getFields() {
    return fields;
  }

  @java.lang.Override
  public boolean equals(Object other) {
    if (this == other) return true;
    return other instanceof GetTracesRequest && equalTo((GetTracesRequest) other);
  }

  @JsonAnyGetter
  public Map<String, Object> getAdditionalProperties() {
    return this.additionalProperties;
  }

  private boolean equalTo(GetTracesRequest other) {
    return page.equals(other.page) && limit.equals(other.limit) && userId.equals(other.userId) && name.equals(other.name) && sessionId.equals(other.sessionId) && fromTimestamp.equals(other.fromTimestamp) && toTimestamp.equals(other.toTimestamp) && orderBy.equals(other.orderBy) && tags.equals(other.tags) && version.equals(other.version) && release.equals(other.release) && environment.equals(other.environment) && fields.equals(other.fields);
  }

  @java.lang.Override
  public int hashCode() {
    return Objects.hash(this.page, this.limit, this.userId, this.name, this.sessionId, this.fromTimestamp, this.toTimestamp, this.orderBy, this.tags, this.version, this.release, this.environment, this.fields);
  }

  @java.lang.Override
  public String toString() {
    return ObjectMappers.stringify(this);
  }

  public static Builder builder() {
    return new Builder();
  }

  @JsonIgnoreProperties(
      ignoreUnknown = true
  )
  public static final class Builder {
    private Optional<Integer> page = Optional.empty();

    private Optional<Integer> limit = Optional.empty();

    private Optional<String> userId = Optional.empty();

    private Optional<String> name = Optional.empty();

    private Optional<String> sessionId = Optional.empty();

    private Optional<OffsetDateTime> fromTimestamp = Optional.empty();

    private Optional<OffsetDateTime> toTimestamp = Optional.empty();

    private Optional<String> orderBy = Optional.empty();

    private Optional<String> tags = Optional.empty();

    private Optional<String> version = Optional.empty();

    private Optional<String> release = Optional.empty();

    private Optional<String> environment = Optional.empty();

    private Optional<String> fields = Optional.empty();

    @JsonAnySetter
    private Map<String, Object> additionalProperties = new HashMap<>();

    private Builder() {
    }

    public Builder from(GetTracesRequest other) {
      page(other.getPage());
      limit(other.getLimit());
      userId(other.getUserId());
      name(other.getName());
      sessionId(other.getSessionId());
      fromTimestamp(other.getFromTimestamp());
      toTimestamp(other.getToTimestamp());
      orderBy(other.getOrderBy());
      tags(other.getTags());
      version(other.getVersion());
      release(other.getRelease());
      environment(other.getEnvironment());
      fields(other.getFields());
      return this;
    }

    @JsonSetter(
        value = "page",
        nulls = Nulls.SKIP
    )
    public Builder page(Optional<Integer> page) {
      this.page = page;
      return this;
    }

    public Builder page(Integer page) {
      this.page = Optional.ofNullable(page);
      return this;
    }

    @JsonSetter(
        value = "limit",
        nulls = Nulls.SKIP
    )
    public Builder limit(Optional<Integer> limit) {
      this.limit = limit;
      return this;
    }

    public Builder limit(Integer limit) {
      this.limit = Optional.ofNullable(limit);
      return this;
    }

    @JsonSetter(
        value = "userId",
        nulls = Nulls.SKIP
    )
    public Builder userId(Optional<String> userId) {
      this.userId = userId;
      return this;
    }

    public Builder userId(String userId) {
      this.userId = Optional.ofNullable(userId);
      return this;
    }

    @JsonSetter(
        value = "name",
        nulls = Nulls.SKIP
    )
    public Builder name(Optional<String> name) {
      this.name = name;
      return this;
    }

    public Builder name(String name) {
      this.name = Optional.ofNullable(name);
      return this;
    }

    @JsonSetter(
        value = "sessionId",
        nulls = Nulls.SKIP
    )
    public Builder sessionId(Optional<String> sessionId) {
      this.sessionId = sessionId;
      return this;
    }

    public Builder sessionId(String sessionId) {
      this.sessionId = Optional.ofNullable(sessionId);
      return this;
    }

    @JsonSetter(
        value = "fromTimestamp",
        nulls = Nulls.SKIP
    )
    public Builder fromTimestamp(Optional<OffsetDateTime> fromTimestamp) {
      this.fromTimestamp = fromTimestamp;
      return this;
    }

    public Builder fromTimestamp(OffsetDateTime fromTimestamp) {
      this.fromTimestamp = Optional.ofNullable(fromTimestamp);
      return this;
    }

    @JsonSetter(
        value = "toTimestamp",
        nulls = Nulls.SKIP
    )
    public Builder toTimestamp(Optional<OffsetDateTime> toTimestamp) {
      this.toTimestamp = toTimestamp;
      return this;
    }

    public Builder toTimestamp(OffsetDateTime toTimestamp) {
      this.toTimestamp = Optional.ofNullable(toTimestamp);
      return this;
    }

    @JsonSetter(
        value = "orderBy",
        nulls = Nulls.SKIP
    )
    public Builder orderBy(Optional<String> orderBy) {
      this.orderBy = orderBy;
      return this;
    }

    public Builder orderBy(String orderBy) {
      this.orderBy = Optional.ofNullable(orderBy);
      return this;
    }

    @JsonSetter(
        value = "tags",
        nulls = Nulls.SKIP
    )
    public Builder tags(Optional<String> tags) {
      this.tags = tags;
      return this;
    }

    public Builder tags(String tags) {
      this.tags = Optional.ofNullable(tags);
      return this;
    }

    @JsonSetter(
        value = "version",
        nulls = Nulls.SKIP
    )
    public Builder version(Optional<String> version) {
      this.version = version;
      return this;
    }

    public Builder version(String version) {
      this.version = Optional.ofNullable(version);
      return this;
    }

    @JsonSetter(
        value = "release",
        nulls = Nulls.SKIP
    )
    public Builder release(Optional<String> release) {
      this.release = release;
      return this;
    }

    public Builder release(String release) {
      this.release = Optional.ofNullable(release);
      return this;
    }

    @JsonSetter(
        value = "environment",
        nulls = Nulls.SKIP
    )
    public Builder environment(Optional<String> environment) {
      this.environment = environment;
      return this;
    }

    public Builder environment(String environment) {
      this.environment = Optional.ofNullable(environment);
      return this;
    }

    @JsonSetter(
        value = "fields",
        nulls = Nulls.SKIP
    )
    public Builder fields(Optional<String> fields) {
      this.fields = fields;
      return this;
    }

    public Builder fields(String fields) {
      this.fields = Optional.ofNullable(fields);
      return this;
    }

    public GetTracesRequest build() {
      return new GetTracesRequest(page, limit, userId, name, sessionId, fromTimestamp, toTimestamp, orderBy, tags, version, release, environment, fields, additionalProperties);
    }
  }
}
