/**
 * This file was auto-generated by Fern from our API Definition.
 */

package com.langfuse.client.resources.utils.pagination.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.langfuse.client.core.ObjectMappers;
import java.lang.Object;
import java.lang.String;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(
    builder = MetaResponse.Builder.class
)
public final class MetaResponse {
  private final int page;

  private final int limit;

  private final int totalItems;

  private final int totalPages;

  private final Map<String, Object> additionalProperties;

  private MetaResponse(int page, int limit, int totalItems, int totalPages,
      Map<String, Object> additionalProperties) {
    this.page = page;
    this.limit = limit;
    this.totalItems = totalItems;
    this.totalPages = totalPages;
    this.additionalProperties = additionalProperties;
  }

  /**
   * @return current page number
   */
  @JsonProperty("page")
  public int getPage() {
    return page;
  }

  /**
   * @return number of items per page
   */
  @JsonProperty("limit")
  public int getLimit() {
    return limit;
  }

  /**
   * @return number of total items given the current filters/selection (if any)
   */
  @JsonProperty("totalItems")
  public int getTotalItems() {
    return totalItems;
  }

  /**
   * @return number of total pages given the current limit
   */
  @JsonProperty("totalPages")
  public int getTotalPages() {
    return totalPages;
  }

  @java.lang.Override
  public boolean equals(Object other) {
    if (this == other) return true;
    return other instanceof MetaResponse && equalTo((MetaResponse) other);
  }

  @JsonAnyGetter
  public Map<String, Object> getAdditionalProperties() {
    return this.additionalProperties;
  }

  private boolean equalTo(MetaResponse other) {
    return page == other.page && limit == other.limit && totalItems == other.totalItems && totalPages == other.totalPages;
  }

  @java.lang.Override
  public int hashCode() {
    return Objects.hash(this.page, this.limit, this.totalItems, this.totalPages);
  }

  @java.lang.Override
  public String toString() {
    return ObjectMappers.stringify(this);
  }

  public static PageStage builder() {
    return new Builder();
  }

  public interface PageStage {
    LimitStage page(int page);

    Builder from(MetaResponse other);
  }

  public interface LimitStage {
    TotalItemsStage limit(int limit);
  }

  public interface TotalItemsStage {
    TotalPagesStage totalItems(int totalItems);
  }

  public interface TotalPagesStage {
    _FinalStage totalPages(int totalPages);
  }

  public interface _FinalStage {
    MetaResponse build();
  }

  @JsonIgnoreProperties(
      ignoreUnknown = true
  )
  public static final class Builder implements PageStage, LimitStage, TotalItemsStage, TotalPagesStage, _FinalStage {
    private int page;

    private int limit;

    private int totalItems;

    private int totalPages;

    @JsonAnySetter
    private Map<String, Object> additionalProperties = new HashMap<>();

    private Builder() {
    }

    @java.lang.Override
    public Builder from(MetaResponse other) {
      page(other.getPage());
      limit(other.getLimit());
      totalItems(other.getTotalItems());
      totalPages(other.getTotalPages());
      return this;
    }

    /**
     * <p>current page number</p>
     * @return Reference to {@code this} so that method calls can be chained together.
     */
    @java.lang.Override
    @JsonSetter("page")
    public LimitStage page(int page) {
      this.page = page;
      return this;
    }

    /**
     * <p>number of items per page</p>
     * @return Reference to {@code this} so that method calls can be chained together.
     */
    @java.lang.Override
    @JsonSetter("limit")
    public TotalItemsStage limit(int limit) {
      this.limit = limit;
      return this;
    }

    /**
     * <p>number of total items given the current filters/selection (if any)</p>
     * @return Reference to {@code this} so that method calls can be chained together.
     */
    @java.lang.Override
    @JsonSetter("totalItems")
    public TotalPagesStage totalItems(int totalItems) {
      this.totalItems = totalItems;
      return this;
    }

    /**
     * <p>number of total pages given the current limit</p>
     * @return Reference to {@code this} so that method calls can be chained together.
     */
    @java.lang.Override
    @JsonSetter("totalPages")
    public _FinalStage totalPages(int totalPages) {
      this.totalPages = totalPages;
      return this;
    }

    @java.lang.Override
    public MetaResponse build() {
      return new MetaResponse(page, limit, totalItems, totalPages, additionalProperties);
    }
  }
}
