/*
 * Decompiled with CFR 0.152.
 */
package com.langfuse.client.core;

import com.langfuse.client.core.QueryStringMapper;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import okhttp3.HttpUrl;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public final class QueryStringMapperTest {
    @Test
    public void testObjectWithQuotedString_indexedArrays() {
        final HashMap<String, String> map = new HashMap<String, String>(){
            {
                this.put("hello", "\"world\"");
            }
        };
        String expectedQueryString = "withquoted%5Bhello%5D=%22world%22";
        String actualQueryString = QueryStringMapperTest.queryString((Map<String, Object>)new HashMap<String, Object>(this){
            final /* synthetic */ QueryStringMapperTest this$0;
            {
                this.this$0 = this$0;
                this.put("withquoted", map);
            }
        }, false);
        Assertions.assertEquals((Object)expectedQueryString, (Object)actualQueryString);
    }

    @Test
    public void testObjectWithQuotedString_arraysAsRepeats() {
        final HashMap<String, String> map = new HashMap<String, String>(){
            {
                this.put("hello", "\"world\"");
            }
        };
        String expectedQueryString = "withquoted%5Bhello%5D=%22world%22";
        String actualQueryString = QueryStringMapperTest.queryString((Map<String, Object>)new HashMap<String, Object>(this){
            final /* synthetic */ QueryStringMapperTest this$0;
            {
                this.this$0 = this$0;
                this.put("withquoted", map);
            }
        }, true);
        Assertions.assertEquals((Object)expectedQueryString, (Object)actualQueryString);
    }

    @Test
    public void testObject_indexedArrays() {
        final HashMap<String, String> map = new HashMap<String, String>(){
            {
                this.put("foo", "bar");
                this.put("baz", "qux");
            }
        };
        String expectedQueryString = "metadata%5Bfoo%5D=bar&metadata%5Bbaz%5D=qux";
        String actualQueryString = QueryStringMapperTest.queryString((Map<String, Object>)new HashMap<String, Object>(this){
            final /* synthetic */ QueryStringMapperTest this$0;
            {
                this.this$0 = this$0;
                this.put("metadata", map);
            }
        }, false);
        Assertions.assertEquals((Object)expectedQueryString, (Object)actualQueryString);
    }

    @Test
    public void testObject_arraysAsRepeats() {
        final HashMap<String, String> map = new HashMap<String, String>(){
            {
                this.put("foo", "bar");
                this.put("baz", "qux");
            }
        };
        String expectedQueryString = "metadata%5Bfoo%5D=bar&metadata%5Bbaz%5D=qux";
        String actualQueryString = QueryStringMapperTest.queryString((Map<String, Object>)new HashMap<String, Object>(this){
            final /* synthetic */ QueryStringMapperTest this$0;
            {
                this.this$0 = this$0;
                this.put("metadata", map);
            }
        }, true);
        Assertions.assertEquals((Object)expectedQueryString, (Object)actualQueryString);
    }

    @Test
    public void testNestedObject_indexedArrays() {
        final HashMap<String, Map<String, String>> nestedMap = new HashMap<String, Map<String, String>>(){
            {
                this.put("mapkey1", new HashMap<String, String>(){
                    {
                        this.put("mapkey1mapkey1", "mapkey1mapkey1value");
                        this.put("mapkey1mapkey2", "mapkey1mapkey2value");
                    }
                });
                this.put("mapkey2", new HashMap<String, String>(){
                    {
                        this.put("mapkey2mapkey1", "mapkey2mapkey1value");
                    }
                });
            }
        };
        String expectedQueryString = "nested%5Bmapkey2%5D%5Bmapkey2mapkey1%5D=mapkey2mapkey1value&nested%5Bmapkey1%5D%5Bmapkey1mapkey1%5D=mapkey1mapkey1value&nested%5Bmapkey1%5D%5Bmapkey1mapkey2%5D=mapkey1mapkey2value";
        String actualQueryString = QueryStringMapperTest.queryString((Map<String, Object>)new HashMap<String, Object>(this){
            final /* synthetic */ QueryStringMapperTest this$0;
            {
                this.this$0 = this$0;
                this.put("nested", nestedMap);
            }
        }, false);
        Assertions.assertEquals((Object)expectedQueryString, (Object)actualQueryString);
    }

    @Test
    public void testNestedObject_arraysAsRepeats() {
        final HashMap<String, Map<String, String>> nestedMap = new HashMap<String, Map<String, String>>(){
            {
                this.put("mapkey1", new HashMap<String, String>(){
                    {
                        this.put("mapkey1mapkey1", "mapkey1mapkey1value");
                        this.put("mapkey1mapkey2", "mapkey1mapkey2value");
                    }
                });
                this.put("mapkey2", new HashMap<String, String>(){
                    {
                        this.put("mapkey2mapkey1", "mapkey2mapkey1value");
                    }
                });
            }
        };
        String expectedQueryString = "nested%5Bmapkey2%5D%5Bmapkey2mapkey1%5D=mapkey2mapkey1value&nested%5Bmapkey1%5D%5Bmapkey1mapkey1%5D=mapkey1mapkey1value&nested%5Bmapkey1%5D%5Bmapkey1mapkey2%5D=mapkey1mapkey2value";
        String actualQueryString = QueryStringMapperTest.queryString((Map<String, Object>)new HashMap<String, Object>(this){
            final /* synthetic */ QueryStringMapperTest this$0;
            {
                this.this$0 = this$0;
                this.put("nested", nestedMap);
            }
        }, true);
        Assertions.assertEquals((Object)expectedQueryString, (Object)actualQueryString);
    }

    @Test
    public void testDateTime_indexedArrays() {
        final OffsetDateTime dateTime = OffsetDateTime.ofInstant(Instant.ofEpochSecond(1740412107L), ZoneId.of("America/New_York"));
        String expectedQueryString = "datetime=2025-02-24T10%3A48%3A27-05%3A00";
        String actualQueryString = QueryStringMapperTest.queryString((Map<String, Object>)new HashMap<String, Object>(this){
            final /* synthetic */ QueryStringMapperTest this$0;
            {
                this.this$0 = this$0;
                this.put("datetime", dateTime);
            }
        }, false);
        Assertions.assertEquals((Object)expectedQueryString, (Object)actualQueryString);
    }

    @Test
    public void testDateTime_arraysAsRepeats() {
        final OffsetDateTime dateTime = OffsetDateTime.ofInstant(Instant.ofEpochSecond(1740412107L), ZoneId.of("America/New_York"));
        String expectedQueryString = "datetime=2025-02-24T10%3A48%3A27-05%3A00";
        String actualQueryString = QueryStringMapperTest.queryString((Map<String, Object>)new HashMap<String, Object>(this){
            final /* synthetic */ QueryStringMapperTest this$0;
            {
                this.this$0 = this$0;
                this.put("datetime", dateTime);
            }
        }, true);
        Assertions.assertEquals((Object)expectedQueryString, (Object)actualQueryString);
    }

    @Test
    public void testObjectArray_indexedArrays() {
        final ArrayList<Map<String, String>> mapArray = new ArrayList<Map<String, String>>(){
            {
                this.add(new HashMap<String, String>(){
                    {
                        this.put("key", "hello");
                        this.put("value", "world");
                    }
                });
                this.add(new HashMap<String, String>(){
                    {
                        this.put("key", "foo");
                        this.put("value", "bar");
                    }
                });
                this.add(new HashMap());
            }
        };
        String expectedQueryString = "objects%5B0%5D%5Bvalue%5D=world&objects%5B0%5D%5Bkey%5D=hello&objects%5B1%5D%5Bvalue%5D=bar&objects%5B1%5D%5Bkey%5D=foo";
        String actualQueryString = QueryStringMapperTest.queryString((Map<String, Object>)new HashMap<String, Object>(this){
            final /* synthetic */ QueryStringMapperTest this$0;
            {
                this.this$0 = this$0;
                this.put("objects", mapArray);
            }
        }, false);
        Assertions.assertEquals((Object)expectedQueryString, (Object)actualQueryString);
    }

    @Test
    public void testObjectArray_arraysAsRepeats() {
        final ArrayList<Map<String, String>> mapArray = new ArrayList<Map<String, String>>(){
            {
                this.add(new HashMap<String, String>(){
                    {
                        this.put("key", "hello");
                        this.put("value", "world");
                    }
                });
                this.add(new HashMap<String, String>(){
                    {
                        this.put("key", "foo");
                        this.put("value", "bar");
                    }
                });
                this.add(new HashMap());
            }
        };
        String expectedQueryString = "objects%5Bvalue%5D=world&objects%5Bkey%5D=hello&objects%5Bvalue%5D=bar&objects%5Bkey%5D=foo";
        String actualQueryString = QueryStringMapperTest.queryString((Map<String, Object>)new HashMap<String, Object>(this){
            final /* synthetic */ QueryStringMapperTest this$0;
            {
                this.this$0 = this$0;
                this.put("objects", mapArray);
            }
        }, true);
        Assertions.assertEquals((Object)expectedQueryString, (Object)actualQueryString);
    }

    @Test
    public void testObjectWithArray_indexedArrays() {
        final HashMap<String, Object> objectWithArray = new HashMap<String, Object>(){
            {
                this.put("id", "abc123");
                this.put("contactIds", new ArrayList<String>(){
                    {
                        this.add("id1");
                        this.add("id2");
                        this.add("id3");
                    }
                });
            }
        };
        String expectedQueryString = "objectwitharray%5Bid%5D=abc123&objectwitharray%5BcontactIds%5D%5B0%5D=id1&objectwitharray%5BcontactIds%5D%5B1%5D=id2&objectwitharray%5BcontactIds%5D%5B2%5D=id3";
        String actualQueryString = QueryStringMapperTest.queryString((Map<String, Object>)new HashMap<String, Object>(this){
            final /* synthetic */ QueryStringMapperTest this$0;
            {
                this.this$0 = this$0;
                this.put("objectwitharray", objectWithArray);
            }
        }, false);
        Assertions.assertEquals((Object)expectedQueryString, (Object)actualQueryString);
    }

    @Test
    public void testObjectWithArray_arraysAsRepeats() {
        final HashMap<String, Object> objectWithArray = new HashMap<String, Object>(){
            {
                this.put("id", "abc123");
                this.put("contactIds", new ArrayList<String>(){
                    {
                        this.add("id1");
                        this.add("id2");
                        this.add("id3");
                    }
                });
            }
        };
        String expectedQueryString = "objectwitharray%5Bid%5D=abc123&objectwitharray%5BcontactIds%5D=id1&objectwitharray%5BcontactIds%5D=id2&objectwitharray%5BcontactIds%5D=id3";
        String actualQueryString = QueryStringMapperTest.queryString((Map<String, Object>)new HashMap<String, Object>(this){
            final /* synthetic */ QueryStringMapperTest this$0;
            {
                this.this$0 = this$0;
                this.put("objectwitharray", objectWithArray);
            }
        }, true);
        Assertions.assertEquals((Object)expectedQueryString, (Object)actualQueryString);
    }

    private static String queryString(Map<String, Object> params, boolean arraysAsRepeats) {
        HttpUrl.Builder httpUrl = HttpUrl.parse((String)"http://www.fakewebsite.com/").newBuilder();
        params.forEach((paramName, paramValue) -> QueryStringMapper.addQueryParameter(httpUrl, paramName, paramValue, arraysAsRepeats));
        return httpUrl.build().encodedQuery();
    }
}

