/*
 * Decompiled with CFR 0.152.
 */
package com.langfuse.client.resources.annotationqueues.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.langfuse.client.core.ObjectMappers;
import com.langfuse.client.resources.annotationqueues.types.AnnotationQueueObjectType;
import com.langfuse.client.resources.annotationqueues.types.AnnotationQueueStatus;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class AnnotationQueueItem {
    private final String id;
    private final String queueId;
    private final String objectId;
    private final AnnotationQueueObjectType objectType;
    private final AnnotationQueueStatus status;
    private final Optional<OffsetDateTime> completedAt;
    private final OffsetDateTime createdAt;
    private final OffsetDateTime updatedAt;
    private final Map<String, Object> additionalProperties;

    private AnnotationQueueItem(String id, String queueId, String objectId, AnnotationQueueObjectType objectType, AnnotationQueueStatus status, Optional<OffsetDateTime> completedAt, OffsetDateTime createdAt, OffsetDateTime updatedAt, Map<String, Object> additionalProperties) {
        this.id = id;
        this.queueId = queueId;
        this.objectId = objectId;
        this.objectType = objectType;
        this.status = status;
        this.completedAt = completedAt;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="queueId")
    public String getQueueId() {
        return this.queueId;
    }

    @JsonProperty(value="objectId")
    public String getObjectId() {
        return this.objectId;
    }

    @JsonProperty(value="objectType")
    public AnnotationQueueObjectType getObjectType() {
        return this.objectType;
    }

    @JsonProperty(value="status")
    public AnnotationQueueStatus getStatus() {
        return this.status;
    }

    @JsonProperty(value="completedAt")
    public Optional<OffsetDateTime> getCompletedAt() {
        return this.completedAt;
    }

    @JsonProperty(value="createdAt")
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="updatedAt")
    public OffsetDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof AnnotationQueueItem && this.equalTo((AnnotationQueueItem)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(AnnotationQueueItem other) {
        return this.id.equals(other.id) && this.queueId.equals(other.queueId) && this.objectId.equals(other.objectId) && this.objectType.equals((Object)other.objectType) && this.status.equals((Object)other.status) && this.completedAt.equals(other.completedAt) && this.createdAt.equals(other.createdAt) && this.updatedAt.equals(other.updatedAt);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.queueId, this.objectId, this.objectType, this.status, this.completedAt, this.createdAt, this.updatedAt});
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements IdStage,
    QueueIdStage,
    ObjectIdStage,
    ObjectTypeStage,
    StatusStage,
    CreatedAtStage,
    UpdatedAtStage,
    _FinalStage {
        private String id;
        private String queueId;
        private String objectId;
        private AnnotationQueueObjectType objectType;
        private AnnotationQueueStatus status;
        private OffsetDateTime createdAt;
        private OffsetDateTime updatedAt;
        private Optional<OffsetDateTime> completedAt = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(AnnotationQueueItem other) {
            this.id(other.getId());
            this.queueId(other.getQueueId());
            this.objectId(other.getObjectId());
            this.objectType(other.getObjectType());
            this.status(other.getStatus());
            this.completedAt(other.getCompletedAt());
            this.createdAt(other.getCreatedAt());
            this.updatedAt(other.getUpdatedAt());
            return this;
        }

        @Override
        @JsonSetter(value="id")
        public QueueIdStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="queueId")
        public ObjectIdStage queueId(@NotNull String queueId) {
            this.queueId = Objects.requireNonNull(queueId, "queueId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="objectId")
        public ObjectTypeStage objectId(@NotNull String objectId) {
            this.objectId = Objects.requireNonNull(objectId, "objectId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="objectType")
        public StatusStage objectType(@NotNull AnnotationQueueObjectType objectType) {
            this.objectType = Objects.requireNonNull(objectType, "objectType must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="status")
        public CreatedAtStage status(@NotNull AnnotationQueueStatus status) {
            this.status = Objects.requireNonNull(status, "status must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="createdAt")
        public UpdatedAtStage createdAt(@NotNull OffsetDateTime createdAt) {
            this.createdAt = Objects.requireNonNull(createdAt, "createdAt must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="updatedAt")
        public _FinalStage updatedAt(@NotNull OffsetDateTime updatedAt) {
            this.updatedAt = Objects.requireNonNull(updatedAt, "updatedAt must not be null");
            return this;
        }

        @Override
        public _FinalStage completedAt(OffsetDateTime completedAt) {
            this.completedAt = Optional.ofNullable(completedAt);
            return this;
        }

        @Override
        @JsonSetter(value="completedAt", nulls=Nulls.SKIP)
        public _FinalStage completedAt(Optional<OffsetDateTime> completedAt) {
            this.completedAt = completedAt;
            return this;
        }

        @Override
        public AnnotationQueueItem build() {
            return new AnnotationQueueItem(this.id, this.queueId, this.objectId, this.objectType, this.status, this.completedAt, this.createdAt, this.updatedAt, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public AnnotationQueueItem build();

        public _FinalStage completedAt(Optional<OffsetDateTime> var1);

        public _FinalStage completedAt(OffsetDateTime var1);
    }

    public static interface UpdatedAtStage {
        public _FinalStage updatedAt(@NotNull OffsetDateTime var1);
    }

    public static interface CreatedAtStage {
        public UpdatedAtStage createdAt(@NotNull OffsetDateTime var1);
    }

    public static interface StatusStage {
        public CreatedAtStage status(@NotNull AnnotationQueueStatus var1);
    }

    public static interface ObjectTypeStage {
        public StatusStage objectType(@NotNull AnnotationQueueObjectType var1);
    }

    public static interface ObjectIdStage {
        public ObjectTypeStage objectId(@NotNull String var1);
    }

    public static interface QueueIdStage {
        public ObjectIdStage queueId(@NotNull String var1);
    }

    public static interface IdStage {
        public QueueIdStage id(@NotNull String var1);

        public Builder from(AnnotationQueueItem var1);
    }
}

