/*
 * Decompiled with CFR 0.152.
 */
package com.langfuse.client.resources.annotationqueues.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.langfuse.client.core.ObjectMappers;
import com.langfuse.client.resources.annotationqueues.types.AnnotationQueueObjectType;
import com.langfuse.client.resources.annotationqueues.types.AnnotationQueueStatus;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CreateAnnotationQueueItemRequest {
    private final String objectId;
    private final AnnotationQueueObjectType objectType;
    private final Optional<AnnotationQueueStatus> status;
    private final Map<String, Object> additionalProperties;

    private CreateAnnotationQueueItemRequest(String objectId, AnnotationQueueObjectType objectType, Optional<AnnotationQueueStatus> status, Map<String, Object> additionalProperties) {
        this.objectId = objectId;
        this.objectType = objectType;
        this.status = status;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="objectId")
    public String getObjectId() {
        return this.objectId;
    }

    @JsonProperty(value="objectType")
    public AnnotationQueueObjectType getObjectType() {
        return this.objectType;
    }

    @JsonProperty(value="status")
    public Optional<AnnotationQueueStatus> getStatus() {
        return this.status;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CreateAnnotationQueueItemRequest && this.equalTo((CreateAnnotationQueueItemRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CreateAnnotationQueueItemRequest other) {
        return this.objectId.equals(other.objectId) && this.objectType.equals((Object)other.objectType) && this.status.equals(other.status);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.objectId, this.objectType, this.status});
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static ObjectIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements ObjectIdStage,
    ObjectTypeStage,
    _FinalStage {
        private String objectId;
        private AnnotationQueueObjectType objectType;
        private Optional<AnnotationQueueStatus> status = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(CreateAnnotationQueueItemRequest other) {
            this.objectId(other.getObjectId());
            this.objectType(other.getObjectType());
            this.status(other.getStatus());
            return this;
        }

        @Override
        @JsonSetter(value="objectId")
        public ObjectTypeStage objectId(@NotNull String objectId) {
            this.objectId = Objects.requireNonNull(objectId, "objectId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="objectType")
        public _FinalStage objectType(@NotNull AnnotationQueueObjectType objectType) {
            this.objectType = Objects.requireNonNull(objectType, "objectType must not be null");
            return this;
        }

        @Override
        public _FinalStage status(AnnotationQueueStatus status) {
            this.status = Optional.ofNullable(status);
            return this;
        }

        @Override
        @JsonSetter(value="status", nulls=Nulls.SKIP)
        public _FinalStage status(Optional<AnnotationQueueStatus> status) {
            this.status = status;
            return this;
        }

        @Override
        public CreateAnnotationQueueItemRequest build() {
            return new CreateAnnotationQueueItemRequest(this.objectId, this.objectType, this.status, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public CreateAnnotationQueueItemRequest build();

        public _FinalStage status(Optional<AnnotationQueueStatus> var1);

        public _FinalStage status(AnnotationQueueStatus var1);
    }

    public static interface ObjectTypeStage {
        public _FinalStage objectType(@NotNull AnnotationQueueObjectType var1);
    }

    public static interface ObjectIdStage {
        public ObjectTypeStage objectId(@NotNull String var1);

        public Builder from(CreateAnnotationQueueItemRequest var1);
    }
}

