/*
 * Decompiled with CFR 0.152.
 */
package com.langfuse.client.resources.comments.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.langfuse.client.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class GetCommentsRequest {
    private final Optional<Integer> page;
    private final Optional<Integer> limit;
    private final Optional<String> objectType;
    private final Optional<String> objectId;
    private final Optional<String> authorUserId;
    private final Map<String, Object> additionalProperties;

    private GetCommentsRequest(Optional<Integer> page, Optional<Integer> limit, Optional<String> objectType, Optional<String> objectId, Optional<String> authorUserId, Map<String, Object> additionalProperties) {
        this.page = page;
        this.limit = limit;
        this.objectType = objectType;
        this.objectId = objectId;
        this.authorUserId = authorUserId;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="page")
    public Optional<Integer> getPage() {
        return this.page;
    }

    @JsonProperty(value="limit")
    public Optional<Integer> getLimit() {
        return this.limit;
    }

    @JsonProperty(value="objectType")
    public Optional<String> getObjectType() {
        return this.objectType;
    }

    @JsonProperty(value="objectId")
    public Optional<String> getObjectId() {
        return this.objectId;
    }

    @JsonProperty(value="authorUserId")
    public Optional<String> getAuthorUserId() {
        return this.authorUserId;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof GetCommentsRequest && this.equalTo((GetCommentsRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(GetCommentsRequest other) {
        return this.page.equals(other.page) && this.limit.equals(other.limit) && this.objectType.equals(other.objectType) && this.objectId.equals(other.objectId) && this.authorUserId.equals(other.authorUserId);
    }

    public int hashCode() {
        return Objects.hash(this.page, this.limit, this.objectType, this.objectId, this.authorUserId);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<Integer> page = Optional.empty();
        private Optional<Integer> limit = Optional.empty();
        private Optional<String> objectType = Optional.empty();
        private Optional<String> objectId = Optional.empty();
        private Optional<String> authorUserId = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(GetCommentsRequest other) {
            this.page(other.getPage());
            this.limit(other.getLimit());
            this.objectType(other.getObjectType());
            this.objectId(other.getObjectId());
            this.authorUserId(other.getAuthorUserId());
            return this;
        }

        @JsonSetter(value="page", nulls=Nulls.SKIP)
        public Builder page(Optional<Integer> page) {
            this.page = page;
            return this;
        }

        public Builder page(Integer page) {
            this.page = Optional.ofNullable(page);
            return this;
        }

        @JsonSetter(value="limit", nulls=Nulls.SKIP)
        public Builder limit(Optional<Integer> limit) {
            this.limit = limit;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = Optional.ofNullable(limit);
            return this;
        }

        @JsonSetter(value="objectType", nulls=Nulls.SKIP)
        public Builder objectType(Optional<String> objectType) {
            this.objectType = objectType;
            return this;
        }

        public Builder objectType(String objectType) {
            this.objectType = Optional.ofNullable(objectType);
            return this;
        }

        @JsonSetter(value="objectId", nulls=Nulls.SKIP)
        public Builder objectId(Optional<String> objectId) {
            this.objectId = objectId;
            return this;
        }

        public Builder objectId(String objectId) {
            this.objectId = Optional.ofNullable(objectId);
            return this;
        }

        @JsonSetter(value="authorUserId", nulls=Nulls.SKIP)
        public Builder authorUserId(Optional<String> authorUserId) {
            this.authorUserId = authorUserId;
            return this;
        }

        public Builder authorUserId(String authorUserId) {
            this.authorUserId = Optional.ofNullable(authorUserId);
            return this;
        }

        public GetCommentsRequest build() {
            return new GetCommentsRequest(this.page, this.limit, this.objectType, this.objectId, this.authorUserId, this.additionalProperties);
        }
    }
}

