/*
 * Decompiled with CFR 0.152.
 */
package com.langfuse.client.resources.datasetrunitems.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.langfuse.client.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CreateDatasetRunItemRequest {
    private final String runName;
    private final Optional<String> runDescription;
    private final Optional<Object> metadata;
    private final String datasetItemId;
    private final Optional<String> observationId;
    private final Optional<String> traceId;
    private final Map<String, Object> additionalProperties;

    private CreateDatasetRunItemRequest(String runName, Optional<String> runDescription, Optional<Object> metadata, String datasetItemId, Optional<String> observationId, Optional<String> traceId, Map<String, Object> additionalProperties) {
        this.runName = runName;
        this.runDescription = runDescription;
        this.metadata = metadata;
        this.datasetItemId = datasetItemId;
        this.observationId = observationId;
        this.traceId = traceId;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="runName")
    public String getRunName() {
        return this.runName;
    }

    @JsonProperty(value="runDescription")
    public Optional<String> getRunDescription() {
        return this.runDescription;
    }

    @JsonProperty(value="metadata")
    public Optional<Object> getMetadata() {
        return this.metadata;
    }

    @JsonProperty(value="datasetItemId")
    public String getDatasetItemId() {
        return this.datasetItemId;
    }

    @JsonProperty(value="observationId")
    public Optional<String> getObservationId() {
        return this.observationId;
    }

    @JsonProperty(value="traceId")
    public Optional<String> getTraceId() {
        return this.traceId;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CreateDatasetRunItemRequest && this.equalTo((CreateDatasetRunItemRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CreateDatasetRunItemRequest other) {
        return this.runName.equals(other.runName) && this.runDescription.equals(other.runDescription) && this.metadata.equals(other.metadata) && this.datasetItemId.equals(other.datasetItemId) && this.observationId.equals(other.observationId) && this.traceId.equals(other.traceId);
    }

    public int hashCode() {
        return Objects.hash(this.runName, this.runDescription, this.metadata, this.datasetItemId, this.observationId, this.traceId);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static RunNameStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements RunNameStage,
    DatasetItemIdStage,
    _FinalStage {
        private String runName;
        private String datasetItemId;
        private Optional<String> traceId = Optional.empty();
        private Optional<String> observationId = Optional.empty();
        private Optional<Object> metadata = Optional.empty();
        private Optional<String> runDescription = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(CreateDatasetRunItemRequest other) {
            this.runName(other.getRunName());
            this.runDescription(other.getRunDescription());
            this.metadata(other.getMetadata());
            this.datasetItemId(other.getDatasetItemId());
            this.observationId(other.getObservationId());
            this.traceId(other.getTraceId());
            return this;
        }

        @Override
        @JsonSetter(value="runName")
        public DatasetItemIdStage runName(@NotNull String runName) {
            this.runName = Objects.requireNonNull(runName, "runName must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="datasetItemId")
        public _FinalStage datasetItemId(@NotNull String datasetItemId) {
            this.datasetItemId = Objects.requireNonNull(datasetItemId, "datasetItemId must not be null");
            return this;
        }

        @Override
        public _FinalStage traceId(String traceId) {
            this.traceId = Optional.ofNullable(traceId);
            return this;
        }

        @Override
        @JsonSetter(value="traceId", nulls=Nulls.SKIP)
        public _FinalStage traceId(Optional<String> traceId) {
            this.traceId = traceId;
            return this;
        }

        @Override
        public _FinalStage observationId(String observationId) {
            this.observationId = Optional.ofNullable(observationId);
            return this;
        }

        @Override
        @JsonSetter(value="observationId", nulls=Nulls.SKIP)
        public _FinalStage observationId(Optional<String> observationId) {
            this.observationId = observationId;
            return this;
        }

        @Override
        public _FinalStage metadata(Object metadata) {
            this.metadata = Optional.ofNullable(metadata);
            return this;
        }

        @Override
        @JsonSetter(value="metadata", nulls=Nulls.SKIP)
        public _FinalStage metadata(Optional<Object> metadata) {
            this.metadata = metadata;
            return this;
        }

        @Override
        public _FinalStage runDescription(String runDescription) {
            this.runDescription = Optional.ofNullable(runDescription);
            return this;
        }

        @Override
        @JsonSetter(value="runDescription", nulls=Nulls.SKIP)
        public _FinalStage runDescription(Optional<String> runDescription) {
            this.runDescription = runDescription;
            return this;
        }

        @Override
        public CreateDatasetRunItemRequest build() {
            return new CreateDatasetRunItemRequest(this.runName, this.runDescription, this.metadata, this.datasetItemId, this.observationId, this.traceId, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public CreateDatasetRunItemRequest build();

        public _FinalStage runDescription(Optional<String> var1);

        public _FinalStage runDescription(String var1);

        public _FinalStage metadata(Optional<Object> var1);

        public _FinalStage metadata(Object var1);

        public _FinalStage observationId(Optional<String> var1);

        public _FinalStage observationId(String var1);

        public _FinalStage traceId(Optional<String> var1);

        public _FinalStage traceId(String var1);
    }

    public static interface DatasetItemIdStage {
        public _FinalStage datasetItemId(@NotNull String var1);
    }

    public static interface RunNameStage {
        public DatasetItemIdStage runName(@NotNull String var1);

        public Builder from(CreateDatasetRunItemRequest var1);
    }
}

