/*
 * Decompiled with CFR 0.152.
 */
package com.langfuse.client.resources.ingestion.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.langfuse.client.core.ObjectMappers;
import com.langfuse.client.resources.ingestion.types.CreateSpanBody;
import com.langfuse.client.resources.ingestion.types.IBaseEvent;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CreateSpanEvent
implements IBaseEvent {
    private final String id;
    private final String timestamp;
    private final Optional<Object> metadata;
    private final CreateSpanBody body;
    private final Map<String, Object> additionalProperties;

    private CreateSpanEvent(String id, String timestamp, Optional<Object> metadata, CreateSpanBody body, Map<String, Object> additionalProperties) {
        this.id = id;
        this.timestamp = timestamp;
        this.metadata = metadata;
        this.body = body;
        this.additionalProperties = additionalProperties;
    }

    @Override
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @Override
    @JsonProperty(value="timestamp")
    public String getTimestamp() {
        return this.timestamp;
    }

    @Override
    @JsonProperty(value="metadata")
    public Optional<Object> getMetadata() {
        return this.metadata;
    }

    @JsonProperty(value="body")
    public CreateSpanBody getBody() {
        return this.body;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CreateSpanEvent && this.equalTo((CreateSpanEvent)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CreateSpanEvent other) {
        return this.id.equals(other.id) && this.timestamp.equals(other.timestamp) && this.metadata.equals(other.metadata) && this.body.equals(other.body);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.timestamp, this.metadata, this.body);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements IdStage,
    TimestampStage,
    BodyStage,
    _FinalStage {
        private String id;
        private String timestamp;
        private CreateSpanBody body;
        private Optional<Object> metadata = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(CreateSpanEvent other) {
            this.id(other.getId());
            this.timestamp(other.getTimestamp());
            this.metadata(other.getMetadata());
            this.body(other.getBody());
            return this;
        }

        @Override
        @JsonSetter(value="id")
        public TimestampStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="timestamp")
        public BodyStage timestamp(@NotNull String timestamp) {
            this.timestamp = Objects.requireNonNull(timestamp, "timestamp must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="body")
        public _FinalStage body(@NotNull CreateSpanBody body) {
            this.body = Objects.requireNonNull(body, "body must not be null");
            return this;
        }

        @Override
        public _FinalStage metadata(Object metadata) {
            this.metadata = Optional.ofNullable(metadata);
            return this;
        }

        @Override
        @JsonSetter(value="metadata", nulls=Nulls.SKIP)
        public _FinalStage metadata(Optional<Object> metadata) {
            this.metadata = metadata;
            return this;
        }

        @Override
        public CreateSpanEvent build() {
            return new CreateSpanEvent(this.id, this.timestamp, this.metadata, this.body, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public CreateSpanEvent build();

        public _FinalStage metadata(Optional<Object> var1);

        public _FinalStage metadata(Object var1);
    }

    public static interface BodyStage {
        public _FinalStage body(@NotNull CreateSpanBody var1);
    }

    public static interface TimestampStage {
        public BodyStage timestamp(@NotNull String var1);
    }

    public static interface IdStage {
        public TimestampStage id(@NotNull String var1);

        public Builder from(CreateSpanEvent var1);
    }
}

