/*
 * Decompiled with CFR 0.152.
 */
package com.langfuse.client.resources.ingestion.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.langfuse.client.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class OpenAiCompletionUsageSchema {
    private final int promptTokens;
    private final int completionTokens;
    private final int totalTokens;
    private final Optional<Map<String, Optional<Integer>>> promptTokensDetails;
    private final Optional<Map<String, Optional<Integer>>> completionTokensDetails;
    private final Map<String, Object> additionalProperties;

    private OpenAiCompletionUsageSchema(int promptTokens, int completionTokens, int totalTokens, Optional<Map<String, Optional<Integer>>> promptTokensDetails, Optional<Map<String, Optional<Integer>>> completionTokensDetails, Map<String, Object> additionalProperties) {
        this.promptTokens = promptTokens;
        this.completionTokens = completionTokens;
        this.totalTokens = totalTokens;
        this.promptTokensDetails = promptTokensDetails;
        this.completionTokensDetails = completionTokensDetails;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="prompt_tokens")
    public int getPromptTokens() {
        return this.promptTokens;
    }

    @JsonProperty(value="completion_tokens")
    public int getCompletionTokens() {
        return this.completionTokens;
    }

    @JsonProperty(value="total_tokens")
    public int getTotalTokens() {
        return this.totalTokens;
    }

    @JsonProperty(value="prompt_tokens_details")
    public Optional<Map<String, Optional<Integer>>> getPromptTokensDetails() {
        return this.promptTokensDetails;
    }

    @JsonProperty(value="completion_tokens_details")
    public Optional<Map<String, Optional<Integer>>> getCompletionTokensDetails() {
        return this.completionTokensDetails;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof OpenAiCompletionUsageSchema && this.equalTo((OpenAiCompletionUsageSchema)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(OpenAiCompletionUsageSchema other) {
        return this.promptTokens == other.promptTokens && this.completionTokens == other.completionTokens && this.totalTokens == other.totalTokens && this.promptTokensDetails.equals(other.promptTokensDetails) && this.completionTokensDetails.equals(other.completionTokensDetails);
    }

    public int hashCode() {
        return Objects.hash(this.promptTokens, this.completionTokens, this.totalTokens, this.promptTokensDetails, this.completionTokensDetails);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static PromptTokensStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements PromptTokensStage,
    CompletionTokensStage,
    TotalTokensStage,
    _FinalStage {
        private int promptTokens;
        private int completionTokens;
        private int totalTokens;
        private Optional<Map<String, Optional<Integer>>> completionTokensDetails = Optional.empty();
        private Optional<Map<String, Optional<Integer>>> promptTokensDetails = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(OpenAiCompletionUsageSchema other) {
            this.promptTokens(other.getPromptTokens());
            this.completionTokens(other.getCompletionTokens());
            this.totalTokens(other.getTotalTokens());
            this.promptTokensDetails(other.getPromptTokensDetails());
            this.completionTokensDetails(other.getCompletionTokensDetails());
            return this;
        }

        @Override
        @JsonSetter(value="prompt_tokens")
        public CompletionTokensStage promptTokens(int promptTokens) {
            this.promptTokens = promptTokens;
            return this;
        }

        @Override
        @JsonSetter(value="completion_tokens")
        public TotalTokensStage completionTokens(int completionTokens) {
            this.completionTokens = completionTokens;
            return this;
        }

        @Override
        @JsonSetter(value="total_tokens")
        public _FinalStage totalTokens(int totalTokens) {
            this.totalTokens = totalTokens;
            return this;
        }

        @Override
        public _FinalStage completionTokensDetails(Map<String, Optional<Integer>> completionTokensDetails) {
            this.completionTokensDetails = Optional.ofNullable(completionTokensDetails);
            return this;
        }

        @Override
        @JsonSetter(value="completion_tokens_details", nulls=Nulls.SKIP)
        public _FinalStage completionTokensDetails(Optional<Map<String, Optional<Integer>>> completionTokensDetails) {
            this.completionTokensDetails = completionTokensDetails;
            return this;
        }

        @Override
        public _FinalStage promptTokensDetails(Map<String, Optional<Integer>> promptTokensDetails) {
            this.promptTokensDetails = Optional.ofNullable(promptTokensDetails);
            return this;
        }

        @Override
        @JsonSetter(value="prompt_tokens_details", nulls=Nulls.SKIP)
        public _FinalStage promptTokensDetails(Optional<Map<String, Optional<Integer>>> promptTokensDetails) {
            this.promptTokensDetails = promptTokensDetails;
            return this;
        }

        @Override
        public OpenAiCompletionUsageSchema build() {
            return new OpenAiCompletionUsageSchema(this.promptTokens, this.completionTokens, this.totalTokens, this.promptTokensDetails, this.completionTokensDetails, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public OpenAiCompletionUsageSchema build();

        public _FinalStage promptTokensDetails(Optional<Map<String, Optional<Integer>>> var1);

        public _FinalStage promptTokensDetails(Map<String, Optional<Integer>> var1);

        public _FinalStage completionTokensDetails(Optional<Map<String, Optional<Integer>>> var1);

        public _FinalStage completionTokensDetails(Map<String, Optional<Integer>> var1);
    }

    public static interface TotalTokensStage {
        public _FinalStage totalTokens(int var1);
    }

    public static interface CompletionTokensStage {
        public TotalTokensStage completionTokens(int var1);
    }

    public static interface PromptTokensStage {
        public CompletionTokensStage promptTokens(int var1);

        public Builder from(OpenAiCompletionUsageSchema var1);
    }
}

