/*
 * Decompiled with CFR 0.152.
 */
package com.langfuse.client.resources.ingestion.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.langfuse.client.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class OpenAiResponseUsageSchema {
    private final int inputTokens;
    private final int outputTokens;
    private final int totalTokens;
    private final Optional<Map<String, Optional<Integer>>> inputTokensDetails;
    private final Optional<Map<String, Optional<Integer>>> outputTokensDetails;
    private final Map<String, Object> additionalProperties;

    private OpenAiResponseUsageSchema(int inputTokens, int outputTokens, int totalTokens, Optional<Map<String, Optional<Integer>>> inputTokensDetails, Optional<Map<String, Optional<Integer>>> outputTokensDetails, Map<String, Object> additionalProperties) {
        this.inputTokens = inputTokens;
        this.outputTokens = outputTokens;
        this.totalTokens = totalTokens;
        this.inputTokensDetails = inputTokensDetails;
        this.outputTokensDetails = outputTokensDetails;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="input_tokens")
    public int getInputTokens() {
        return this.inputTokens;
    }

    @JsonProperty(value="output_tokens")
    public int getOutputTokens() {
        return this.outputTokens;
    }

    @JsonProperty(value="total_tokens")
    public int getTotalTokens() {
        return this.totalTokens;
    }

    @JsonProperty(value="input_tokens_details")
    public Optional<Map<String, Optional<Integer>>> getInputTokensDetails() {
        return this.inputTokensDetails;
    }

    @JsonProperty(value="output_tokens_details")
    public Optional<Map<String, Optional<Integer>>> getOutputTokensDetails() {
        return this.outputTokensDetails;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof OpenAiResponseUsageSchema && this.equalTo((OpenAiResponseUsageSchema)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(OpenAiResponseUsageSchema other) {
        return this.inputTokens == other.inputTokens && this.outputTokens == other.outputTokens && this.totalTokens == other.totalTokens && this.inputTokensDetails.equals(other.inputTokensDetails) && this.outputTokensDetails.equals(other.outputTokensDetails);
    }

    public int hashCode() {
        return Objects.hash(this.inputTokens, this.outputTokens, this.totalTokens, this.inputTokensDetails, this.outputTokensDetails);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static InputTokensStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements InputTokensStage,
    OutputTokensStage,
    TotalTokensStage,
    _FinalStage {
        private int inputTokens;
        private int outputTokens;
        private int totalTokens;
        private Optional<Map<String, Optional<Integer>>> outputTokensDetails = Optional.empty();
        private Optional<Map<String, Optional<Integer>>> inputTokensDetails = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(OpenAiResponseUsageSchema other) {
            this.inputTokens(other.getInputTokens());
            this.outputTokens(other.getOutputTokens());
            this.totalTokens(other.getTotalTokens());
            this.inputTokensDetails(other.getInputTokensDetails());
            this.outputTokensDetails(other.getOutputTokensDetails());
            return this;
        }

        @Override
        @JsonSetter(value="input_tokens")
        public OutputTokensStage inputTokens(int inputTokens) {
            this.inputTokens = inputTokens;
            return this;
        }

        @Override
        @JsonSetter(value="output_tokens")
        public TotalTokensStage outputTokens(int outputTokens) {
            this.outputTokens = outputTokens;
            return this;
        }

        @Override
        @JsonSetter(value="total_tokens")
        public _FinalStage totalTokens(int totalTokens) {
            this.totalTokens = totalTokens;
            return this;
        }

        @Override
        public _FinalStage outputTokensDetails(Map<String, Optional<Integer>> outputTokensDetails) {
            this.outputTokensDetails = Optional.ofNullable(outputTokensDetails);
            return this;
        }

        @Override
        @JsonSetter(value="output_tokens_details", nulls=Nulls.SKIP)
        public _FinalStage outputTokensDetails(Optional<Map<String, Optional<Integer>>> outputTokensDetails) {
            this.outputTokensDetails = outputTokensDetails;
            return this;
        }

        @Override
        public _FinalStage inputTokensDetails(Map<String, Optional<Integer>> inputTokensDetails) {
            this.inputTokensDetails = Optional.ofNullable(inputTokensDetails);
            return this;
        }

        @Override
        @JsonSetter(value="input_tokens_details", nulls=Nulls.SKIP)
        public _FinalStage inputTokensDetails(Optional<Map<String, Optional<Integer>>> inputTokensDetails) {
            this.inputTokensDetails = inputTokensDetails;
            return this;
        }

        @Override
        public OpenAiResponseUsageSchema build() {
            return new OpenAiResponseUsageSchema(this.inputTokens, this.outputTokens, this.totalTokens, this.inputTokensDetails, this.outputTokensDetails, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public OpenAiResponseUsageSchema build();

        public _FinalStage inputTokensDetails(Optional<Map<String, Optional<Integer>>> var1);

        public _FinalStage inputTokensDetails(Map<String, Optional<Integer>> var1);

        public _FinalStage outputTokensDetails(Optional<Map<String, Optional<Integer>>> var1);

        public _FinalStage outputTokensDetails(Map<String, Optional<Integer>> var1);
    }

    public static interface TotalTokensStage {
        public _FinalStage totalTokens(int var1);
    }

    public static interface OutputTokensStage {
        public TotalTokensStage outputTokens(int var1);
    }

    public static interface InputTokensStage {
        public OutputTokensStage inputTokens(int var1);

        public Builder from(OpenAiResponseUsageSchema var1);
    }
}

