/*
 * Decompiled with CFR 0.152.
 */
package com.langfuse.client.resources.organizations.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.langfuse.client.core.ObjectMappers;
import com.langfuse.client.resources.organizations.types.MembershipRole;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class MembershipResponse {
    private final String userId;
    private final MembershipRole role;
    private final String email;
    private final String name;
    private final Map<String, Object> additionalProperties;

    private MembershipResponse(String userId, MembershipRole role, String email, String name, Map<String, Object> additionalProperties) {
        this.userId = userId;
        this.role = role;
        this.email = email;
        this.name = name;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="userId")
    public String getUserId() {
        return this.userId;
    }

    @JsonProperty(value="role")
    public MembershipRole getRole() {
        return this.role;
    }

    @JsonProperty(value="email")
    public String getEmail() {
        return this.email;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof MembershipResponse && this.equalTo((MembershipResponse)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(MembershipResponse other) {
        return this.userId.equals(other.userId) && this.role.equals((Object)other.role) && this.email.equals(other.email) && this.name.equals(other.name);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.userId, this.role, this.email, this.name});
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static UserIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements UserIdStage,
    RoleStage,
    EmailStage,
    NameStage,
    _FinalStage {
        private String userId;
        private MembershipRole role;
        private String email;
        private String name;
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(MembershipResponse other) {
            this.userId(other.getUserId());
            this.role(other.getRole());
            this.email(other.getEmail());
            this.name(other.getName());
            return this;
        }

        @Override
        @JsonSetter(value="userId")
        public RoleStage userId(@NotNull String userId) {
            this.userId = Objects.requireNonNull(userId, "userId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="role")
        public EmailStage role(@NotNull MembershipRole role) {
            this.role = Objects.requireNonNull(role, "role must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="email")
        public NameStage email(@NotNull String email) {
            this.email = Objects.requireNonNull(email, "email must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="name")
        public _FinalStage name(@NotNull String name) {
            this.name = Objects.requireNonNull(name, "name must not be null");
            return this;
        }

        @Override
        public MembershipResponse build() {
            return new MembershipResponse(this.userId, this.role, this.email, this.name, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public MembershipResponse build();
    }

    public static interface NameStage {
        public _FinalStage name(@NotNull String var1);
    }

    public static interface EmailStage {
        public NameStage email(@NotNull String var1);
    }

    public static interface RoleStage {
        public EmailStage role(@NotNull MembershipRole var1);
    }

    public static interface UserIdStage {
        public RoleStage userId(@NotNull String var1);

        public Builder from(MembershipResponse var1);
    }
}

