/*
 * Decompiled with CFR 0.152.
 */
package com.langfuse.client.resources.projects.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.langfuse.client.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class UpdateProjectRequest {
    private final String name;
    private final Optional<Map<String, Object>> metadata;
    private final int retention;
    private final Map<String, Object> additionalProperties;

    private UpdateProjectRequest(String name, Optional<Map<String, Object>> metadata, int retention, Map<String, Object> additionalProperties) {
        this.name = name;
        this.metadata = metadata;
        this.retention = retention;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="metadata")
    public Optional<Map<String, Object>> getMetadata() {
        return this.metadata;
    }

    @JsonProperty(value="retention")
    public int getRetention() {
        return this.retention;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof UpdateProjectRequest && this.equalTo((UpdateProjectRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(UpdateProjectRequest other) {
        return this.name.equals(other.name) && this.metadata.equals(other.metadata) && this.retention == other.retention;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.metadata, this.retention);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static NameStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements NameStage,
    RetentionStage,
    _FinalStage {
        private String name;
        private int retention;
        private Optional<Map<String, Object>> metadata = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(UpdateProjectRequest other) {
            this.name(other.getName());
            this.metadata(other.getMetadata());
            this.retention(other.getRetention());
            return this;
        }

        @Override
        @JsonSetter(value="name")
        public RetentionStage name(@NotNull String name) {
            this.name = Objects.requireNonNull(name, "name must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="retention")
        public _FinalStage retention(int retention) {
            this.retention = retention;
            return this;
        }

        @Override
        public _FinalStage metadata(Map<String, Object> metadata) {
            this.metadata = Optional.ofNullable(metadata);
            return this;
        }

        @Override
        @JsonSetter(value="metadata", nulls=Nulls.SKIP)
        public _FinalStage metadata(Optional<Map<String, Object>> metadata) {
            this.metadata = metadata;
            return this;
        }

        @Override
        public UpdateProjectRequest build() {
            return new UpdateProjectRequest(this.name, this.metadata, this.retention, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public UpdateProjectRequest build();

        public _FinalStage metadata(Optional<Map<String, Object>> var1);

        public _FinalStage metadata(Map<String, Object> var1);
    }

    public static interface RetentionStage {
        public _FinalStage retention(int var1);
    }

    public static interface NameStage {
        public RetentionStage name(@NotNull String var1);

        public Builder from(UpdateProjectRequest var1);
    }
}

