/*
 * Decompiled with CFR 0.152.
 */
package com.langfuse.client.resources.prompts.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.langfuse.client.core.ObjectMappers;
import com.langfuse.client.resources.prompts.types.IBasePrompt;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class BasePrompt
implements IBasePrompt {
    private final String name;
    private final int version;
    private final Object config;
    private final List<String> labels;
    private final List<String> tags;
    private final Optional<String> commitMessage;
    private final Optional<Map<String, Object>> resolutionGraph;
    private final Map<String, Object> additionalProperties;

    private BasePrompt(String name, int version, Object config, List<String> labels, List<String> tags, Optional<String> commitMessage, Optional<Map<String, Object>> resolutionGraph, Map<String, Object> additionalProperties) {
        this.name = name;
        this.version = version;
        this.config = config;
        this.labels = labels;
        this.tags = tags;
        this.commitMessage = commitMessage;
        this.resolutionGraph = resolutionGraph;
        this.additionalProperties = additionalProperties;
    }

    @Override
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @Override
    @JsonProperty(value="version")
    public int getVersion() {
        return this.version;
    }

    @Override
    @JsonProperty(value="config")
    public Object getConfig() {
        return this.config;
    }

    @Override
    @JsonProperty(value="labels")
    public List<String> getLabels() {
        return this.labels;
    }

    @Override
    @JsonProperty(value="tags")
    public List<String> getTags() {
        return this.tags;
    }

    @Override
    @JsonProperty(value="commitMessage")
    public Optional<String> getCommitMessage() {
        return this.commitMessage;
    }

    @Override
    @JsonProperty(value="resolutionGraph")
    public Optional<Map<String, Object>> getResolutionGraph() {
        return this.resolutionGraph;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof BasePrompt && this.equalTo((BasePrompt)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(BasePrompt other) {
        return this.name.equals(other.name) && this.version == other.version && this.config.equals(other.config) && this.labels.equals(other.labels) && this.tags.equals(other.tags) && this.commitMessage.equals(other.commitMessage) && this.resolutionGraph.equals(other.resolutionGraph);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.version, this.config, this.labels, this.tags, this.commitMessage, this.resolutionGraph);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static NameStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements NameStage,
    VersionStage,
    ConfigStage,
    _FinalStage {
        private String name;
        private int version;
        private Object config;
        private Optional<Map<String, Object>> resolutionGraph = Optional.empty();
        private Optional<String> commitMessage = Optional.empty();
        private List<String> tags = new ArrayList<String>();
        private List<String> labels = new ArrayList<String>();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(BasePrompt other) {
            this.name(other.getName());
            this.version(other.getVersion());
            this.config(other.getConfig());
            this.labels(other.getLabels());
            this.tags(other.getTags());
            this.commitMessage(other.getCommitMessage());
            this.resolutionGraph(other.getResolutionGraph());
            return this;
        }

        @Override
        @JsonSetter(value="name")
        public VersionStage name(@NotNull String name) {
            this.name = Objects.requireNonNull(name, "name must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="version")
        public ConfigStage version(int version) {
            this.version = version;
            return this;
        }

        @Override
        @JsonSetter(value="config")
        public _FinalStage config(Object config) {
            this.config = config;
            return this;
        }

        @Override
        public _FinalStage resolutionGraph(Map<String, Object> resolutionGraph) {
            this.resolutionGraph = Optional.ofNullable(resolutionGraph);
            return this;
        }

        @Override
        @JsonSetter(value="resolutionGraph", nulls=Nulls.SKIP)
        public _FinalStage resolutionGraph(Optional<Map<String, Object>> resolutionGraph) {
            this.resolutionGraph = resolutionGraph;
            return this;
        }

        @Override
        public _FinalStage commitMessage(String commitMessage) {
            this.commitMessage = Optional.ofNullable(commitMessage);
            return this;
        }

        @Override
        @JsonSetter(value="commitMessage", nulls=Nulls.SKIP)
        public _FinalStage commitMessage(Optional<String> commitMessage) {
            this.commitMessage = commitMessage;
            return this;
        }

        @Override
        public _FinalStage addAllTags(List<String> tags) {
            this.tags.addAll(tags);
            return this;
        }

        @Override
        public _FinalStage addTags(String tags) {
            this.tags.add(tags);
            return this;
        }

        @Override
        @JsonSetter(value="tags", nulls=Nulls.SKIP)
        public _FinalStage tags(List<String> tags) {
            this.tags.clear();
            this.tags.addAll(tags);
            return this;
        }

        @Override
        public _FinalStage addAllLabels(List<String> labels) {
            this.labels.addAll(labels);
            return this;
        }

        @Override
        public _FinalStage addLabels(String labels) {
            this.labels.add(labels);
            return this;
        }

        @Override
        @JsonSetter(value="labels", nulls=Nulls.SKIP)
        public _FinalStage labels(List<String> labels) {
            this.labels.clear();
            this.labels.addAll(labels);
            return this;
        }

        @Override
        public BasePrompt build() {
            return new BasePrompt(this.name, this.version, this.config, this.labels, this.tags, this.commitMessage, this.resolutionGraph, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public BasePrompt build();

        public _FinalStage labels(List<String> var1);

        public _FinalStage addLabels(String var1);

        public _FinalStage addAllLabels(List<String> var1);

        public _FinalStage tags(List<String> var1);

        public _FinalStage addTags(String var1);

        public _FinalStage addAllTags(List<String> var1);

        public _FinalStage commitMessage(Optional<String> var1);

        public _FinalStage commitMessage(String var1);

        public _FinalStage resolutionGraph(Optional<Map<String, Object>> var1);

        public _FinalStage resolutionGraph(Map<String, Object> var1);
    }

    public static interface ConfigStage {
        public _FinalStage config(Object var1);
    }

    public static interface VersionStage {
        public ConfigStage version(int var1);
    }

    public static interface NameStage {
        public VersionStage name(@NotNull String var1);

        public Builder from(BasePrompt var1);
    }
}

