/*
 * Decompiled with CFR 0.152.
 */
package com.langfuse.client.resources.scim.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.langfuse.client.core.ObjectMappers;
import com.langfuse.client.resources.scim.types.ScimEmail;
import com.langfuse.client.resources.scim.types.ScimName;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CreateUserRequest {
    private final String userName;
    private final ScimName name;
    private final Optional<List<ScimEmail>> emails;
    private final Optional<Boolean> active;
    private final Optional<String> password;
    private final Map<String, Object> additionalProperties;

    private CreateUserRequest(String userName, ScimName name, Optional<List<ScimEmail>> emails, Optional<Boolean> active, Optional<String> password, Map<String, Object> additionalProperties) {
        this.userName = userName;
        this.name = name;
        this.emails = emails;
        this.active = active;
        this.password = password;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="userName")
    public String getUserName() {
        return this.userName;
    }

    @JsonProperty(value="name")
    public ScimName getName() {
        return this.name;
    }

    @JsonProperty(value="emails")
    public Optional<List<ScimEmail>> getEmails() {
        return this.emails;
    }

    @JsonProperty(value="active")
    public Optional<Boolean> getActive() {
        return this.active;
    }

    @JsonProperty(value="password")
    public Optional<String> getPassword() {
        return this.password;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CreateUserRequest && this.equalTo((CreateUserRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CreateUserRequest other) {
        return this.userName.equals(other.userName) && this.name.equals(other.name) && this.emails.equals(other.emails) && this.active.equals(other.active) && this.password.equals(other.password);
    }

    public int hashCode() {
        return Objects.hash(this.userName, this.name, this.emails, this.active, this.password);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static UserNameStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements UserNameStage,
    NameStage,
    _FinalStage {
        private String userName;
        private ScimName name;
        private Optional<String> password = Optional.empty();
        private Optional<Boolean> active = Optional.empty();
        private Optional<List<ScimEmail>> emails = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(CreateUserRequest other) {
            this.userName(other.getUserName());
            this.name(other.getName());
            this.emails(other.getEmails());
            this.active(other.getActive());
            this.password(other.getPassword());
            return this;
        }

        @Override
        @JsonSetter(value="userName")
        public NameStage userName(@NotNull String userName) {
            this.userName = Objects.requireNonNull(userName, "userName must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="name")
        public _FinalStage name(@NotNull ScimName name) {
            this.name = Objects.requireNonNull(name, "name must not be null");
            return this;
        }

        @Override
        public _FinalStage password(String password) {
            this.password = Optional.ofNullable(password);
            return this;
        }

        @Override
        @JsonSetter(value="password", nulls=Nulls.SKIP)
        public _FinalStage password(Optional<String> password) {
            this.password = password;
            return this;
        }

        @Override
        public _FinalStage active(Boolean active) {
            this.active = Optional.ofNullable(active);
            return this;
        }

        @Override
        @JsonSetter(value="active", nulls=Nulls.SKIP)
        public _FinalStage active(Optional<Boolean> active) {
            this.active = active;
            return this;
        }

        @Override
        public _FinalStage emails(List<ScimEmail> emails) {
            this.emails = Optional.ofNullable(emails);
            return this;
        }

        @Override
        @JsonSetter(value="emails", nulls=Nulls.SKIP)
        public _FinalStage emails(Optional<List<ScimEmail>> emails) {
            this.emails = emails;
            return this;
        }

        @Override
        public CreateUserRequest build() {
            return new CreateUserRequest(this.userName, this.name, this.emails, this.active, this.password, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public CreateUserRequest build();

        public _FinalStage emails(Optional<List<ScimEmail>> var1);

        public _FinalStage emails(List<ScimEmail> var1);

        public _FinalStage active(Optional<Boolean> var1);

        public _FinalStage active(Boolean var1);

        public _FinalStage password(Optional<String> var1);

        public _FinalStage password(String var1);
    }

    public static interface NameStage {
        public _FinalStage name(@NotNull ScimName var1);
    }

    public static interface UserNameStage {
        public NameStage userName(@NotNull String var1);

        public Builder from(CreateUserRequest var1);
    }
}

