/*
 * Decompiled with CFR 0.152.
 */
package com.langfuse.client.resources.scim.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.langfuse.client.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class BulkConfig {
    private final boolean supported;
    private final int maxOperations;
    private final int maxPayloadSize;
    private final Map<String, Object> additionalProperties;

    private BulkConfig(boolean supported, int maxOperations, int maxPayloadSize, Map<String, Object> additionalProperties) {
        this.supported = supported;
        this.maxOperations = maxOperations;
        this.maxPayloadSize = maxPayloadSize;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="supported")
    public boolean getSupported() {
        return this.supported;
    }

    @JsonProperty(value="maxOperations")
    public int getMaxOperations() {
        return this.maxOperations;
    }

    @JsonProperty(value="maxPayloadSize")
    public int getMaxPayloadSize() {
        return this.maxPayloadSize;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof BulkConfig && this.equalTo((BulkConfig)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(BulkConfig other) {
        return this.supported == other.supported && this.maxOperations == other.maxOperations && this.maxPayloadSize == other.maxPayloadSize;
    }

    public int hashCode() {
        return Objects.hash(this.supported, this.maxOperations, this.maxPayloadSize);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static SupportedStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements SupportedStage,
    MaxOperationsStage,
    MaxPayloadSizeStage,
    _FinalStage {
        private boolean supported;
        private int maxOperations;
        private int maxPayloadSize;
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(BulkConfig other) {
            this.supported(other.getSupported());
            this.maxOperations(other.getMaxOperations());
            this.maxPayloadSize(other.getMaxPayloadSize());
            return this;
        }

        @Override
        @JsonSetter(value="supported")
        public MaxOperationsStage supported(boolean supported) {
            this.supported = supported;
            return this;
        }

        @Override
        @JsonSetter(value="maxOperations")
        public MaxPayloadSizeStage maxOperations(int maxOperations) {
            this.maxOperations = maxOperations;
            return this;
        }

        @Override
        @JsonSetter(value="maxPayloadSize")
        public _FinalStage maxPayloadSize(int maxPayloadSize) {
            this.maxPayloadSize = maxPayloadSize;
            return this;
        }

        @Override
        public BulkConfig build() {
            return new BulkConfig(this.supported, this.maxOperations, this.maxPayloadSize, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public BulkConfig build();
    }

    public static interface MaxPayloadSizeStage {
        public _FinalStage maxPayloadSize(int var1);
    }

    public static interface MaxOperationsStage {
        public MaxPayloadSizeStage maxOperations(int var1);
    }

    public static interface SupportedStage {
        public MaxOperationsStage supported(boolean var1);

        public Builder from(BulkConfig var1);
    }
}

