/*
 * Decompiled with CFR 0.152.
 */
package com.langfuse.client.resources.scim.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.langfuse.client.core.ObjectMappers;
import com.langfuse.client.resources.scim.types.ResourceMeta;
import com.langfuse.client.resources.scim.types.SchemaExtension;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ResourceType {
    private final Optional<List<String>> schemas;
    private final String id;
    private final String name;
    private final String endpoint;
    private final String description;
    private final String schema;
    private final List<SchemaExtension> schemaExtensions;
    private final ResourceMeta meta;
    private final Map<String, Object> additionalProperties;

    private ResourceType(Optional<List<String>> schemas, String id, String name, String endpoint, String description, String schema, List<SchemaExtension> schemaExtensions, ResourceMeta meta, Map<String, Object> additionalProperties) {
        this.schemas = schemas;
        this.id = id;
        this.name = name;
        this.endpoint = endpoint;
        this.description = description;
        this.schema = schema;
        this.schemaExtensions = schemaExtensions;
        this.meta = meta;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="schemas")
    public Optional<List<String>> getSchemas() {
        return this.schemas;
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="endpoint")
    public String getEndpoint() {
        return this.endpoint;
    }

    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="schema")
    public String getSchema() {
        return this.schema;
    }

    @JsonProperty(value="schemaExtensions")
    public List<SchemaExtension> getSchemaExtensions() {
        return this.schemaExtensions;
    }

    @JsonProperty(value="meta")
    public ResourceMeta getMeta() {
        return this.meta;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ResourceType && this.equalTo((ResourceType)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ResourceType other) {
        return this.schemas.equals(other.schemas) && this.id.equals(other.id) && this.name.equals(other.name) && this.endpoint.equals(other.endpoint) && this.description.equals(other.description) && this.schema.equals(other.schema) && this.schemaExtensions.equals(other.schemaExtensions) && this.meta.equals(other.meta);
    }

    public int hashCode() {
        return Objects.hash(this.schemas, this.id, this.name, this.endpoint, this.description, this.schema, this.schemaExtensions, this.meta);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements IdStage,
    NameStage,
    EndpointStage,
    DescriptionStage,
    SchemaStage,
    MetaStage,
    _FinalStage {
        private String id;
        private String name;
        private String endpoint;
        private String description;
        private String schema;
        private ResourceMeta meta;
        private List<SchemaExtension> schemaExtensions = new ArrayList<SchemaExtension>();
        private Optional<List<String>> schemas = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(ResourceType other) {
            this.schemas(other.getSchemas());
            this.id(other.getId());
            this.name(other.getName());
            this.endpoint(other.getEndpoint());
            this.description(other.getDescription());
            this.schema(other.getSchema());
            this.schemaExtensions(other.getSchemaExtensions());
            this.meta(other.getMeta());
            return this;
        }

        @Override
        @JsonSetter(value="id")
        public NameStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="name")
        public EndpointStage name(@NotNull String name) {
            this.name = Objects.requireNonNull(name, "name must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="endpoint")
        public DescriptionStage endpoint(@NotNull String endpoint) {
            this.endpoint = Objects.requireNonNull(endpoint, "endpoint must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="description")
        public SchemaStage description(@NotNull String description) {
            this.description = Objects.requireNonNull(description, "description must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="schema")
        public MetaStage schema(@NotNull String schema) {
            this.schema = Objects.requireNonNull(schema, "schema must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="meta")
        public _FinalStage meta(@NotNull ResourceMeta meta) {
            this.meta = Objects.requireNonNull(meta, "meta must not be null");
            return this;
        }

        @Override
        public _FinalStage addAllSchemaExtensions(List<SchemaExtension> schemaExtensions) {
            this.schemaExtensions.addAll(schemaExtensions);
            return this;
        }

        @Override
        public _FinalStage addSchemaExtensions(SchemaExtension schemaExtensions) {
            this.schemaExtensions.add(schemaExtensions);
            return this;
        }

        @Override
        @JsonSetter(value="schemaExtensions", nulls=Nulls.SKIP)
        public _FinalStage schemaExtensions(List<SchemaExtension> schemaExtensions) {
            this.schemaExtensions.clear();
            this.schemaExtensions.addAll(schemaExtensions);
            return this;
        }

        @Override
        public _FinalStage schemas(List<String> schemas) {
            this.schemas = Optional.ofNullable(schemas);
            return this;
        }

        @Override
        @JsonSetter(value="schemas", nulls=Nulls.SKIP)
        public _FinalStage schemas(Optional<List<String>> schemas) {
            this.schemas = schemas;
            return this;
        }

        @Override
        public ResourceType build() {
            return new ResourceType(this.schemas, this.id, this.name, this.endpoint, this.description, this.schema, this.schemaExtensions, this.meta, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public ResourceType build();

        public _FinalStage schemas(Optional<List<String>> var1);

        public _FinalStage schemas(List<String> var1);

        public _FinalStage schemaExtensions(List<SchemaExtension> var1);

        public _FinalStage addSchemaExtensions(SchemaExtension var1);

        public _FinalStage addAllSchemaExtensions(List<SchemaExtension> var1);
    }

    public static interface MetaStage {
        public _FinalStage meta(@NotNull ResourceMeta var1);
    }

    public static interface SchemaStage {
        public MetaStage schema(@NotNull String var1);
    }

    public static interface DescriptionStage {
        public SchemaStage description(@NotNull String var1);
    }

    public static interface EndpointStage {
        public DescriptionStage endpoint(@NotNull String var1);
    }

    public static interface NameStage {
        public EndpointStage name(@NotNull String var1);
    }

    public static interface IdStage {
        public NameStage id(@NotNull String var1);

        public Builder from(ResourceType var1);
    }
}

