/*
 * Decompiled with CFR 0.152.
 */
package com.langfuse.client.resources.scim.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.langfuse.client.core.ObjectMappers;
import com.langfuse.client.resources.scim.types.ResourceType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ResourceTypesResponse {
    private final List<String> schemas;
    private final int totalResults;
    private final List<ResourceType> resources;
    private final Map<String, Object> additionalProperties;

    private ResourceTypesResponse(List<String> schemas, int totalResults, List<ResourceType> resources, Map<String, Object> additionalProperties) {
        this.schemas = schemas;
        this.totalResults = totalResults;
        this.resources = resources;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="schemas")
    public List<String> getSchemas() {
        return this.schemas;
    }

    @JsonProperty(value="totalResults")
    public int getTotalResults() {
        return this.totalResults;
    }

    @JsonProperty(value="Resources")
    public List<ResourceType> getResources() {
        return this.resources;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ResourceTypesResponse && this.equalTo((ResourceTypesResponse)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ResourceTypesResponse other) {
        return this.schemas.equals(other.schemas) && this.totalResults == other.totalResults && this.resources.equals(other.resources);
    }

    public int hashCode() {
        return Objects.hash(this.schemas, this.totalResults, this.resources);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static TotalResultsStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements TotalResultsStage,
    _FinalStage {
        private int totalResults;
        private List<ResourceType> resources = new ArrayList<ResourceType>();
        private List<String> schemas = new ArrayList<String>();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(ResourceTypesResponse other) {
            this.schemas(other.getSchemas());
            this.totalResults(other.getTotalResults());
            this.resources(other.getResources());
            return this;
        }

        @Override
        @JsonSetter(value="totalResults")
        public _FinalStage totalResults(int totalResults) {
            this.totalResults = totalResults;
            return this;
        }

        @Override
        public _FinalStage addAllResources(List<ResourceType> resources) {
            this.resources.addAll(resources);
            return this;
        }

        @Override
        public _FinalStage addResources(ResourceType resources) {
            this.resources.add(resources);
            return this;
        }

        @Override
        @JsonSetter(value="Resources", nulls=Nulls.SKIP)
        public _FinalStage resources(List<ResourceType> resources) {
            this.resources.clear();
            this.resources.addAll(resources);
            return this;
        }

        @Override
        public _FinalStage addAllSchemas(List<String> schemas) {
            this.schemas.addAll(schemas);
            return this;
        }

        @Override
        public _FinalStage addSchemas(String schemas) {
            this.schemas.add(schemas);
            return this;
        }

        @Override
        @JsonSetter(value="schemas", nulls=Nulls.SKIP)
        public _FinalStage schemas(List<String> schemas) {
            this.schemas.clear();
            this.schemas.addAll(schemas);
            return this;
        }

        @Override
        public ResourceTypesResponse build() {
            return new ResourceTypesResponse(this.schemas, this.totalResults, this.resources, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public ResourceTypesResponse build();

        public _FinalStage schemas(List<String> var1);

        public _FinalStage addSchemas(String var1);

        public _FinalStage addAllSchemas(List<String> var1);

        public _FinalStage resources(List<ResourceType> var1);

        public _FinalStage addResources(ResourceType var1);

        public _FinalStage addAllResources(List<ResourceType> var1);
    }

    public static interface TotalResultsStage {
        public _FinalStage totalResults(int var1);

        public Builder from(ResourceTypesResponse var1);
    }
}

