/*
 * Decompiled with CFR 0.152.
 */
package com.langfuse.client.resources.scim.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.langfuse.client.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class SchemaExtension {
    private final String schema;
    private final boolean required;
    private final Map<String, Object> additionalProperties;

    private SchemaExtension(String schema, boolean required, Map<String, Object> additionalProperties) {
        this.schema = schema;
        this.required = required;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="schema")
    public String getSchema() {
        return this.schema;
    }

    @JsonProperty(value="required")
    public boolean getRequired() {
        return this.required;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof SchemaExtension && this.equalTo((SchemaExtension)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(SchemaExtension other) {
        return this.schema.equals(other.schema) && this.required == other.required;
    }

    public int hashCode() {
        return Objects.hash(this.schema, this.required);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static SchemaStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements SchemaStage,
    RequiredStage,
    _FinalStage {
        private String schema;
        private boolean required;
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(SchemaExtension other) {
            this.schema(other.getSchema());
            this.required(other.getRequired());
            return this;
        }

        @Override
        @JsonSetter(value="schema")
        public RequiredStage schema(@NotNull String schema) {
            this.schema = Objects.requireNonNull(schema, "schema must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="required")
        public _FinalStage required(boolean required) {
            this.required = required;
            return this;
        }

        @Override
        public SchemaExtension build() {
            return new SchemaExtension(this.schema, this.required, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public SchemaExtension build();
    }

    public static interface RequiredStage {
        public _FinalStage required(boolean var1);
    }

    public static interface SchemaStage {
        public RequiredStage schema(@NotNull String var1);

        public Builder from(SchemaExtension var1);
    }
}

