/*
 * Decompiled with CFR 0.152.
 */
package com.langfuse.client.resources.scim.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.langfuse.client.core.ObjectMappers;
import com.langfuse.client.resources.scim.types.ScimUser;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ScimUsersListResponse {
    private final List<String> schemas;
    private final int totalResults;
    private final int startIndex;
    private final int itemsPerPage;
    private final List<ScimUser> resources;
    private final Map<String, Object> additionalProperties;

    private ScimUsersListResponse(List<String> schemas, int totalResults, int startIndex, int itemsPerPage, List<ScimUser> resources, Map<String, Object> additionalProperties) {
        this.schemas = schemas;
        this.totalResults = totalResults;
        this.startIndex = startIndex;
        this.itemsPerPage = itemsPerPage;
        this.resources = resources;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="schemas")
    public List<String> getSchemas() {
        return this.schemas;
    }

    @JsonProperty(value="totalResults")
    public int getTotalResults() {
        return this.totalResults;
    }

    @JsonProperty(value="startIndex")
    public int getStartIndex() {
        return this.startIndex;
    }

    @JsonProperty(value="itemsPerPage")
    public int getItemsPerPage() {
        return this.itemsPerPage;
    }

    @JsonProperty(value="Resources")
    public List<ScimUser> getResources() {
        return this.resources;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ScimUsersListResponse && this.equalTo((ScimUsersListResponse)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ScimUsersListResponse other) {
        return this.schemas.equals(other.schemas) && this.totalResults == other.totalResults && this.startIndex == other.startIndex && this.itemsPerPage == other.itemsPerPage && this.resources.equals(other.resources);
    }

    public int hashCode() {
        return Objects.hash(this.schemas, this.totalResults, this.startIndex, this.itemsPerPage, this.resources);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static TotalResultsStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements TotalResultsStage,
    StartIndexStage,
    ItemsPerPageStage,
    _FinalStage {
        private int totalResults;
        private int startIndex;
        private int itemsPerPage;
        private List<ScimUser> resources = new ArrayList<ScimUser>();
        private List<String> schemas = new ArrayList<String>();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(ScimUsersListResponse other) {
            this.schemas(other.getSchemas());
            this.totalResults(other.getTotalResults());
            this.startIndex(other.getStartIndex());
            this.itemsPerPage(other.getItemsPerPage());
            this.resources(other.getResources());
            return this;
        }

        @Override
        @JsonSetter(value="totalResults")
        public StartIndexStage totalResults(int totalResults) {
            this.totalResults = totalResults;
            return this;
        }

        @Override
        @JsonSetter(value="startIndex")
        public ItemsPerPageStage startIndex(int startIndex) {
            this.startIndex = startIndex;
            return this;
        }

        @Override
        @JsonSetter(value="itemsPerPage")
        public _FinalStage itemsPerPage(int itemsPerPage) {
            this.itemsPerPage = itemsPerPage;
            return this;
        }

        @Override
        public _FinalStage addAllResources(List<ScimUser> resources) {
            this.resources.addAll(resources);
            return this;
        }

        @Override
        public _FinalStage addResources(ScimUser resources) {
            this.resources.add(resources);
            return this;
        }

        @Override
        @JsonSetter(value="Resources", nulls=Nulls.SKIP)
        public _FinalStage resources(List<ScimUser> resources) {
            this.resources.clear();
            this.resources.addAll(resources);
            return this;
        }

        @Override
        public _FinalStage addAllSchemas(List<String> schemas) {
            this.schemas.addAll(schemas);
            return this;
        }

        @Override
        public _FinalStage addSchemas(String schemas) {
            this.schemas.add(schemas);
            return this;
        }

        @Override
        @JsonSetter(value="schemas", nulls=Nulls.SKIP)
        public _FinalStage schemas(List<String> schemas) {
            this.schemas.clear();
            this.schemas.addAll(schemas);
            return this;
        }

        @Override
        public ScimUsersListResponse build() {
            return new ScimUsersListResponse(this.schemas, this.totalResults, this.startIndex, this.itemsPerPage, this.resources, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public ScimUsersListResponse build();

        public _FinalStage schemas(List<String> var1);

        public _FinalStage addSchemas(String var1);

        public _FinalStage addAllSchemas(List<String> var1);

        public _FinalStage resources(List<ScimUser> var1);

        public _FinalStage addResources(ScimUser var1);

        public _FinalStage addAllResources(List<ScimUser> var1);
    }

    public static interface ItemsPerPageStage {
        public _FinalStage itemsPerPage(int var1);
    }

    public static interface StartIndexStage {
        public ItemsPerPageStage startIndex(int var1);
    }

    public static interface TotalResultsStage {
        public StartIndexStage totalResults(int var1);

        public Builder from(ScimUsersListResponse var1);
    }
}

