/*
 * Decompiled with CFR 0.152.
 */
package com.langfuse.client.resources.scoreconfigs.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.langfuse.client.core.ObjectMappers;
import com.langfuse.client.resources.commons.types.ConfigCategory;
import com.langfuse.client.resources.commons.types.ScoreDataType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CreateScoreConfigRequest {
    private final String name;
    private final ScoreDataType dataType;
    private final Optional<List<ConfigCategory>> categories;
    private final Optional<Double> minValue;
    private final Optional<Double> maxValue;
    private final Optional<String> description;
    private final Map<String, Object> additionalProperties;

    private CreateScoreConfigRequest(String name, ScoreDataType dataType, Optional<List<ConfigCategory>> categories, Optional<Double> minValue, Optional<Double> maxValue, Optional<String> description, Map<String, Object> additionalProperties) {
        this.name = name;
        this.dataType = dataType;
        this.categories = categories;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.description = description;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="dataType")
    public ScoreDataType getDataType() {
        return this.dataType;
    }

    @JsonProperty(value="categories")
    public Optional<List<ConfigCategory>> getCategories() {
        return this.categories;
    }

    @JsonProperty(value="minValue")
    public Optional<Double> getMinValue() {
        return this.minValue;
    }

    @JsonProperty(value="maxValue")
    public Optional<Double> getMaxValue() {
        return this.maxValue;
    }

    @JsonProperty(value="description")
    public Optional<String> getDescription() {
        return this.description;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CreateScoreConfigRequest && this.equalTo((CreateScoreConfigRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CreateScoreConfigRequest other) {
        return this.name.equals(other.name) && this.dataType.equals((Object)other.dataType) && this.categories.equals(other.categories) && this.minValue.equals(other.minValue) && this.maxValue.equals(other.maxValue) && this.description.equals(other.description);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.dataType, this.categories, this.minValue, this.maxValue, this.description});
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static NameStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements NameStage,
    DataTypeStage,
    _FinalStage {
        private String name;
        private ScoreDataType dataType;
        private Optional<String> description = Optional.empty();
        private Optional<Double> maxValue = Optional.empty();
        private Optional<Double> minValue = Optional.empty();
        private Optional<List<ConfigCategory>> categories = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(CreateScoreConfigRequest other) {
            this.name(other.getName());
            this.dataType(other.getDataType());
            this.categories(other.getCategories());
            this.minValue(other.getMinValue());
            this.maxValue(other.getMaxValue());
            this.description(other.getDescription());
            return this;
        }

        @Override
        @JsonSetter(value="name")
        public DataTypeStage name(@NotNull String name) {
            this.name = Objects.requireNonNull(name, "name must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="dataType")
        public _FinalStage dataType(@NotNull ScoreDataType dataType) {
            this.dataType = Objects.requireNonNull(dataType, "dataType must not be null");
            return this;
        }

        @Override
        public _FinalStage description(String description) {
            this.description = Optional.ofNullable(description);
            return this;
        }

        @Override
        @JsonSetter(value="description", nulls=Nulls.SKIP)
        public _FinalStage description(Optional<String> description) {
            this.description = description;
            return this;
        }

        @Override
        public _FinalStage maxValue(Double maxValue) {
            this.maxValue = Optional.ofNullable(maxValue);
            return this;
        }

        @Override
        @JsonSetter(value="maxValue", nulls=Nulls.SKIP)
        public _FinalStage maxValue(Optional<Double> maxValue) {
            this.maxValue = maxValue;
            return this;
        }

        @Override
        public _FinalStage minValue(Double minValue) {
            this.minValue = Optional.ofNullable(minValue);
            return this;
        }

        @Override
        @JsonSetter(value="minValue", nulls=Nulls.SKIP)
        public _FinalStage minValue(Optional<Double> minValue) {
            this.minValue = minValue;
            return this;
        }

        @Override
        public _FinalStage categories(List<ConfigCategory> categories) {
            this.categories = Optional.ofNullable(categories);
            return this;
        }

        @Override
        @JsonSetter(value="categories", nulls=Nulls.SKIP)
        public _FinalStage categories(Optional<List<ConfigCategory>> categories) {
            this.categories = categories;
            return this;
        }

        @Override
        public CreateScoreConfigRequest build() {
            return new CreateScoreConfigRequest(this.name, this.dataType, this.categories, this.minValue, this.maxValue, this.description, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public CreateScoreConfigRequest build();

        public _FinalStage categories(Optional<List<ConfigCategory>> var1);

        public _FinalStage categories(List<ConfigCategory> var1);

        public _FinalStage minValue(Optional<Double> var1);

        public _FinalStage minValue(Double var1);

        public _FinalStage maxValue(Optional<Double> var1);

        public _FinalStage maxValue(Double var1);

        public _FinalStage description(Optional<String> var1);

        public _FinalStage description(String var1);
    }

    public static interface DataTypeStage {
        public _FinalStage dataType(@NotNull ScoreDataType var1);
    }

    public static interface NameStage {
        public DataTypeStage name(@NotNull String var1);

        public Builder from(CreateScoreConfigRequest var1);
    }
}

