/*
 * Decompiled with CFR 0.152.
 */
package com.langfuse.client.resources.scorev2.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.langfuse.client.core.ObjectMappers;
import com.langfuse.client.resources.commons.types.ScoreDataType;
import com.langfuse.client.resources.commons.types.ScoreSource;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class GetScoresRequest {
    private final Optional<Integer> page;
    private final Optional<Integer> limit;
    private final Optional<String> userId;
    private final Optional<String> name;
    private final Optional<OffsetDateTime> fromTimestamp;
    private final Optional<OffsetDateTime> toTimestamp;
    private final Optional<String> environment;
    private final Optional<ScoreSource> source;
    private final Optional<String> operator;
    private final Optional<Double> value;
    private final Optional<String> scoreIds;
    private final Optional<String> configId;
    private final Optional<String> queueId;
    private final Optional<ScoreDataType> dataType;
    private final Optional<String> traceTags;
    private final Map<String, Object> additionalProperties;

    private GetScoresRequest(Optional<Integer> page, Optional<Integer> limit, Optional<String> userId, Optional<String> name, Optional<OffsetDateTime> fromTimestamp, Optional<OffsetDateTime> toTimestamp, Optional<String> environment, Optional<ScoreSource> source, Optional<String> operator, Optional<Double> value, Optional<String> scoreIds, Optional<String> configId, Optional<String> queueId, Optional<ScoreDataType> dataType, Optional<String> traceTags, Map<String, Object> additionalProperties) {
        this.page = page;
        this.limit = limit;
        this.userId = userId;
        this.name = name;
        this.fromTimestamp = fromTimestamp;
        this.toTimestamp = toTimestamp;
        this.environment = environment;
        this.source = source;
        this.operator = operator;
        this.value = value;
        this.scoreIds = scoreIds;
        this.configId = configId;
        this.queueId = queueId;
        this.dataType = dataType;
        this.traceTags = traceTags;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="page")
    public Optional<Integer> getPage() {
        return this.page;
    }

    @JsonProperty(value="limit")
    public Optional<Integer> getLimit() {
        return this.limit;
    }

    @JsonProperty(value="userId")
    public Optional<String> getUserId() {
        return this.userId;
    }

    @JsonProperty(value="name")
    public Optional<String> getName() {
        return this.name;
    }

    @JsonProperty(value="fromTimestamp")
    public Optional<OffsetDateTime> getFromTimestamp() {
        return this.fromTimestamp;
    }

    @JsonProperty(value="toTimestamp")
    public Optional<OffsetDateTime> getToTimestamp() {
        return this.toTimestamp;
    }

    @JsonProperty(value="environment")
    public Optional<String> getEnvironment() {
        return this.environment;
    }

    @JsonProperty(value="source")
    public Optional<ScoreSource> getSource() {
        return this.source;
    }

    @JsonProperty(value="operator")
    public Optional<String> getOperator() {
        return this.operator;
    }

    @JsonProperty(value="value")
    public Optional<Double> getValue() {
        return this.value;
    }

    @JsonProperty(value="scoreIds")
    public Optional<String> getScoreIds() {
        return this.scoreIds;
    }

    @JsonProperty(value="configId")
    public Optional<String> getConfigId() {
        return this.configId;
    }

    @JsonProperty(value="queueId")
    public Optional<String> getQueueId() {
        return this.queueId;
    }

    @JsonProperty(value="dataType")
    public Optional<ScoreDataType> getDataType() {
        return this.dataType;
    }

    @JsonProperty(value="traceTags")
    public Optional<String> getTraceTags() {
        return this.traceTags;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof GetScoresRequest && this.equalTo((GetScoresRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(GetScoresRequest other) {
        return this.page.equals(other.page) && this.limit.equals(other.limit) && this.userId.equals(other.userId) && this.name.equals(other.name) && this.fromTimestamp.equals(other.fromTimestamp) && this.toTimestamp.equals(other.toTimestamp) && this.environment.equals(other.environment) && this.source.equals(other.source) && this.operator.equals(other.operator) && this.value.equals(other.value) && this.scoreIds.equals(other.scoreIds) && this.configId.equals(other.configId) && this.queueId.equals(other.queueId) && this.dataType.equals(other.dataType) && this.traceTags.equals(other.traceTags);
    }

    public int hashCode() {
        return Objects.hash(this.page, this.limit, this.userId, this.name, this.fromTimestamp, this.toTimestamp, this.environment, this.source, this.operator, this.value, this.scoreIds, this.configId, this.queueId, this.dataType, this.traceTags);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<Integer> page = Optional.empty();
        private Optional<Integer> limit = Optional.empty();
        private Optional<String> userId = Optional.empty();
        private Optional<String> name = Optional.empty();
        private Optional<OffsetDateTime> fromTimestamp = Optional.empty();
        private Optional<OffsetDateTime> toTimestamp = Optional.empty();
        private Optional<String> environment = Optional.empty();
        private Optional<ScoreSource> source = Optional.empty();
        private Optional<String> operator = Optional.empty();
        private Optional<Double> value = Optional.empty();
        private Optional<String> scoreIds = Optional.empty();
        private Optional<String> configId = Optional.empty();
        private Optional<String> queueId = Optional.empty();
        private Optional<ScoreDataType> dataType = Optional.empty();
        private Optional<String> traceTags = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(GetScoresRequest other) {
            this.page(other.getPage());
            this.limit(other.getLimit());
            this.userId(other.getUserId());
            this.name(other.getName());
            this.fromTimestamp(other.getFromTimestamp());
            this.toTimestamp(other.getToTimestamp());
            this.environment(other.getEnvironment());
            this.source(other.getSource());
            this.operator(other.getOperator());
            this.value(other.getValue());
            this.scoreIds(other.getScoreIds());
            this.configId(other.getConfigId());
            this.queueId(other.getQueueId());
            this.dataType(other.getDataType());
            this.traceTags(other.getTraceTags());
            return this;
        }

        @JsonSetter(value="page", nulls=Nulls.SKIP)
        public Builder page(Optional<Integer> page) {
            this.page = page;
            return this;
        }

        public Builder page(Integer page) {
            this.page = Optional.ofNullable(page);
            return this;
        }

        @JsonSetter(value="limit", nulls=Nulls.SKIP)
        public Builder limit(Optional<Integer> limit) {
            this.limit = limit;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = Optional.ofNullable(limit);
            return this;
        }

        @JsonSetter(value="userId", nulls=Nulls.SKIP)
        public Builder userId(Optional<String> userId) {
            this.userId = userId;
            return this;
        }

        public Builder userId(String userId) {
            this.userId = Optional.ofNullable(userId);
            return this;
        }

        @JsonSetter(value="name", nulls=Nulls.SKIP)
        public Builder name(Optional<String> name) {
            this.name = name;
            return this;
        }

        public Builder name(String name) {
            this.name = Optional.ofNullable(name);
            return this;
        }

        @JsonSetter(value="fromTimestamp", nulls=Nulls.SKIP)
        public Builder fromTimestamp(Optional<OffsetDateTime> fromTimestamp) {
            this.fromTimestamp = fromTimestamp;
            return this;
        }

        public Builder fromTimestamp(OffsetDateTime fromTimestamp) {
            this.fromTimestamp = Optional.ofNullable(fromTimestamp);
            return this;
        }

        @JsonSetter(value="toTimestamp", nulls=Nulls.SKIP)
        public Builder toTimestamp(Optional<OffsetDateTime> toTimestamp) {
            this.toTimestamp = toTimestamp;
            return this;
        }

        public Builder toTimestamp(OffsetDateTime toTimestamp) {
            this.toTimestamp = Optional.ofNullable(toTimestamp);
            return this;
        }

        @JsonSetter(value="environment", nulls=Nulls.SKIP)
        public Builder environment(Optional<String> environment) {
            this.environment = environment;
            return this;
        }

        public Builder environment(String environment) {
            this.environment = Optional.ofNullable(environment);
            return this;
        }

        @JsonSetter(value="source", nulls=Nulls.SKIP)
        public Builder source(Optional<ScoreSource> source) {
            this.source = source;
            return this;
        }

        public Builder source(ScoreSource source) {
            this.source = Optional.ofNullable(source);
            return this;
        }

        @JsonSetter(value="operator", nulls=Nulls.SKIP)
        public Builder operator(Optional<String> operator) {
            this.operator = operator;
            return this;
        }

        public Builder operator(String operator) {
            this.operator = Optional.ofNullable(operator);
            return this;
        }

        @JsonSetter(value="value", nulls=Nulls.SKIP)
        public Builder value(Optional<Double> value) {
            this.value = value;
            return this;
        }

        public Builder value(Double value) {
            this.value = Optional.ofNullable(value);
            return this;
        }

        @JsonSetter(value="scoreIds", nulls=Nulls.SKIP)
        public Builder scoreIds(Optional<String> scoreIds) {
            this.scoreIds = scoreIds;
            return this;
        }

        public Builder scoreIds(String scoreIds) {
            this.scoreIds = Optional.ofNullable(scoreIds);
            return this;
        }

        @JsonSetter(value="configId", nulls=Nulls.SKIP)
        public Builder configId(Optional<String> configId) {
            this.configId = configId;
            return this;
        }

        public Builder configId(String configId) {
            this.configId = Optional.ofNullable(configId);
            return this;
        }

        @JsonSetter(value="queueId", nulls=Nulls.SKIP)
        public Builder queueId(Optional<String> queueId) {
            this.queueId = queueId;
            return this;
        }

        public Builder queueId(String queueId) {
            this.queueId = Optional.ofNullable(queueId);
            return this;
        }

        @JsonSetter(value="dataType", nulls=Nulls.SKIP)
        public Builder dataType(Optional<ScoreDataType> dataType) {
            this.dataType = dataType;
            return this;
        }

        public Builder dataType(ScoreDataType dataType) {
            this.dataType = Optional.ofNullable(dataType);
            return this;
        }

        @JsonSetter(value="traceTags", nulls=Nulls.SKIP)
        public Builder traceTags(Optional<String> traceTags) {
            this.traceTags = traceTags;
            return this;
        }

        public Builder traceTags(String traceTags) {
            this.traceTags = Optional.ofNullable(traceTags);
            return this;
        }

        public GetScoresRequest build() {
            return new GetScoresRequest(this.page, this.limit, this.userId, this.name, this.fromTimestamp, this.toTimestamp, this.environment, this.source, this.operator, this.value, this.scoreIds, this.configId, this.queueId, this.dataType, this.traceTags, this.additionalProperties);
        }
    }
}

