/*
 * Decompiled with CFR 0.152.
 */
package com.larksuite.oapi.core.api.handler;

import com.larksuite.oapi.core.AppType;
import com.larksuite.oapi.core.Config;
import com.larksuite.oapi.core.Context;
import com.larksuite.oapi.core.Keys;
import com.larksuite.oapi.core.api.exception.AccessTokenObtainException;
import com.larksuite.oapi.core.api.exception.AppTicketIsEmptyException;
import com.larksuite.oapi.core.api.handler.Handler;
import com.larksuite.oapi.core.api.request.BaseRequest;
import com.larksuite.oapi.core.api.request.Request;
import com.larksuite.oapi.core.api.token.AppAccessToken;
import com.larksuite.oapi.core.api.token.ISVAppAccessTokenReq;
import com.larksuite.oapi.core.api.token.ISVTenantAccessTokenReq;
import com.larksuite.oapi.core.api.token.InternalAccessTokenReq;
import com.larksuite.oapi.core.api.token.TenantAccessToken;
import com.larksuite.oapi.core.utils.Strings;
import com.larksuite.oapi.okhttp3_14.Request;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccessToken {
    private static final Logger log = LoggerFactory.getLogger(AccessToken.class);
    private static final int expiryDeltaOfSecond = 180;

    public static AppAccessToken getInternalAppAccessToken(Context ctx) throws Exception {
        Config config = Config.ByCtx(ctx);
        AppAccessToken appAccessToken = new AppAccessToken();
        InternalAccessTokenReq internalAccessTokenReq = new InternalAccessTokenReq();
        internalAccessTokenReq.setAppId(config.getAppSettings().getAppID());
        internalAccessTokenReq.setAppSecret(config.getAppSettings().getAppSecret());
        Request<InternalAccessTokenReq, AppAccessToken> request = Request.newRequestByAuth("auth/v3/app_access_token/internal", "POST", internalAccessTokenReq, appAccessToken);
        Handler.DEFAULT.handle(ctx, request);
        if (request.getResponse().getCode() != 0) {
            throw new AccessTokenObtainException("obtain internal app access token\uff0cfailure information:", request.getResponse());
        }
        return request.getResponse().getData();
    }

    public static TenantAccessToken getInternalTenantAccessToken(Context ctx) throws Exception {
        Config config = Config.ByCtx(ctx);
        TenantAccessToken tenantAccessToken = new TenantAccessToken();
        InternalAccessTokenReq internalAccessTokenReq = new InternalAccessTokenReq();
        internalAccessTokenReq.setAppId(config.getAppSettings().getAppID());
        internalAccessTokenReq.setAppSecret(config.getAppSettings().getAppSecret());
        Request<InternalAccessTokenReq, TenantAccessToken> request = Request.newRequestByAuth("auth/v3/tenant_access_token/internal", "POST", internalAccessTokenReq, tenantAccessToken);
        Handler.DEFAULT.handle(ctx, request);
        if (request.getResponse().getCode() != 0) {
            throw new AccessTokenObtainException("obtain internal tenant access token\uff0cfailure information:", request.getResponse());
        }
        return request.getResponse().getData();
    }

    private static String getAppTicket(Context ctx) throws Exception {
        Config config = Config.ByCtx(ctx);
        return config.getStore().get(Keys.appTicketKey(config.getAppSettings().getAppID()));
    }

    public static AppAccessToken getIsvAppAccessToken(Context ctx) throws Exception {
        String appTicket = AccessToken.getAppTicket(ctx);
        if (Strings.isEmpty(appTicket)) {
            throw new AppTicketIsEmptyException();
        }
        Config config = Config.ByCtx(ctx);
        AppAccessToken appAccessToken = new AppAccessToken();
        ISVAppAccessTokenReq isvAppAccessTokenReq = new ISVAppAccessTokenReq();
        isvAppAccessTokenReq.setAppId(config.getAppSettings().getAppID());
        isvAppAccessTokenReq.setAppSecret(config.getAppSettings().getAppSecret());
        isvAppAccessTokenReq.setAppTicket(appTicket);
        Request<ISVAppAccessTokenReq, AppAccessToken> request = Request.newRequestByAuth("auth/v3/app_access_token", "POST", isvAppAccessTokenReq, appAccessToken);
        Handler.DEFAULT.handle(ctx, request);
        if (request.getResponse().getCode() != 0) {
            throw new AccessTokenObtainException("obtain isv app access token\uff0cfailure information:", request.getResponse());
        }
        return request.getResponse().getData();
    }

    public static AccessTokenPair getISVTenantAccessToken(Context ctx) throws Exception {
        AppAccessToken appAccessToken = AccessToken.getIsvAppAccessToken(ctx);
        BaseRequest base = BaseRequest.byContext(ctx);
        TenantAccessToken tenantAccessToken = new TenantAccessToken();
        ISVTenantAccessTokenReq isvTenantAccessTokenReq = new ISVTenantAccessTokenReq();
        isvTenantAccessTokenReq.setAppAccessToken(appAccessToken.getAppAccessToken());
        isvTenantAccessTokenReq.setTenantKey(base.getTenantKey());
        Request<ISVTenantAccessTokenReq, TenantAccessToken> request = Request.newRequestByAuth("auth/v3/tenant_access_token", "POST", isvTenantAccessTokenReq, tenantAccessToken);
        Handler.DEFAULT.handle(ctx, request);
        if (request.getResponse().getCode() != 0) {
            throw new AccessTokenObtainException("obtain isv tenant access token\uff0cfailure information:", request.getResponse());
        }
        tenantAccessToken = request.getResponse().getData();
        return new AccessTokenPair(appAccessToken, tenantAccessToken);
    }

    private static void setAppAccessTokenToStore(Context ctx, AppAccessToken appAccessToken) {
        Config config = Config.ByCtx(ctx);
        int expire = appAccessToken.getExpire() - 180;
        try {
            config.getStore().put(Keys.appAccessTokenKey(config.getAppSettings().getAppID()), appAccessToken.getAppAccessToken(), expire, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            log.warn("store put happen exception, message:{}", (Object)e.getMessage());
        }
    }

    private static void setTenantAccessTokenToStore(Context ctx, TenantAccessToken tenantAccessToken) {
        Config config = Config.ByCtx(ctx);
        BaseRequest base = BaseRequest.byContext(ctx);
        int expire = tenantAccessToken.getExpire() - 180;
        try {
            config.getStore().put(Keys.tenantAccessTokenKey(config.getAppSettings().getAppID(), base.getTenantKey() == null ? "" : base.getTenantKey()), tenantAccessToken.getTenantAccessToken(), expire, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            log.warn("store put happen exception, message:{}", (Object)e.getMessage());
        }
    }

    public static void signApp(Context ctx, Request.Builder httpRequestBuilder) throws Exception {
        String tok;
        BaseRequest base = BaseRequest.byContext(ctx);
        Config config = Config.ByCtx(ctx);
        if (!base.isRetry() && !Strings.isEmpty(tok = config.getStore().get(Keys.appAccessTokenKey(config.getAppSettings().getAppID())))) {
            AccessToken.sign(httpRequestBuilder, tok);
            return;
        }
        AppAccessToken appAccessToken = null;
        appAccessToken = config.getAppSettings().getAppType() == AppType.Internal ? AccessToken.getInternalAppAccessToken(ctx) : AccessToken.getIsvAppAccessToken(ctx);
        AccessToken.setAppAccessTokenToStore(ctx, appAccessToken);
        AccessToken.sign(httpRequestBuilder, appAccessToken.getAppAccessToken());
    }

    public static void signTenant(Context ctx, Request.Builder httpRequestBuilder) throws Exception {
        TenantAccessToken tenantAccessToken;
        String tok;
        String tenantKey;
        BaseRequest base = BaseRequest.byContext(ctx);
        Config config = Config.ByCtx(ctx);
        String string = tenantKey = base.getTenantKey() == null ? "" : base.getTenantKey();
        if (!base.isRetry() && !Strings.isEmpty(tok = config.getStore().get(Keys.tenantAccessTokenKey(config.getAppSettings().getAppID(), tenantKey)))) {
            AccessToken.sign(httpRequestBuilder, tok);
            return;
        }
        if (config.getAppSettings().getAppType() == AppType.Internal) {
            tenantAccessToken = AccessToken.getInternalTenantAccessToken(ctx);
        } else {
            AccessTokenPair pair = AccessToken.getISVTenantAccessToken(ctx);
            AppAccessToken appAccessToken = pair.appAccessToken;
            tenantAccessToken = pair.tenantAccessToken;
            if (appAccessToken != null) {
                AccessToken.setAppAccessTokenToStore(ctx, appAccessToken);
            }
        }
        AccessToken.setTenantAccessTokenToStore(ctx, tenantAccessToken);
        AccessToken.sign(httpRequestBuilder, tenantAccessToken.getTenantAccessToken());
    }

    public static void signUser(Context ctx, Request.Builder httpRequestBuilder) {
        BaseRequest base = BaseRequest.byContext(ctx);
        if (!Strings.isEmpty(base.getUserAccessToken())) {
            AccessToken.sign(httpRequestBuilder, base.getUserAccessToken());
        }
    }

    private static void sign(Request.Builder httpRequestBuilder, String token) {
        httpRequestBuilder.header("Authorization", "Bearer " + token);
    }

    private static class AccessTokenPair {
        private AppAccessToken appAccessToken;
        private TenantAccessToken tenantAccessToken;

        public AccessTokenPair(AppAccessToken appAccessToken, TenantAccessToken tenantAccessToken) {
            this.appAccessToken = appAccessToken;
            this.tenantAccessToken = tenantAccessToken;
        }
    }
}

