/*
 * Decompiled with CFR 0.152.
 */
package com.larksuite.oapi.core.api.handler;

import com.larksuite.oapi.core.Config;
import com.larksuite.oapi.core.Context;
import com.larksuite.oapi.core.api.exception.AppTicketIsEmptyException;
import com.larksuite.oapi.core.api.handler.SubHandler;
import com.larksuite.oapi.core.api.handler.subhandler.BuildSubHandler;
import com.larksuite.oapi.core.api.handler.subhandler.InitSubHandler;
import com.larksuite.oapi.core.api.handler.subhandler.SendSubHandler;
import com.larksuite.oapi.core.api.handler.subhandler.SignSubHandler;
import com.larksuite.oapi.core.api.handler.subhandler.UnmarshalRespSubHandler;
import com.larksuite.oapi.core.api.handler.subhandler.ValidateRespSubHandler;
import com.larksuite.oapi.core.api.handler.subhandler.ValidateSubHandler;
import com.larksuite.oapi.core.api.request.Request;
import com.larksuite.oapi.core.api.response.EmptyData;
import com.larksuite.oapi.core.api.token.ApplyAppTicketReq;
import com.larksuite.oapi.core.utils.Strings;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Handler {
    public static final Handler DEFAULT = new Handler();
    private static final Logger log = LoggerFactory.getLogger(Handler.class);
    private final SubHandler init = new InitSubHandler();
    private final SubHandler validate = new ValidateSubHandler();
    private final SubHandler build = new BuildSubHandler();
    private final SubHandler sign = new SignSubHandler();
    private final SubHandler send = new SendSubHandler();
    private final SubHandler validateResponse = new ValidateRespSubHandler();
    private final SubHandler unmarshalResponse = new UnmarshalRespSubHandler();

    private Handler() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <I, O> void handle(Context ctx, Request<I, O> req) throws Exception {
        Exception exception = null;
        try {
            this.init.handle(ctx, req);
            this.validate.handle(ctx, req);
            int i = 0;
            do {
                this.build.handle(ctx, req);
                this.sign.handle(ctx, req);
                this.send.handle(ctx, req);
                this.validateResponse.handle(ctx, req);
                this.unmarshalResponse.handle(ctx, req);
            } while (req.isRetry() && ++i < 2);
        }
        catch (Exception e) {
            exception = e;
        }
        finally {
            this.complement(ctx, req, exception);
        }
    }

    private void deleteTmpFile(String requestBodyFilePath) {
        if (Strings.isEmpty(requestBodyFilePath)) {
            return;
        }
        new File(requestBodyFilePath).delete();
    }

    private <I, O> void complement(Context ctx, Request<I, O> req, Exception e) throws Exception {
        this.deleteTmpFile(req.getRequestBodyFilePath());
        if (e != null) {
            if (e instanceof AppTicketIsEmptyException) {
                this.applyAppTicket(ctx);
            }
            throw e;
        }
        if (req.getResponse().getCode() == 10012) {
            this.applyAppTicket(ctx);
        }
    }

    private void applyAppTicket(Context ctx) {
        Config config = Config.ByCtx(ctx);
        ApplyAppTicketReq applyAppTicketReq = new ApplyAppTicketReq();
        applyAppTicketReq.setAppId(config.getAppSettings().getAppID());
        applyAppTicketReq.setAppSecret(config.getAppSettings().getAppSecret());
        Request<ApplyAppTicketReq, EmptyData> req = Request.newRequestByAuth("auth/v3/app_ticket/resend", "POST", applyAppTicketReq, new EmptyData());
        try {
            this.handle(ctx, req);
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
    }
}

