/*
 * Decompiled with CFR 0.152.
 */
package com.larksuite.oapi.core.api.handler.subhandler;

import com.larksuite.oapi.core.Context;
import com.larksuite.oapi.core.api.handler.SubHandler;
import com.larksuite.oapi.core.api.request.Request;
import com.larksuite.oapi.core.api.response.Body;
import com.larksuite.oapi.core.api.tools.IOs;
import com.larksuite.oapi.okhttp3_14.Response;
import java.io.OutputStream;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnmarshalRespSubHandler
implements SubHandler {
    private static final Logger log = LoggerFactory.getLogger(UnmarshalRespSubHandler.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <I, O> void handle(Context ctx, Request<I, O> req) throws Exception {
        Response httpResponse = req.getHttpResponse();
        if (req.isResponseStreamReal()) {
            block5: {
                try {
                    if (req.getOutput() instanceof OutputStream) {
                        IOs.copy(Objects.requireNonNull(httpResponse.body()).byteStream(), (OutputStream)req.getOutput());
                        req.getResponse().setData(req.getOutput());
                        break block5;
                    }
                    throw new UnsupportedOperationException("when response is stream, request.output instanceof OutputStream");
                }
                finally {
                    Objects.requireNonNull(httpResponse.body()).close();
                }
            }
            return;
        }
        String body = Objects.requireNonNull(httpResponse.body()).string();
        log.debug("[unmarshalResponse] request:{}, response body:{}", (Object)req.toString(), (Object)body);
        this.unmarshalResp(req, body);
    }

    public <I, O> void unmarshalResp(Request<I, O> req, String body) {
        body = body.trim();
        Body b = (Body)req.getGson().fromJson(body, Body.class);
        req.setRetry(b.retry());
        req.getResponse().setBody(b);
        if (b.getCode() != 0) {
            return;
        }
        if (req.isNotDataField()) {
            Object output = req.getGson().fromJson(body, req.getOutput().getClass());
            req.getResponse().setData(output);
        } else {
            if (b.getData() == null || b.getData().size() == 0) {
                return;
            }
            String data = req.getGson().toJson(b.getData());
            Object output = req.getGson().fromJson(data, req.getOutput().getClass());
            req.getResponse().setData(output);
        }
    }
}

