/*
 * Decompiled with CFR 0.152.
 */
package com.larksuite.oapi.core.api.request;

import com.google.gson.Gson;
import com.larksuite.oapi.core.Context;
import com.larksuite.oapi.core.api.AccessTokenType;
import com.larksuite.oapi.core.api.request.RequestOpt;
import com.larksuite.oapi.core.api.request.RequestOptFn;
import com.larksuite.oapi.core.utils.Jsons;
import com.larksuite.oapi.core.utils.Strings;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BaseRequest<I, O> {
    private static final String ctxKeyRequestInfo = "------ctxKeyRequestInfo";
    private final String httpMethod;
    private final I input;
    private final Set<AccessTokenType> accessTokenTypeSet;
    private final List<RequestOptFn> requestOptFns;
    private final O output;
    private String domain;
    private String httpPath;
    private String queryParams;
    private AccessTokenType accessTokenType;
    private String tenantKey;
    private String userAccessToken;
    private boolean isNotDataField;
    private long timeoutOfMs;
    private boolean retry;
    private boolean isResponseStream;
    private boolean isResponseStreamReal;
    private Gson gson;

    public BaseRequest(String httpPath, String httpMethod, AccessTokenType accessTokenType, I input, O output, RequestOptFn ... requestOptFns) {
        this.httpPath = httpPath;
        this.httpMethod = httpMethod;
        this.input = input;
        this.output = output;
        this.accessTokenTypeSet = new HashSet<AccessTokenType>();
        this.accessTokenTypeSet.add(accessTokenType);
        this.accessTokenType = accessTokenType;
        this.requestOptFns = new ArrayList<RequestOptFn>();
        this.requestOptFns.addAll(Arrays.asList(requestOptFns));
    }

    public BaseRequest(String httpPath, String httpMethod, AccessTokenType[] accessTokenTypes, I input, O output, RequestOptFn ... requestOptFns) {
        this.httpPath = httpPath;
        this.httpMethod = httpMethod;
        this.input = input;
        this.output = output;
        this.accessTokenTypeSet = new HashSet<AccessTokenType>();
        this.accessTokenTypeSet.addAll(Arrays.asList(accessTokenTypes));
        this.accessTokenType = this.getDefaultAccessTokenType(accessTokenTypes);
        this.requestOptFns = new ArrayList<RequestOptFn>();
        this.requestOptFns.addAll(Arrays.asList(requestOptFns));
    }

    public static BaseRequest byContext(Context context) {
        return (BaseRequest)context.get(ctxKeyRequestInfo);
    }

    private static String encode(String value) {
        try {
            return URLEncoder.encode(value, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return "";
        }
    }

    public void init(String domain) {
        this.setDomain(domain);
        RequestOpt opt = new RequestOpt();
        for (RequestOptFn f : this.getRequestOptFns()) {
            f.fn(opt);
        }
        this.timeoutOfMs = opt.getTimeoutOfMs();
        this.isNotDataField = opt.isNotDataField();
        this.setResponseStream(opt.isResponseStream());
        this.setGson(Jsons.LONG_TO_STR_GSON);
        if (opt.isSupportLongDataType()) {
            this.setGson(Jsons.DEFAULT_GSON);
        }
        if (!Strings.isEmpty(opt.getTenantKey()) && this.getAccessTokenTypeSet().contains((Object)AccessTokenType.Tenant)) {
            this.tenantKey = opt.getTenantKey();
            this.accessTokenType = AccessTokenType.Tenant;
        }
        if (!Strings.isEmpty(opt.getUserAccessToken()) && this.getAccessTokenTypeSet().contains((Object)AccessTokenType.User)) {
            this.userAccessToken = opt.getUserAccessToken();
            this.accessTokenType = AccessTokenType.User;
        }
        if (opt.getPathParams() != null) {
            this.httpPath = this.resolvePath(this.getHttpPath(), opt.getPathParams());
        }
        if (opt.getQueryParams() != null) {
            this.queryParams = this.buildQuery(opt.getQueryParams());
        }
    }

    public String resolvePath(String path, Map<String, Object> pathVar) {
        String tmpPath = path;
        StringBuilder newPath = new StringBuilder();
        while (true) {
            String varName;
            int i;
            if ((i = tmpPath.indexOf(":")) == -1) {
                newPath.append(tmpPath);
                break;
            }
            newPath.append(tmpPath, 0, i);
            String subPath = tmpPath.substring(i);
            int j = subPath.indexOf("/");
            if (j == -1) {
                j = subPath.length();
            }
            if ((varName = subPath.substring(1, j)).equals("")) {
                newPath.append(subPath.substring(0, j));
            } else {
                Object v = pathVar.get(varName);
                if (v == null) {
                    throw new IllegalArgumentException("path:" + path + ", param name:" + varName + " not found value");
                }
                newPath.append(v.toString());
            }
            if (j == subPath.length()) break;
            tmpPath = subPath.substring(j);
        }
        return newPath.toString();
    }

    public String buildQuery(Map<String, Object> params) {
        if (params == null || params.isEmpty()) {
            return "";
        }
        Set<Map.Entry<String, Object>> entries = params.entrySet();
        ArrayList<String> list = new ArrayList<String>();
        for (Map.Entry<String, Object> entry : entries) {
            String name = entry.getKey();
            Object value = entry.getValue();
            if (value == null) continue;
            if (value instanceof List) {
                for (Object o : (List)value) {
                    list.add(name + "=" + BaseRequest.encode(o.toString()));
                }
                continue;
            }
            if (value.getClass().isArray()) {
                int len = Array.getLength(value);
                for (int i = 0; i < len; ++i) {
                    list.add(name + "=" + BaseRequest.encode(Array.get(value, i).toString()));
                }
                continue;
            }
            list.add(name + "=" + BaseRequest.encode(value.toString()));
        }
        if (list.isEmpty()) {
            return "";
        }
        StringBuilder query = new StringBuilder();
        for (String s : list) {
            query.append(s).append("&");
        }
        return query.deleteCharAt(query.length() - 1).toString();
    }

    private AccessTokenType getDefaultAccessTokenType(AccessTokenType[] accessTokenTypes) {
        AccessTokenType accessTokenType = accessTokenTypes[0];
        for (AccessTokenType t : accessTokenTypes) {
            if (t != AccessTokenType.Tenant) continue;
            accessTokenType = t;
            break;
        }
        return accessTokenType;
    }

    public void withContext(Context context) {
        context.set(ctxKeyRequestInfo, this);
    }

    public long getTimeoutOfMs() {
        return this.timeoutOfMs;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public String getHttpPath() {
        return this.httpPath;
    }

    public String getHttpMethod() {
        return this.httpMethod;
    }

    public String getQueryParams() {
        return this.queryParams;
    }

    public I getInput() {
        return this.input;
    }

    public Set<AccessTokenType> getAccessTokenTypeSet() {
        return this.accessTokenTypeSet;
    }

    public AccessTokenType getAccessTokenType() {
        return this.accessTokenType;
    }

    public String getTenantKey() {
        return this.tenantKey;
    }

    public String getUserAccessToken() {
        return this.userAccessToken;
    }

    public boolean isNotDataField() {
        return this.isNotDataField;
    }

    public O getOutput() {
        return this.output;
    }

    public boolean isRetry() {
        return this.retry;
    }

    public void setRetry(boolean retry) {
        this.retry = retry;
    }

    public boolean isResponseStream() {
        return this.isResponseStream;
    }

    public void setResponseStream(boolean responseStream) {
        this.isResponseStream = responseStream;
    }

    public List<RequestOptFn> getRequestOptFns() {
        return this.requestOptFns;
    }

    public boolean isResponseStreamReal() {
        return this.isResponseStreamReal;
    }

    public void setResponseStreamReal(boolean responseStreamReal) {
        this.isResponseStreamReal = responseStreamReal;
    }

    public Gson getGson() {
        return this.gson;
    }

    public void setGson(Gson gson) {
        this.gson = gson;
    }

    public String url() {
        String path = this.httpPath;
        if (!path.startsWith("http")) {
            path = path.startsWith("/open-apis") ? this.getDomain() + this.getHttpPath() : this.getDomain() + "/open-apis/" + this.getHttpPath();
        }
        if (!Strings.isEmpty(this.getQueryParams())) {
            path = path + "?" + this.getQueryParams();
        }
        return path;
    }
}

