/*
 * Decompiled with CFR 0.152.
 */
package com.larksuite.oapi.service.application.v6;

import com.larksuite.oapi.core.Config;
import com.larksuite.oapi.core.api.AccessTokenType;
import com.larksuite.oapi.core.api.Api;
import com.larksuite.oapi.core.api.ReqCaller;
import com.larksuite.oapi.core.api.request.Request;
import com.larksuite.oapi.core.api.request.RequestOptFn;
import com.larksuite.oapi.core.api.response.Response;
import com.larksuite.oapi.core.event.Event;
import com.larksuite.oapi.core.event.IHandler;
import com.larksuite.oapi.service.application.v6.model.ApplicationAppUsageOverviewReqBody;
import com.larksuite.oapi.service.application.v6.model.ApplicationAppUsageOverviewResult;
import com.larksuite.oapi.service.application.v6.model.ApplicationVisibilityAddedEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ApplicationService {
    private final Config config;
    private final ApplicationVisibilitys applicationVisibilitys;
    private final ApplicationAppUsages applicationAppUsages;

    public ApplicationService(Config config) {
        this.config = config;
        this.applicationVisibilitys = new ApplicationVisibilitys(this);
        this.applicationAppUsages = new ApplicationAppUsages(this);
    }

    public ApplicationVisibilitys getApplicationVisibilitys() {
        return this.applicationVisibilitys;
    }

    public ApplicationAppUsages getApplicationAppUsages() {
        return this.applicationAppUsages;
    }

    public void setApplicationVisibilityAddedEventHandler(ApplicationVisibilityAddedEventHandler handler) {
        Event.setTypeHandler(this.config, "application.application.visibility.added_v6", handler);
    }

    public static abstract class ApplicationVisibilityAddedEventHandler
    implements IHandler<ApplicationVisibilityAddedEvent> {
        @Override
        public ApplicationVisibilityAddedEvent getEvent() {
            return new ApplicationVisibilityAddedEvent();
        }
    }

    public static class ApplicationAppUsageOverviewReqCall
    extends ReqCaller<ApplicationAppUsageOverviewReqBody, ApplicationAppUsageOverviewResult> {
        private final ApplicationAppUsages applicationAppUsages;
        private final ApplicationAppUsageOverviewReqBody body;
        private final Map<String, Object> pathParams;
        private final Map<String, Object> queryParams;
        private final List<RequestOptFn> optFns;
        private ApplicationAppUsageOverviewResult result;

        private ApplicationAppUsageOverviewReqCall(ApplicationAppUsages applicationAppUsages, ApplicationAppUsageOverviewReqBody body, RequestOptFn ... optFns) {
            this.body = body;
            this.pathParams = new HashMap<String, Object>();
            this.queryParams = new HashMap<String, Object>();
            this.optFns = new ArrayList<RequestOptFn>();
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new ApplicationAppUsageOverviewResult();
            this.applicationAppUsages = applicationAppUsages;
        }

        public ApplicationAppUsageOverviewReqCall setAppId(String appId) {
            this.pathParams.put("app_id", appId);
            return this;
        }

        public ApplicationAppUsageOverviewReqCall setDepartmentIdType(String departmentIdType) {
            this.queryParams.put("department_id_type", departmentIdType);
            return this;
        }

        @Override
        public Response<ApplicationAppUsageOverviewResult> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            this.optFns.add(Request.setQueryParams(this.queryParams));
            Request<ApplicationAppUsageOverviewReqBody, ApplicationAppUsageOverviewResult> request = Request.newRequest("/open-apis/application/v6/applications/:app_id/app_usage/overview", "POST", new AccessTokenType[]{AccessTokenType.Tenant}, this.body, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.applicationAppUsages.service.config, request);
        }
    }

    public static class ApplicationAppUsages {
        private final ApplicationService service;

        public ApplicationAppUsages(ApplicationService service) {
            this.service = service;
        }

        public ApplicationAppUsageOverviewReqCall overview(ApplicationAppUsageOverviewReqBody body, RequestOptFn ... optFns) {
            return new ApplicationAppUsageOverviewReqCall(this, body, optFns);
        }
    }

    public static class ApplicationVisibilitys {
        private final ApplicationService service;

        public ApplicationVisibilitys(ApplicationService service) {
            this.service = service;
        }
    }
}

