/*
 * Decompiled with CFR 0.152.
 */
package com.larksuite.oapi.service.contact.v3;

import com.larksuite.oapi.core.Config;
import com.larksuite.oapi.core.api.AccessTokenType;
import com.larksuite.oapi.core.api.Api;
import com.larksuite.oapi.core.api.ReqCaller;
import com.larksuite.oapi.core.api.request.Request;
import com.larksuite.oapi.core.api.request.RequestOptFn;
import com.larksuite.oapi.core.api.response.EmptyData;
import com.larksuite.oapi.core.api.response.Response;
import com.larksuite.oapi.core.event.Event;
import com.larksuite.oapi.core.event.IHandler;
import com.larksuite.oapi.service.contact.v3.model.CustomAttrListResult;
import com.larksuite.oapi.service.contact.v3.model.Department;
import com.larksuite.oapi.service.contact.v3.model.DepartmentCreateResult;
import com.larksuite.oapi.service.contact.v3.model.DepartmentCreatedEvent;
import com.larksuite.oapi.service.contact.v3.model.DepartmentDeletedEvent;
import com.larksuite.oapi.service.contact.v3.model.DepartmentGetResult;
import com.larksuite.oapi.service.contact.v3.model.DepartmentListResult;
import com.larksuite.oapi.service.contact.v3.model.DepartmentParentResult;
import com.larksuite.oapi.service.contact.v3.model.DepartmentPatchResult;
import com.larksuite.oapi.service.contact.v3.model.DepartmentSearchReqBody;
import com.larksuite.oapi.service.contact.v3.model.DepartmentSearchResult;
import com.larksuite.oapi.service.contact.v3.model.DepartmentUpdateResult;
import com.larksuite.oapi.service.contact.v3.model.DepartmentUpdatedEvent;
import com.larksuite.oapi.service.contact.v3.model.EmployeeTypeEnum;
import com.larksuite.oapi.service.contact.v3.model.EmployeeTypeEnumActivedEvent;
import com.larksuite.oapi.service.contact.v3.model.EmployeeTypeEnumCreateResult;
import com.larksuite.oapi.service.contact.v3.model.EmployeeTypeEnumCreatedEvent;
import com.larksuite.oapi.service.contact.v3.model.EmployeeTypeEnumDeactivatedEvent;
import com.larksuite.oapi.service.contact.v3.model.EmployeeTypeEnumDeletedEvent;
import com.larksuite.oapi.service.contact.v3.model.EmployeeTypeEnumListResult;
import com.larksuite.oapi.service.contact.v3.model.EmployeeTypeEnumUpdateResult;
import com.larksuite.oapi.service.contact.v3.model.EmployeeTypeEnumUpdatedEvent;
import com.larksuite.oapi.service.contact.v3.model.GroupCreateReqBody;
import com.larksuite.oapi.service.contact.v3.model.GroupCreateResult;
import com.larksuite.oapi.service.contact.v3.model.GroupGetResult;
import com.larksuite.oapi.service.contact.v3.model.GroupMemberAddReqBody;
import com.larksuite.oapi.service.contact.v3.model.GroupMemberRemoveReqBody;
import com.larksuite.oapi.service.contact.v3.model.GroupMemberSimplelistResult;
import com.larksuite.oapi.service.contact.v3.model.GroupPatchReqBody;
import com.larksuite.oapi.service.contact.v3.model.GroupSimplelistResult;
import com.larksuite.oapi.service.contact.v3.model.ScopeUpdatedEvent;
import com.larksuite.oapi.service.contact.v3.model.User;
import com.larksuite.oapi.service.contact.v3.model.UserCreateResult;
import com.larksuite.oapi.service.contact.v3.model.UserCreatedEvent;
import com.larksuite.oapi.service.contact.v3.model.UserDeleteReqBody;
import com.larksuite.oapi.service.contact.v3.model.UserDeletedEvent;
import com.larksuite.oapi.service.contact.v3.model.UserGetResult;
import com.larksuite.oapi.service.contact.v3.model.UserListResult;
import com.larksuite.oapi.service.contact.v3.model.UserPatchResult;
import com.larksuite.oapi.service.contact.v3.model.UserUpdateResult;
import com.larksuite.oapi.service.contact.v3.model.UserUpdatedEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ContactService {
    private final Config config;
    private final Users users;
    private final Departments departments;
    private final Scopes scopes;
    private final EmployeeTypeEnums employeeTypeEnums;
    private final CustomAttrs customAttrs;
    private final Groups groups;
    private final GroupMembers groupMembers;

    public ContactService(Config config) {
        this.config = config;
        this.users = new Users(this);
        this.departments = new Departments(this);
        this.scopes = new Scopes(this);
        this.employeeTypeEnums = new EmployeeTypeEnums(this);
        this.customAttrs = new CustomAttrs(this);
        this.groups = new Groups(this);
        this.groupMembers = new GroupMembers(this);
    }

    public Users getUsers() {
        return this.users;
    }

    public Departments getDepartments() {
        return this.departments;
    }

    public Scopes getScopes() {
        return this.scopes;
    }

    public EmployeeTypeEnums getEmployeeTypeEnums() {
        return this.employeeTypeEnums;
    }

    public CustomAttrs getCustomAttrs() {
        return this.customAttrs;
    }

    public Groups getGroups() {
        return this.groups;
    }

    public GroupMembers getGroupMembers() {
        return this.groupMembers;
    }

    public void setDepartmentCreatedEventHandler(DepartmentCreatedEventHandler handler) {
        Event.setTypeHandler(this.config, "contact.department.created_v3", handler);
    }

    public void setDepartmentDeletedEventHandler(DepartmentDeletedEventHandler handler) {
        Event.setTypeHandler(this.config, "contact.department.deleted_v3", handler);
    }

    public void setDepartmentUpdatedEventHandler(DepartmentUpdatedEventHandler handler) {
        Event.setTypeHandler(this.config, "contact.department.updated_v3", handler);
    }

    public void setEmployeeTypeEnumActivedEventHandler(EmployeeTypeEnumActivedEventHandler handler) {
        Event.setTypeHandler(this.config, "contact.employee_type_enum.actived_v3", handler);
    }

    public void setEmployeeTypeEnumCreatedEventHandler(EmployeeTypeEnumCreatedEventHandler handler) {
        Event.setTypeHandler(this.config, "contact.employee_type_enum.created_v3", handler);
    }

    public void setEmployeeTypeEnumDeactivatedEventHandler(EmployeeTypeEnumDeactivatedEventHandler handler) {
        Event.setTypeHandler(this.config, "contact.employee_type_enum.deactivated_v3", handler);
    }

    public void setEmployeeTypeEnumDeletedEventHandler(EmployeeTypeEnumDeletedEventHandler handler) {
        Event.setTypeHandler(this.config, "contact.employee_type_enum.deleted_v3", handler);
    }

    public void setEmployeeTypeEnumUpdatedEventHandler(EmployeeTypeEnumUpdatedEventHandler handler) {
        Event.setTypeHandler(this.config, "contact.employee_type_enum.updated_v3", handler);
    }

    public void setScopeUpdatedEventHandler(ScopeUpdatedEventHandler handler) {
        Event.setTypeHandler(this.config, "contact.scope.updated_v3", handler);
    }

    public void setUserCreatedEventHandler(UserCreatedEventHandler handler) {
        Event.setTypeHandler(this.config, "contact.user.created_v3", handler);
    }

    public void setUserDeletedEventHandler(UserDeletedEventHandler handler) {
        Event.setTypeHandler(this.config, "contact.user.deleted_v3", handler);
    }

    public void setUserUpdatedEventHandler(UserUpdatedEventHandler handler) {
        Event.setTypeHandler(this.config, "contact.user.updated_v3", handler);
    }

    public static abstract class UserUpdatedEventHandler
    implements IHandler<UserUpdatedEvent> {
        @Override
        public UserUpdatedEvent getEvent() {
            return new UserUpdatedEvent();
        }
    }

    public static abstract class UserDeletedEventHandler
    implements IHandler<UserDeletedEvent> {
        @Override
        public UserDeletedEvent getEvent() {
            return new UserDeletedEvent();
        }
    }

    public static abstract class UserCreatedEventHandler
    implements IHandler<UserCreatedEvent> {
        @Override
        public UserCreatedEvent getEvent() {
            return new UserCreatedEvent();
        }
    }

    public static abstract class ScopeUpdatedEventHandler
    implements IHandler<ScopeUpdatedEvent> {
        @Override
        public ScopeUpdatedEvent getEvent() {
            return new ScopeUpdatedEvent();
        }
    }

    public static abstract class EmployeeTypeEnumUpdatedEventHandler
    implements IHandler<EmployeeTypeEnumUpdatedEvent> {
        @Override
        public EmployeeTypeEnumUpdatedEvent getEvent() {
            return new EmployeeTypeEnumUpdatedEvent();
        }
    }

    public static abstract class EmployeeTypeEnumDeletedEventHandler
    implements IHandler<EmployeeTypeEnumDeletedEvent> {
        @Override
        public EmployeeTypeEnumDeletedEvent getEvent() {
            return new EmployeeTypeEnumDeletedEvent();
        }
    }

    public static abstract class EmployeeTypeEnumDeactivatedEventHandler
    implements IHandler<EmployeeTypeEnumDeactivatedEvent> {
        @Override
        public EmployeeTypeEnumDeactivatedEvent getEvent() {
            return new EmployeeTypeEnumDeactivatedEvent();
        }
    }

    public static abstract class EmployeeTypeEnumCreatedEventHandler
    implements IHandler<EmployeeTypeEnumCreatedEvent> {
        @Override
        public EmployeeTypeEnumCreatedEvent getEvent() {
            return new EmployeeTypeEnumCreatedEvent();
        }
    }

    public static abstract class EmployeeTypeEnumActivedEventHandler
    implements IHandler<EmployeeTypeEnumActivedEvent> {
        @Override
        public EmployeeTypeEnumActivedEvent getEvent() {
            return new EmployeeTypeEnumActivedEvent();
        }
    }

    public static abstract class DepartmentUpdatedEventHandler
    implements IHandler<DepartmentUpdatedEvent> {
        @Override
        public DepartmentUpdatedEvent getEvent() {
            return new DepartmentUpdatedEvent();
        }
    }

    public static abstract class DepartmentDeletedEventHandler
    implements IHandler<DepartmentDeletedEvent> {
        @Override
        public DepartmentDeletedEvent getEvent() {
            return new DepartmentDeletedEvent();
        }
    }

    public static abstract class DepartmentCreatedEventHandler
    implements IHandler<DepartmentCreatedEvent> {
        @Override
        public DepartmentCreatedEvent getEvent() {
            return new DepartmentCreatedEvent();
        }
    }

    public static class GroupMemberRemoveReqCall
    extends ReqCaller<GroupMemberRemoveReqBody, EmptyData> {
        private final GroupMembers groupMembers;
        private final GroupMemberRemoveReqBody body;
        private final Map<String, Object> pathParams;
        private final List<RequestOptFn> optFns;
        private EmptyData result;

        private GroupMemberRemoveReqCall(GroupMembers groupMembers, GroupMemberRemoveReqBody body, RequestOptFn ... optFns) {
            this.body = body;
            this.pathParams = new HashMap<String, Object>();
            this.optFns = new ArrayList<RequestOptFn>();
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new EmptyData();
            this.groupMembers = groupMembers;
        }

        public GroupMemberRemoveReqCall setGroupId(String groupId) {
            this.pathParams.put("group_id", groupId);
            return this;
        }

        @Override
        public Response<EmptyData> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            Request<GroupMemberRemoveReqBody, EmptyData> request = Request.newRequest("/open-apis/contact/v3/group/:group_id/member/remove", "POST", new AccessTokenType[]{AccessTokenType.Tenant}, this.body, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.groupMembers.service.config, request);
        }
    }

    public static class GroupMemberAddReqCall
    extends ReqCaller<GroupMemberAddReqBody, EmptyData> {
        private final GroupMembers groupMembers;
        private final GroupMemberAddReqBody body;
        private final Map<String, Object> pathParams;
        private final List<RequestOptFn> optFns;
        private EmptyData result;

        private GroupMemberAddReqCall(GroupMembers groupMembers, GroupMemberAddReqBody body, RequestOptFn ... optFns) {
            this.body = body;
            this.pathParams = new HashMap<String, Object>();
            this.optFns = new ArrayList<RequestOptFn>();
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new EmptyData();
            this.groupMembers = groupMembers;
        }

        public GroupMemberAddReqCall setGroupId(String groupId) {
            this.pathParams.put("group_id", groupId);
            return this;
        }

        @Override
        public Response<EmptyData> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            Request<GroupMemberAddReqBody, EmptyData> request = Request.newRequest("/open-apis/contact/v3/group/:group_id/member/add", "POST", new AccessTokenType[]{AccessTokenType.Tenant}, this.body, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.groupMembers.service.config, request);
        }
    }

    public static class GroupMemberSimplelistReqCall
    extends ReqCaller<Object, GroupMemberSimplelistResult> {
        private final GroupMembers groupMembers;
        private final Map<String, Object> pathParams = new HashMap<String, Object>();
        private final Map<String, Object> queryParams = new HashMap<String, Object>();
        private final List<RequestOptFn> optFns = new ArrayList<RequestOptFn>();
        private GroupMemberSimplelistResult result;

        private GroupMemberSimplelistReqCall(GroupMembers groupMembers, RequestOptFn ... optFns) {
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new GroupMemberSimplelistResult();
            this.groupMembers = groupMembers;
        }

        public GroupMemberSimplelistReqCall setGroupId(String groupId) {
            this.pathParams.put("group_id", groupId);
            return this;
        }

        public GroupMemberSimplelistReqCall setPageSize(Integer pageSize) {
            this.queryParams.put("page_size", pageSize);
            return this;
        }

        public GroupMemberSimplelistReqCall setPageToken(String pageToken) {
            this.queryParams.put("page_token", pageToken);
            return this;
        }

        public GroupMemberSimplelistReqCall setMemberIdType(String memberIdType) {
            this.queryParams.put("member_id_type", memberIdType);
            return this;
        }

        public GroupMemberSimplelistReqCall setMemberType(String memberType) {
            this.queryParams.put("member_type", memberType);
            return this;
        }

        @Override
        public Response<GroupMemberSimplelistResult> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            this.optFns.add(Request.setQueryParams(this.queryParams));
            Request<Object, GroupMemberSimplelistResult> request = Request.newRequest("/open-apis/contact/v3/group/:group_id/member/simplelist", "GET", new AccessTokenType[]{AccessTokenType.Tenant}, null, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.groupMembers.service.config, request);
        }
    }

    public static class GroupMembers {
        private final ContactService service;

        public GroupMembers(ContactService service) {
            this.service = service;
        }

        public GroupMemberSimplelistReqCall simplelist(RequestOptFn ... optFns) {
            return new GroupMemberSimplelistReqCall(this, optFns);
        }

        public GroupMemberAddReqCall add(GroupMemberAddReqBody body, RequestOptFn ... optFns) {
            return new GroupMemberAddReqCall(this, body, optFns);
        }

        public GroupMemberRemoveReqCall remove(GroupMemberRemoveReqBody body, RequestOptFn ... optFns) {
            return new GroupMemberRemoveReqCall(this, body, optFns);
        }
    }

    public static class GroupPatchReqCall
    extends ReqCaller<GroupPatchReqBody, EmptyData> {
        private final Groups groups;
        private final GroupPatchReqBody body;
        private final Map<String, Object> pathParams;
        private final List<RequestOptFn> optFns;
        private EmptyData result;

        private GroupPatchReqCall(Groups groups, GroupPatchReqBody body, RequestOptFn ... optFns) {
            this.body = body;
            this.pathParams = new HashMap<String, Object>();
            this.optFns = new ArrayList<RequestOptFn>();
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new EmptyData();
            this.groups = groups;
        }

        public GroupPatchReqCall setGroupId(String groupId) {
            this.pathParams.put("group_id", groupId);
            return this;
        }

        @Override
        public Response<EmptyData> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            Request<GroupPatchReqBody, EmptyData> request = Request.newRequest("/open-apis/contact/v3/group/:group_id", "PATCH", new AccessTokenType[]{AccessTokenType.Tenant}, this.body, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.groups.service.config, request);
        }
    }

    public static class GroupGetReqCall
    extends ReqCaller<Object, GroupGetResult> {
        private final Groups groups;
        private final Map<String, Object> pathParams = new HashMap<String, Object>();
        private final List<RequestOptFn> optFns = new ArrayList<RequestOptFn>();
        private GroupGetResult result;

        private GroupGetReqCall(Groups groups, RequestOptFn ... optFns) {
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new GroupGetResult();
            this.groups = groups;
        }

        public GroupGetReqCall setGroupId(String groupId) {
            this.pathParams.put("group_id", groupId);
            return this;
        }

        @Override
        public Response<GroupGetResult> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            Request<Object, GroupGetResult> request = Request.newRequest("/open-apis/contact/v3/group/:group_id", "GET", new AccessTokenType[]{AccessTokenType.Tenant}, null, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.groups.service.config, request);
        }
    }

    public static class GroupDeleteReqCall
    extends ReqCaller<Object, EmptyData> {
        private final Groups groups;
        private final Map<String, Object> pathParams = new HashMap<String, Object>();
        private final List<RequestOptFn> optFns = new ArrayList<RequestOptFn>();
        private EmptyData result;

        private GroupDeleteReqCall(Groups groups, RequestOptFn ... optFns) {
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new EmptyData();
            this.groups = groups;
        }

        public GroupDeleteReqCall setGroupId(String groupId) {
            this.pathParams.put("group_id", groupId);
            return this;
        }

        @Override
        public Response<EmptyData> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            Request<Object, EmptyData> request = Request.newRequest("/open-apis/contact/v3/group/:group_id", "DELETE", new AccessTokenType[]{AccessTokenType.Tenant}, null, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.groups.service.config, request);
        }
    }

    public static class GroupSimplelistReqCall
    extends ReqCaller<Object, GroupSimplelistResult> {
        private final Groups groups;
        private final Map<String, Object> queryParams = new HashMap<String, Object>();
        private final List<RequestOptFn> optFns = new ArrayList<RequestOptFn>();
        private GroupSimplelistResult result;

        private GroupSimplelistReqCall(Groups groups, RequestOptFn ... optFns) {
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new GroupSimplelistResult();
            this.groups = groups;
        }

        public GroupSimplelistReqCall setPageSize(Integer pageSize) {
            this.queryParams.put("page_size", pageSize);
            return this;
        }

        public GroupSimplelistReqCall setPageToken(String pageToken) {
            this.queryParams.put("page_token", pageToken);
            return this;
        }

        public GroupSimplelistReqCall setType(Integer type) {
            this.queryParams.put("type", type);
            return this;
        }

        @Override
        public Response<GroupSimplelistResult> execute() throws Exception {
            this.optFns.add(Request.setQueryParams(this.queryParams));
            Request<Object, GroupSimplelistResult> request = Request.newRequest("/open-apis/contact/v3/group/simplelist", "GET", new AccessTokenType[]{AccessTokenType.Tenant}, null, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.groups.service.config, request);
        }
    }

    public static class GroupCreateReqCall
    extends ReqCaller<GroupCreateReqBody, GroupCreateResult> {
        private final Groups groups;
        private final GroupCreateReqBody body;
        private final List<RequestOptFn> optFns;
        private GroupCreateResult result;

        private GroupCreateReqCall(Groups groups, GroupCreateReqBody body, RequestOptFn ... optFns) {
            this.body = body;
            this.optFns = new ArrayList<RequestOptFn>();
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new GroupCreateResult();
            this.groups = groups;
        }

        @Override
        public Response<GroupCreateResult> execute() throws Exception {
            Request<GroupCreateReqBody, GroupCreateResult> request = Request.newRequest("/open-apis/contact/v3/group", "POST", new AccessTokenType[]{AccessTokenType.Tenant}, this.body, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.groups.service.config, request);
        }
    }

    public static class Groups {
        private final ContactService service;

        public Groups(ContactService service) {
            this.service = service;
        }

        public GroupCreateReqCall create(GroupCreateReqBody body, RequestOptFn ... optFns) {
            return new GroupCreateReqCall(this, body, optFns);
        }

        public GroupSimplelistReqCall simplelist(RequestOptFn ... optFns) {
            return new GroupSimplelistReqCall(this, optFns);
        }

        public GroupDeleteReqCall delete(RequestOptFn ... optFns) {
            return new GroupDeleteReqCall(this, optFns);
        }

        public GroupGetReqCall get(RequestOptFn ... optFns) {
            return new GroupGetReqCall(this, optFns);
        }

        public GroupPatchReqCall patch(GroupPatchReqBody body, RequestOptFn ... optFns) {
            return new GroupPatchReqCall(this, body, optFns);
        }
    }

    public static class CustomAttrListReqCall
    extends ReqCaller<Object, CustomAttrListResult> {
        private final CustomAttrs customAttrs;
        private final Map<String, Object> queryParams = new HashMap<String, Object>();
        private final List<RequestOptFn> optFns = new ArrayList<RequestOptFn>();
        private CustomAttrListResult result;

        private CustomAttrListReqCall(CustomAttrs customAttrs, RequestOptFn ... optFns) {
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new CustomAttrListResult();
            this.customAttrs = customAttrs;
        }

        public CustomAttrListReqCall setPageSize(Integer pageSize) {
            this.queryParams.put("page_size", pageSize);
            return this;
        }

        public CustomAttrListReqCall setPageToken(String pageToken) {
            this.queryParams.put("page_token", pageToken);
            return this;
        }

        @Override
        public Response<CustomAttrListResult> execute() throws Exception {
            this.optFns.add(Request.setQueryParams(this.queryParams));
            Request<Object, CustomAttrListResult> request = Request.newRequest("/open-apis/contact/v3/custom_attrs", "GET", new AccessTokenType[]{AccessTokenType.Tenant}, null, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.customAttrs.service.config, request);
        }
    }

    public static class CustomAttrs {
        private final ContactService service;

        public CustomAttrs(ContactService service) {
            this.service = service;
        }

        public CustomAttrListReqCall list(RequestOptFn ... optFns) {
            return new CustomAttrListReqCall(this, optFns);
        }
    }

    public static class EmployeeTypeEnumUpdateReqCall
    extends ReqCaller<EmployeeTypeEnum, EmployeeTypeEnumUpdateResult> {
        private final EmployeeTypeEnums employeeTypeEnums;
        private final EmployeeTypeEnum body;
        private final Map<String, Object> pathParams;
        private final List<RequestOptFn> optFns;
        private EmployeeTypeEnumUpdateResult result;

        private EmployeeTypeEnumUpdateReqCall(EmployeeTypeEnums employeeTypeEnums, EmployeeTypeEnum body, RequestOptFn ... optFns) {
            this.body = body;
            this.pathParams = new HashMap<String, Object>();
            this.optFns = new ArrayList<RequestOptFn>();
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new EmployeeTypeEnumUpdateResult();
            this.employeeTypeEnums = employeeTypeEnums;
        }

        public EmployeeTypeEnumUpdateReqCall setEnumId(String enumId) {
            this.pathParams.put("enum_id", enumId);
            return this;
        }

        @Override
        public Response<EmployeeTypeEnumUpdateResult> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            Request<EmployeeTypeEnum, EmployeeTypeEnumUpdateResult> request = Request.newRequest("/open-apis/contact/v3/employee_type_enums/:enum_id", "PUT", new AccessTokenType[]{AccessTokenType.Tenant}, this.body, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.employeeTypeEnums.service.config, request);
        }
    }

    public static class EmployeeTypeEnumDeleteReqCall
    extends ReqCaller<Object, EmptyData> {
        private final EmployeeTypeEnums employeeTypeEnums;
        private final Map<String, Object> pathParams = new HashMap<String, Object>();
        private final List<RequestOptFn> optFns = new ArrayList<RequestOptFn>();
        private EmptyData result;

        private EmployeeTypeEnumDeleteReqCall(EmployeeTypeEnums employeeTypeEnums, RequestOptFn ... optFns) {
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new EmptyData();
            this.employeeTypeEnums = employeeTypeEnums;
        }

        public EmployeeTypeEnumDeleteReqCall setEnumId(String enumId) {
            this.pathParams.put("enum_id", enumId);
            return this;
        }

        @Override
        public Response<EmptyData> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            Request<Object, EmptyData> request = Request.newRequest("/open-apis/contact/v3/employee_type_enums/:enum_id", "DELETE", new AccessTokenType[]{AccessTokenType.Tenant}, null, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.employeeTypeEnums.service.config, request);
        }
    }

    public static class EmployeeTypeEnumCreateReqCall
    extends ReqCaller<EmployeeTypeEnum, EmployeeTypeEnumCreateResult> {
        private final EmployeeTypeEnums employeeTypeEnums;
        private final EmployeeTypeEnum body;
        private final List<RequestOptFn> optFns;
        private EmployeeTypeEnumCreateResult result;

        private EmployeeTypeEnumCreateReqCall(EmployeeTypeEnums employeeTypeEnums, EmployeeTypeEnum body, RequestOptFn ... optFns) {
            this.body = body;
            this.optFns = new ArrayList<RequestOptFn>();
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new EmployeeTypeEnumCreateResult();
            this.employeeTypeEnums = employeeTypeEnums;
        }

        @Override
        public Response<EmployeeTypeEnumCreateResult> execute() throws Exception {
            Request<EmployeeTypeEnum, EmployeeTypeEnumCreateResult> request = Request.newRequest("/open-apis/contact/v3/employee_type_enums", "POST", new AccessTokenType[]{AccessTokenType.Tenant}, this.body, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.employeeTypeEnums.service.config, request);
        }
    }

    public static class EmployeeTypeEnumListReqCall
    extends ReqCaller<Object, EmployeeTypeEnumListResult> {
        private final EmployeeTypeEnums employeeTypeEnums;
        private final Map<String, Object> queryParams = new HashMap<String, Object>();
        private final List<RequestOptFn> optFns = new ArrayList<RequestOptFn>();
        private EmployeeTypeEnumListResult result;

        private EmployeeTypeEnumListReqCall(EmployeeTypeEnums employeeTypeEnums, RequestOptFn ... optFns) {
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new EmployeeTypeEnumListResult();
            this.employeeTypeEnums = employeeTypeEnums;
        }

        public EmployeeTypeEnumListReqCall setPageToken(String pageToken) {
            this.queryParams.put("page_token", pageToken);
            return this;
        }

        public EmployeeTypeEnumListReqCall setPageSize(Integer pageSize) {
            this.queryParams.put("page_size", pageSize);
            return this;
        }

        @Override
        public Response<EmployeeTypeEnumListResult> execute() throws Exception {
            this.optFns.add(Request.setQueryParams(this.queryParams));
            Request<Object, EmployeeTypeEnumListResult> request = Request.newRequest("/open-apis/contact/v3/employee_type_enums", "GET", new AccessTokenType[]{AccessTokenType.Tenant}, null, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.employeeTypeEnums.service.config, request);
        }
    }

    public static class EmployeeTypeEnums {
        private final ContactService service;

        public EmployeeTypeEnums(ContactService service) {
            this.service = service;
        }

        public EmployeeTypeEnumListReqCall list(RequestOptFn ... optFns) {
            return new EmployeeTypeEnumListReqCall(this, optFns);
        }

        public EmployeeTypeEnumCreateReqCall create(EmployeeTypeEnum body, RequestOptFn ... optFns) {
            return new EmployeeTypeEnumCreateReqCall(this, body, optFns);
        }

        public EmployeeTypeEnumDeleteReqCall delete(RequestOptFn ... optFns) {
            return new EmployeeTypeEnumDeleteReqCall(this, optFns);
        }

        public EmployeeTypeEnumUpdateReqCall update(EmployeeTypeEnum body, RequestOptFn ... optFns) {
            return new EmployeeTypeEnumUpdateReqCall(this, body, optFns);
        }
    }

    public static class Scopes {
        private final ContactService service;

        public Scopes(ContactService service) {
            this.service = service;
        }
    }

    public static class DepartmentSearchReqCall
    extends ReqCaller<DepartmentSearchReqBody, DepartmentSearchResult> {
        private final Departments departments;
        private final DepartmentSearchReqBody body;
        private final Map<String, Object> queryParams;
        private final List<RequestOptFn> optFns;
        private DepartmentSearchResult result;

        private DepartmentSearchReqCall(Departments departments, DepartmentSearchReqBody body, RequestOptFn ... optFns) {
            this.body = body;
            this.queryParams = new HashMap<String, Object>();
            this.optFns = new ArrayList<RequestOptFn>();
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new DepartmentSearchResult();
            this.departments = departments;
        }

        public DepartmentSearchReqCall setUserIdType(String userIdType) {
            this.queryParams.put("user_id_type", userIdType);
            return this;
        }

        public DepartmentSearchReqCall setDepartmentIdType(String departmentIdType) {
            this.queryParams.put("department_id_type", departmentIdType);
            return this;
        }

        public DepartmentSearchReqCall setPageToken(String pageToken) {
            this.queryParams.put("page_token", pageToken);
            return this;
        }

        public DepartmentSearchReqCall setPageSize(Integer pageSize) {
            this.queryParams.put("page_size", pageSize);
            return this;
        }

        @Override
        public Response<DepartmentSearchResult> execute() throws Exception {
            this.optFns.add(Request.setQueryParams(this.queryParams));
            Request<DepartmentSearchReqBody, DepartmentSearchResult> request = Request.newRequest("/open-apis/contact/v3/departments/search", "POST", new AccessTokenType[]{AccessTokenType.User}, this.body, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.departments.service.config, request);
        }
    }

    public static class DepartmentParentReqCall
    extends ReqCaller<Object, DepartmentParentResult> {
        private final Departments departments;
        private final Map<String, Object> queryParams = new HashMap<String, Object>();
        private final List<RequestOptFn> optFns = new ArrayList<RequestOptFn>();
        private DepartmentParentResult result;

        private DepartmentParentReqCall(Departments departments, RequestOptFn ... optFns) {
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new DepartmentParentResult();
            this.departments = departments;
        }

        public DepartmentParentReqCall setUserIdType(String userIdType) {
            this.queryParams.put("user_id_type", userIdType);
            return this;
        }

        public DepartmentParentReqCall setDepartmentIdType(String departmentIdType) {
            this.queryParams.put("department_id_type", departmentIdType);
            return this;
        }

        public DepartmentParentReqCall setDepartmentId(String departmentId) {
            this.queryParams.put("department_id", departmentId);
            return this;
        }

        public DepartmentParentReqCall setPageToken(String pageToken) {
            this.queryParams.put("page_token", pageToken);
            return this;
        }

        public DepartmentParentReqCall setPageSize(Integer pageSize) {
            this.queryParams.put("page_size", pageSize);
            return this;
        }

        @Override
        public Response<DepartmentParentResult> execute() throws Exception {
            this.optFns.add(Request.setQueryParams(this.queryParams));
            Request<Object, DepartmentParentResult> request = Request.newRequest("/open-apis/contact/v3/departments/parent", "GET", new AccessTokenType[]{AccessTokenType.Tenant, AccessTokenType.User}, null, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.departments.service.config, request);
        }
    }

    public static class DepartmentUpdateReqCall
    extends ReqCaller<Department, DepartmentUpdateResult> {
        private final Departments departments;
        private final Department body;
        private final Map<String, Object> pathParams;
        private final Map<String, Object> queryParams;
        private final List<RequestOptFn> optFns;
        private DepartmentUpdateResult result;

        private DepartmentUpdateReqCall(Departments departments, Department body, RequestOptFn ... optFns) {
            this.body = body;
            this.pathParams = new HashMap<String, Object>();
            this.queryParams = new HashMap<String, Object>();
            this.optFns = new ArrayList<RequestOptFn>();
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new DepartmentUpdateResult();
            this.departments = departments;
        }

        public DepartmentUpdateReqCall setDepartmentId(String departmentId) {
            this.pathParams.put("department_id", departmentId);
            return this;
        }

        public DepartmentUpdateReqCall setUserIdType(String userIdType) {
            this.queryParams.put("user_id_type", userIdType);
            return this;
        }

        public DepartmentUpdateReqCall setDepartmentIdType(String departmentIdType) {
            this.queryParams.put("department_id_type", departmentIdType);
            return this;
        }

        @Override
        public Response<DepartmentUpdateResult> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            this.optFns.add(Request.setQueryParams(this.queryParams));
            Request<Department, DepartmentUpdateResult> request = Request.newRequest("/open-apis/contact/v3/departments/:department_id", "PUT", new AccessTokenType[]{AccessTokenType.Tenant}, this.body, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.departments.service.config, request);
        }
    }

    public static class DepartmentDeleteReqCall
    extends ReqCaller<Object, EmptyData> {
        private final Departments departments;
        private final Map<String, Object> pathParams = new HashMap<String, Object>();
        private final Map<String, Object> queryParams = new HashMap<String, Object>();
        private final List<RequestOptFn> optFns = new ArrayList<RequestOptFn>();
        private EmptyData result;

        private DepartmentDeleteReqCall(Departments departments, RequestOptFn ... optFns) {
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new EmptyData();
            this.departments = departments;
        }

        public DepartmentDeleteReqCall setDepartmentId(String departmentId) {
            this.pathParams.put("department_id", departmentId);
            return this;
        }

        public DepartmentDeleteReqCall setDepartmentIdType(String departmentIdType) {
            this.queryParams.put("department_id_type", departmentIdType);
            return this;
        }

        @Override
        public Response<EmptyData> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            this.optFns.add(Request.setQueryParams(this.queryParams));
            Request<Object, EmptyData> request = Request.newRequest("/open-apis/contact/v3/departments/:department_id", "DELETE", new AccessTokenType[]{AccessTokenType.Tenant}, null, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.departments.service.config, request);
        }
    }

    public static class DepartmentCreateReqCall
    extends ReqCaller<Department, DepartmentCreateResult> {
        private final Departments departments;
        private final Department body;
        private final Map<String, Object> queryParams;
        private final List<RequestOptFn> optFns;
        private DepartmentCreateResult result;

        private DepartmentCreateReqCall(Departments departments, Department body, RequestOptFn ... optFns) {
            this.body = body;
            this.queryParams = new HashMap<String, Object>();
            this.optFns = new ArrayList<RequestOptFn>();
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new DepartmentCreateResult();
            this.departments = departments;
        }

        public DepartmentCreateReqCall setUserIdType(String userIdType) {
            this.queryParams.put("user_id_type", userIdType);
            return this;
        }

        public DepartmentCreateReqCall setDepartmentIdType(String departmentIdType) {
            this.queryParams.put("department_id_type", departmentIdType);
            return this;
        }

        public DepartmentCreateReqCall setClientToken(String clientToken) {
            this.queryParams.put("client_token", clientToken);
            return this;
        }

        @Override
        public Response<DepartmentCreateResult> execute() throws Exception {
            this.optFns.add(Request.setQueryParams(this.queryParams));
            Request<Department, DepartmentCreateResult> request = Request.newRequest("/open-apis/contact/v3/departments", "POST", new AccessTokenType[]{AccessTokenType.Tenant}, this.body, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.departments.service.config, request);
        }
    }

    public static class DepartmentPatchReqCall
    extends ReqCaller<Department, DepartmentPatchResult> {
        private final Departments departments;
        private final Department body;
        private final Map<String, Object> pathParams;
        private final Map<String, Object> queryParams;
        private final List<RequestOptFn> optFns;
        private DepartmentPatchResult result;

        private DepartmentPatchReqCall(Departments departments, Department body, RequestOptFn ... optFns) {
            this.body = body;
            this.pathParams = new HashMap<String, Object>();
            this.queryParams = new HashMap<String, Object>();
            this.optFns = new ArrayList<RequestOptFn>();
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new DepartmentPatchResult();
            this.departments = departments;
        }

        public DepartmentPatchReqCall setDepartmentId(String departmentId) {
            this.pathParams.put("department_id", departmentId);
            return this;
        }

        public DepartmentPatchReqCall setUserIdType(String userIdType) {
            this.queryParams.put("user_id_type", userIdType);
            return this;
        }

        public DepartmentPatchReqCall setDepartmentIdType(String departmentIdType) {
            this.queryParams.put("department_id_type", departmentIdType);
            return this;
        }

        @Override
        public Response<DepartmentPatchResult> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            this.optFns.add(Request.setQueryParams(this.queryParams));
            Request<Department, DepartmentPatchResult> request = Request.newRequest("/open-apis/contact/v3/departments/:department_id", "PATCH", new AccessTokenType[]{AccessTokenType.Tenant}, this.body, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.departments.service.config, request);
        }
    }

    public static class DepartmentListReqCall
    extends ReqCaller<Object, DepartmentListResult> {
        private final Departments departments;
        private final Map<String, Object> queryParams = new HashMap<String, Object>();
        private final List<RequestOptFn> optFns = new ArrayList<RequestOptFn>();
        private DepartmentListResult result;

        private DepartmentListReqCall(Departments departments, RequestOptFn ... optFns) {
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new DepartmentListResult();
            this.departments = departments;
        }

        public DepartmentListReqCall setUserIdType(String userIdType) {
            this.queryParams.put("user_id_type", userIdType);
            return this;
        }

        public DepartmentListReqCall setDepartmentIdType(String departmentIdType) {
            this.queryParams.put("department_id_type", departmentIdType);
            return this;
        }

        public DepartmentListReqCall setParentDepartmentId(String parentDepartmentId) {
            this.queryParams.put("parent_department_id", parentDepartmentId);
            return this;
        }

        public DepartmentListReqCall setFetchChild(Boolean fetchChild) {
            this.queryParams.put("fetch_child", fetchChild);
            return this;
        }

        public DepartmentListReqCall setPageToken(String pageToken) {
            this.queryParams.put("page_token", pageToken);
            return this;
        }

        public DepartmentListReqCall setPageSize(Integer pageSize) {
            this.queryParams.put("page_size", pageSize);
            return this;
        }

        @Override
        public Response<DepartmentListResult> execute() throws Exception {
            this.optFns.add(Request.setQueryParams(this.queryParams));
            Request<Object, DepartmentListResult> request = Request.newRequest("/open-apis/contact/v3/departments", "GET", new AccessTokenType[]{AccessTokenType.Tenant, AccessTokenType.User}, null, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.departments.service.config, request);
        }
    }

    public static class DepartmentGetReqCall
    extends ReqCaller<Object, DepartmentGetResult> {
        private final Departments departments;
        private final Map<String, Object> pathParams = new HashMap<String, Object>();
        private final Map<String, Object> queryParams = new HashMap<String, Object>();
        private final List<RequestOptFn> optFns = new ArrayList<RequestOptFn>();
        private DepartmentGetResult result;

        private DepartmentGetReqCall(Departments departments, RequestOptFn ... optFns) {
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new DepartmentGetResult();
            this.departments = departments;
        }

        public DepartmentGetReqCall setDepartmentId(String departmentId) {
            this.pathParams.put("department_id", departmentId);
            return this;
        }

        public DepartmentGetReqCall setUserIdType(String userIdType) {
            this.queryParams.put("user_id_type", userIdType);
            return this;
        }

        public DepartmentGetReqCall setDepartmentIdType(String departmentIdType) {
            this.queryParams.put("department_id_type", departmentIdType);
            return this;
        }

        @Override
        public Response<DepartmentGetResult> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            this.optFns.add(Request.setQueryParams(this.queryParams));
            Request<Object, DepartmentGetResult> request = Request.newRequest("/open-apis/contact/v3/departments/:department_id", "GET", new AccessTokenType[]{AccessTokenType.Tenant, AccessTokenType.User}, null, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.departments.service.config, request);
        }
    }

    public static class Departments {
        private final ContactService service;

        public Departments(ContactService service) {
            this.service = service;
        }

        public DepartmentGetReqCall get(RequestOptFn ... optFns) {
            return new DepartmentGetReqCall(this, optFns);
        }

        public DepartmentListReqCall list(RequestOptFn ... optFns) {
            return new DepartmentListReqCall(this, optFns);
        }

        public DepartmentPatchReqCall patch(Department body, RequestOptFn ... optFns) {
            return new DepartmentPatchReqCall(this, body, optFns);
        }

        public DepartmentCreateReqCall create(Department body, RequestOptFn ... optFns) {
            return new DepartmentCreateReqCall(this, body, optFns);
        }

        public DepartmentDeleteReqCall delete(RequestOptFn ... optFns) {
            return new DepartmentDeleteReqCall(this, optFns);
        }

        public DepartmentUpdateReqCall update(Department body, RequestOptFn ... optFns) {
            return new DepartmentUpdateReqCall(this, body, optFns);
        }

        public DepartmentParentReqCall parent(RequestOptFn ... optFns) {
            return new DepartmentParentReqCall(this, optFns);
        }

        public DepartmentSearchReqCall search(DepartmentSearchReqBody body, RequestOptFn ... optFns) {
            return new DepartmentSearchReqCall(this, body, optFns);
        }
    }

    public static class UserListReqCall
    extends ReqCaller<Object, UserListResult> {
        private final Users users;
        private final Map<String, Object> queryParams = new HashMap<String, Object>();
        private final List<RequestOptFn> optFns = new ArrayList<RequestOptFn>();
        private UserListResult result;

        private UserListReqCall(Users users, RequestOptFn ... optFns) {
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new UserListResult();
            this.users = users;
        }

        public UserListReqCall setUserIdType(String userIdType) {
            this.queryParams.put("user_id_type", userIdType);
            return this;
        }

        public UserListReqCall setDepartmentIdType(String departmentIdType) {
            this.queryParams.put("department_id_type", departmentIdType);
            return this;
        }

        public UserListReqCall setDepartmentId(String departmentId) {
            this.queryParams.put("department_id", departmentId);
            return this;
        }

        public UserListReqCall setPageToken(String pageToken) {
            this.queryParams.put("page_token", pageToken);
            return this;
        }

        public UserListReqCall setPageSize(Integer pageSize) {
            this.queryParams.put("page_size", pageSize);
            return this;
        }

        @Override
        public Response<UserListResult> execute() throws Exception {
            this.optFns.add(Request.setQueryParams(this.queryParams));
            Request<Object, UserListResult> request = Request.newRequest("/open-apis/contact/v3/users", "GET", new AccessTokenType[]{AccessTokenType.Tenant, AccessTokenType.User}, null, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.users.service.config, request);
        }
    }

    public static class UserGetReqCall
    extends ReqCaller<Object, UserGetResult> {
        private final Users users;
        private final Map<String, Object> pathParams = new HashMap<String, Object>();
        private final Map<String, Object> queryParams = new HashMap<String, Object>();
        private final List<RequestOptFn> optFns = new ArrayList<RequestOptFn>();
        private UserGetResult result;

        private UserGetReqCall(Users users, RequestOptFn ... optFns) {
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new UserGetResult();
            this.users = users;
        }

        public UserGetReqCall setUserId(String userId) {
            this.pathParams.put("user_id", userId);
            return this;
        }

        public UserGetReqCall setUserIdType(String userIdType) {
            this.queryParams.put("user_id_type", userIdType);
            return this;
        }

        public UserGetReqCall setDepartmentIdType(String departmentIdType) {
            this.queryParams.put("department_id_type", departmentIdType);
            return this;
        }

        @Override
        public Response<UserGetResult> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            this.optFns.add(Request.setQueryParams(this.queryParams));
            Request<Object, UserGetResult> request = Request.newRequest("/open-apis/contact/v3/users/:user_id", "GET", new AccessTokenType[]{AccessTokenType.Tenant, AccessTokenType.User}, null, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.users.service.config, request);
        }
    }

    public static class UserPatchReqCall
    extends ReqCaller<User, UserPatchResult> {
        private final Users users;
        private final User body;
        private final Map<String, Object> pathParams;
        private final Map<String, Object> queryParams;
        private final List<RequestOptFn> optFns;
        private UserPatchResult result;

        private UserPatchReqCall(Users users, User body, RequestOptFn ... optFns) {
            this.body = body;
            this.pathParams = new HashMap<String, Object>();
            this.queryParams = new HashMap<String, Object>();
            this.optFns = new ArrayList<RequestOptFn>();
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new UserPatchResult();
            this.users = users;
        }

        public UserPatchReqCall setUserId(String userId) {
            this.pathParams.put("user_id", userId);
            return this;
        }

        public UserPatchReqCall setUserIdType(String userIdType) {
            this.queryParams.put("user_id_type", userIdType);
            return this;
        }

        public UserPatchReqCall setDepartmentIdType(String departmentIdType) {
            this.queryParams.put("department_id_type", departmentIdType);
            return this;
        }

        @Override
        public Response<UserPatchResult> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            this.optFns.add(Request.setQueryParams(this.queryParams));
            Request<User, UserPatchResult> request = Request.newRequest("/open-apis/contact/v3/users/:user_id", "PATCH", new AccessTokenType[]{AccessTokenType.Tenant, AccessTokenType.User}, this.body, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.users.service.config, request);
        }
    }

    public static class UserCreateReqCall
    extends ReqCaller<User, UserCreateResult> {
        private final Users users;
        private final User body;
        private final Map<String, Object> queryParams;
        private final List<RequestOptFn> optFns;
        private UserCreateResult result;

        private UserCreateReqCall(Users users, User body, RequestOptFn ... optFns) {
            this.body = body;
            this.queryParams = new HashMap<String, Object>();
            this.optFns = new ArrayList<RequestOptFn>();
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new UserCreateResult();
            this.users = users;
        }

        public UserCreateReqCall setUserIdType(String userIdType) {
            this.queryParams.put("user_id_type", userIdType);
            return this;
        }

        public UserCreateReqCall setDepartmentIdType(String departmentIdType) {
            this.queryParams.put("department_id_type", departmentIdType);
            return this;
        }

        public UserCreateReqCall setClientToken(String clientToken) {
            this.queryParams.put("client_token", clientToken);
            return this;
        }

        @Override
        public Response<UserCreateResult> execute() throws Exception {
            this.optFns.add(Request.setQueryParams(this.queryParams));
            Request<User, UserCreateResult> request = Request.newRequest("/open-apis/contact/v3/users", "POST", new AccessTokenType[]{AccessTokenType.Tenant}, this.body, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.users.service.config, request);
        }
    }

    public static class UserUpdateReqCall
    extends ReqCaller<User, UserUpdateResult> {
        private final Users users;
        private final User body;
        private final Map<String, Object> pathParams;
        private final Map<String, Object> queryParams;
        private final List<RequestOptFn> optFns;
        private UserUpdateResult result;

        private UserUpdateReqCall(Users users, User body, RequestOptFn ... optFns) {
            this.body = body;
            this.pathParams = new HashMap<String, Object>();
            this.queryParams = new HashMap<String, Object>();
            this.optFns = new ArrayList<RequestOptFn>();
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new UserUpdateResult();
            this.users = users;
        }

        public UserUpdateReqCall setUserId(String userId) {
            this.pathParams.put("user_id", userId);
            return this;
        }

        public UserUpdateReqCall setUserIdType(String userIdType) {
            this.queryParams.put("user_id_type", userIdType);
            return this;
        }

        public UserUpdateReqCall setDepartmentIdType(String departmentIdType) {
            this.queryParams.put("department_id_type", departmentIdType);
            return this;
        }

        @Override
        public Response<UserUpdateResult> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            this.optFns.add(Request.setQueryParams(this.queryParams));
            Request<User, UserUpdateResult> request = Request.newRequest("/open-apis/contact/v3/users/:user_id", "PUT", new AccessTokenType[]{AccessTokenType.Tenant}, this.body, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.users.service.config, request);
        }
    }

    public static class UserDeleteReqCall
    extends ReqCaller<UserDeleteReqBody, EmptyData> {
        private final Users users;
        private final UserDeleteReqBody body;
        private final Map<String, Object> pathParams;
        private final Map<String, Object> queryParams;
        private final List<RequestOptFn> optFns;
        private EmptyData result;

        private UserDeleteReqCall(Users users, UserDeleteReqBody body, RequestOptFn ... optFns) {
            this.body = body;
            this.pathParams = new HashMap<String, Object>();
            this.queryParams = new HashMap<String, Object>();
            this.optFns = new ArrayList<RequestOptFn>();
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new EmptyData();
            this.users = users;
        }

        public UserDeleteReqCall setUserId(String userId) {
            this.pathParams.put("user_id", userId);
            return this;
        }

        public UserDeleteReqCall setUserIdType(String userIdType) {
            this.queryParams.put("user_id_type", userIdType);
            return this;
        }

        @Override
        public Response<EmptyData> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            this.optFns.add(Request.setQueryParams(this.queryParams));
            Request<UserDeleteReqBody, EmptyData> request = Request.newRequest("/open-apis/contact/v3/users/:user_id", "DELETE", new AccessTokenType[]{AccessTokenType.Tenant}, this.body, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.users.service.config, request);
        }
    }

    public static class Users {
        private final ContactService service;

        public Users(ContactService service) {
            this.service = service;
        }

        public UserDeleteReqCall delete(UserDeleteReqBody body, RequestOptFn ... optFns) {
            return new UserDeleteReqCall(this, body, optFns);
        }

        public UserUpdateReqCall update(User body, RequestOptFn ... optFns) {
            return new UserUpdateReqCall(this, body, optFns);
        }

        public UserCreateReqCall create(User body, RequestOptFn ... optFns) {
            return new UserCreateReqCall(this, body, optFns);
        }

        public UserPatchReqCall patch(User body, RequestOptFn ... optFns) {
            return new UserPatchReqCall(this, body, optFns);
        }

        public UserGetReqCall get(RequestOptFn ... optFns) {
            return new UserGetReqCall(this, optFns);
        }

        public UserListReqCall list(RequestOptFn ... optFns) {
            return new UserListReqCall(this, optFns);
        }
    }
}

