/*
 * Decompiled with CFR 0.152.
 */
package com.larksuite.oapi.service.ehr.v1;

import com.larksuite.oapi.core.Config;
import com.larksuite.oapi.core.api.AccessTokenType;
import com.larksuite.oapi.core.api.Api;
import com.larksuite.oapi.core.api.ReqCaller;
import com.larksuite.oapi.core.api.request.Request;
import com.larksuite.oapi.core.api.request.RequestOptFn;
import com.larksuite.oapi.core.api.response.Response;
import com.larksuite.oapi.service.ehr.v1.model.EmployeeListResult;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EhrService {
    private final Config config;
    private final Attachments attachments;
    private final Employees employees;

    public EhrService(Config config) {
        this.config = config;
        this.attachments = new Attachments(this);
        this.employees = new Employees(this);
    }

    public Attachments getAttachments() {
        return this.attachments;
    }

    public Employees getEmployees() {
        return this.employees;
    }

    public static class EmployeeListReqCall
    extends ReqCaller<Object, EmployeeListResult> {
        private final Employees employees;
        private final Map<String, Object> queryParams = new HashMap<String, Object>();
        private final List<RequestOptFn> optFns = new ArrayList<RequestOptFn>();
        private EmployeeListResult result;

        private EmployeeListReqCall(Employees employees, RequestOptFn ... optFns) {
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new EmployeeListResult();
            this.employees = employees;
        }

        public EmployeeListReqCall setView(String view) {
            this.queryParams.put("view", view);
            return this;
        }

        public EmployeeListReqCall setStatus(Integer ... status) {
            this.queryParams.put("status", status);
            return this;
        }

        public EmployeeListReqCall setType(Integer ... type) {
            this.queryParams.put("type", type);
            return this;
        }

        public EmployeeListReqCall setStartTime(Long startTime) {
            this.queryParams.put("start_time", startTime);
            return this;
        }

        public EmployeeListReqCall setEndTime(Long endTime) {
            this.queryParams.put("end_time", endTime);
            return this;
        }

        public EmployeeListReqCall setUserIdType(String userIdType) {
            this.queryParams.put("user_id_type", userIdType);
            return this;
        }

        public EmployeeListReqCall setUserIds(String ... userIds) {
            this.queryParams.put("user_ids", userIds);
            return this;
        }

        public EmployeeListReqCall setPageToken(String pageToken) {
            this.queryParams.put("page_token", pageToken);
            return this;
        }

        public EmployeeListReqCall setPageSize(Integer pageSize) {
            this.queryParams.put("page_size", pageSize);
            return this;
        }

        @Override
        public Response<EmployeeListResult> execute() throws Exception {
            this.optFns.add(Request.setQueryParams(this.queryParams));
            Request<Object, EmployeeListResult> request = Request.newRequest("/open-apis/ehr/v1/employees", "GET", new AccessTokenType[]{AccessTokenType.Tenant}, null, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.employees.service.config, request);
        }
    }

    public static class Employees {
        private final EhrService service;

        public Employees(EhrService service) {
            this.service = service;
        }

        public EmployeeListReqCall list(RequestOptFn ... optFns) {
            return new EmployeeListReqCall(this, optFns);
        }
    }

    public static class AttachmentGetReqCall
    extends ReqCaller<Object, OutputStream> {
        private final Attachments attachments;
        private final Map<String, Object> pathParams = new HashMap<String, Object>();
        private final List<RequestOptFn> optFns = new ArrayList<RequestOptFn>();
        private OutputStream result;

        private AttachmentGetReqCall(Attachments attachments, RequestOptFn ... optFns) {
            this.optFns.addAll(Arrays.asList(optFns));
            this.attachments = attachments;
        }

        public AttachmentGetReqCall setToken(String token) {
            this.pathParams.put("token", token);
            return this;
        }

        public AttachmentGetReqCall setResponseStream(OutputStream result) {
            this.result = result;
            return this;
        }

        @Override
        public Response<OutputStream> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            this.optFns.add(Request.setResponseStream());
            Request<Object, OutputStream> request = Request.newRequest("/open-apis/ehr/v1/attachments/:token", "GET", new AccessTokenType[]{AccessTokenType.Tenant}, null, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.attachments.service.config, request);
        }
    }

    public static class Attachments {
        private final EhrService service;

        public Attachments(EhrService service) {
            this.service = service;
        }

        public AttachmentGetReqCall get(RequestOptFn ... optFns) {
            return new AttachmentGetReqCall(this, optFns);
        }
    }
}

