/*
 * Decompiled with CFR 0.152.
 */
package com.larksuite.oapi.service.speech_to_text.v1;

import com.larksuite.oapi.core.Config;
import com.larksuite.oapi.core.api.AccessTokenType;
import com.larksuite.oapi.core.api.Api;
import com.larksuite.oapi.core.api.ReqCaller;
import com.larksuite.oapi.core.api.request.Request;
import com.larksuite.oapi.core.api.request.RequestOptFn;
import com.larksuite.oapi.core.api.response.Response;
import com.larksuite.oapi.service.speech_to_text.v1.model.SpeechFileRecognizeReqBody;
import com.larksuite.oapi.service.speech_to_text.v1.model.SpeechFileRecognizeResult;
import com.larksuite.oapi.service.speech_to_text.v1.model.SpeechStreamRecognizeReqBody;
import com.larksuite.oapi.service.speech_to_text.v1.model.SpeechStreamRecognizeResult;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class SpeechToTextService {
    private final Config config;
    private final Speechs speechs;

    public SpeechToTextService(Config config) {
        this.config = config;
        this.speechs = new Speechs(this);
    }

    public Speechs getSpeechs() {
        return this.speechs;
    }

    public static class SpeechStreamRecognizeReqCall
    extends ReqCaller<SpeechStreamRecognizeReqBody, SpeechStreamRecognizeResult> {
        private final Speechs speechs;
        private final SpeechStreamRecognizeReqBody body;
        private final List<RequestOptFn> optFns;
        private SpeechStreamRecognizeResult result;

        private SpeechStreamRecognizeReqCall(Speechs speechs, SpeechStreamRecognizeReqBody body, RequestOptFn ... optFns) {
            this.body = body;
            this.optFns = new ArrayList<RequestOptFn>();
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new SpeechStreamRecognizeResult();
            this.speechs = speechs;
        }

        @Override
        public Response<SpeechStreamRecognizeResult> execute() throws Exception {
            Request<SpeechStreamRecognizeReqBody, SpeechStreamRecognizeResult> request = Request.newRequest("/open-apis/speech_to_text/v1/speech/stream_recognize", "POST", new AccessTokenType[]{AccessTokenType.Tenant}, this.body, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.speechs.service.config, request);
        }
    }

    public static class SpeechFileRecognizeReqCall
    extends ReqCaller<SpeechFileRecognizeReqBody, SpeechFileRecognizeResult> {
        private final Speechs speechs;
        private final SpeechFileRecognizeReqBody body;
        private final List<RequestOptFn> optFns;
        private SpeechFileRecognizeResult result;

        private SpeechFileRecognizeReqCall(Speechs speechs, SpeechFileRecognizeReqBody body, RequestOptFn ... optFns) {
            this.body = body;
            this.optFns = new ArrayList<RequestOptFn>();
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new SpeechFileRecognizeResult();
            this.speechs = speechs;
        }

        @Override
        public Response<SpeechFileRecognizeResult> execute() throws Exception {
            Request<SpeechFileRecognizeReqBody, SpeechFileRecognizeResult> request = Request.newRequest("/open-apis/speech_to_text/v1/speech/file_recognize", "POST", new AccessTokenType[]{AccessTokenType.Tenant}, this.body, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.speechs.service.config, request);
        }
    }

    public static class Speechs {
        private final SpeechToTextService service;

        public Speechs(SpeechToTextService service) {
            this.service = service;
        }

        public SpeechFileRecognizeReqCall fileRecognize(SpeechFileRecognizeReqBody body, RequestOptFn ... optFns) {
            return new SpeechFileRecognizeReqCall(this, body, optFns);
        }

        public SpeechStreamRecognizeReqCall streamRecognize(SpeechStreamRecognizeReqBody body, RequestOptFn ... optFns) {
            return new SpeechStreamRecognizeReqCall(this, body, optFns);
        }
    }
}

