/*
 * Decompiled with CFR 0.152.
 */
package com.larksuite.oapi.service.acs.v1;

import com.larksuite.oapi.core.Config;
import com.larksuite.oapi.core.api.AccessTokenType;
import com.larksuite.oapi.core.api.Api;
import com.larksuite.oapi.core.api.ReqCaller;
import com.larksuite.oapi.core.api.request.FormData;
import com.larksuite.oapi.core.api.request.FormDataFile;
import com.larksuite.oapi.core.api.request.Request;
import com.larksuite.oapi.core.api.request.RequestOptFn;
import com.larksuite.oapi.core.api.response.EmptyData;
import com.larksuite.oapi.core.api.response.Response;
import com.larksuite.oapi.core.event.Event;
import com.larksuite.oapi.core.event.IHandler;
import com.larksuite.oapi.service.acs.v1.model.AccessRecordCreatedEvent;
import com.larksuite.oapi.service.acs.v1.model.AccessRecordListResult;
import com.larksuite.oapi.service.acs.v1.model.DeviceListResult;
import com.larksuite.oapi.service.acs.v1.model.User;
import com.larksuite.oapi.service.acs.v1.model.UserGetResult;
import com.larksuite.oapi.service.acs.v1.model.UserListResult;
import com.larksuite.oapi.service.acs.v1.model.UserUpdatedEvent;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AcsService {
    private final Config config;
    private final AccessRecords accessRecords;
    private final Users users;
    private final Devices devices;
    private final AccessRecordAccessPhotos accessRecordAccessPhotos;
    private final UserFaces userFaces;

    public AcsService(Config config) {
        this.config = config;
        this.accessRecords = new AccessRecords(this);
        this.users = new Users(this);
        this.devices = new Devices(this);
        this.accessRecordAccessPhotos = new AccessRecordAccessPhotos(this);
        this.userFaces = new UserFaces(this);
    }

    public AccessRecords getAccessRecords() {
        return this.accessRecords;
    }

    public Users getUsers() {
        return this.users;
    }

    public Devices getDevices() {
        return this.devices;
    }

    public AccessRecordAccessPhotos getAccessRecordAccessPhotos() {
        return this.accessRecordAccessPhotos;
    }

    public UserFaces getUserFaces() {
        return this.userFaces;
    }

    public void setAccessRecordCreatedEventHandler(AccessRecordCreatedEventHandler handler) {
        Event.setTypeHandler(this.config, "acs.access_record.created_v1", handler);
    }

    public void setUserUpdatedEventHandler(UserUpdatedEventHandler handler) {
        Event.setTypeHandler(this.config, "acs.user.updated_v1", handler);
    }

    public static abstract class UserUpdatedEventHandler
    implements IHandler<UserUpdatedEvent> {
        @Override
        public UserUpdatedEvent getEvent() {
            return new UserUpdatedEvent();
        }
    }

    public static abstract class AccessRecordCreatedEventHandler
    implements IHandler<AccessRecordCreatedEvent> {
        @Override
        public AccessRecordCreatedEvent getEvent() {
            return new AccessRecordCreatedEvent();
        }
    }

    public static class UserFaceUpdateReqCall
    extends ReqCaller<FormData, EmptyData> {
        private final UserFaces userFaces;
        private final FormData body = new FormData();
        private final Map<String, Object> pathParams = new HashMap<String, Object>();
        private final Map<String, Object> queryParams = new HashMap<String, Object>();
        private final List<RequestOptFn> optFns = new ArrayList<RequestOptFn>();
        private EmptyData result;

        private UserFaceUpdateReqCall(UserFaces userFaces, RequestOptFn ... optFns) {
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new EmptyData();
            this.userFaces = userFaces;
        }

        public UserFaceUpdateReqCall setUserId(String userId) {
            this.pathParams.put("user_id", userId);
            return this;
        }

        public UserFaceUpdateReqCall setUserIdType(String userIdType) {
            this.queryParams.put("user_id_type", userIdType);
            return this;
        }

        public UserFaceUpdateReqCall setFiles(FormDataFile files) {
            this.body.addFile("files", files);
            return this;
        }

        public UserFaceUpdateReqCall setFileType(String fileType) {
            this.body.addField("file_type", fileType);
            return this;
        }

        public UserFaceUpdateReqCall setFileName(String fileName) {
            this.body.addField("file_name", fileName);
            return this;
        }

        @Override
        public Response<EmptyData> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            this.optFns.add(Request.setQueryParams(this.queryParams));
            Request<FormData, EmptyData> request = Request.newRequest("/open-apis/acs/v1/users/:user_id/face", "PUT", new AccessTokenType[]{AccessTokenType.Tenant}, this.body, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.userFaces.service.config, request);
        }
    }

    public static class UserFaceGetReqCall
    extends ReqCaller<Object, OutputStream> {
        private final UserFaces userFaces;
        private final Map<String, Object> pathParams = new HashMap<String, Object>();
        private final Map<String, Object> queryParams = new HashMap<String, Object>();
        private final List<RequestOptFn> optFns = new ArrayList<RequestOptFn>();
        private OutputStream result;

        private UserFaceGetReqCall(UserFaces userFaces, RequestOptFn ... optFns) {
            this.optFns.addAll(Arrays.asList(optFns));
            this.userFaces = userFaces;
        }

        public UserFaceGetReqCall setUserId(String userId) {
            this.pathParams.put("user_id", userId);
            return this;
        }

        public UserFaceGetReqCall setIsCropped(Boolean isCropped) {
            this.queryParams.put("is_cropped", isCropped);
            return this;
        }

        public UserFaceGetReqCall setUserIdType(String userIdType) {
            this.queryParams.put("user_id_type", userIdType);
            return this;
        }

        public UserFaceGetReqCall setResponseStream(OutputStream result) {
            this.result = result;
            return this;
        }

        @Override
        public Response<OutputStream> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            this.optFns.add(Request.setQueryParams(this.queryParams));
            this.optFns.add(Request.setResponseStream());
            Request<Object, OutputStream> request = Request.newRequest("/open-apis/acs/v1/users/:user_id/face", "GET", new AccessTokenType[]{AccessTokenType.Tenant}, null, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.userFaces.service.config, request);
        }
    }

    public static class UserFaces {
        private final AcsService service;

        public UserFaces(AcsService service) {
            this.service = service;
        }

        public UserFaceGetReqCall get(RequestOptFn ... optFns) {
            return new UserFaceGetReqCall(this, optFns);
        }

        public UserFaceUpdateReqCall update(RequestOptFn ... optFns) {
            return new UserFaceUpdateReqCall(this, optFns);
        }
    }

    public static class AccessRecordAccessPhotoGetReqCall
    extends ReqCaller<Object, OutputStream> {
        private final AccessRecordAccessPhotos accessRecordAccessPhotos;
        private final Map<String, Object> pathParams = new HashMap<String, Object>();
        private final List<RequestOptFn> optFns = new ArrayList<RequestOptFn>();
        private OutputStream result;

        private AccessRecordAccessPhotoGetReqCall(AccessRecordAccessPhotos accessRecordAccessPhotos, RequestOptFn ... optFns) {
            this.optFns.addAll(Arrays.asList(optFns));
            this.accessRecordAccessPhotos = accessRecordAccessPhotos;
        }

        public AccessRecordAccessPhotoGetReqCall setAccessRecordId(Long accessRecordId) {
            this.pathParams.put("access_record_id", accessRecordId);
            return this;
        }

        public AccessRecordAccessPhotoGetReqCall setResponseStream(OutputStream result) {
            this.result = result;
            return this;
        }

        @Override
        public Response<OutputStream> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            this.optFns.add(Request.setResponseStream());
            Request<Object, OutputStream> request = Request.newRequest("/open-apis/acs/v1/access_records/:access_record_id/access_photo", "GET", new AccessTokenType[]{AccessTokenType.Tenant}, null, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.accessRecordAccessPhotos.service.config, request);
        }
    }

    public static class AccessRecordAccessPhotos {
        private final AcsService service;

        public AccessRecordAccessPhotos(AcsService service) {
            this.service = service;
        }

        public AccessRecordAccessPhotoGetReqCall get(RequestOptFn ... optFns) {
            return new AccessRecordAccessPhotoGetReqCall(this, optFns);
        }
    }

    public static class DeviceListReqCall
    extends ReqCaller<Object, DeviceListResult> {
        private final Devices devices;
        private final List<RequestOptFn> optFns = new ArrayList<RequestOptFn>();
        private DeviceListResult result;

        private DeviceListReqCall(Devices devices, RequestOptFn ... optFns) {
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new DeviceListResult();
            this.devices = devices;
        }

        @Override
        public Response<DeviceListResult> execute() throws Exception {
            Request<Object, DeviceListResult> request = Request.newRequest("/open-apis/acs/v1/devices", "GET", new AccessTokenType[]{AccessTokenType.Tenant}, null, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.devices.service.config, request);
        }
    }

    public static class Devices {
        private final AcsService service;

        public Devices(AcsService service) {
            this.service = service;
        }

        public DeviceListReqCall list(RequestOptFn ... optFns) {
            return new DeviceListReqCall(this, optFns);
        }
    }

    public static class UserListReqCall
    extends ReqCaller<Object, UserListResult> {
        private final Users users;
        private final Map<String, Object> queryParams = new HashMap<String, Object>();
        private final List<RequestOptFn> optFns = new ArrayList<RequestOptFn>();
        private UserListResult result;

        private UserListReqCall(Users users, RequestOptFn ... optFns) {
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new UserListResult();
            this.users = users;
        }

        public UserListReqCall setPageSize(Integer pageSize) {
            this.queryParams.put("page_size", pageSize);
            return this;
        }

        public UserListReqCall setPageToken(String pageToken) {
            this.queryParams.put("page_token", pageToken);
            return this;
        }

        public UserListReqCall setUserIdType(String userIdType) {
            this.queryParams.put("user_id_type", userIdType);
            return this;
        }

        @Override
        public Response<UserListResult> execute() throws Exception {
            this.optFns.add(Request.setQueryParams(this.queryParams));
            Request<Object, UserListResult> request = Request.newRequest("/open-apis/acs/v1/users", "GET", new AccessTokenType[]{AccessTokenType.Tenant}, null, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.users.service.config, request);
        }
    }

    public static class UserGetReqCall
    extends ReqCaller<Object, UserGetResult> {
        private final Users users;
        private final Map<String, Object> pathParams = new HashMap<String, Object>();
        private final Map<String, Object> queryParams = new HashMap<String, Object>();
        private final List<RequestOptFn> optFns = new ArrayList<RequestOptFn>();
        private UserGetResult result;

        private UserGetReqCall(Users users, RequestOptFn ... optFns) {
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new UserGetResult();
            this.users = users;
        }

        public UserGetReqCall setUserId(String userId) {
            this.pathParams.put("user_id", userId);
            return this;
        }

        public UserGetReqCall setUserIdType(String userIdType) {
            this.queryParams.put("user_id_type", userIdType);
            return this;
        }

        @Override
        public Response<UserGetResult> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            this.optFns.add(Request.setQueryParams(this.queryParams));
            Request<Object, UserGetResult> request = Request.newRequest("/open-apis/acs/v1/users/:user_id", "GET", new AccessTokenType[]{AccessTokenType.Tenant}, null, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.users.service.config, request);
        }
    }

    public static class UserPatchReqCall
    extends ReqCaller<User, EmptyData> {
        private final Users users;
        private final User body;
        private final Map<String, Object> pathParams;
        private final Map<String, Object> queryParams;
        private final List<RequestOptFn> optFns;
        private EmptyData result;

        private UserPatchReqCall(Users users, User body, RequestOptFn ... optFns) {
            this.body = body;
            this.pathParams = new HashMap<String, Object>();
            this.queryParams = new HashMap<String, Object>();
            this.optFns = new ArrayList<RequestOptFn>();
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new EmptyData();
            this.users = users;
        }

        public UserPatchReqCall setUserId(String userId) {
            this.pathParams.put("user_id", userId);
            return this;
        }

        public UserPatchReqCall setUserIdType(String userIdType) {
            this.queryParams.put("user_id_type", userIdType);
            return this;
        }

        @Override
        public Response<EmptyData> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            this.optFns.add(Request.setQueryParams(this.queryParams));
            Request<User, EmptyData> request = Request.newRequest("/open-apis/acs/v1/users/:user_id", "PATCH", new AccessTokenType[]{AccessTokenType.Tenant}, this.body, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.users.service.config, request);
        }
    }

    public static class Users {
        private final AcsService service;

        public Users(AcsService service) {
            this.service = service;
        }

        public UserPatchReqCall patch(User body, RequestOptFn ... optFns) {
            return new UserPatchReqCall(this, body, optFns);
        }

        public UserGetReqCall get(RequestOptFn ... optFns) {
            return new UserGetReqCall(this, optFns);
        }

        public UserListReqCall list(RequestOptFn ... optFns) {
            return new UserListReqCall(this, optFns);
        }
    }

    public static class AccessRecordListReqCall
    extends ReqCaller<Object, AccessRecordListResult> {
        private final AccessRecords accessRecords;
        private final Map<String, Object> queryParams = new HashMap<String, Object>();
        private final List<RequestOptFn> optFns = new ArrayList<RequestOptFn>();
        private AccessRecordListResult result;

        private AccessRecordListReqCall(AccessRecords accessRecords, RequestOptFn ... optFns) {
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new AccessRecordListResult();
            this.accessRecords = accessRecords;
        }

        public AccessRecordListReqCall setPageSize(Integer pageSize) {
            this.queryParams.put("page_size", pageSize);
            return this;
        }

        public AccessRecordListReqCall setPageToken(String pageToken) {
            this.queryParams.put("page_token", pageToken);
            return this;
        }

        public AccessRecordListReqCall setFrom(Integer from) {
            this.queryParams.put("from", from);
            return this;
        }

        public AccessRecordListReqCall setTo(Integer to) {
            this.queryParams.put("to", to);
            return this;
        }

        public AccessRecordListReqCall setDeviceId(Long deviceId) {
            this.queryParams.put("device_id", deviceId);
            return this;
        }

        public AccessRecordListReqCall setUserIdType(String userIdType) {
            this.queryParams.put("user_id_type", userIdType);
            return this;
        }

        @Override
        public Response<AccessRecordListResult> execute() throws Exception {
            this.optFns.add(Request.setQueryParams(this.queryParams));
            Request<Object, AccessRecordListResult> request = Request.newRequest("/open-apis/acs/v1/access_records", "GET", new AccessTokenType[]{AccessTokenType.Tenant}, null, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.accessRecords.service.config, request);
        }
    }

    public static class AccessRecords {
        private final AcsService service;

        public AccessRecords(AcsService service) {
            this.service = service;
        }

        public AccessRecordListReqCall list(RequestOptFn ... optFns) {
            return new AccessRecordListReqCall(this, optFns);
        }
    }
}

