/*
 * Decompiled with CFR 0.152.
 */
package com.larksuite.oapi.service.bitable.v1;

import com.larksuite.oapi.core.Config;
import com.larksuite.oapi.core.api.AccessTokenType;
import com.larksuite.oapi.core.api.Api;
import com.larksuite.oapi.core.api.ReqCaller;
import com.larksuite.oapi.core.api.request.Request;
import com.larksuite.oapi.core.api.request.RequestOptFn;
import com.larksuite.oapi.core.api.response.EmptyData;
import com.larksuite.oapi.core.api.response.Response;
import com.larksuite.oapi.service.bitable.v1.model.AppGetResult;
import com.larksuite.oapi.service.bitable.v1.model.AppTableBatchCreateReqBody;
import com.larksuite.oapi.service.bitable.v1.model.AppTableBatchCreateResult;
import com.larksuite.oapi.service.bitable.v1.model.AppTableBatchDeleteReqBody;
import com.larksuite.oapi.service.bitable.v1.model.AppTableCreateReqBody;
import com.larksuite.oapi.service.bitable.v1.model.AppTableCreateResult;
import com.larksuite.oapi.service.bitable.v1.model.AppTableField;
import com.larksuite.oapi.service.bitable.v1.model.AppTableFieldCreateResult;
import com.larksuite.oapi.service.bitable.v1.model.AppTableFieldDeleteResult;
import com.larksuite.oapi.service.bitable.v1.model.AppTableFieldListResult;
import com.larksuite.oapi.service.bitable.v1.model.AppTableFieldUpdateResult;
import com.larksuite.oapi.service.bitable.v1.model.AppTableListResult;
import com.larksuite.oapi.service.bitable.v1.model.AppTableRecord;
import com.larksuite.oapi.service.bitable.v1.model.AppTableRecordBatchCreateReqBody;
import com.larksuite.oapi.service.bitable.v1.model.AppTableRecordBatchCreateResult;
import com.larksuite.oapi.service.bitable.v1.model.AppTableRecordBatchDeleteReqBody;
import com.larksuite.oapi.service.bitable.v1.model.AppTableRecordBatchDeleteResult;
import com.larksuite.oapi.service.bitable.v1.model.AppTableRecordBatchUpdateReqBody;
import com.larksuite.oapi.service.bitable.v1.model.AppTableRecordBatchUpdateResult;
import com.larksuite.oapi.service.bitable.v1.model.AppTableRecordCreateResult;
import com.larksuite.oapi.service.bitable.v1.model.AppTableRecordGetResult;
import com.larksuite.oapi.service.bitable.v1.model.AppTableRecordListResult;
import com.larksuite.oapi.service.bitable.v1.model.AppTableRecordUpdateResult;
import com.larksuite.oapi.service.bitable.v1.model.AppTableView;
import com.larksuite.oapi.service.bitable.v1.model.AppTableViewCreateResult;
import com.larksuite.oapi.service.bitable.v1.model.AppTableViewListResult;
import com.larksuite.oapi.service.bitable.v1.model.DeleteRecord;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BitableService {
    private final Config config;
    private final Apps apps;
    private final AppTables appTables;
    private final AppTableFields appTableFields;
    private final AppTableRecords appTableRecords;
    private final AppTableViews appTableViews;

    public BitableService(Config config) {
        this.config = config;
        this.apps = new Apps(this);
        this.appTables = new AppTables(this);
        this.appTableFields = new AppTableFields(this);
        this.appTableRecords = new AppTableRecords(this);
        this.appTableViews = new AppTableViews(this);
    }

    public Apps getApps() {
        return this.apps;
    }

    public AppTables getAppTables() {
        return this.appTables;
    }

    public AppTableFields getAppTableFields() {
        return this.appTableFields;
    }

    public AppTableRecords getAppTableRecords() {
        return this.appTableRecords;
    }

    public AppTableViews getAppTableViews() {
        return this.appTableViews;
    }

    public static class AppTableViewListReqCall
    extends ReqCaller<Object, AppTableViewListResult> {
        private final AppTableViews appTableViews;
        private final Map<String, Object> pathParams = new HashMap<String, Object>();
        private final Map<String, Object> queryParams = new HashMap<String, Object>();
        private final List<RequestOptFn> optFns = new ArrayList<RequestOptFn>();
        private AppTableViewListResult result;

        private AppTableViewListReqCall(AppTableViews appTableViews, RequestOptFn ... optFns) {
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new AppTableViewListResult();
            this.appTableViews = appTableViews;
        }

        public AppTableViewListReqCall setAppToken(String appToken) {
            this.pathParams.put("app_token", appToken);
            return this;
        }

        public AppTableViewListReqCall setTableId(String tableId) {
            this.pathParams.put("table_id", tableId);
            return this;
        }

        public AppTableViewListReqCall setPageSize(Integer pageSize) {
            this.queryParams.put("page_size", pageSize);
            return this;
        }

        public AppTableViewListReqCall setPageToken(String pageToken) {
            this.queryParams.put("page_token", pageToken);
            return this;
        }

        @Override
        public Response<AppTableViewListResult> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            this.optFns.add(Request.setQueryParams(this.queryParams));
            Request<Object, AppTableViewListResult> request = Request.newRequest("/open-apis/bitable/v1/apps/:app_token/tables/:table_id/views", "GET", new AccessTokenType[]{AccessTokenType.User, AccessTokenType.Tenant}, null, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.appTableViews.service.config, request);
        }
    }

    public static class AppTableViewDeleteReqCall
    extends ReqCaller<Object, EmptyData> {
        private final AppTableViews appTableViews;
        private final Map<String, Object> pathParams = new HashMap<String, Object>();
        private final List<RequestOptFn> optFns = new ArrayList<RequestOptFn>();
        private EmptyData result;

        private AppTableViewDeleteReqCall(AppTableViews appTableViews, RequestOptFn ... optFns) {
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new EmptyData();
            this.appTableViews = appTableViews;
        }

        public AppTableViewDeleteReqCall setAppToken(String appToken) {
            this.pathParams.put("app_token", appToken);
            return this;
        }

        public AppTableViewDeleteReqCall setTableId(String tableId) {
            this.pathParams.put("table_id", tableId);
            return this;
        }

        public AppTableViewDeleteReqCall setViewId(String viewId) {
            this.pathParams.put("view_id", viewId);
            return this;
        }

        @Override
        public Response<EmptyData> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            Request<Object, EmptyData> request = Request.newRequest("/open-apis/bitable/v1/apps/:app_token/tables/:table_id/views/:view_id", "DELETE", new AccessTokenType[]{AccessTokenType.User, AccessTokenType.Tenant}, null, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.appTableViews.service.config, request);
        }
    }

    public static class AppTableViewCreateReqCall
    extends ReqCaller<AppTableView, AppTableViewCreateResult> {
        private final AppTableViews appTableViews;
        private final AppTableView body;
        private final Map<String, Object> pathParams;
        private final List<RequestOptFn> optFns;
        private AppTableViewCreateResult result;

        private AppTableViewCreateReqCall(AppTableViews appTableViews, AppTableView body, RequestOptFn ... optFns) {
            this.body = body;
            this.pathParams = new HashMap<String, Object>();
            this.optFns = new ArrayList<RequestOptFn>();
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new AppTableViewCreateResult();
            this.appTableViews = appTableViews;
        }

        public AppTableViewCreateReqCall setAppToken(String appToken) {
            this.pathParams.put("app_token", appToken);
            return this;
        }

        public AppTableViewCreateReqCall setTableId(String tableId) {
            this.pathParams.put("table_id", tableId);
            return this;
        }

        @Override
        public Response<AppTableViewCreateResult> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            Request<AppTableView, AppTableViewCreateResult> request = Request.newRequest("/open-apis/bitable/v1/apps/:app_token/tables/:table_id/views", "POST", new AccessTokenType[]{AccessTokenType.User, AccessTokenType.Tenant}, this.body, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.appTableViews.service.config, request);
        }
    }

    public static class AppTableViews {
        private final BitableService service;

        public AppTableViews(BitableService service) {
            this.service = service;
        }

        public AppTableViewCreateReqCall create(AppTableView body, RequestOptFn ... optFns) {
            return new AppTableViewCreateReqCall(this, body, optFns);
        }

        public AppTableViewDeleteReqCall delete(RequestOptFn ... optFns) {
            return new AppTableViewDeleteReqCall(this, optFns);
        }

        public AppTableViewListReqCall list(RequestOptFn ... optFns) {
            return new AppTableViewListReqCall(this, optFns);
        }
    }

    public static class AppTableRecordCreateReqCall
    extends ReqCaller<AppTableRecord, AppTableRecordCreateResult> {
        private final AppTableRecords appTableRecords;
        private final AppTableRecord body;
        private final Map<String, Object> pathParams;
        private final Map<String, Object> queryParams;
        private final List<RequestOptFn> optFns;
        private AppTableRecordCreateResult result;

        private AppTableRecordCreateReqCall(AppTableRecords appTableRecords, AppTableRecord body, RequestOptFn ... optFns) {
            this.body = body;
            this.pathParams = new HashMap<String, Object>();
            this.queryParams = new HashMap<String, Object>();
            this.optFns = new ArrayList<RequestOptFn>();
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new AppTableRecordCreateResult();
            this.appTableRecords = appTableRecords;
        }

        public AppTableRecordCreateReqCall setAppToken(String appToken) {
            this.pathParams.put("app_token", appToken);
            return this;
        }

        public AppTableRecordCreateReqCall setTableId(String tableId) {
            this.pathParams.put("table_id", tableId);
            return this;
        }

        public AppTableRecordCreateReqCall setUserIdType(String userIdType) {
            this.queryParams.put("user_id_type", userIdType);
            return this;
        }

        @Override
        public Response<AppTableRecordCreateResult> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            this.optFns.add(Request.setQueryParams(this.queryParams));
            Request<AppTableRecord, AppTableRecordCreateResult> request = Request.newRequest("/open-apis/bitable/v1/apps/:app_token/tables/:table_id/records", "POST", new AccessTokenType[]{AccessTokenType.User, AccessTokenType.Tenant}, this.body, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.appTableRecords.service.config, request);
        }
    }

    public static class AppTableRecordBatchUpdateReqCall
    extends ReqCaller<AppTableRecordBatchUpdateReqBody, AppTableRecordBatchUpdateResult> {
        private final AppTableRecords appTableRecords;
        private final AppTableRecordBatchUpdateReqBody body;
        private final Map<String, Object> pathParams;
        private final Map<String, Object> queryParams;
        private final List<RequestOptFn> optFns;
        private AppTableRecordBatchUpdateResult result;

        private AppTableRecordBatchUpdateReqCall(AppTableRecords appTableRecords, AppTableRecordBatchUpdateReqBody body, RequestOptFn ... optFns) {
            this.body = body;
            this.pathParams = new HashMap<String, Object>();
            this.queryParams = new HashMap<String, Object>();
            this.optFns = new ArrayList<RequestOptFn>();
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new AppTableRecordBatchUpdateResult();
            this.appTableRecords = appTableRecords;
        }

        public AppTableRecordBatchUpdateReqCall setAppToken(String appToken) {
            this.pathParams.put("app_token", appToken);
            return this;
        }

        public AppTableRecordBatchUpdateReqCall setTableId(String tableId) {
            this.pathParams.put("table_id", tableId);
            return this;
        }

        public AppTableRecordBatchUpdateReqCall setUserIdType(String userIdType) {
            this.queryParams.put("user_id_type", userIdType);
            return this;
        }

        @Override
        public Response<AppTableRecordBatchUpdateResult> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            this.optFns.add(Request.setQueryParams(this.queryParams));
            Request<AppTableRecordBatchUpdateReqBody, AppTableRecordBatchUpdateResult> request = Request.newRequest("/open-apis/bitable/v1/apps/:app_token/tables/:table_id/records/batch_update", "POST", new AccessTokenType[]{AccessTokenType.User, AccessTokenType.Tenant}, this.body, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.appTableRecords.service.config, request);
        }
    }

    public static class AppTableRecordListReqCall
    extends ReqCaller<Object, AppTableRecordListResult> {
        private final AppTableRecords appTableRecords;
        private final Map<String, Object> pathParams = new HashMap<String, Object>();
        private final Map<String, Object> queryParams = new HashMap<String, Object>();
        private final List<RequestOptFn> optFns = new ArrayList<RequestOptFn>();
        private AppTableRecordListResult result;

        private AppTableRecordListReqCall(AppTableRecords appTableRecords, RequestOptFn ... optFns) {
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new AppTableRecordListResult();
            this.appTableRecords = appTableRecords;
        }

        public AppTableRecordListReqCall setAppToken(String appToken) {
            this.pathParams.put("app_token", appToken);
            return this;
        }

        public AppTableRecordListReqCall setTableId(String tableId) {
            this.pathParams.put("table_id", tableId);
            return this;
        }

        public AppTableRecordListReqCall setViewId(String viewId) {
            this.queryParams.put("view_id", viewId);
            return this;
        }

        public AppTableRecordListReqCall setFilter(String filter) {
            this.queryParams.put("filter", filter);
            return this;
        }

        public AppTableRecordListReqCall setSort(String sort) {
            this.queryParams.put("sort", sort);
            return this;
        }

        public AppTableRecordListReqCall setFieldNames(String fieldNames) {
            this.queryParams.put("field_names", fieldNames);
            return this;
        }

        public AppTableRecordListReqCall setTextFieldAsArray(Boolean textFieldAsArray) {
            this.queryParams.put("text_field_as_array", textFieldAsArray);
            return this;
        }

        public AppTableRecordListReqCall setPageToken(String pageToken) {
            this.queryParams.put("page_token", pageToken);
            return this;
        }

        public AppTableRecordListReqCall setPageSize(Integer pageSize) {
            this.queryParams.put("page_size", pageSize);
            return this;
        }

        public AppTableRecordListReqCall setUserIdType(String userIdType) {
            this.queryParams.put("user_id_type", userIdType);
            return this;
        }

        @Override
        public Response<AppTableRecordListResult> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            this.optFns.add(Request.setQueryParams(this.queryParams));
            Request<Object, AppTableRecordListResult> request = Request.newRequest("/open-apis/bitable/v1/apps/:app_token/tables/:table_id/records", "GET", new AccessTokenType[]{AccessTokenType.User, AccessTokenType.Tenant}, null, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.appTableRecords.service.config, request);
        }
    }

    public static class AppTableRecordDeleteReqCall
    extends ReqCaller<Object, DeleteRecord> {
        private final AppTableRecords appTableRecords;
        private final Map<String, Object> pathParams = new HashMap<String, Object>();
        private final List<RequestOptFn> optFns = new ArrayList<RequestOptFn>();
        private DeleteRecord result;

        private AppTableRecordDeleteReqCall(AppTableRecords appTableRecords, RequestOptFn ... optFns) {
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new DeleteRecord();
            this.appTableRecords = appTableRecords;
        }

        public AppTableRecordDeleteReqCall setAppToken(String appToken) {
            this.pathParams.put("app_token", appToken);
            return this;
        }

        public AppTableRecordDeleteReqCall setTableId(String tableId) {
            this.pathParams.put("table_id", tableId);
            return this;
        }

        public AppTableRecordDeleteReqCall setRecordId(String recordId) {
            this.pathParams.put("record_id", recordId);
            return this;
        }

        @Override
        public Response<DeleteRecord> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            Request<Object, DeleteRecord> request = Request.newRequest("/open-apis/bitable/v1/apps/:app_token/tables/:table_id/records/:record_id", "DELETE", new AccessTokenType[]{AccessTokenType.User, AccessTokenType.Tenant}, null, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.appTableRecords.service.config, request);
        }
    }

    public static class AppTableRecordUpdateReqCall
    extends ReqCaller<AppTableRecord, AppTableRecordUpdateResult> {
        private final AppTableRecords appTableRecords;
        private final AppTableRecord body;
        private final Map<String, Object> pathParams;
        private final Map<String, Object> queryParams;
        private final List<RequestOptFn> optFns;
        private AppTableRecordUpdateResult result;

        private AppTableRecordUpdateReqCall(AppTableRecords appTableRecords, AppTableRecord body, RequestOptFn ... optFns) {
            this.body = body;
            this.pathParams = new HashMap<String, Object>();
            this.queryParams = new HashMap<String, Object>();
            this.optFns = new ArrayList<RequestOptFn>();
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new AppTableRecordUpdateResult();
            this.appTableRecords = appTableRecords;
        }

        public AppTableRecordUpdateReqCall setAppToken(String appToken) {
            this.pathParams.put("app_token", appToken);
            return this;
        }

        public AppTableRecordUpdateReqCall setTableId(String tableId) {
            this.pathParams.put("table_id", tableId);
            return this;
        }

        public AppTableRecordUpdateReqCall setRecordId(String recordId) {
            this.pathParams.put("record_id", recordId);
            return this;
        }

        public AppTableRecordUpdateReqCall setUserIdType(String userIdType) {
            this.queryParams.put("user_id_type", userIdType);
            return this;
        }

        @Override
        public Response<AppTableRecordUpdateResult> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            this.optFns.add(Request.setQueryParams(this.queryParams));
            Request<AppTableRecord, AppTableRecordUpdateResult> request = Request.newRequest("/open-apis/bitable/v1/apps/:app_token/tables/:table_id/records/:record_id", "PUT", new AccessTokenType[]{AccessTokenType.User, AccessTokenType.Tenant}, this.body, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.appTableRecords.service.config, request);
        }
    }

    public static class AppTableRecordGetReqCall
    extends ReqCaller<Object, AppTableRecordGetResult> {
        private final AppTableRecords appTableRecords;
        private final Map<String, Object> pathParams = new HashMap<String, Object>();
        private final Map<String, Object> queryParams = new HashMap<String, Object>();
        private final List<RequestOptFn> optFns = new ArrayList<RequestOptFn>();
        private AppTableRecordGetResult result;

        private AppTableRecordGetReqCall(AppTableRecords appTableRecords, RequestOptFn ... optFns) {
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new AppTableRecordGetResult();
            this.appTableRecords = appTableRecords;
        }

        public AppTableRecordGetReqCall setAppToken(String appToken) {
            this.pathParams.put("app_token", appToken);
            return this;
        }

        public AppTableRecordGetReqCall setTableId(String tableId) {
            this.pathParams.put("table_id", tableId);
            return this;
        }

        public AppTableRecordGetReqCall setRecordId(String recordId) {
            this.pathParams.put("record_id", recordId);
            return this;
        }

        public AppTableRecordGetReqCall setTextFieldAsArray(Boolean textFieldAsArray) {
            this.queryParams.put("text_field_as_array", textFieldAsArray);
            return this;
        }

        public AppTableRecordGetReqCall setUserIdType(String userIdType) {
            this.queryParams.put("user_id_type", userIdType);
            return this;
        }

        @Override
        public Response<AppTableRecordGetResult> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            this.optFns.add(Request.setQueryParams(this.queryParams));
            Request<Object, AppTableRecordGetResult> request = Request.newRequest("/open-apis/bitable/v1/apps/:app_token/tables/:table_id/records/:record_id", "GET", new AccessTokenType[]{AccessTokenType.User, AccessTokenType.Tenant}, null, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.appTableRecords.service.config, request);
        }
    }

    public static class AppTableRecordBatchCreateReqCall
    extends ReqCaller<AppTableRecordBatchCreateReqBody, AppTableRecordBatchCreateResult> {
        private final AppTableRecords appTableRecords;
        private final AppTableRecordBatchCreateReqBody body;
        private final Map<String, Object> pathParams;
        private final Map<String, Object> queryParams;
        private final List<RequestOptFn> optFns;
        private AppTableRecordBatchCreateResult result;

        private AppTableRecordBatchCreateReqCall(AppTableRecords appTableRecords, AppTableRecordBatchCreateReqBody body, RequestOptFn ... optFns) {
            this.body = body;
            this.pathParams = new HashMap<String, Object>();
            this.queryParams = new HashMap<String, Object>();
            this.optFns = new ArrayList<RequestOptFn>();
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new AppTableRecordBatchCreateResult();
            this.appTableRecords = appTableRecords;
        }

        public AppTableRecordBatchCreateReqCall setAppToken(String appToken) {
            this.pathParams.put("app_token", appToken);
            return this;
        }

        public AppTableRecordBatchCreateReqCall setTableId(String tableId) {
            this.pathParams.put("table_id", tableId);
            return this;
        }

        public AppTableRecordBatchCreateReqCall setUserIdType(String userIdType) {
            this.queryParams.put("user_id_type", userIdType);
            return this;
        }

        @Override
        public Response<AppTableRecordBatchCreateResult> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            this.optFns.add(Request.setQueryParams(this.queryParams));
            Request<AppTableRecordBatchCreateReqBody, AppTableRecordBatchCreateResult> request = Request.newRequest("/open-apis/bitable/v1/apps/:app_token/tables/:table_id/records/batch_create", "POST", new AccessTokenType[]{AccessTokenType.User, AccessTokenType.Tenant}, this.body, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.appTableRecords.service.config, request);
        }
    }

    public static class AppTableRecordBatchDeleteReqCall
    extends ReqCaller<AppTableRecordBatchDeleteReqBody, AppTableRecordBatchDeleteResult> {
        private final AppTableRecords appTableRecords;
        private final AppTableRecordBatchDeleteReqBody body;
        private final Map<String, Object> pathParams;
        private final List<RequestOptFn> optFns;
        private AppTableRecordBatchDeleteResult result;

        private AppTableRecordBatchDeleteReqCall(AppTableRecords appTableRecords, AppTableRecordBatchDeleteReqBody body, RequestOptFn ... optFns) {
            this.body = body;
            this.pathParams = new HashMap<String, Object>();
            this.optFns = new ArrayList<RequestOptFn>();
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new AppTableRecordBatchDeleteResult();
            this.appTableRecords = appTableRecords;
        }

        public AppTableRecordBatchDeleteReqCall setAppToken(String appToken) {
            this.pathParams.put("app_token", appToken);
            return this;
        }

        public AppTableRecordBatchDeleteReqCall setTableId(String tableId) {
            this.pathParams.put("table_id", tableId);
            return this;
        }

        @Override
        public Response<AppTableRecordBatchDeleteResult> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            Request<AppTableRecordBatchDeleteReqBody, AppTableRecordBatchDeleteResult> request = Request.newRequest("/open-apis/bitable/v1/apps/:app_token/tables/:table_id/records/batch_delete", "POST", new AccessTokenType[]{AccessTokenType.User, AccessTokenType.Tenant}, this.body, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.appTableRecords.service.config, request);
        }
    }

    public static class AppTableRecords {
        private final BitableService service;

        public AppTableRecords(BitableService service) {
            this.service = service;
        }

        public AppTableRecordBatchDeleteReqCall batchDelete(AppTableRecordBatchDeleteReqBody body, RequestOptFn ... optFns) {
            return new AppTableRecordBatchDeleteReqCall(this, body, optFns);
        }

        public AppTableRecordBatchCreateReqCall batchCreate(AppTableRecordBatchCreateReqBody body, RequestOptFn ... optFns) {
            return new AppTableRecordBatchCreateReqCall(this, body, optFns);
        }

        public AppTableRecordGetReqCall get(RequestOptFn ... optFns) {
            return new AppTableRecordGetReqCall(this, optFns);
        }

        public AppTableRecordUpdateReqCall update(AppTableRecord body, RequestOptFn ... optFns) {
            return new AppTableRecordUpdateReqCall(this, body, optFns);
        }

        public AppTableRecordDeleteReqCall delete(RequestOptFn ... optFns) {
            return new AppTableRecordDeleteReqCall(this, optFns);
        }

        public AppTableRecordListReqCall list(RequestOptFn ... optFns) {
            return new AppTableRecordListReqCall(this, optFns);
        }

        public AppTableRecordBatchUpdateReqCall batchUpdate(AppTableRecordBatchUpdateReqBody body, RequestOptFn ... optFns) {
            return new AppTableRecordBatchUpdateReqCall(this, body, optFns);
        }

        public AppTableRecordCreateReqCall create(AppTableRecord body, RequestOptFn ... optFns) {
            return new AppTableRecordCreateReqCall(this, body, optFns);
        }
    }

    public static class AppTableFieldUpdateReqCall
    extends ReqCaller<AppTableField, AppTableFieldUpdateResult> {
        private final AppTableFields appTableFields;
        private final AppTableField body;
        private final Map<String, Object> pathParams;
        private final List<RequestOptFn> optFns;
        private AppTableFieldUpdateResult result;

        private AppTableFieldUpdateReqCall(AppTableFields appTableFields, AppTableField body, RequestOptFn ... optFns) {
            this.body = body;
            this.pathParams = new HashMap<String, Object>();
            this.optFns = new ArrayList<RequestOptFn>();
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new AppTableFieldUpdateResult();
            this.appTableFields = appTableFields;
        }

        public AppTableFieldUpdateReqCall setAppToken(String appToken) {
            this.pathParams.put("app_token", appToken);
            return this;
        }

        public AppTableFieldUpdateReqCall setTableId(String tableId) {
            this.pathParams.put("table_id", tableId);
            return this;
        }

        public AppTableFieldUpdateReqCall setFieldId(String fieldId) {
            this.pathParams.put("field_id", fieldId);
            return this;
        }

        @Override
        public Response<AppTableFieldUpdateResult> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            Request<AppTableField, AppTableFieldUpdateResult> request = Request.newRequest("/open-apis/bitable/v1/apps/:app_token/tables/:table_id/fields/:field_id", "PUT", new AccessTokenType[]{AccessTokenType.User, AccessTokenType.Tenant}, this.body, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.appTableFields.service.config, request);
        }
    }

    public static class AppTableFieldDeleteReqCall
    extends ReqCaller<Object, AppTableFieldDeleteResult> {
        private final AppTableFields appTableFields;
        private final Map<String, Object> pathParams = new HashMap<String, Object>();
        private final List<RequestOptFn> optFns = new ArrayList<RequestOptFn>();
        private AppTableFieldDeleteResult result;

        private AppTableFieldDeleteReqCall(AppTableFields appTableFields, RequestOptFn ... optFns) {
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new AppTableFieldDeleteResult();
            this.appTableFields = appTableFields;
        }

        public AppTableFieldDeleteReqCall setAppToken(String appToken) {
            this.pathParams.put("app_token", appToken);
            return this;
        }

        public AppTableFieldDeleteReqCall setTableId(String tableId) {
            this.pathParams.put("table_id", tableId);
            return this;
        }

        public AppTableFieldDeleteReqCall setFieldId(String fieldId) {
            this.pathParams.put("field_id", fieldId);
            return this;
        }

        @Override
        public Response<AppTableFieldDeleteResult> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            Request<Object, AppTableFieldDeleteResult> request = Request.newRequest("/open-apis/bitable/v1/apps/:app_token/tables/:table_id/fields/:field_id", "DELETE", new AccessTokenType[]{AccessTokenType.User, AccessTokenType.Tenant}, null, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.appTableFields.service.config, request);
        }
    }

    public static class AppTableFieldCreateReqCall
    extends ReqCaller<AppTableField, AppTableFieldCreateResult> {
        private final AppTableFields appTableFields;
        private final AppTableField body;
        private final Map<String, Object> pathParams;
        private final Map<String, Object> queryParams;
        private final List<RequestOptFn> optFns;
        private AppTableFieldCreateResult result;

        private AppTableFieldCreateReqCall(AppTableFields appTableFields, AppTableField body, RequestOptFn ... optFns) {
            this.body = body;
            this.pathParams = new HashMap<String, Object>();
            this.queryParams = new HashMap<String, Object>();
            this.optFns = new ArrayList<RequestOptFn>();
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new AppTableFieldCreateResult();
            this.appTableFields = appTableFields;
        }

        public AppTableFieldCreateReqCall setAppToken(String appToken) {
            this.pathParams.put("app_token", appToken);
            return this;
        }

        public AppTableFieldCreateReqCall setTableId(String tableId) {
            this.pathParams.put("table_id", tableId);
            return this;
        }

        public AppTableFieldCreateReqCall setUserIdType(String userIdType) {
            this.queryParams.put("user_id_type", userIdType);
            return this;
        }

        @Override
        public Response<AppTableFieldCreateResult> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            this.optFns.add(Request.setQueryParams(this.queryParams));
            Request<AppTableField, AppTableFieldCreateResult> request = Request.newRequest("/open-apis/bitable/v1/apps/:app_token/tables/:table_id/fields", "POST", new AccessTokenType[]{AccessTokenType.User, AccessTokenType.Tenant}, this.body, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.appTableFields.service.config, request);
        }
    }

    public static class AppTableFieldListReqCall
    extends ReqCaller<Object, AppTableFieldListResult> {
        private final AppTableFields appTableFields;
        private final Map<String, Object> pathParams = new HashMap<String, Object>();
        private final Map<String, Object> queryParams = new HashMap<String, Object>();
        private final List<RequestOptFn> optFns = new ArrayList<RequestOptFn>();
        private AppTableFieldListResult result;

        private AppTableFieldListReqCall(AppTableFields appTableFields, RequestOptFn ... optFns) {
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new AppTableFieldListResult();
            this.appTableFields = appTableFields;
        }

        public AppTableFieldListReqCall setAppToken(String appToken) {
            this.pathParams.put("app_token", appToken);
            return this;
        }

        public AppTableFieldListReqCall setTableId(String tableId) {
            this.pathParams.put("table_id", tableId);
            return this;
        }

        public AppTableFieldListReqCall setViewId(String viewId) {
            this.queryParams.put("view_id", viewId);
            return this;
        }

        public AppTableFieldListReqCall setPageToken(String pageToken) {
            this.queryParams.put("page_token", pageToken);
            return this;
        }

        public AppTableFieldListReqCall setPageSize(Integer pageSize) {
            this.queryParams.put("page_size", pageSize);
            return this;
        }

        @Override
        public Response<AppTableFieldListResult> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            this.optFns.add(Request.setQueryParams(this.queryParams));
            Request<Object, AppTableFieldListResult> request = Request.newRequest("/open-apis/bitable/v1/apps/:app_token/tables/:table_id/fields", "GET", new AccessTokenType[]{AccessTokenType.User, AccessTokenType.Tenant}, null, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.appTableFields.service.config, request);
        }
    }

    public static class AppTableFields {
        private final BitableService service;

        public AppTableFields(BitableService service) {
            this.service = service;
        }

        public AppTableFieldListReqCall list(RequestOptFn ... optFns) {
            return new AppTableFieldListReqCall(this, optFns);
        }

        public AppTableFieldCreateReqCall create(AppTableField body, RequestOptFn ... optFns) {
            return new AppTableFieldCreateReqCall(this, body, optFns);
        }

        public AppTableFieldDeleteReqCall delete(RequestOptFn ... optFns) {
            return new AppTableFieldDeleteReqCall(this, optFns);
        }

        public AppTableFieldUpdateReqCall update(AppTableField body, RequestOptFn ... optFns) {
            return new AppTableFieldUpdateReqCall(this, body, optFns);
        }
    }

    public static class AppTableBatchDeleteReqCall
    extends ReqCaller<AppTableBatchDeleteReqBody, EmptyData> {
        private final AppTables appTables;
        private final AppTableBatchDeleteReqBody body;
        private final Map<String, Object> pathParams;
        private final List<RequestOptFn> optFns;
        private EmptyData result;

        private AppTableBatchDeleteReqCall(AppTables appTables, AppTableBatchDeleteReqBody body, RequestOptFn ... optFns) {
            this.body = body;
            this.pathParams = new HashMap<String, Object>();
            this.optFns = new ArrayList<RequestOptFn>();
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new EmptyData();
            this.appTables = appTables;
        }

        public AppTableBatchDeleteReqCall setAppToken(String appToken) {
            this.pathParams.put("app_token", appToken);
            return this;
        }

        @Override
        public Response<EmptyData> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            Request<AppTableBatchDeleteReqBody, EmptyData> request = Request.newRequest("/open-apis/bitable/v1/apps/:app_token/tables/batch_delete", "POST", new AccessTokenType[]{AccessTokenType.User, AccessTokenType.Tenant}, this.body, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.appTables.service.config, request);
        }
    }

    public static class AppTableDeleteReqCall
    extends ReqCaller<Object, EmptyData> {
        private final AppTables appTables;
        private final Map<String, Object> pathParams = new HashMap<String, Object>();
        private final List<RequestOptFn> optFns = new ArrayList<RequestOptFn>();
        private EmptyData result;

        private AppTableDeleteReqCall(AppTables appTables, RequestOptFn ... optFns) {
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new EmptyData();
            this.appTables = appTables;
        }

        public AppTableDeleteReqCall setAppToken(String appToken) {
            this.pathParams.put("app_token", appToken);
            return this;
        }

        public AppTableDeleteReqCall setTableId(String tableId) {
            this.pathParams.put("table_id", tableId);
            return this;
        }

        @Override
        public Response<EmptyData> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            Request<Object, EmptyData> request = Request.newRequest("/open-apis/bitable/v1/apps/:app_token/tables/:table_id", "DELETE", new AccessTokenType[]{AccessTokenType.User, AccessTokenType.Tenant}, null, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.appTables.service.config, request);
        }
    }

    public static class AppTableCreateReqCall
    extends ReqCaller<AppTableCreateReqBody, AppTableCreateResult> {
        private final AppTables appTables;
        private final AppTableCreateReqBody body;
        private final Map<String, Object> pathParams;
        private final Map<String, Object> queryParams;
        private final List<RequestOptFn> optFns;
        private AppTableCreateResult result;

        private AppTableCreateReqCall(AppTables appTables, AppTableCreateReqBody body, RequestOptFn ... optFns) {
            this.body = body;
            this.pathParams = new HashMap<String, Object>();
            this.queryParams = new HashMap<String, Object>();
            this.optFns = new ArrayList<RequestOptFn>();
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new AppTableCreateResult();
            this.appTables = appTables;
        }

        public AppTableCreateReqCall setAppToken(String appToken) {
            this.pathParams.put("app_token", appToken);
            return this;
        }

        public AppTableCreateReqCall setUserIdType(String userIdType) {
            this.queryParams.put("user_id_type", userIdType);
            return this;
        }

        @Override
        public Response<AppTableCreateResult> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            this.optFns.add(Request.setQueryParams(this.queryParams));
            Request<AppTableCreateReqBody, AppTableCreateResult> request = Request.newRequest("/open-apis/bitable/v1/apps/:app_token/tables", "POST", new AccessTokenType[]{AccessTokenType.User, AccessTokenType.Tenant}, this.body, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.appTables.service.config, request);
        }
    }

    public static class AppTableBatchCreateReqCall
    extends ReqCaller<AppTableBatchCreateReqBody, AppTableBatchCreateResult> {
        private final AppTables appTables;
        private final AppTableBatchCreateReqBody body;
        private final Map<String, Object> pathParams;
        private final Map<String, Object> queryParams;
        private final List<RequestOptFn> optFns;
        private AppTableBatchCreateResult result;

        private AppTableBatchCreateReqCall(AppTables appTables, AppTableBatchCreateReqBody body, RequestOptFn ... optFns) {
            this.body = body;
            this.pathParams = new HashMap<String, Object>();
            this.queryParams = new HashMap<String, Object>();
            this.optFns = new ArrayList<RequestOptFn>();
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new AppTableBatchCreateResult();
            this.appTables = appTables;
        }

        public AppTableBatchCreateReqCall setAppToken(String appToken) {
            this.pathParams.put("app_token", appToken);
            return this;
        }

        public AppTableBatchCreateReqCall setUserIdType(String userIdType) {
            this.queryParams.put("user_id_type", userIdType);
            return this;
        }

        @Override
        public Response<AppTableBatchCreateResult> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            this.optFns.add(Request.setQueryParams(this.queryParams));
            Request<AppTableBatchCreateReqBody, AppTableBatchCreateResult> request = Request.newRequest("/open-apis/bitable/v1/apps/:app_token/tables/batch_create", "POST", new AccessTokenType[]{AccessTokenType.User, AccessTokenType.Tenant}, this.body, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.appTables.service.config, request);
        }
    }

    public static class AppTableListReqCall
    extends ReqCaller<Object, AppTableListResult> {
        private final AppTables appTables;
        private final Map<String, Object> pathParams = new HashMap<String, Object>();
        private final Map<String, Object> queryParams = new HashMap<String, Object>();
        private final List<RequestOptFn> optFns = new ArrayList<RequestOptFn>();
        private AppTableListResult result;

        private AppTableListReqCall(AppTables appTables, RequestOptFn ... optFns) {
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new AppTableListResult();
            this.appTables = appTables;
        }

        public AppTableListReqCall setAppToken(String appToken) {
            this.pathParams.put("app_token", appToken);
            return this;
        }

        public AppTableListReqCall setPageToken(String pageToken) {
            this.queryParams.put("page_token", pageToken);
            return this;
        }

        public AppTableListReqCall setPageSize(Integer pageSize) {
            this.queryParams.put("page_size", pageSize);
            return this;
        }

        @Override
        public Response<AppTableListResult> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            this.optFns.add(Request.setQueryParams(this.queryParams));
            Request<Object, AppTableListResult> request = Request.newRequest("/open-apis/bitable/v1/apps/:app_token/tables", "GET", new AccessTokenType[]{AccessTokenType.User, AccessTokenType.Tenant}, null, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.appTables.service.config, request);
        }
    }

    public static class AppTables {
        private final BitableService service;

        public AppTables(BitableService service) {
            this.service = service;
        }

        public AppTableListReqCall list(RequestOptFn ... optFns) {
            return new AppTableListReqCall(this, optFns);
        }

        public AppTableBatchCreateReqCall batchCreate(AppTableBatchCreateReqBody body, RequestOptFn ... optFns) {
            return new AppTableBatchCreateReqCall(this, body, optFns);
        }

        public AppTableCreateReqCall create(AppTableCreateReqBody body, RequestOptFn ... optFns) {
            return new AppTableCreateReqCall(this, body, optFns);
        }

        public AppTableDeleteReqCall delete(RequestOptFn ... optFns) {
            return new AppTableDeleteReqCall(this, optFns);
        }

        public AppTableBatchDeleteReqCall batchDelete(AppTableBatchDeleteReqBody body, RequestOptFn ... optFns) {
            return new AppTableBatchDeleteReqCall(this, body, optFns);
        }
    }

    public static class AppGetReqCall
    extends ReqCaller<Object, AppGetResult> {
        private final Apps apps;
        private final Map<String, Object> pathParams = new HashMap<String, Object>();
        private final List<RequestOptFn> optFns = new ArrayList<RequestOptFn>();
        private AppGetResult result;

        private AppGetReqCall(Apps apps, RequestOptFn ... optFns) {
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new AppGetResult();
            this.apps = apps;
        }

        public AppGetReqCall setAppToken(String appToken) {
            this.pathParams.put("app_token", appToken);
            return this;
        }

        @Override
        public Response<AppGetResult> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            Request<Object, AppGetResult> request = Request.newRequest("/open-apis/bitable/v1/apps/:app_token", "GET", new AccessTokenType[]{AccessTokenType.User, AccessTokenType.Tenant}, null, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.apps.service.config, request);
        }
    }

    public static class Apps {
        private final BitableService service;

        public Apps(BitableService service) {
            this.service = service;
        }

        public AppGetReqCall get(RequestOptFn ... optFns) {
            return new AppGetReqCall(this, optFns);
        }
    }
}

