/*
 * Decompiled with CFR 0.152.
 */
package com.larksuite.oapi.service.drive.v1;

import com.larksuite.oapi.core.Config;
import com.larksuite.oapi.core.api.AccessTokenType;
import com.larksuite.oapi.core.api.Api;
import com.larksuite.oapi.core.api.ReqCaller;
import com.larksuite.oapi.core.api.request.FormData;
import com.larksuite.oapi.core.api.request.FormDataFile;
import com.larksuite.oapi.core.api.request.Request;
import com.larksuite.oapi.core.api.request.RequestOptFn;
import com.larksuite.oapi.core.api.response.EmptyData;
import com.larksuite.oapi.core.api.response.Response;
import com.larksuite.oapi.core.event.Event;
import com.larksuite.oapi.core.event.IHandler;
import com.larksuite.oapi.service.drive.v1.model.FileComment;
import com.larksuite.oapi.service.drive.v1.model.FileCommentListResult;
import com.larksuite.oapi.service.drive.v1.model.FileCommentPatchReqBody;
import com.larksuite.oapi.service.drive.v1.model.FileCommentReplyUpdateReqBody;
import com.larksuite.oapi.service.drive.v1.model.FileDeletedEvent;
import com.larksuite.oapi.service.drive.v1.model.FileEditEvent;
import com.larksuite.oapi.service.drive.v1.model.FilePermissionMemberAddedEvent;
import com.larksuite.oapi.service.drive.v1.model.FilePermissionMemberRemovedEvent;
import com.larksuite.oapi.service.drive.v1.model.FileReadEvent;
import com.larksuite.oapi.service.drive.v1.model.FileStatisticsGetResult;
import com.larksuite.oapi.service.drive.v1.model.FileTitleUpdatedEvent;
import com.larksuite.oapi.service.drive.v1.model.FileTrashedEvent;
import com.larksuite.oapi.service.drive.v1.model.FileUploadAllResult;
import com.larksuite.oapi.service.drive.v1.model.FileUploadFinishReqBody;
import com.larksuite.oapi.service.drive.v1.model.FileUploadFinishResult;
import com.larksuite.oapi.service.drive.v1.model.FileUploadInfo;
import com.larksuite.oapi.service.drive.v1.model.FileUploadPrepareResult;
import com.larksuite.oapi.service.drive.v1.model.ImportTask;
import com.larksuite.oapi.service.drive.v1.model.ImportTaskCreateResult;
import com.larksuite.oapi.service.drive.v1.model.ImportTaskGetResult;
import com.larksuite.oapi.service.drive.v1.model.MediaBatchGetTmpDownloadUrlResult;
import com.larksuite.oapi.service.drive.v1.model.MediaUploadAllResult;
import com.larksuite.oapi.service.drive.v1.model.MediaUploadFinishReqBody;
import com.larksuite.oapi.service.drive.v1.model.MediaUploadFinishResult;
import com.larksuite.oapi.service.drive.v1.model.MediaUploadInfo;
import com.larksuite.oapi.service.drive.v1.model.MediaUploadPrepareResult;
import com.larksuite.oapi.service.drive.v1.model.Member;
import com.larksuite.oapi.service.drive.v1.model.PermissionMemberCreateResult;
import com.larksuite.oapi.service.drive.v1.model.PermissionMemberUpdateResult;
import com.larksuite.oapi.service.drive.v1.model.PermissionPublic;
import com.larksuite.oapi.service.drive.v1.model.PermissionPublicPatchResult;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DriveService {
    private final Config config;
    private final Files files;
    private final FileComments fileComments;
    private final FileCommentReplys fileCommentReplys;
    private final ImportTasks importTasks;
    private final Medias medias;
    private final PermissionMembers permissionMembers;
    private final PermissionPublics permissionPublics;
    private final FileStatisticss fileStatisticss;

    public DriveService(Config config) {
        this.config = config;
        this.files = new Files(this);
        this.fileComments = new FileComments(this);
        this.fileCommentReplys = new FileCommentReplys(this);
        this.importTasks = new ImportTasks(this);
        this.medias = new Medias(this);
        this.permissionMembers = new PermissionMembers(this);
        this.permissionPublics = new PermissionPublics(this);
        this.fileStatisticss = new FileStatisticss(this);
    }

    public Files getFiles() {
        return this.files;
    }

    public FileComments getFileComments() {
        return this.fileComments;
    }

    public FileCommentReplys getFileCommentReplys() {
        return this.fileCommentReplys;
    }

    public ImportTasks getImportTasks() {
        return this.importTasks;
    }

    public Medias getMedias() {
        return this.medias;
    }

    public PermissionMembers getPermissionMembers() {
        return this.permissionMembers;
    }

    public PermissionPublics getPermissionPublics() {
        return this.permissionPublics;
    }

    public FileStatisticss getFileStatisticss() {
        return this.fileStatisticss;
    }

    public void setFileDeletedEventHandler(FileDeletedEventHandler handler) {
        Event.setTypeHandler(this.config, "drive.file.deleted_v1", handler);
    }

    public void setFilePermissionMemberAddedEventHandler(FilePermissionMemberAddedEventHandler handler) {
        Event.setTypeHandler(this.config, "drive.file.permission_member_added_v1", handler);
    }

    public void setFilePermissionMemberRemovedEventHandler(FilePermissionMemberRemovedEventHandler handler) {
        Event.setTypeHandler(this.config, "drive.file.permission_member_removed_v1", handler);
    }

    public void setFileReadEventHandler(FileReadEventHandler handler) {
        Event.setTypeHandler(this.config, "drive.file.read_v1", handler);
    }

    public void setFileTitleUpdatedEventHandler(FileTitleUpdatedEventHandler handler) {
        Event.setTypeHandler(this.config, "drive.file.title_updated_v1", handler);
    }

    public void setFileTrashedEventHandler(FileTrashedEventHandler handler) {
        Event.setTypeHandler(this.config, "drive.file.trashed_v1", handler);
    }

    public void setFileEditEventHandler(FileEditEventHandler handler) {
        Event.setTypeHandler(this.config, "drive.file.edit_v1", handler);
    }

    public static abstract class FileEditEventHandler
    implements IHandler<FileEditEvent> {
        @Override
        public FileEditEvent getEvent() {
            return new FileEditEvent();
        }
    }

    public static abstract class FileTrashedEventHandler
    implements IHandler<FileTrashedEvent> {
        @Override
        public FileTrashedEvent getEvent() {
            return new FileTrashedEvent();
        }
    }

    public static abstract class FileTitleUpdatedEventHandler
    implements IHandler<FileTitleUpdatedEvent> {
        @Override
        public FileTitleUpdatedEvent getEvent() {
            return new FileTitleUpdatedEvent();
        }
    }

    public static abstract class FileReadEventHandler
    implements IHandler<FileReadEvent> {
        @Override
        public FileReadEvent getEvent() {
            return new FileReadEvent();
        }
    }

    public static abstract class FilePermissionMemberRemovedEventHandler
    implements IHandler<FilePermissionMemberRemovedEvent> {
        @Override
        public FilePermissionMemberRemovedEvent getEvent() {
            return new FilePermissionMemberRemovedEvent();
        }
    }

    public static abstract class FilePermissionMemberAddedEventHandler
    implements IHandler<FilePermissionMemberAddedEvent> {
        @Override
        public FilePermissionMemberAddedEvent getEvent() {
            return new FilePermissionMemberAddedEvent();
        }
    }

    public static abstract class FileDeletedEventHandler
    implements IHandler<FileDeletedEvent> {
        @Override
        public FileDeletedEvent getEvent() {
            return new FileDeletedEvent();
        }
    }

    public static class FileStatisticsGetReqCall
    extends ReqCaller<Object, FileStatisticsGetResult> {
        private final FileStatisticss fileStatisticss;
        private final Map<String, Object> pathParams = new HashMap<String, Object>();
        private final Map<String, Object> queryParams = new HashMap<String, Object>();
        private final List<RequestOptFn> optFns = new ArrayList<RequestOptFn>();
        private FileStatisticsGetResult result;

        private FileStatisticsGetReqCall(FileStatisticss fileStatisticss, RequestOptFn ... optFns) {
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new FileStatisticsGetResult();
            this.fileStatisticss = fileStatisticss;
        }

        public FileStatisticsGetReqCall setFileToken(String fileToken) {
            this.pathParams.put("file_token", fileToken);
            return this;
        }

        public FileStatisticsGetReqCall setFileType(String fileType) {
            this.queryParams.put("file_type", fileType);
            return this;
        }

        @Override
        public Response<FileStatisticsGetResult> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            this.optFns.add(Request.setQueryParams(this.queryParams));
            Request<Object, FileStatisticsGetResult> request = Request.newRequest("/open-apis/drive/v1/files/:file_token/statistics", "GET", new AccessTokenType[]{AccessTokenType.Tenant, AccessTokenType.User}, null, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.fileStatisticss.service.config, request);
        }
    }

    public static class FileStatisticss {
        private final DriveService service;

        public FileStatisticss(DriveService service) {
            this.service = service;
        }

        public FileStatisticsGetReqCall get(RequestOptFn ... optFns) {
            return new FileStatisticsGetReqCall(this, optFns);
        }
    }

    public static class PermissionPublicPatchReqCall
    extends ReqCaller<PermissionPublic, PermissionPublicPatchResult> {
        private final PermissionPublics permissionPublics;
        private final PermissionPublic body;
        private final Map<String, Object> pathParams;
        private final Map<String, Object> queryParams;
        private final List<RequestOptFn> optFns;
        private PermissionPublicPatchResult result;

        private PermissionPublicPatchReqCall(PermissionPublics permissionPublics, PermissionPublic body, RequestOptFn ... optFns) {
            this.body = body;
            this.pathParams = new HashMap<String, Object>();
            this.queryParams = new HashMap<String, Object>();
            this.optFns = new ArrayList<RequestOptFn>();
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new PermissionPublicPatchResult();
            this.permissionPublics = permissionPublics;
        }

        public PermissionPublicPatchReqCall setToken(String token) {
            this.pathParams.put("token", token);
            return this;
        }

        public PermissionPublicPatchReqCall setType(String type) {
            this.queryParams.put("type", type);
            return this;
        }

        @Override
        public Response<PermissionPublicPatchResult> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            this.optFns.add(Request.setQueryParams(this.queryParams));
            Request<PermissionPublic, PermissionPublicPatchResult> request = Request.newRequest("/open-apis/drive/v1/permissions/:token/public", "PATCH", new AccessTokenType[]{AccessTokenType.Tenant, AccessTokenType.User}, this.body, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.permissionPublics.service.config, request);
        }
    }

    public static class PermissionPublics {
        private final DriveService service;

        public PermissionPublics(DriveService service) {
            this.service = service;
        }

        public PermissionPublicPatchReqCall patch(PermissionPublic body, RequestOptFn ... optFns) {
            return new PermissionPublicPatchReqCall(this, body, optFns);
        }
    }

    public static class PermissionMemberUpdateReqCall
    extends ReqCaller<Member, PermissionMemberUpdateResult> {
        private final PermissionMembers permissionMembers;
        private final Member body;
        private final Map<String, Object> pathParams;
        private final Map<String, Object> queryParams;
        private final List<RequestOptFn> optFns;
        private PermissionMemberUpdateResult result;

        private PermissionMemberUpdateReqCall(PermissionMembers permissionMembers, Member body, RequestOptFn ... optFns) {
            this.body = body;
            this.pathParams = new HashMap<String, Object>();
            this.queryParams = new HashMap<String, Object>();
            this.optFns = new ArrayList<RequestOptFn>();
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new PermissionMemberUpdateResult();
            this.permissionMembers = permissionMembers;
        }

        public PermissionMemberUpdateReqCall setToken(String token) {
            this.pathParams.put("token", token);
            return this;
        }

        public PermissionMemberUpdateReqCall setMemberId(String memberId) {
            this.pathParams.put("member_id", memberId);
            return this;
        }

        public PermissionMemberUpdateReqCall setNeedNotification(Boolean needNotification) {
            this.queryParams.put("need_notification", needNotification);
            return this;
        }

        public PermissionMemberUpdateReqCall setType(String type) {
            this.queryParams.put("type", type);
            return this;
        }

        @Override
        public Response<PermissionMemberUpdateResult> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            this.optFns.add(Request.setQueryParams(this.queryParams));
            Request<Member, PermissionMemberUpdateResult> request = Request.newRequest("/open-apis/drive/v1/permissions/:token/members/:member_id", "PUT", new AccessTokenType[]{AccessTokenType.Tenant, AccessTokenType.User}, this.body, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.permissionMembers.service.config, request);
        }
    }

    public static class PermissionMemberDeleteReqCall
    extends ReqCaller<Object, EmptyData> {
        private final PermissionMembers permissionMembers;
        private final Map<String, Object> pathParams = new HashMap<String, Object>();
        private final Map<String, Object> queryParams = new HashMap<String, Object>();
        private final List<RequestOptFn> optFns = new ArrayList<RequestOptFn>();
        private EmptyData result;

        private PermissionMemberDeleteReqCall(PermissionMembers permissionMembers, RequestOptFn ... optFns) {
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new EmptyData();
            this.permissionMembers = permissionMembers;
        }

        public PermissionMemberDeleteReqCall setToken(String token) {
            this.pathParams.put("token", token);
            return this;
        }

        public PermissionMemberDeleteReqCall setMemberId(String memberId) {
            this.pathParams.put("member_id", memberId);
            return this;
        }

        public PermissionMemberDeleteReqCall setType(String type) {
            this.queryParams.put("type", type);
            return this;
        }

        public PermissionMemberDeleteReqCall setMemberType(String memberType) {
            this.queryParams.put("member_type", memberType);
            return this;
        }

        @Override
        public Response<EmptyData> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            this.optFns.add(Request.setQueryParams(this.queryParams));
            Request<Object, EmptyData> request = Request.newRequest("/open-apis/drive/v1/permissions/:token/members/:member_id", "DELETE", new AccessTokenType[]{AccessTokenType.Tenant, AccessTokenType.User}, null, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.permissionMembers.service.config, request);
        }
    }

    public static class PermissionMemberCreateReqCall
    extends ReqCaller<Member, PermissionMemberCreateResult> {
        private final PermissionMembers permissionMembers;
        private final Member body;
        private final Map<String, Object> pathParams;
        private final Map<String, Object> queryParams;
        private final List<RequestOptFn> optFns;
        private PermissionMemberCreateResult result;

        private PermissionMemberCreateReqCall(PermissionMembers permissionMembers, Member body, RequestOptFn ... optFns) {
            this.body = body;
            this.pathParams = new HashMap<String, Object>();
            this.queryParams = new HashMap<String, Object>();
            this.optFns = new ArrayList<RequestOptFn>();
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new PermissionMemberCreateResult();
            this.permissionMembers = permissionMembers;
        }

        public PermissionMemberCreateReqCall setToken(String token) {
            this.pathParams.put("token", token);
            return this;
        }

        public PermissionMemberCreateReqCall setType(String type) {
            this.queryParams.put("type", type);
            return this;
        }

        public PermissionMemberCreateReqCall setNeedNotification(Boolean needNotification) {
            this.queryParams.put("need_notification", needNotification);
            return this;
        }

        @Override
        public Response<PermissionMemberCreateResult> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            this.optFns.add(Request.setQueryParams(this.queryParams));
            Request<Member, PermissionMemberCreateResult> request = Request.newRequest("/open-apis/drive/v1/permissions/:token/members", "POST", new AccessTokenType[]{AccessTokenType.Tenant, AccessTokenType.User}, this.body, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.permissionMembers.service.config, request);
        }
    }

    public static class PermissionMembers {
        private final DriveService service;

        public PermissionMembers(DriveService service) {
            this.service = service;
        }

        public PermissionMemberCreateReqCall create(Member body, RequestOptFn ... optFns) {
            return new PermissionMemberCreateReqCall(this, body, optFns);
        }

        public PermissionMemberDeleteReqCall delete(RequestOptFn ... optFns) {
            return new PermissionMemberDeleteReqCall(this, optFns);
        }

        public PermissionMemberUpdateReqCall update(Member body, RequestOptFn ... optFns) {
            return new PermissionMemberUpdateReqCall(this, body, optFns);
        }
    }

    public static class MediaDownloadReqCall
    extends ReqCaller<Object, OutputStream> {
        private final Medias medias;
        private final Map<String, Object> pathParams = new HashMap<String, Object>();
        private final Map<String, Object> queryParams = new HashMap<String, Object>();
        private final List<RequestOptFn> optFns = new ArrayList<RequestOptFn>();
        private OutputStream result;

        private MediaDownloadReqCall(Medias medias, RequestOptFn ... optFns) {
            this.optFns.addAll(Arrays.asList(optFns));
            this.medias = medias;
        }

        public MediaDownloadReqCall setFileToken(String fileToken) {
            this.pathParams.put("file_token", fileToken);
            return this;
        }

        public MediaDownloadReqCall setExtra(String extra) {
            this.queryParams.put("extra", extra);
            return this;
        }

        public MediaDownloadReqCall setResponseStream(OutputStream result) {
            this.result = result;
            return this;
        }

        @Override
        public Response<OutputStream> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            this.optFns.add(Request.setQueryParams(this.queryParams));
            this.optFns.add(Request.setResponseStream());
            Request<Object, OutputStream> request = Request.newRequest("/open-apis/drive/v1/medias/:file_token/download", "GET", new AccessTokenType[]{AccessTokenType.User, AccessTokenType.Tenant}, null, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.medias.service.config, request);
        }
    }

    public static class MediaBatchGetTmpDownloadUrlReqCall
    extends ReqCaller<Object, MediaBatchGetTmpDownloadUrlResult> {
        private final Medias medias;
        private final Map<String, Object> queryParams = new HashMap<String, Object>();
        private final List<RequestOptFn> optFns = new ArrayList<RequestOptFn>();
        private MediaBatchGetTmpDownloadUrlResult result;

        private MediaBatchGetTmpDownloadUrlReqCall(Medias medias, RequestOptFn ... optFns) {
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new MediaBatchGetTmpDownloadUrlResult();
            this.medias = medias;
        }

        public MediaBatchGetTmpDownloadUrlReqCall setFileTokens(String ... fileTokens) {
            this.queryParams.put("file_tokens", fileTokens);
            return this;
        }

        public MediaBatchGetTmpDownloadUrlReqCall setExtra(String extra) {
            this.queryParams.put("extra", extra);
            return this;
        }

        @Override
        public Response<MediaBatchGetTmpDownloadUrlResult> execute() throws Exception {
            this.optFns.add(Request.setQueryParams(this.queryParams));
            Request<Object, MediaBatchGetTmpDownloadUrlResult> request = Request.newRequest("/open-apis/drive/v1/medias/batch_get_tmp_download_url", "GET", new AccessTokenType[]{AccessTokenType.User, AccessTokenType.Tenant}, null, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.medias.service.config, request);
        }
    }

    public static class MediaUploadPrepareReqCall
    extends ReqCaller<MediaUploadInfo, MediaUploadPrepareResult> {
        private final Medias medias;
        private final MediaUploadInfo body;
        private final List<RequestOptFn> optFns;
        private MediaUploadPrepareResult result;

        private MediaUploadPrepareReqCall(Medias medias, MediaUploadInfo body, RequestOptFn ... optFns) {
            this.body = body;
            this.optFns = new ArrayList<RequestOptFn>();
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new MediaUploadPrepareResult();
            this.medias = medias;
        }

        @Override
        public Response<MediaUploadPrepareResult> execute() throws Exception {
            Request<MediaUploadInfo, MediaUploadPrepareResult> request = Request.newRequest("/open-apis/drive/v1/medias/upload_prepare", "POST", new AccessTokenType[]{AccessTokenType.User, AccessTokenType.Tenant}, this.body, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.medias.service.config, request);
        }
    }

    public static class MediaUploadFinishReqCall
    extends ReqCaller<MediaUploadFinishReqBody, MediaUploadFinishResult> {
        private final Medias medias;
        private final MediaUploadFinishReqBody body;
        private final List<RequestOptFn> optFns;
        private MediaUploadFinishResult result;

        private MediaUploadFinishReqCall(Medias medias, MediaUploadFinishReqBody body, RequestOptFn ... optFns) {
            this.body = body;
            this.optFns = new ArrayList<RequestOptFn>();
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new MediaUploadFinishResult();
            this.medias = medias;
        }

        @Override
        public Response<MediaUploadFinishResult> execute() throws Exception {
            Request<MediaUploadFinishReqBody, MediaUploadFinishResult> request = Request.newRequest("/open-apis/drive/v1/medias/upload_finish", "POST", new AccessTokenType[]{AccessTokenType.User, AccessTokenType.Tenant}, this.body, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.medias.service.config, request);
        }
    }

    public static class MediaUploadAllReqCall
    extends ReqCaller<FormData, MediaUploadAllResult> {
        private final Medias medias;
        private final FormData body = new FormData();
        private final List<RequestOptFn> optFns = new ArrayList<RequestOptFn>();
        private MediaUploadAllResult result;

        private MediaUploadAllReqCall(Medias medias, RequestOptFn ... optFns) {
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new MediaUploadAllResult();
            this.medias = medias;
        }

        public MediaUploadAllReqCall setFileName(String fileName) {
            this.body.addField("file_name", fileName);
            return this;
        }

        public MediaUploadAllReqCall setParentType(String parentType) {
            this.body.addField("parent_type", parentType);
            return this;
        }

        public MediaUploadAllReqCall setParentNode(String parentNode) {
            this.body.addField("parent_node", parentNode);
            return this;
        }

        public MediaUploadAllReqCall setSize(Integer size) {
            this.body.addField("size", size);
            return this;
        }

        public MediaUploadAllReqCall setChecksum(String checksum) {
            this.body.addField("checksum", checksum);
            return this;
        }

        public MediaUploadAllReqCall setExtra(String extra) {
            this.body.addField("extra", extra);
            return this;
        }

        public MediaUploadAllReqCall setFile(FormDataFile file) {
            this.body.addFile("file", file);
            return this;
        }

        @Override
        public Response<MediaUploadAllResult> execute() throws Exception {
            Request<FormData, MediaUploadAllResult> request = Request.newRequest("/open-apis/drive/v1/medias/upload_all", "POST", new AccessTokenType[]{AccessTokenType.User, AccessTokenType.Tenant}, this.body, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.medias.service.config, request);
        }
    }

    public static class MediaUploadPartReqCall
    extends ReqCaller<FormData, EmptyData> {
        private final Medias medias;
        private final FormData body = new FormData();
        private final List<RequestOptFn> optFns = new ArrayList<RequestOptFn>();
        private EmptyData result;

        private MediaUploadPartReqCall(Medias medias, RequestOptFn ... optFns) {
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new EmptyData();
            this.medias = medias;
        }

        public MediaUploadPartReqCall setUploadId(String uploadId) {
            this.body.addField("upload_id", uploadId);
            return this;
        }

        public MediaUploadPartReqCall setSeq(Integer seq) {
            this.body.addField("seq", seq);
            return this;
        }

        public MediaUploadPartReqCall setSize(Integer size) {
            this.body.addField("size", size);
            return this;
        }

        public MediaUploadPartReqCall setChecksum(String checksum) {
            this.body.addField("checksum", checksum);
            return this;
        }

        public MediaUploadPartReqCall setFile(FormDataFile file) {
            this.body.addFile("file", file);
            return this;
        }

        @Override
        public Response<EmptyData> execute() throws Exception {
            Request<FormData, EmptyData> request = Request.newRequest("/open-apis/drive/v1/medias/upload_part", "POST", new AccessTokenType[]{AccessTokenType.User, AccessTokenType.Tenant}, this.body, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.medias.service.config, request);
        }
    }

    public static class Medias {
        private final DriveService service;

        public Medias(DriveService service) {
            this.service = service;
        }

        public MediaUploadPartReqCall uploadPart(RequestOptFn ... optFns) {
            return new MediaUploadPartReqCall(this, optFns);
        }

        public MediaUploadAllReqCall uploadAll(RequestOptFn ... optFns) {
            return new MediaUploadAllReqCall(this, optFns);
        }

        public MediaUploadFinishReqCall uploadFinish(MediaUploadFinishReqBody body, RequestOptFn ... optFns) {
            return new MediaUploadFinishReqCall(this, body, optFns);
        }

        public MediaUploadPrepareReqCall uploadPrepare(MediaUploadInfo body, RequestOptFn ... optFns) {
            return new MediaUploadPrepareReqCall(this, body, optFns);
        }

        public MediaBatchGetTmpDownloadUrlReqCall batchGetTmpDownloadUrl(RequestOptFn ... optFns) {
            return new MediaBatchGetTmpDownloadUrlReqCall(this, optFns);
        }

        public MediaDownloadReqCall download(RequestOptFn ... optFns) {
            return new MediaDownloadReqCall(this, optFns);
        }
    }

    public static class ImportTaskGetReqCall
    extends ReqCaller<Object, ImportTaskGetResult> {
        private final ImportTasks importTasks;
        private final Map<String, Object> pathParams = new HashMap<String, Object>();
        private final List<RequestOptFn> optFns = new ArrayList<RequestOptFn>();
        private ImportTaskGetResult result;

        private ImportTaskGetReqCall(ImportTasks importTasks, RequestOptFn ... optFns) {
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new ImportTaskGetResult();
            this.importTasks = importTasks;
        }

        public ImportTaskGetReqCall setTicket(String ticket) {
            this.pathParams.put("ticket", ticket);
            return this;
        }

        @Override
        public Response<ImportTaskGetResult> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            Request<Object, ImportTaskGetResult> request = Request.newRequest("/open-apis/drive/v1/import_tasks/:ticket", "GET", new AccessTokenType[]{AccessTokenType.User, AccessTokenType.Tenant}, null, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.importTasks.service.config, request);
        }
    }

    public static class ImportTaskCreateReqCall
    extends ReqCaller<ImportTask, ImportTaskCreateResult> {
        private final ImportTasks importTasks;
        private final ImportTask body;
        private final List<RequestOptFn> optFns;
        private ImportTaskCreateResult result;

        private ImportTaskCreateReqCall(ImportTasks importTasks, ImportTask body, RequestOptFn ... optFns) {
            this.body = body;
            this.optFns = new ArrayList<RequestOptFn>();
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new ImportTaskCreateResult();
            this.importTasks = importTasks;
        }

        @Override
        public Response<ImportTaskCreateResult> execute() throws Exception {
            Request<ImportTask, ImportTaskCreateResult> request = Request.newRequest("/open-apis/drive/v1/import_tasks", "POST", new AccessTokenType[]{AccessTokenType.User, AccessTokenType.Tenant}, this.body, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.importTasks.service.config, request);
        }
    }

    public static class ImportTasks {
        private final DriveService service;

        public ImportTasks(DriveService service) {
            this.service = service;
        }

        public ImportTaskCreateReqCall create(ImportTask body, RequestOptFn ... optFns) {
            return new ImportTaskCreateReqCall(this, body, optFns);
        }

        public ImportTaskGetReqCall get(RequestOptFn ... optFns) {
            return new ImportTaskGetReqCall(this, optFns);
        }
    }

    public static class FileCommentReplyDeleteReqCall
    extends ReqCaller<Object, EmptyData> {
        private final FileCommentReplys fileCommentReplys;
        private final Map<String, Object> pathParams = new HashMap<String, Object>();
        private final Map<String, Object> queryParams = new HashMap<String, Object>();
        private final List<RequestOptFn> optFns = new ArrayList<RequestOptFn>();
        private EmptyData result;

        private FileCommentReplyDeleteReqCall(FileCommentReplys fileCommentReplys, RequestOptFn ... optFns) {
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new EmptyData();
            this.fileCommentReplys = fileCommentReplys;
        }

        public FileCommentReplyDeleteReqCall setFileToken(String fileToken) {
            this.pathParams.put("file_token", fileToken);
            return this;
        }

        public FileCommentReplyDeleteReqCall setCommentId(Long commentId) {
            this.pathParams.put("comment_id", commentId);
            return this;
        }

        public FileCommentReplyDeleteReqCall setReplyId(Long replyId) {
            this.pathParams.put("reply_id", replyId);
            return this;
        }

        public FileCommentReplyDeleteReqCall setFileType(String fileType) {
            this.queryParams.put("file_type", fileType);
            return this;
        }

        @Override
        public Response<EmptyData> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            this.optFns.add(Request.setQueryParams(this.queryParams));
            Request<Object, EmptyData> request = Request.newRequest("/open-apis/drive/v1/files/:file_token/comments/:comment_id/replies/:reply_id", "DELETE", new AccessTokenType[]{AccessTokenType.User, AccessTokenType.Tenant}, null, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.fileCommentReplys.service.config, request);
        }
    }

    public static class FileCommentReplyUpdateReqCall
    extends ReqCaller<FileCommentReplyUpdateReqBody, EmptyData> {
        private final FileCommentReplys fileCommentReplys;
        private final FileCommentReplyUpdateReqBody body;
        private final Map<String, Object> pathParams;
        private final Map<String, Object> queryParams;
        private final List<RequestOptFn> optFns;
        private EmptyData result;

        private FileCommentReplyUpdateReqCall(FileCommentReplys fileCommentReplys, FileCommentReplyUpdateReqBody body, RequestOptFn ... optFns) {
            this.body = body;
            this.pathParams = new HashMap<String, Object>();
            this.queryParams = new HashMap<String, Object>();
            this.optFns = new ArrayList<RequestOptFn>();
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new EmptyData();
            this.fileCommentReplys = fileCommentReplys;
        }

        public FileCommentReplyUpdateReqCall setFileToken(String fileToken) {
            this.pathParams.put("file_token", fileToken);
            return this;
        }

        public FileCommentReplyUpdateReqCall setCommentId(Long commentId) {
            this.pathParams.put("comment_id", commentId);
            return this;
        }

        public FileCommentReplyUpdateReqCall setReplyId(Long replyId) {
            this.pathParams.put("reply_id", replyId);
            return this;
        }

        public FileCommentReplyUpdateReqCall setFileType(String fileType) {
            this.queryParams.put("file_type", fileType);
            return this;
        }

        public FileCommentReplyUpdateReqCall setUserIdType(String userIdType) {
            this.queryParams.put("user_id_type", userIdType);
            return this;
        }

        @Override
        public Response<EmptyData> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            this.optFns.add(Request.setQueryParams(this.queryParams));
            Request<FileCommentReplyUpdateReqBody, EmptyData> request = Request.newRequest("/open-apis/drive/v1/files/:file_token/comments/:comment_id/replies/:reply_id", "PUT", new AccessTokenType[]{AccessTokenType.User, AccessTokenType.Tenant}, this.body, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.fileCommentReplys.service.config, request);
        }
    }

    public static class FileCommentReplys {
        private final DriveService service;

        public FileCommentReplys(DriveService service) {
            this.service = service;
        }

        public FileCommentReplyUpdateReqCall update(FileCommentReplyUpdateReqBody body, RequestOptFn ... optFns) {
            return new FileCommentReplyUpdateReqCall(this, body, optFns);
        }

        public FileCommentReplyDeleteReqCall delete(RequestOptFn ... optFns) {
            return new FileCommentReplyDeleteReqCall(this, optFns);
        }
    }

    public static class FileCommentPatchReqCall
    extends ReqCaller<FileCommentPatchReqBody, EmptyData> {
        private final FileComments fileComments;
        private final FileCommentPatchReqBody body;
        private final Map<String, Object> pathParams;
        private final Map<String, Object> queryParams;
        private final List<RequestOptFn> optFns;
        private EmptyData result;

        private FileCommentPatchReqCall(FileComments fileComments, FileCommentPatchReqBody body, RequestOptFn ... optFns) {
            this.body = body;
            this.pathParams = new HashMap<String, Object>();
            this.queryParams = new HashMap<String, Object>();
            this.optFns = new ArrayList<RequestOptFn>();
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new EmptyData();
            this.fileComments = fileComments;
        }

        public FileCommentPatchReqCall setFileToken(String fileToken) {
            this.pathParams.put("file_token", fileToken);
            return this;
        }

        public FileCommentPatchReqCall setCommentId(Long commentId) {
            this.pathParams.put("comment_id", commentId);
            return this;
        }

        public FileCommentPatchReqCall setFileType(String fileType) {
            this.queryParams.put("file_type", fileType);
            return this;
        }

        @Override
        public Response<EmptyData> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            this.optFns.add(Request.setQueryParams(this.queryParams));
            Request<FileCommentPatchReqBody, EmptyData> request = Request.newRequest("/open-apis/drive/v1/files/:file_token/comments/:comment_id", "PATCH", new AccessTokenType[]{AccessTokenType.User, AccessTokenType.Tenant}, this.body, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.fileComments.service.config, request);
        }
    }

    public static class FileCommentListReqCall
    extends ReqCaller<Object, FileCommentListResult> {
        private final FileComments fileComments;
        private final Map<String, Object> pathParams = new HashMap<String, Object>();
        private final Map<String, Object> queryParams = new HashMap<String, Object>();
        private final List<RequestOptFn> optFns = new ArrayList<RequestOptFn>();
        private FileCommentListResult result;

        private FileCommentListReqCall(FileComments fileComments, RequestOptFn ... optFns) {
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new FileCommentListResult();
            this.fileComments = fileComments;
        }

        public FileCommentListReqCall setFileToken(String fileToken) {
            this.pathParams.put("file_token", fileToken);
            return this;
        }

        public FileCommentListReqCall setFileType(String fileType) {
            this.queryParams.put("file_type", fileType);
            return this;
        }

        public FileCommentListReqCall setUserIdType(String userIdType) {
            this.queryParams.put("user_id_type", userIdType);
            return this;
        }

        public FileCommentListReqCall setIsSolved(Boolean isSolved) {
            this.queryParams.put("is_solved", isSolved);
            return this;
        }

        public FileCommentListReqCall setPageToken(String pageToken) {
            this.queryParams.put("page_token", pageToken);
            return this;
        }

        public FileCommentListReqCall setPageSize(Integer pageSize) {
            this.queryParams.put("page_size", pageSize);
            return this;
        }

        @Override
        public Response<FileCommentListResult> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            this.optFns.add(Request.setQueryParams(this.queryParams));
            Request<Object, FileCommentListResult> request = Request.newRequest("/open-apis/drive/v1/files/:file_token/comments", "GET", new AccessTokenType[]{AccessTokenType.User, AccessTokenType.Tenant}, null, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.fileComments.service.config, request);
        }
    }

    public static class FileCommentGetReqCall
    extends ReqCaller<Object, FileComment> {
        private final FileComments fileComments;
        private final Map<String, Object> pathParams = new HashMap<String, Object>();
        private final Map<String, Object> queryParams = new HashMap<String, Object>();
        private final List<RequestOptFn> optFns = new ArrayList<RequestOptFn>();
        private FileComment result;

        private FileCommentGetReqCall(FileComments fileComments, RequestOptFn ... optFns) {
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new FileComment();
            this.fileComments = fileComments;
        }

        public FileCommentGetReqCall setFileToken(String fileToken) {
            this.pathParams.put("file_token", fileToken);
            return this;
        }

        public FileCommentGetReqCall setCommentId(Long commentId) {
            this.pathParams.put("comment_id", commentId);
            return this;
        }

        public FileCommentGetReqCall setFileType(String fileType) {
            this.queryParams.put("file_type", fileType);
            return this;
        }

        public FileCommentGetReqCall setUserIdType(String userIdType) {
            this.queryParams.put("user_id_type", userIdType);
            return this;
        }

        @Override
        public Response<FileComment> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            this.optFns.add(Request.setQueryParams(this.queryParams));
            Request<Object, FileComment> request = Request.newRequest("/open-apis/drive/v1/files/:file_token/comments/:comment_id", "GET", new AccessTokenType[]{AccessTokenType.User, AccessTokenType.Tenant}, null, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.fileComments.service.config, request);
        }
    }

    public static class FileCommentCreateReqCall
    extends ReqCaller<FileComment, FileComment> {
        private final FileComments fileComments;
        private final FileComment body;
        private final Map<String, Object> pathParams;
        private final Map<String, Object> queryParams;
        private final List<RequestOptFn> optFns;
        private FileComment result;

        private FileCommentCreateReqCall(FileComments fileComments, FileComment body, RequestOptFn ... optFns) {
            this.body = body;
            this.pathParams = new HashMap<String, Object>();
            this.queryParams = new HashMap<String, Object>();
            this.optFns = new ArrayList<RequestOptFn>();
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new FileComment();
            this.fileComments = fileComments;
        }

        public FileCommentCreateReqCall setFileToken(String fileToken) {
            this.pathParams.put("file_token", fileToken);
            return this;
        }

        public FileCommentCreateReqCall setFileType(String fileType) {
            this.queryParams.put("file_type", fileType);
            return this;
        }

        public FileCommentCreateReqCall setUserIdType(String userIdType) {
            this.queryParams.put("user_id_type", userIdType);
            return this;
        }

        @Override
        public Response<FileComment> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            this.optFns.add(Request.setQueryParams(this.queryParams));
            Request<FileComment, FileComment> request = Request.newRequest("/open-apis/drive/v1/files/:file_token/comments", "POST", new AccessTokenType[]{AccessTokenType.User, AccessTokenType.Tenant}, this.body, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.fileComments.service.config, request);
        }
    }

    public static class FileComments {
        private final DriveService service;

        public FileComments(DriveService service) {
            this.service = service;
        }

        public FileCommentCreateReqCall create(FileComment body, RequestOptFn ... optFns) {
            return new FileCommentCreateReqCall(this, body, optFns);
        }

        public FileCommentGetReqCall get(RequestOptFn ... optFns) {
            return new FileCommentGetReqCall(this, optFns);
        }

        public FileCommentListReqCall list(RequestOptFn ... optFns) {
            return new FileCommentListReqCall(this, optFns);
        }

        public FileCommentPatchReqCall patch(FileCommentPatchReqBody body, RequestOptFn ... optFns) {
            return new FileCommentPatchReqCall(this, body, optFns);
        }
    }

    public static class FileSubscribeReqCall
    extends ReqCaller<Object, EmptyData> {
        private final Files files;
        private final Map<String, Object> pathParams = new HashMap<String, Object>();
        private final Map<String, Object> queryParams = new HashMap<String, Object>();
        private final List<RequestOptFn> optFns = new ArrayList<RequestOptFn>();
        private EmptyData result;

        private FileSubscribeReqCall(Files files, RequestOptFn ... optFns) {
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new EmptyData();
            this.files = files;
        }

        public FileSubscribeReqCall setFileToken(String fileToken) {
            this.pathParams.put("file_token", fileToken);
            return this;
        }

        public FileSubscribeReqCall setFileType(String fileType) {
            this.queryParams.put("file_type", fileType);
            return this;
        }

        @Override
        public Response<EmptyData> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            this.optFns.add(Request.setQueryParams(this.queryParams));
            Request<Object, EmptyData> request = Request.newRequest("/open-apis/drive/v1/files/:file_token/subscribe", "POST", new AccessTokenType[]{AccessTokenType.User, AccessTokenType.Tenant}, null, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.files.service.config, request);
        }
    }

    public static class FileDownloadReqCall
    extends ReqCaller<Object, OutputStream> {
        private final Files files;
        private final Map<String, Object> pathParams = new HashMap<String, Object>();
        private final List<RequestOptFn> optFns = new ArrayList<RequestOptFn>();
        private OutputStream result;

        private FileDownloadReqCall(Files files, RequestOptFn ... optFns) {
            this.optFns.addAll(Arrays.asList(optFns));
            this.files = files;
        }

        public FileDownloadReqCall setFileToken(String fileToken) {
            this.pathParams.put("file_token", fileToken);
            return this;
        }

        public FileDownloadReqCall setResponseStream(OutputStream result) {
            this.result = result;
            return this;
        }

        @Override
        public Response<OutputStream> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            this.optFns.add(Request.setResponseStream());
            Request<Object, OutputStream> request = Request.newRequest("/open-apis/drive/v1/files/:file_token/download", "GET", new AccessTokenType[]{AccessTokenType.User, AccessTokenType.Tenant}, null, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.files.service.config, request);
        }
    }

    public static class FileUploadPartReqCall
    extends ReqCaller<FormData, EmptyData> {
        private final Files files;
        private final FormData body = new FormData();
        private final List<RequestOptFn> optFns = new ArrayList<RequestOptFn>();
        private EmptyData result;

        private FileUploadPartReqCall(Files files, RequestOptFn ... optFns) {
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new EmptyData();
            this.files = files;
        }

        public FileUploadPartReqCall setUploadId(String uploadId) {
            this.body.addField("upload_id", uploadId);
            return this;
        }

        public FileUploadPartReqCall setSeq(Integer seq) {
            this.body.addField("seq", seq);
            return this;
        }

        public FileUploadPartReqCall setSize(Integer size) {
            this.body.addField("size", size);
            return this;
        }

        public FileUploadPartReqCall setChecksum(String checksum) {
            this.body.addField("checksum", checksum);
            return this;
        }

        public FileUploadPartReqCall setFile(FormDataFile file) {
            this.body.addFile("file", file);
            return this;
        }

        @Override
        public Response<EmptyData> execute() throws Exception {
            Request<FormData, EmptyData> request = Request.newRequest("/open-apis/drive/v1/files/upload_part", "POST", new AccessTokenType[]{AccessTokenType.User, AccessTokenType.Tenant}, this.body, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.files.service.config, request);
        }
    }

    public static class FileUploadAllReqCall
    extends ReqCaller<FormData, FileUploadAllResult> {
        private final Files files;
        private final FormData body = new FormData();
        private final List<RequestOptFn> optFns = new ArrayList<RequestOptFn>();
        private FileUploadAllResult result;

        private FileUploadAllReqCall(Files files, RequestOptFn ... optFns) {
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new FileUploadAllResult();
            this.files = files;
        }

        public FileUploadAllReqCall setFileName(String fileName) {
            this.body.addField("file_name", fileName);
            return this;
        }

        public FileUploadAllReqCall setParentType(String parentType) {
            this.body.addField("parent_type", parentType);
            return this;
        }

        public FileUploadAllReqCall setParentNode(String parentNode) {
            this.body.addField("parent_node", parentNode);
            return this;
        }

        public FileUploadAllReqCall setSize(Integer size) {
            this.body.addField("size", size);
            return this;
        }

        public FileUploadAllReqCall setChecksum(String checksum) {
            this.body.addField("checksum", checksum);
            return this;
        }

        public FileUploadAllReqCall setFile(FormDataFile file) {
            this.body.addFile("file", file);
            return this;
        }

        @Override
        public Response<FileUploadAllResult> execute() throws Exception {
            Request<FormData, FileUploadAllResult> request = Request.newRequest("/open-apis/drive/v1/files/upload_all", "POST", new AccessTokenType[]{AccessTokenType.User, AccessTokenType.Tenant}, this.body, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.files.service.config, request);
        }
    }

    public static class FileUploadPrepareReqCall
    extends ReqCaller<FileUploadInfo, FileUploadPrepareResult> {
        private final Files files;
        private final FileUploadInfo body;
        private final List<RequestOptFn> optFns;
        private FileUploadPrepareResult result;

        private FileUploadPrepareReqCall(Files files, FileUploadInfo body, RequestOptFn ... optFns) {
            this.body = body;
            this.optFns = new ArrayList<RequestOptFn>();
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new FileUploadPrepareResult();
            this.files = files;
        }

        @Override
        public Response<FileUploadPrepareResult> execute() throws Exception {
            Request<FileUploadInfo, FileUploadPrepareResult> request = Request.newRequest("/open-apis/drive/v1/files/upload_prepare", "POST", new AccessTokenType[]{AccessTokenType.User, AccessTokenType.Tenant}, this.body, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.files.service.config, request);
        }
    }

    public static class FileUploadFinishReqCall
    extends ReqCaller<FileUploadFinishReqBody, FileUploadFinishResult> {
        private final Files files;
        private final FileUploadFinishReqBody body;
        private final List<RequestOptFn> optFns;
        private FileUploadFinishResult result;

        private FileUploadFinishReqCall(Files files, FileUploadFinishReqBody body, RequestOptFn ... optFns) {
            this.body = body;
            this.optFns = new ArrayList<RequestOptFn>();
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new FileUploadFinishResult();
            this.files = files;
        }

        @Override
        public Response<FileUploadFinishResult> execute() throws Exception {
            Request<FileUploadFinishReqBody, FileUploadFinishResult> request = Request.newRequest("/open-apis/drive/v1/files/upload_finish", "POST", new AccessTokenType[]{AccessTokenType.User, AccessTokenType.Tenant}, this.body, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.files.service.config, request);
        }
    }

    public static class Files {
        private final DriveService service;

        public Files(DriveService service) {
            this.service = service;
        }

        public FileUploadFinishReqCall uploadFinish(FileUploadFinishReqBody body, RequestOptFn ... optFns) {
            return new FileUploadFinishReqCall(this, body, optFns);
        }

        public FileUploadPrepareReqCall uploadPrepare(FileUploadInfo body, RequestOptFn ... optFns) {
            return new FileUploadPrepareReqCall(this, body, optFns);
        }

        public FileUploadAllReqCall uploadAll(RequestOptFn ... optFns) {
            return new FileUploadAllReqCall(this, optFns);
        }

        public FileUploadPartReqCall uploadPart(RequestOptFn ... optFns) {
            return new FileUploadPartReqCall(this, optFns);
        }

        public FileDownloadReqCall download(RequestOptFn ... optFns) {
            return new FileDownloadReqCall(this, optFns);
        }

        public FileSubscribeReqCall subscribe(RequestOptFn ... optFns) {
            return new FileSubscribeReqCall(this, optFns);
        }
    }
}

