/*
 * Decompiled with CFR 0.152.
 */
package com.larksuite.oapi.service.image.v4;

import com.larksuite.oapi.core.Config;
import com.larksuite.oapi.core.api.AccessTokenType;
import com.larksuite.oapi.core.api.Api;
import com.larksuite.oapi.core.api.ReqCaller;
import com.larksuite.oapi.core.api.request.FormData;
import com.larksuite.oapi.core.api.request.FormDataFile;
import com.larksuite.oapi.core.api.request.Request;
import com.larksuite.oapi.core.api.request.RequestOptFn;
import com.larksuite.oapi.core.api.response.Response;
import com.larksuite.oapi.service.image.v4.model.Image;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ImageService {
    private final Config config;
    private final Images images;

    public ImageService(Config config) {
        this.config = config;
        this.images = new Images(this);
    }

    public Images getImages() {
        return this.images;
    }

    public static class ImagePutReqCall
    extends ReqCaller<FormData, Image> {
        private final Images images;
        private final FormData body = new FormData();
        private final List<RequestOptFn> optFns = new ArrayList<RequestOptFn>();
        private Image result;

        private ImagePutReqCall(Images images, RequestOptFn ... optFns) {
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new Image();
            this.images = images;
        }

        public ImagePutReqCall setImage(FormDataFile image) {
            this.body.addFile("image", image);
            return this;
        }

        public ImagePutReqCall setImageType(String imageType) {
            this.body.addField("image_type", imageType);
            return this;
        }

        @Override
        public Response<Image> execute() throws Exception {
            Request<FormData, Image> request = Request.newRequest("/open-apis/image/v4/put", "POST", new AccessTokenType[]{AccessTokenType.Tenant}, this.body, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.images.service.config, request);
        }
    }

    public static class ImageGetReqCall
    extends ReqCaller<Object, OutputStream> {
        private final Images images;
        private final Map<String, Object> queryParams = new HashMap<String, Object>();
        private final List<RequestOptFn> optFns = new ArrayList<RequestOptFn>();
        private OutputStream result;

        private ImageGetReqCall(Images images, RequestOptFn ... optFns) {
            this.optFns.addAll(Arrays.asList(optFns));
            this.images = images;
        }

        public ImageGetReqCall setImageKey(String imageKey) {
            this.queryParams.put("image_key", imageKey);
            return this;
        }

        public ImageGetReqCall setResponseStream(OutputStream result) {
            this.result = result;
            return this;
        }

        @Override
        public Response<OutputStream> execute() throws Exception {
            this.optFns.add(Request.setQueryParams(this.queryParams));
            this.optFns.add(Request.setResponseStream());
            Request<Object, OutputStream> request = Request.newRequest("/open-apis/image/v4/get", "GET", new AccessTokenType[]{AccessTokenType.Tenant}, null, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.images.service.config, request);
        }
    }

    public static class Images {
        private final ImageService service;

        public Images(ImageService service) {
            this.service = service;
        }

        public ImageGetReqCall get(RequestOptFn ... optFns) {
            return new ImageGetReqCall(this, optFns);
        }

        public ImagePutReqCall put(RequestOptFn ... optFns) {
            return new ImagePutReqCall(this, optFns);
        }
    }
}

