/*
 * Decompiled with CFR 0.152.
 */
package com.larksuite.oapi.service.mail.v1;

import com.larksuite.oapi.core.Config;
import com.larksuite.oapi.core.api.AccessTokenType;
import com.larksuite.oapi.core.api.Api;
import com.larksuite.oapi.core.api.ReqCaller;
import com.larksuite.oapi.core.api.request.Request;
import com.larksuite.oapi.core.api.request.RequestOptFn;
import com.larksuite.oapi.core.api.response.EmptyData;
import com.larksuite.oapi.core.api.response.Response;
import com.larksuite.oapi.service.mail.v1.model.Mailgroup;
import com.larksuite.oapi.service.mail.v1.model.MailgroupListResult;
import com.larksuite.oapi.service.mail.v1.model.MailgroupMember;
import com.larksuite.oapi.service.mail.v1.model.MailgroupMemberListResult;
import com.larksuite.oapi.service.mail.v1.model.MailgroupPermissionMember;
import com.larksuite.oapi.service.mail.v1.model.MailgroupPermissionMemberListResult;
import com.larksuite.oapi.service.mail.v1.model.PublicMailbox;
import com.larksuite.oapi.service.mail.v1.model.PublicMailboxListResult;
import com.larksuite.oapi.service.mail.v1.model.PublicMailboxMember;
import com.larksuite.oapi.service.mail.v1.model.PublicMailboxMemberListResult;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MailService {
    private final Config config;
    private final MailgroupMembers mailgroupMembers;
    private final MailgroupPermissionMembers mailgroupPermissionMembers;
    private final PublicMailboxs publicMailboxs;
    private final PublicMailboxMembers publicMailboxMembers;
    private final Mailgroups mailgroups;

    public MailService(Config config) {
        this.config = config;
        this.mailgroupMembers = new MailgroupMembers(this);
        this.mailgroupPermissionMembers = new MailgroupPermissionMembers(this);
        this.publicMailboxs = new PublicMailboxs(this);
        this.publicMailboxMembers = new PublicMailboxMembers(this);
        this.mailgroups = new Mailgroups(this);
    }

    public MailgroupMembers getMailgroupMembers() {
        return this.mailgroupMembers;
    }

    public MailgroupPermissionMembers getMailgroupPermissionMembers() {
        return this.mailgroupPermissionMembers;
    }

    public PublicMailboxs getPublicMailboxs() {
        return this.publicMailboxs;
    }

    public PublicMailboxMembers getPublicMailboxMembers() {
        return this.publicMailboxMembers;
    }

    public Mailgroups getMailgroups() {
        return this.mailgroups;
    }

    public static class MailgroupPatchReqCall
    extends ReqCaller<Mailgroup, Mailgroup> {
        private final Mailgroups mailgroups;
        private final Mailgroup body;
        private final Map<String, Object> pathParams;
        private final List<RequestOptFn> optFns;
        private Mailgroup result;

        private MailgroupPatchReqCall(Mailgroups mailgroups, Mailgroup body, RequestOptFn ... optFns) {
            this.body = body;
            this.pathParams = new HashMap<String, Object>();
            this.optFns = new ArrayList<RequestOptFn>();
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new Mailgroup();
            this.mailgroups = mailgroups;
        }

        public MailgroupPatchReqCall setMailgroupId(String mailgroupId) {
            this.pathParams.put("mailgroup_id", mailgroupId);
            return this;
        }

        @Override
        public Response<Mailgroup> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            Request<Mailgroup, Mailgroup> request = Request.newRequest("/open-apis/mail/v1/mailgroups/:mailgroup_id", "PATCH", new AccessTokenType[]{AccessTokenType.Tenant}, this.body, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.mailgroups.service.config, request);
        }
    }

    public static class MailgroupListReqCall
    extends ReqCaller<Object, MailgroupListResult> {
        private final Mailgroups mailgroups;
        private final Map<String, Object> queryParams = new HashMap<String, Object>();
        private final List<RequestOptFn> optFns = new ArrayList<RequestOptFn>();
        private MailgroupListResult result;

        private MailgroupListReqCall(Mailgroups mailgroups, RequestOptFn ... optFns) {
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new MailgroupListResult();
            this.mailgroups = mailgroups;
        }

        public MailgroupListReqCall setPageToken(String pageToken) {
            this.queryParams.put("page_token", pageToken);
            return this;
        }

        public MailgroupListReqCall setPageSize(Integer pageSize) {
            this.queryParams.put("page_size", pageSize);
            return this;
        }

        @Override
        public Response<MailgroupListResult> execute() throws Exception {
            this.optFns.add(Request.setQueryParams(this.queryParams));
            Request<Object, MailgroupListResult> request = Request.newRequest("/open-apis/mail/v1/mailgroups", "GET", new AccessTokenType[]{AccessTokenType.Tenant}, null, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.mailgroups.service.config, request);
        }
    }

    public static class MailgroupCreateReqCall
    extends ReqCaller<Mailgroup, Mailgroup> {
        private final Mailgroups mailgroups;
        private final Mailgroup body;
        private final List<RequestOptFn> optFns;
        private Mailgroup result;

        private MailgroupCreateReqCall(Mailgroups mailgroups, Mailgroup body, RequestOptFn ... optFns) {
            this.body = body;
            this.optFns = new ArrayList<RequestOptFn>();
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new Mailgroup();
            this.mailgroups = mailgroups;
        }

        @Override
        public Response<Mailgroup> execute() throws Exception {
            Request<Mailgroup, Mailgroup> request = Request.newRequest("/open-apis/mail/v1/mailgroups", "POST", new AccessTokenType[]{AccessTokenType.Tenant}, this.body, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.mailgroups.service.config, request);
        }
    }

    public static class MailgroupDeleteReqCall
    extends ReqCaller<Object, EmptyData> {
        private final Mailgroups mailgroups;
        private final Map<String, Object> pathParams = new HashMap<String, Object>();
        private final List<RequestOptFn> optFns = new ArrayList<RequestOptFn>();
        private EmptyData result;

        private MailgroupDeleteReqCall(Mailgroups mailgroups, RequestOptFn ... optFns) {
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new EmptyData();
            this.mailgroups = mailgroups;
        }

        public MailgroupDeleteReqCall setMailgroupId(String mailgroupId) {
            this.pathParams.put("mailgroup_id", mailgroupId);
            return this;
        }

        @Override
        public Response<EmptyData> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            Request<Object, EmptyData> request = Request.newRequest("/open-apis/mail/v1/mailgroups/:mailgroup_id", "DELETE", new AccessTokenType[]{AccessTokenType.Tenant}, null, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.mailgroups.service.config, request);
        }
    }

    public static class MailgroupUpdateReqCall
    extends ReqCaller<Mailgroup, Mailgroup> {
        private final Mailgroups mailgroups;
        private final Mailgroup body;
        private final Map<String, Object> pathParams;
        private final List<RequestOptFn> optFns;
        private Mailgroup result;

        private MailgroupUpdateReqCall(Mailgroups mailgroups, Mailgroup body, RequestOptFn ... optFns) {
            this.body = body;
            this.pathParams = new HashMap<String, Object>();
            this.optFns = new ArrayList<RequestOptFn>();
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new Mailgroup();
            this.mailgroups = mailgroups;
        }

        public MailgroupUpdateReqCall setMailgroupId(String mailgroupId) {
            this.pathParams.put("mailgroup_id", mailgroupId);
            return this;
        }

        @Override
        public Response<Mailgroup> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            Request<Mailgroup, Mailgroup> request = Request.newRequest("/open-apis/mail/v1/mailgroups/:mailgroup_id", "PUT", new AccessTokenType[]{AccessTokenType.Tenant}, this.body, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.mailgroups.service.config, request);
        }
    }

    public static class MailgroupGetReqCall
    extends ReqCaller<Object, Mailgroup> {
        private final Mailgroups mailgroups;
        private final Map<String, Object> pathParams = new HashMap<String, Object>();
        private final List<RequestOptFn> optFns = new ArrayList<RequestOptFn>();
        private Mailgroup result;

        private MailgroupGetReqCall(Mailgroups mailgroups, RequestOptFn ... optFns) {
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new Mailgroup();
            this.mailgroups = mailgroups;
        }

        public MailgroupGetReqCall setMailgroupId(String mailgroupId) {
            this.pathParams.put("mailgroup_id", mailgroupId);
            return this;
        }

        @Override
        public Response<Mailgroup> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            Request<Object, Mailgroup> request = Request.newRequest("/open-apis/mail/v1/mailgroups/:mailgroup_id", "GET", new AccessTokenType[]{AccessTokenType.Tenant}, null, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.mailgroups.service.config, request);
        }
    }

    public static class Mailgroups {
        private final MailService service;

        public Mailgroups(MailService service) {
            this.service = service;
        }

        public MailgroupGetReqCall get(RequestOptFn ... optFns) {
            return new MailgroupGetReqCall(this, optFns);
        }

        public MailgroupUpdateReqCall update(Mailgroup body, RequestOptFn ... optFns) {
            return new MailgroupUpdateReqCall(this, body, optFns);
        }

        public MailgroupDeleteReqCall delete(RequestOptFn ... optFns) {
            return new MailgroupDeleteReqCall(this, optFns);
        }

        public MailgroupCreateReqCall create(Mailgroup body, RequestOptFn ... optFns) {
            return new MailgroupCreateReqCall(this, body, optFns);
        }

        public MailgroupListReqCall list(RequestOptFn ... optFns) {
            return new MailgroupListReqCall(this, optFns);
        }

        public MailgroupPatchReqCall patch(Mailgroup body, RequestOptFn ... optFns) {
            return new MailgroupPatchReqCall(this, body, optFns);
        }
    }

    public static class PublicMailboxMemberCreateReqCall
    extends ReqCaller<PublicMailboxMember, PublicMailboxMember> {
        private final PublicMailboxMembers publicMailboxMembers;
        private final PublicMailboxMember body;
        private final Map<String, Object> pathParams;
        private final Map<String, Object> queryParams;
        private final List<RequestOptFn> optFns;
        private PublicMailboxMember result;

        private PublicMailboxMemberCreateReqCall(PublicMailboxMembers publicMailboxMembers, PublicMailboxMember body, RequestOptFn ... optFns) {
            this.body = body;
            this.pathParams = new HashMap<String, Object>();
            this.queryParams = new HashMap<String, Object>();
            this.optFns = new ArrayList<RequestOptFn>();
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new PublicMailboxMember();
            this.publicMailboxMembers = publicMailboxMembers;
        }

        public PublicMailboxMemberCreateReqCall setPublicMailboxId(String publicMailboxId) {
            this.pathParams.put("public_mailbox_id", publicMailboxId);
            return this;
        }

        public PublicMailboxMemberCreateReqCall setUserIdType(String userIdType) {
            this.queryParams.put("user_id_type", userIdType);
            return this;
        }

        @Override
        public Response<PublicMailboxMember> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            this.optFns.add(Request.setQueryParams(this.queryParams));
            Request<PublicMailboxMember, PublicMailboxMember> request = Request.newRequest("/open-apis/mail/v1/public_mailboxes/:public_mailbox_id/members", "POST", new AccessTokenType[]{AccessTokenType.Tenant}, this.body, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.publicMailboxMembers.service.config, request);
        }
    }

    public static class PublicMailboxMemberListReqCall
    extends ReqCaller<Object, PublicMailboxMemberListResult> {
        private final PublicMailboxMembers publicMailboxMembers;
        private final Map<String, Object> pathParams = new HashMap<String, Object>();
        private final Map<String, Object> queryParams = new HashMap<String, Object>();
        private final List<RequestOptFn> optFns = new ArrayList<RequestOptFn>();
        private PublicMailboxMemberListResult result;

        private PublicMailboxMemberListReqCall(PublicMailboxMembers publicMailboxMembers, RequestOptFn ... optFns) {
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new PublicMailboxMemberListResult();
            this.publicMailboxMembers = publicMailboxMembers;
        }

        public PublicMailboxMemberListReqCall setPublicMailboxId(String publicMailboxId) {
            this.pathParams.put("public_mailbox_id", publicMailboxId);
            return this;
        }

        public PublicMailboxMemberListReqCall setUserIdType(String userIdType) {
            this.queryParams.put("user_id_type", userIdType);
            return this;
        }

        public PublicMailboxMemberListReqCall setPageToken(String pageToken) {
            this.queryParams.put("page_token", pageToken);
            return this;
        }

        public PublicMailboxMemberListReqCall setPageSize(Integer pageSize) {
            this.queryParams.put("page_size", pageSize);
            return this;
        }

        @Override
        public Response<PublicMailboxMemberListResult> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            this.optFns.add(Request.setQueryParams(this.queryParams));
            Request<Object, PublicMailboxMemberListResult> request = Request.newRequest("/open-apis/mail/v1/public_mailboxes/:public_mailbox_id/members", "GET", new AccessTokenType[]{AccessTokenType.Tenant}, null, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.publicMailboxMembers.service.config, request);
        }
    }

    public static class PublicMailboxMemberClearReqCall
    extends ReqCaller<Object, EmptyData> {
        private final PublicMailboxMembers publicMailboxMembers;
        private final Map<String, Object> pathParams = new HashMap<String, Object>();
        private final List<RequestOptFn> optFns = new ArrayList<RequestOptFn>();
        private EmptyData result;

        private PublicMailboxMemberClearReqCall(PublicMailboxMembers publicMailboxMembers, RequestOptFn ... optFns) {
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new EmptyData();
            this.publicMailboxMembers = publicMailboxMembers;
        }

        public PublicMailboxMemberClearReqCall setPublicMailboxId(String publicMailboxId) {
            this.pathParams.put("public_mailbox_id", publicMailboxId);
            return this;
        }

        @Override
        public Response<EmptyData> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            Request<Object, EmptyData> request = Request.newRequest("/open-apis/mail/v1/public_mailboxes/:public_mailbox_id/members/clear", "POST", new AccessTokenType[]{AccessTokenType.Tenant}, null, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.publicMailboxMembers.service.config, request);
        }
    }

    public static class PublicMailboxMemberDeleteReqCall
    extends ReqCaller<Object, EmptyData> {
        private final PublicMailboxMembers publicMailboxMembers;
        private final Map<String, Object> pathParams = new HashMap<String, Object>();
        private final List<RequestOptFn> optFns = new ArrayList<RequestOptFn>();
        private EmptyData result;

        private PublicMailboxMemberDeleteReqCall(PublicMailboxMembers publicMailboxMembers, RequestOptFn ... optFns) {
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new EmptyData();
            this.publicMailboxMembers = publicMailboxMembers;
        }

        public PublicMailboxMemberDeleteReqCall setPublicMailboxId(String publicMailboxId) {
            this.pathParams.put("public_mailbox_id", publicMailboxId);
            return this;
        }

        public PublicMailboxMemberDeleteReqCall setMemberId(String memberId) {
            this.pathParams.put("member_id", memberId);
            return this;
        }

        @Override
        public Response<EmptyData> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            Request<Object, EmptyData> request = Request.newRequest("/open-apis/mail/v1/public_mailboxes/:public_mailbox_id/members/:member_id", "DELETE", new AccessTokenType[]{AccessTokenType.Tenant}, null, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.publicMailboxMembers.service.config, request);
        }
    }

    public static class PublicMailboxMemberGetReqCall
    extends ReqCaller<Object, PublicMailboxMember> {
        private final PublicMailboxMembers publicMailboxMembers;
        private final Map<String, Object> pathParams = new HashMap<String, Object>();
        private final Map<String, Object> queryParams = new HashMap<String, Object>();
        private final List<RequestOptFn> optFns = new ArrayList<RequestOptFn>();
        private PublicMailboxMember result;

        private PublicMailboxMemberGetReqCall(PublicMailboxMembers publicMailboxMembers, RequestOptFn ... optFns) {
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new PublicMailboxMember();
            this.publicMailboxMembers = publicMailboxMembers;
        }

        public PublicMailboxMemberGetReqCall setPublicMailboxId(String publicMailboxId) {
            this.pathParams.put("public_mailbox_id", publicMailboxId);
            return this;
        }

        public PublicMailboxMemberGetReqCall setMemberId(String memberId) {
            this.pathParams.put("member_id", memberId);
            return this;
        }

        public PublicMailboxMemberGetReqCall setUserIdType(String userIdType) {
            this.queryParams.put("user_id_type", userIdType);
            return this;
        }

        @Override
        public Response<PublicMailboxMember> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            this.optFns.add(Request.setQueryParams(this.queryParams));
            Request<Object, PublicMailboxMember> request = Request.newRequest("/open-apis/mail/v1/public_mailboxes/:public_mailbox_id/members/:member_id", "GET", new AccessTokenType[]{AccessTokenType.Tenant}, null, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.publicMailboxMembers.service.config, request);
        }
    }

    public static class PublicMailboxMembers {
        private final MailService service;

        public PublicMailboxMembers(MailService service) {
            this.service = service;
        }

        public PublicMailboxMemberGetReqCall get(RequestOptFn ... optFns) {
            return new PublicMailboxMemberGetReqCall(this, optFns);
        }

        public PublicMailboxMemberDeleteReqCall delete(RequestOptFn ... optFns) {
            return new PublicMailboxMemberDeleteReqCall(this, optFns);
        }

        public PublicMailboxMemberClearReqCall clear(RequestOptFn ... optFns) {
            return new PublicMailboxMemberClearReqCall(this, optFns);
        }

        public PublicMailboxMemberListReqCall list(RequestOptFn ... optFns) {
            return new PublicMailboxMemberListReqCall(this, optFns);
        }

        public PublicMailboxMemberCreateReqCall create(PublicMailboxMember body, RequestOptFn ... optFns) {
            return new PublicMailboxMemberCreateReqCall(this, body, optFns);
        }
    }

    public static class PublicMailboxPatchReqCall
    extends ReqCaller<PublicMailbox, PublicMailbox> {
        private final PublicMailboxs publicMailboxs;
        private final PublicMailbox body;
        private final Map<String, Object> pathParams;
        private final List<RequestOptFn> optFns;
        private PublicMailbox result;

        private PublicMailboxPatchReqCall(PublicMailboxs publicMailboxs, PublicMailbox body, RequestOptFn ... optFns) {
            this.body = body;
            this.pathParams = new HashMap<String, Object>();
            this.optFns = new ArrayList<RequestOptFn>();
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new PublicMailbox();
            this.publicMailboxs = publicMailboxs;
        }

        public PublicMailboxPatchReqCall setPublicMailboxId(String publicMailboxId) {
            this.pathParams.put("public_mailbox_id", publicMailboxId);
            return this;
        }

        @Override
        public Response<PublicMailbox> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            Request<PublicMailbox, PublicMailbox> request = Request.newRequest("/open-apis/mail/v1/public_mailboxes/:public_mailbox_id", "PATCH", new AccessTokenType[]{AccessTokenType.Tenant}, this.body, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.publicMailboxs.service.config, request);
        }
    }

    public static class PublicMailboxGetReqCall
    extends ReqCaller<Object, PublicMailbox> {
        private final PublicMailboxs publicMailboxs;
        private final Map<String, Object> pathParams = new HashMap<String, Object>();
        private final List<RequestOptFn> optFns = new ArrayList<RequestOptFn>();
        private PublicMailbox result;

        private PublicMailboxGetReqCall(PublicMailboxs publicMailboxs, RequestOptFn ... optFns) {
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new PublicMailbox();
            this.publicMailboxs = publicMailboxs;
        }

        public PublicMailboxGetReqCall setPublicMailboxId(String publicMailboxId) {
            this.pathParams.put("public_mailbox_id", publicMailboxId);
            return this;
        }

        @Override
        public Response<PublicMailbox> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            Request<Object, PublicMailbox> request = Request.newRequest("/open-apis/mail/v1/public_mailboxes/:public_mailbox_id", "GET", new AccessTokenType[]{AccessTokenType.Tenant}, null, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.publicMailboxs.service.config, request);
        }
    }

    public static class PublicMailboxCreateReqCall
    extends ReqCaller<PublicMailbox, PublicMailbox> {
        private final PublicMailboxs publicMailboxs;
        private final PublicMailbox body;
        private final List<RequestOptFn> optFns;
        private PublicMailbox result;

        private PublicMailboxCreateReqCall(PublicMailboxs publicMailboxs, PublicMailbox body, RequestOptFn ... optFns) {
            this.body = body;
            this.optFns = new ArrayList<RequestOptFn>();
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new PublicMailbox();
            this.publicMailboxs = publicMailboxs;
        }

        @Override
        public Response<PublicMailbox> execute() throws Exception {
            Request<PublicMailbox, PublicMailbox> request = Request.newRequest("/open-apis/mail/v1/public_mailboxes", "POST", new AccessTokenType[]{AccessTokenType.Tenant}, this.body, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.publicMailboxs.service.config, request);
        }
    }

    public static class PublicMailboxListReqCall
    extends ReqCaller<Object, PublicMailboxListResult> {
        private final PublicMailboxs publicMailboxs;
        private final Map<String, Object> queryParams = new HashMap<String, Object>();
        private final List<RequestOptFn> optFns = new ArrayList<RequestOptFn>();
        private PublicMailboxListResult result;

        private PublicMailboxListReqCall(PublicMailboxs publicMailboxs, RequestOptFn ... optFns) {
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new PublicMailboxListResult();
            this.publicMailboxs = publicMailboxs;
        }

        public PublicMailboxListReqCall setPageToken(String pageToken) {
            this.queryParams.put("page_token", pageToken);
            return this;
        }

        public PublicMailboxListReqCall setPageSize(Integer pageSize) {
            this.queryParams.put("page_size", pageSize);
            return this;
        }

        @Override
        public Response<PublicMailboxListResult> execute() throws Exception {
            this.optFns.add(Request.setQueryParams(this.queryParams));
            Request<Object, PublicMailboxListResult> request = Request.newRequest("/open-apis/mail/v1/public_mailboxes", "GET", new AccessTokenType[]{AccessTokenType.Tenant}, null, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.publicMailboxs.service.config, request);
        }
    }

    public static class PublicMailboxUpdateReqCall
    extends ReqCaller<PublicMailbox, PublicMailbox> {
        private final PublicMailboxs publicMailboxs;
        private final PublicMailbox body;
        private final Map<String, Object> pathParams;
        private final List<RequestOptFn> optFns;
        private PublicMailbox result;

        private PublicMailboxUpdateReqCall(PublicMailboxs publicMailboxs, PublicMailbox body, RequestOptFn ... optFns) {
            this.body = body;
            this.pathParams = new HashMap<String, Object>();
            this.optFns = new ArrayList<RequestOptFn>();
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new PublicMailbox();
            this.publicMailboxs = publicMailboxs;
        }

        public PublicMailboxUpdateReqCall setPublicMailboxId(String publicMailboxId) {
            this.pathParams.put("public_mailbox_id", publicMailboxId);
            return this;
        }

        @Override
        public Response<PublicMailbox> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            Request<PublicMailbox, PublicMailbox> request = Request.newRequest("/open-apis/mail/v1/public_mailboxes/:public_mailbox_id", "PUT", new AccessTokenType[]{AccessTokenType.Tenant}, this.body, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.publicMailboxs.service.config, request);
        }
    }

    public static class PublicMailboxs {
        private final MailService service;

        public PublicMailboxs(MailService service) {
            this.service = service;
        }

        public PublicMailboxUpdateReqCall update(PublicMailbox body, RequestOptFn ... optFns) {
            return new PublicMailboxUpdateReqCall(this, body, optFns);
        }

        public PublicMailboxListReqCall list(RequestOptFn ... optFns) {
            return new PublicMailboxListReqCall(this, optFns);
        }

        public PublicMailboxCreateReqCall create(PublicMailbox body, RequestOptFn ... optFns) {
            return new PublicMailboxCreateReqCall(this, body, optFns);
        }

        public PublicMailboxGetReqCall get(RequestOptFn ... optFns) {
            return new PublicMailboxGetReqCall(this, optFns);
        }

        public PublicMailboxPatchReqCall patch(PublicMailbox body, RequestOptFn ... optFns) {
            return new PublicMailboxPatchReqCall(this, body, optFns);
        }
    }

    public static class MailgroupPermissionMemberCreateReqCall
    extends ReqCaller<MailgroupPermissionMember, MailgroupPermissionMember> {
        private final MailgroupPermissionMembers mailgroupPermissionMembers;
        private final MailgroupPermissionMember body;
        private final Map<String, Object> pathParams;
        private final Map<String, Object> queryParams;
        private final List<RequestOptFn> optFns;
        private MailgroupPermissionMember result;

        private MailgroupPermissionMemberCreateReqCall(MailgroupPermissionMembers mailgroupPermissionMembers, MailgroupPermissionMember body, RequestOptFn ... optFns) {
            this.body = body;
            this.pathParams = new HashMap<String, Object>();
            this.queryParams = new HashMap<String, Object>();
            this.optFns = new ArrayList<RequestOptFn>();
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new MailgroupPermissionMember();
            this.mailgroupPermissionMembers = mailgroupPermissionMembers;
        }

        public MailgroupPermissionMemberCreateReqCall setMailgroupId(String mailgroupId) {
            this.pathParams.put("mailgroup_id", mailgroupId);
            return this;
        }

        public MailgroupPermissionMemberCreateReqCall setUserIdType(String userIdType) {
            this.queryParams.put("user_id_type", userIdType);
            return this;
        }

        public MailgroupPermissionMemberCreateReqCall setDepartmentIdType(String departmentIdType) {
            this.queryParams.put("department_id_type", departmentIdType);
            return this;
        }

        @Override
        public Response<MailgroupPermissionMember> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            this.optFns.add(Request.setQueryParams(this.queryParams));
            Request<MailgroupPermissionMember, MailgroupPermissionMember> request = Request.newRequest("/open-apis/mail/v1/mailgroups/:mailgroup_id/permission_members", "POST", new AccessTokenType[]{AccessTokenType.Tenant}, this.body, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.mailgroupPermissionMembers.service.config, request);
        }
    }

    public static class MailgroupPermissionMemberListReqCall
    extends ReqCaller<Object, MailgroupPermissionMemberListResult> {
        private final MailgroupPermissionMembers mailgroupPermissionMembers;
        private final Map<String, Object> pathParams = new HashMap<String, Object>();
        private final Map<String, Object> queryParams = new HashMap<String, Object>();
        private final List<RequestOptFn> optFns = new ArrayList<RequestOptFn>();
        private MailgroupPermissionMemberListResult result;

        private MailgroupPermissionMemberListReqCall(MailgroupPermissionMembers mailgroupPermissionMembers, RequestOptFn ... optFns) {
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new MailgroupPermissionMemberListResult();
            this.mailgroupPermissionMembers = mailgroupPermissionMembers;
        }

        public MailgroupPermissionMemberListReqCall setMailgroupId(String mailgroupId) {
            this.pathParams.put("mailgroup_id", mailgroupId);
            return this;
        }

        public MailgroupPermissionMemberListReqCall setUserIdType(String userIdType) {
            this.queryParams.put("user_id_type", userIdType);
            return this;
        }

        public MailgroupPermissionMemberListReqCall setDepartmentIdType(String departmentIdType) {
            this.queryParams.put("department_id_type", departmentIdType);
            return this;
        }

        public MailgroupPermissionMemberListReqCall setPageToken(String pageToken) {
            this.queryParams.put("page_token", pageToken);
            return this;
        }

        public MailgroupPermissionMemberListReqCall setPageSize(Integer pageSize) {
            this.queryParams.put("page_size", pageSize);
            return this;
        }

        @Override
        public Response<MailgroupPermissionMemberListResult> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            this.optFns.add(Request.setQueryParams(this.queryParams));
            Request<Object, MailgroupPermissionMemberListResult> request = Request.newRequest("/open-apis/mail/v1/mailgroups/:mailgroup_id/permission_members", "GET", new AccessTokenType[]{AccessTokenType.Tenant}, null, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.mailgroupPermissionMembers.service.config, request);
        }
    }

    public static class MailgroupPermissionMemberGetReqCall
    extends ReqCaller<Object, MailgroupPermissionMember> {
        private final MailgroupPermissionMembers mailgroupPermissionMembers;
        private final Map<String, Object> pathParams = new HashMap<String, Object>();
        private final Map<String, Object> queryParams = new HashMap<String, Object>();
        private final List<RequestOptFn> optFns = new ArrayList<RequestOptFn>();
        private MailgroupPermissionMember result;

        private MailgroupPermissionMemberGetReqCall(MailgroupPermissionMembers mailgroupPermissionMembers, RequestOptFn ... optFns) {
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new MailgroupPermissionMember();
            this.mailgroupPermissionMembers = mailgroupPermissionMembers;
        }

        public MailgroupPermissionMemberGetReqCall setMailgroupId(String mailgroupId) {
            this.pathParams.put("mailgroup_id", mailgroupId);
            return this;
        }

        public MailgroupPermissionMemberGetReqCall setPermissionMemberId(String permissionMemberId) {
            this.pathParams.put("permission_member_id", permissionMemberId);
            return this;
        }

        public MailgroupPermissionMemberGetReqCall setUserIdType(String userIdType) {
            this.queryParams.put("user_id_type", userIdType);
            return this;
        }

        public MailgroupPermissionMemberGetReqCall setDepartmentIdType(String departmentIdType) {
            this.queryParams.put("department_id_type", departmentIdType);
            return this;
        }

        @Override
        public Response<MailgroupPermissionMember> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            this.optFns.add(Request.setQueryParams(this.queryParams));
            Request<Object, MailgroupPermissionMember> request = Request.newRequest("/open-apis/mail/v1/mailgroups/:mailgroup_id/permission_members/:permission_member_id", "GET", new AccessTokenType[]{AccessTokenType.Tenant}, null, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.mailgroupPermissionMembers.service.config, request);
        }
    }

    public static class MailgroupPermissionMemberDeleteReqCall
    extends ReqCaller<Object, EmptyData> {
        private final MailgroupPermissionMembers mailgroupPermissionMembers;
        private final Map<String, Object> pathParams = new HashMap<String, Object>();
        private final List<RequestOptFn> optFns = new ArrayList<RequestOptFn>();
        private EmptyData result;

        private MailgroupPermissionMemberDeleteReqCall(MailgroupPermissionMembers mailgroupPermissionMembers, RequestOptFn ... optFns) {
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new EmptyData();
            this.mailgroupPermissionMembers = mailgroupPermissionMembers;
        }

        public MailgroupPermissionMemberDeleteReqCall setMailgroupId(String mailgroupId) {
            this.pathParams.put("mailgroup_id", mailgroupId);
            return this;
        }

        public MailgroupPermissionMemberDeleteReqCall setPermissionMemberId(String permissionMemberId) {
            this.pathParams.put("permission_member_id", permissionMemberId);
            return this;
        }

        @Override
        public Response<EmptyData> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            Request<Object, EmptyData> request = Request.newRequest("/open-apis/mail/v1/mailgroups/:mailgroup_id/permission_members/:permission_member_id", "DELETE", new AccessTokenType[]{AccessTokenType.Tenant}, null, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.mailgroupPermissionMembers.service.config, request);
        }
    }

    public static class MailgroupPermissionMembers {
        private final MailService service;

        public MailgroupPermissionMembers(MailService service) {
            this.service = service;
        }

        public MailgroupPermissionMemberDeleteReqCall delete(RequestOptFn ... optFns) {
            return new MailgroupPermissionMemberDeleteReqCall(this, optFns);
        }

        public MailgroupPermissionMemberGetReqCall get(RequestOptFn ... optFns) {
            return new MailgroupPermissionMemberGetReqCall(this, optFns);
        }

        public MailgroupPermissionMemberListReqCall list(RequestOptFn ... optFns) {
            return new MailgroupPermissionMemberListReqCall(this, optFns);
        }

        public MailgroupPermissionMemberCreateReqCall create(MailgroupPermissionMember body, RequestOptFn ... optFns) {
            return new MailgroupPermissionMemberCreateReqCall(this, body, optFns);
        }
    }

    public static class MailgroupMemberDeleteReqCall
    extends ReqCaller<Object, EmptyData> {
        private final MailgroupMembers mailgroupMembers;
        private final Map<String, Object> pathParams = new HashMap<String, Object>();
        private final List<RequestOptFn> optFns = new ArrayList<RequestOptFn>();
        private EmptyData result;

        private MailgroupMemberDeleteReqCall(MailgroupMembers mailgroupMembers, RequestOptFn ... optFns) {
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new EmptyData();
            this.mailgroupMembers = mailgroupMembers;
        }

        public MailgroupMemberDeleteReqCall setMailgroupId(String mailgroupId) {
            this.pathParams.put("mailgroup_id", mailgroupId);
            return this;
        }

        public MailgroupMemberDeleteReqCall setMemberId(String memberId) {
            this.pathParams.put("member_id", memberId);
            return this;
        }

        @Override
        public Response<EmptyData> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            Request<Object, EmptyData> request = Request.newRequest("/open-apis/mail/v1/mailgroups/:mailgroup_id/members/:member_id", "DELETE", new AccessTokenType[]{AccessTokenType.Tenant}, null, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.mailgroupMembers.service.config, request);
        }
    }

    public static class MailgroupMemberCreateReqCall
    extends ReqCaller<MailgroupMember, MailgroupMember> {
        private final MailgroupMembers mailgroupMembers;
        private final MailgroupMember body;
        private final Map<String, Object> pathParams;
        private final Map<String, Object> queryParams;
        private final List<RequestOptFn> optFns;
        private MailgroupMember result;

        private MailgroupMemberCreateReqCall(MailgroupMembers mailgroupMembers, MailgroupMember body, RequestOptFn ... optFns) {
            this.body = body;
            this.pathParams = new HashMap<String, Object>();
            this.queryParams = new HashMap<String, Object>();
            this.optFns = new ArrayList<RequestOptFn>();
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new MailgroupMember();
            this.mailgroupMembers = mailgroupMembers;
        }

        public MailgroupMemberCreateReqCall setMailgroupId(String mailgroupId) {
            this.pathParams.put("mailgroup_id", mailgroupId);
            return this;
        }

        public MailgroupMemberCreateReqCall setUserIdType(String userIdType) {
            this.queryParams.put("user_id_type", userIdType);
            return this;
        }

        public MailgroupMemberCreateReqCall setDepartmentIdType(String departmentIdType) {
            this.queryParams.put("department_id_type", departmentIdType);
            return this;
        }

        @Override
        public Response<MailgroupMember> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            this.optFns.add(Request.setQueryParams(this.queryParams));
            Request<MailgroupMember, MailgroupMember> request = Request.newRequest("/open-apis/mail/v1/mailgroups/:mailgroup_id/members", "POST", new AccessTokenType[]{AccessTokenType.Tenant}, this.body, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.mailgroupMembers.service.config, request);
        }
    }

    public static class MailgroupMemberGetReqCall
    extends ReqCaller<Object, MailgroupMember> {
        private final MailgroupMembers mailgroupMembers;
        private final Map<String, Object> pathParams = new HashMap<String, Object>();
        private final Map<String, Object> queryParams = new HashMap<String, Object>();
        private final List<RequestOptFn> optFns = new ArrayList<RequestOptFn>();
        private MailgroupMember result;

        private MailgroupMemberGetReqCall(MailgroupMembers mailgroupMembers, RequestOptFn ... optFns) {
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new MailgroupMember();
            this.mailgroupMembers = mailgroupMembers;
        }

        public MailgroupMemberGetReqCall setMailgroupId(String mailgroupId) {
            this.pathParams.put("mailgroup_id", mailgroupId);
            return this;
        }

        public MailgroupMemberGetReqCall setMemberId(String memberId) {
            this.pathParams.put("member_id", memberId);
            return this;
        }

        public MailgroupMemberGetReqCall setUserIdType(String userIdType) {
            this.queryParams.put("user_id_type", userIdType);
            return this;
        }

        public MailgroupMemberGetReqCall setDepartmentIdType(String departmentIdType) {
            this.queryParams.put("department_id_type", departmentIdType);
            return this;
        }

        @Override
        public Response<MailgroupMember> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            this.optFns.add(Request.setQueryParams(this.queryParams));
            Request<Object, MailgroupMember> request = Request.newRequest("/open-apis/mail/v1/mailgroups/:mailgroup_id/members/:member_id", "GET", new AccessTokenType[]{AccessTokenType.Tenant}, null, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.mailgroupMembers.service.config, request);
        }
    }

    public static class MailgroupMemberListReqCall
    extends ReqCaller<Object, MailgroupMemberListResult> {
        private final MailgroupMembers mailgroupMembers;
        private final Map<String, Object> pathParams = new HashMap<String, Object>();
        private final Map<String, Object> queryParams = new HashMap<String, Object>();
        private final List<RequestOptFn> optFns = new ArrayList<RequestOptFn>();
        private MailgroupMemberListResult result;

        private MailgroupMemberListReqCall(MailgroupMembers mailgroupMembers, RequestOptFn ... optFns) {
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new MailgroupMemberListResult();
            this.mailgroupMembers = mailgroupMembers;
        }

        public MailgroupMemberListReqCall setMailgroupId(String mailgroupId) {
            this.pathParams.put("mailgroup_id", mailgroupId);
            return this;
        }

        public MailgroupMemberListReqCall setUserIdType(String userIdType) {
            this.queryParams.put("user_id_type", userIdType);
            return this;
        }

        public MailgroupMemberListReqCall setDepartmentIdType(String departmentIdType) {
            this.queryParams.put("department_id_type", departmentIdType);
            return this;
        }

        public MailgroupMemberListReqCall setPageToken(String pageToken) {
            this.queryParams.put("page_token", pageToken);
            return this;
        }

        public MailgroupMemberListReqCall setPageSize(Integer pageSize) {
            this.queryParams.put("page_size", pageSize);
            return this;
        }

        @Override
        public Response<MailgroupMemberListResult> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            this.optFns.add(Request.setQueryParams(this.queryParams));
            Request<Object, MailgroupMemberListResult> request = Request.newRequest("/open-apis/mail/v1/mailgroups/:mailgroup_id/members", "GET", new AccessTokenType[]{AccessTokenType.Tenant}, null, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.mailgroupMembers.service.config, request);
        }
    }

    public static class MailgroupMembers {
        private final MailService service;

        public MailgroupMembers(MailService service) {
            this.service = service;
        }

        public MailgroupMemberListReqCall list(RequestOptFn ... optFns) {
            return new MailgroupMemberListReqCall(this, optFns);
        }

        public MailgroupMemberGetReqCall get(RequestOptFn ... optFns) {
            return new MailgroupMemberGetReqCall(this, optFns);
        }

        public MailgroupMemberCreateReqCall create(MailgroupMember body, RequestOptFn ... optFns) {
            return new MailgroupMemberCreateReqCall(this, body, optFns);
        }

        public MailgroupMemberDeleteReqCall delete(RequestOptFn ... optFns) {
            return new MailgroupMemberDeleteReqCall(this, optFns);
        }
    }
}

