/*
 * Decompiled with CFR 0.152.
 */
package com.larksuite.oapi.service.task.v1;

import com.larksuite.oapi.core.Config;
import com.larksuite.oapi.core.api.AccessTokenType;
import com.larksuite.oapi.core.api.Api;
import com.larksuite.oapi.core.api.ReqCaller;
import com.larksuite.oapi.core.api.request.Request;
import com.larksuite.oapi.core.api.request.RequestOptFn;
import com.larksuite.oapi.core.api.response.EmptyData;
import com.larksuite.oapi.core.api.response.Response;
import com.larksuite.oapi.core.event.Event;
import com.larksuite.oapi.core.event.IHandler;
import com.larksuite.oapi.service.task.v1.model.Collaborator;
import com.larksuite.oapi.service.task.v1.model.Comment;
import com.larksuite.oapi.service.task.v1.model.Follower;
import com.larksuite.oapi.service.task.v1.model.Reminder;
import com.larksuite.oapi.service.task.v1.model.Task;
import com.larksuite.oapi.service.task.v1.model.TaskCollaboratorCreateResult;
import com.larksuite.oapi.service.task.v1.model.TaskCollaboratorListResult;
import com.larksuite.oapi.service.task.v1.model.TaskCommentCreateResult;
import com.larksuite.oapi.service.task.v1.model.TaskCommentGetResult;
import com.larksuite.oapi.service.task.v1.model.TaskCommentUpdateReqBody;
import com.larksuite.oapi.service.task.v1.model.TaskCommentUpdateResult;
import com.larksuite.oapi.service.task.v1.model.TaskCommentUpdatedEvent;
import com.larksuite.oapi.service.task.v1.model.TaskCreateResult;
import com.larksuite.oapi.service.task.v1.model.TaskFollowerCreateResult;
import com.larksuite.oapi.service.task.v1.model.TaskFollowerListResult;
import com.larksuite.oapi.service.task.v1.model.TaskGetResult;
import com.larksuite.oapi.service.task.v1.model.TaskPatchReqBody;
import com.larksuite.oapi.service.task.v1.model.TaskPatchResult;
import com.larksuite.oapi.service.task.v1.model.TaskReminderCreateResult;
import com.larksuite.oapi.service.task.v1.model.TaskReminderListResult;
import com.larksuite.oapi.service.task.v1.model.TaskUpdatedEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TaskService {
    private final Config config;
    private final Tasks tasks;
    private final TaskComments taskComments;
    private final TaskCollaborators taskCollaborators;
    private final TaskFollowers taskFollowers;
    private final TaskReminders taskReminders;

    public TaskService(Config config) {
        this.config = config;
        this.tasks = new Tasks(this);
        this.taskComments = new TaskComments(this);
        this.taskCollaborators = new TaskCollaborators(this);
        this.taskFollowers = new TaskFollowers(this);
        this.taskReminders = new TaskReminders(this);
    }

    public Tasks getTasks() {
        return this.tasks;
    }

    public TaskComments getTaskComments() {
        return this.taskComments;
    }

    public TaskCollaborators getTaskCollaborators() {
        return this.taskCollaborators;
    }

    public TaskFollowers getTaskFollowers() {
        return this.taskFollowers;
    }

    public TaskReminders getTaskReminders() {
        return this.taskReminders;
    }

    public void setTaskUpdatedEventHandler(TaskUpdatedEventHandler handler) {
        Event.setTypeHandler(this.config, "task.task.updated_v1", handler);
    }

    public void setTaskCommentUpdatedEventHandler(TaskCommentUpdatedEventHandler handler) {
        Event.setTypeHandler(this.config, "task.task.comment.updated_v1", handler);
    }

    public static abstract class TaskCommentUpdatedEventHandler
    implements IHandler<TaskCommentUpdatedEvent> {
        @Override
        public TaskCommentUpdatedEvent getEvent() {
            return new TaskCommentUpdatedEvent();
        }
    }

    public static abstract class TaskUpdatedEventHandler
    implements IHandler<TaskUpdatedEvent> {
        @Override
        public TaskUpdatedEvent getEvent() {
            return new TaskUpdatedEvent();
        }
    }

    public static class TaskReminderListReqCall
    extends ReqCaller<Object, TaskReminderListResult> {
        private final TaskReminders taskReminders;
        private final Map<String, Object> pathParams = new HashMap<String, Object>();
        private final Map<String, Object> queryParams = new HashMap<String, Object>();
        private final List<RequestOptFn> optFns = new ArrayList<RequestOptFn>();
        private TaskReminderListResult result;

        private TaskReminderListReqCall(TaskReminders taskReminders, RequestOptFn ... optFns) {
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new TaskReminderListResult();
            this.taskReminders = taskReminders;
        }

        public TaskReminderListReqCall setTaskId(String taskId) {
            this.pathParams.put("task_id", taskId);
            return this;
        }

        public TaskReminderListReqCall setPageSize(Integer pageSize) {
            this.queryParams.put("page_size", pageSize);
            return this;
        }

        public TaskReminderListReqCall setPageToken(String pageToken) {
            this.queryParams.put("page_token", pageToken);
            return this;
        }

        @Override
        public Response<TaskReminderListResult> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            this.optFns.add(Request.setQueryParams(this.queryParams));
            Request<Object, TaskReminderListResult> request = Request.newRequest("/open-apis/task/v1/tasks/:task_id/reminders", "GET", new AccessTokenType[]{AccessTokenType.Tenant}, null, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.taskReminders.service.config, request);
        }
    }

    public static class TaskReminderDeleteReqCall
    extends ReqCaller<Object, EmptyData> {
        private final TaskReminders taskReminders;
        private final Map<String, Object> pathParams = new HashMap<String, Object>();
        private final List<RequestOptFn> optFns = new ArrayList<RequestOptFn>();
        private EmptyData result;

        private TaskReminderDeleteReqCall(TaskReminders taskReminders, RequestOptFn ... optFns) {
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new EmptyData();
            this.taskReminders = taskReminders;
        }

        public TaskReminderDeleteReqCall setTaskId(String taskId) {
            this.pathParams.put("task_id", taskId);
            return this;
        }

        public TaskReminderDeleteReqCall setReminderId(String reminderId) {
            this.pathParams.put("reminder_id", reminderId);
            return this;
        }

        @Override
        public Response<EmptyData> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            Request<Object, EmptyData> request = Request.newRequest("/open-apis/task/v1/tasks/:task_id/reminders/:reminder_id", "DELETE", new AccessTokenType[]{AccessTokenType.Tenant}, null, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.taskReminders.service.config, request);
        }
    }

    public static class TaskReminderCreateReqCall
    extends ReqCaller<Reminder, TaskReminderCreateResult> {
        private final TaskReminders taskReminders;
        private final Reminder body;
        private final Map<String, Object> pathParams;
        private final List<RequestOptFn> optFns;
        private TaskReminderCreateResult result;

        private TaskReminderCreateReqCall(TaskReminders taskReminders, Reminder body, RequestOptFn ... optFns) {
            this.body = body;
            this.pathParams = new HashMap<String, Object>();
            this.optFns = new ArrayList<RequestOptFn>();
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new TaskReminderCreateResult();
            this.taskReminders = taskReminders;
        }

        public TaskReminderCreateReqCall setTaskId(String taskId) {
            this.pathParams.put("task_id", taskId);
            return this;
        }

        @Override
        public Response<TaskReminderCreateResult> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            Request<Reminder, TaskReminderCreateResult> request = Request.newRequest("/open-apis/task/v1/tasks/:task_id/reminders", "POST", new AccessTokenType[]{AccessTokenType.Tenant}, this.body, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.taskReminders.service.config, request);
        }
    }

    public static class TaskReminders {
        private final TaskService service;

        public TaskReminders(TaskService service) {
            this.service = service;
        }

        public TaskReminderCreateReqCall create(Reminder body, RequestOptFn ... optFns) {
            return new TaskReminderCreateReqCall(this, body, optFns);
        }

        public TaskReminderDeleteReqCall delete(RequestOptFn ... optFns) {
            return new TaskReminderDeleteReqCall(this, optFns);
        }

        public TaskReminderListReqCall list(RequestOptFn ... optFns) {
            return new TaskReminderListReqCall(this, optFns);
        }
    }

    public static class TaskFollowerListReqCall
    extends ReqCaller<Object, TaskFollowerListResult> {
        private final TaskFollowers taskFollowers;
        private final Map<String, Object> pathParams = new HashMap<String, Object>();
        private final Map<String, Object> queryParams = new HashMap<String, Object>();
        private final List<RequestOptFn> optFns = new ArrayList<RequestOptFn>();
        private TaskFollowerListResult result;

        private TaskFollowerListReqCall(TaskFollowers taskFollowers, RequestOptFn ... optFns) {
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new TaskFollowerListResult();
            this.taskFollowers = taskFollowers;
        }

        public TaskFollowerListReqCall setTaskId(String taskId) {
            this.pathParams.put("task_id", taskId);
            return this;
        }

        public TaskFollowerListReqCall setPageSize(Integer pageSize) {
            this.queryParams.put("page_size", pageSize);
            return this;
        }

        public TaskFollowerListReqCall setPageToken(String pageToken) {
            this.queryParams.put("page_token", pageToken);
            return this;
        }

        public TaskFollowerListReqCall setUserIdType(String userIdType) {
            this.queryParams.put("user_id_type", userIdType);
            return this;
        }

        @Override
        public Response<TaskFollowerListResult> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            this.optFns.add(Request.setQueryParams(this.queryParams));
            Request<Object, TaskFollowerListResult> request = Request.newRequest("/open-apis/task/v1/tasks/:task_id/followers", "GET", new AccessTokenType[]{AccessTokenType.Tenant}, null, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.taskFollowers.service.config, request);
        }
    }

    public static class TaskFollowerDeleteReqCall
    extends ReqCaller<Object, EmptyData> {
        private final TaskFollowers taskFollowers;
        private final Map<String, Object> pathParams = new HashMap<String, Object>();
        private final List<RequestOptFn> optFns = new ArrayList<RequestOptFn>();
        private EmptyData result;

        private TaskFollowerDeleteReqCall(TaskFollowers taskFollowers, RequestOptFn ... optFns) {
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new EmptyData();
            this.taskFollowers = taskFollowers;
        }

        public TaskFollowerDeleteReqCall setTaskId(String taskId) {
            this.pathParams.put("task_id", taskId);
            return this;
        }

        public TaskFollowerDeleteReqCall setFollowerId(String followerId) {
            this.pathParams.put("follower_id", followerId);
            return this;
        }

        @Override
        public Response<EmptyData> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            Request<Object, EmptyData> request = Request.newRequest("/open-apis/task/v1/tasks/:task_id/followers/:follower_id", "DELETE", new AccessTokenType[]{AccessTokenType.Tenant}, null, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.taskFollowers.service.config, request);
        }
    }

    public static class TaskFollowerCreateReqCall
    extends ReqCaller<Follower, TaskFollowerCreateResult> {
        private final TaskFollowers taskFollowers;
        private final Follower body;
        private final Map<String, Object> pathParams;
        private final Map<String, Object> queryParams;
        private final List<RequestOptFn> optFns;
        private TaskFollowerCreateResult result;

        private TaskFollowerCreateReqCall(TaskFollowers taskFollowers, Follower body, RequestOptFn ... optFns) {
            this.body = body;
            this.pathParams = new HashMap<String, Object>();
            this.queryParams = new HashMap<String, Object>();
            this.optFns = new ArrayList<RequestOptFn>();
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new TaskFollowerCreateResult();
            this.taskFollowers = taskFollowers;
        }

        public TaskFollowerCreateReqCall setTaskId(String taskId) {
            this.pathParams.put("task_id", taskId);
            return this;
        }

        public TaskFollowerCreateReqCall setUserIdType(String userIdType) {
            this.queryParams.put("user_id_type", userIdType);
            return this;
        }

        @Override
        public Response<TaskFollowerCreateResult> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            this.optFns.add(Request.setQueryParams(this.queryParams));
            Request<Follower, TaskFollowerCreateResult> request = Request.newRequest("/open-apis/task/v1/tasks/:task_id/followers", "POST", new AccessTokenType[]{AccessTokenType.Tenant}, this.body, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.taskFollowers.service.config, request);
        }
    }

    public static class TaskFollowers {
        private final TaskService service;

        public TaskFollowers(TaskService service) {
            this.service = service;
        }

        public TaskFollowerCreateReqCall create(Follower body, RequestOptFn ... optFns) {
            return new TaskFollowerCreateReqCall(this, body, optFns);
        }

        public TaskFollowerDeleteReqCall delete(RequestOptFn ... optFns) {
            return new TaskFollowerDeleteReqCall(this, optFns);
        }

        public TaskFollowerListReqCall list(RequestOptFn ... optFns) {
            return new TaskFollowerListReqCall(this, optFns);
        }
    }

    public static class TaskCollaboratorListReqCall
    extends ReqCaller<Object, TaskCollaboratorListResult> {
        private final TaskCollaborators taskCollaborators;
        private final Map<String, Object> pathParams = new HashMap<String, Object>();
        private final Map<String, Object> queryParams = new HashMap<String, Object>();
        private final List<RequestOptFn> optFns = new ArrayList<RequestOptFn>();
        private TaskCollaboratorListResult result;

        private TaskCollaboratorListReqCall(TaskCollaborators taskCollaborators, RequestOptFn ... optFns) {
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new TaskCollaboratorListResult();
            this.taskCollaborators = taskCollaborators;
        }

        public TaskCollaboratorListReqCall setTaskId(String taskId) {
            this.pathParams.put("task_id", taskId);
            return this;
        }

        public TaskCollaboratorListReqCall setPageSize(Integer pageSize) {
            this.queryParams.put("page_size", pageSize);
            return this;
        }

        public TaskCollaboratorListReqCall setPageToken(String pageToken) {
            this.queryParams.put("page_token", pageToken);
            return this;
        }

        public TaskCollaboratorListReqCall setUserIdType(String userIdType) {
            this.queryParams.put("user_id_type", userIdType);
            return this;
        }

        @Override
        public Response<TaskCollaboratorListResult> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            this.optFns.add(Request.setQueryParams(this.queryParams));
            Request<Object, TaskCollaboratorListResult> request = Request.newRequest("/open-apis/task/v1/tasks/:task_id/collaborators", "GET", new AccessTokenType[]{AccessTokenType.Tenant}, null, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.taskCollaborators.service.config, request);
        }
    }

    public static class TaskCollaboratorDeleteReqCall
    extends ReqCaller<Object, EmptyData> {
        private final TaskCollaborators taskCollaborators;
        private final Map<String, Object> pathParams = new HashMap<String, Object>();
        private final List<RequestOptFn> optFns = new ArrayList<RequestOptFn>();
        private EmptyData result;

        private TaskCollaboratorDeleteReqCall(TaskCollaborators taskCollaborators, RequestOptFn ... optFns) {
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new EmptyData();
            this.taskCollaborators = taskCollaborators;
        }

        public TaskCollaboratorDeleteReqCall setTaskId(String taskId) {
            this.pathParams.put("task_id", taskId);
            return this;
        }

        public TaskCollaboratorDeleteReqCall setCollaboratorId(String collaboratorId) {
            this.pathParams.put("collaborator_id", collaboratorId);
            return this;
        }

        @Override
        public Response<EmptyData> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            Request<Object, EmptyData> request = Request.newRequest("/open-apis/task/v1/tasks/:task_id/collaborators/:collaborator_id", "DELETE", new AccessTokenType[]{AccessTokenType.Tenant}, null, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.taskCollaborators.service.config, request);
        }
    }

    public static class TaskCollaboratorCreateReqCall
    extends ReqCaller<Collaborator, TaskCollaboratorCreateResult> {
        private final TaskCollaborators taskCollaborators;
        private final Collaborator body;
        private final Map<String, Object> pathParams;
        private final Map<String, Object> queryParams;
        private final List<RequestOptFn> optFns;
        private TaskCollaboratorCreateResult result;

        private TaskCollaboratorCreateReqCall(TaskCollaborators taskCollaborators, Collaborator body, RequestOptFn ... optFns) {
            this.body = body;
            this.pathParams = new HashMap<String, Object>();
            this.queryParams = new HashMap<String, Object>();
            this.optFns = new ArrayList<RequestOptFn>();
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new TaskCollaboratorCreateResult();
            this.taskCollaborators = taskCollaborators;
        }

        public TaskCollaboratorCreateReqCall setTaskId(String taskId) {
            this.pathParams.put("task_id", taskId);
            return this;
        }

        public TaskCollaboratorCreateReqCall setUserIdType(String userIdType) {
            this.queryParams.put("user_id_type", userIdType);
            return this;
        }

        @Override
        public Response<TaskCollaboratorCreateResult> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            this.optFns.add(Request.setQueryParams(this.queryParams));
            Request<Collaborator, TaskCollaboratorCreateResult> request = Request.newRequest("/open-apis/task/v1/tasks/:task_id/collaborators", "POST", new AccessTokenType[]{AccessTokenType.Tenant}, this.body, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.taskCollaborators.service.config, request);
        }
    }

    public static class TaskCollaborators {
        private final TaskService service;

        public TaskCollaborators(TaskService service) {
            this.service = service;
        }

        public TaskCollaboratorCreateReqCall create(Collaborator body, RequestOptFn ... optFns) {
            return new TaskCollaboratorCreateReqCall(this, body, optFns);
        }

        public TaskCollaboratorDeleteReqCall delete(RequestOptFn ... optFns) {
            return new TaskCollaboratorDeleteReqCall(this, optFns);
        }

        public TaskCollaboratorListReqCall list(RequestOptFn ... optFns) {
            return new TaskCollaboratorListReqCall(this, optFns);
        }
    }

    public static class TaskCommentUpdateReqCall
    extends ReqCaller<TaskCommentUpdateReqBody, TaskCommentUpdateResult> {
        private final TaskComments taskComments;
        private final TaskCommentUpdateReqBody body;
        private final Map<String, Object> pathParams;
        private final List<RequestOptFn> optFns;
        private TaskCommentUpdateResult result;

        private TaskCommentUpdateReqCall(TaskComments taskComments, TaskCommentUpdateReqBody body, RequestOptFn ... optFns) {
            this.body = body;
            this.pathParams = new HashMap<String, Object>();
            this.optFns = new ArrayList<RequestOptFn>();
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new TaskCommentUpdateResult();
            this.taskComments = taskComments;
        }

        public TaskCommentUpdateReqCall setTaskId(String taskId) {
            this.pathParams.put("task_id", taskId);
            return this;
        }

        public TaskCommentUpdateReqCall setCommentId(Long commentId) {
            this.pathParams.put("comment_id", commentId);
            return this;
        }

        @Override
        public Response<TaskCommentUpdateResult> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            Request<TaskCommentUpdateReqBody, TaskCommentUpdateResult> request = Request.newRequest("/open-apis/task/v1/tasks/:task_id/comments/:comment_id", "PUT", new AccessTokenType[]{AccessTokenType.Tenant}, this.body, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.taskComments.service.config, request);
        }
    }

    public static class TaskCommentGetReqCall
    extends ReqCaller<Object, TaskCommentGetResult> {
        private final TaskComments taskComments;
        private final Map<String, Object> pathParams = new HashMap<String, Object>();
        private final List<RequestOptFn> optFns = new ArrayList<RequestOptFn>();
        private TaskCommentGetResult result;

        private TaskCommentGetReqCall(TaskComments taskComments, RequestOptFn ... optFns) {
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new TaskCommentGetResult();
            this.taskComments = taskComments;
        }

        public TaskCommentGetReqCall setTaskId(String taskId) {
            this.pathParams.put("task_id", taskId);
            return this;
        }

        public TaskCommentGetReqCall setCommentId(Long commentId) {
            this.pathParams.put("comment_id", commentId);
            return this;
        }

        @Override
        public Response<TaskCommentGetResult> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            Request<Object, TaskCommentGetResult> request = Request.newRequest("/open-apis/task/v1/tasks/:task_id/comments/:comment_id", "GET", new AccessTokenType[]{AccessTokenType.Tenant}, null, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.taskComments.service.config, request);
        }
    }

    public static class TaskCommentDeleteReqCall
    extends ReqCaller<Object, EmptyData> {
        private final TaskComments taskComments;
        private final Map<String, Object> pathParams = new HashMap<String, Object>();
        private final List<RequestOptFn> optFns = new ArrayList<RequestOptFn>();
        private EmptyData result;

        private TaskCommentDeleteReqCall(TaskComments taskComments, RequestOptFn ... optFns) {
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new EmptyData();
            this.taskComments = taskComments;
        }

        public TaskCommentDeleteReqCall setTaskId(String taskId) {
            this.pathParams.put("task_id", taskId);
            return this;
        }

        public TaskCommentDeleteReqCall setCommentId(Long commentId) {
            this.pathParams.put("comment_id", commentId);
            return this;
        }

        @Override
        public Response<EmptyData> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            Request<Object, EmptyData> request = Request.newRequest("/open-apis/task/v1/tasks/:task_id/comments/:comment_id", "DELETE", new AccessTokenType[]{AccessTokenType.Tenant}, null, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.taskComments.service.config, request);
        }
    }

    public static class TaskCommentCreateReqCall
    extends ReqCaller<Comment, TaskCommentCreateResult> {
        private final TaskComments taskComments;
        private final Comment body;
        private final Map<String, Object> pathParams;
        private final List<RequestOptFn> optFns;
        private TaskCommentCreateResult result;

        private TaskCommentCreateReqCall(TaskComments taskComments, Comment body, RequestOptFn ... optFns) {
            this.body = body;
            this.pathParams = new HashMap<String, Object>();
            this.optFns = new ArrayList<RequestOptFn>();
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new TaskCommentCreateResult();
            this.taskComments = taskComments;
        }

        public TaskCommentCreateReqCall setTaskId(String taskId) {
            this.pathParams.put("task_id", taskId);
            return this;
        }

        @Override
        public Response<TaskCommentCreateResult> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            Request<Comment, TaskCommentCreateResult> request = Request.newRequest("/open-apis/task/v1/tasks/:task_id/comments", "POST", new AccessTokenType[]{AccessTokenType.Tenant}, this.body, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.taskComments.service.config, request);
        }
    }

    public static class TaskComments {
        private final TaskService service;

        public TaskComments(TaskService service) {
            this.service = service;
        }

        public TaskCommentCreateReqCall create(Comment body, RequestOptFn ... optFns) {
            return new TaskCommentCreateReqCall(this, body, optFns);
        }

        public TaskCommentDeleteReqCall delete(RequestOptFn ... optFns) {
            return new TaskCommentDeleteReqCall(this, optFns);
        }

        public TaskCommentGetReqCall get(RequestOptFn ... optFns) {
            return new TaskCommentGetReqCall(this, optFns);
        }

        public TaskCommentUpdateReqCall update(TaskCommentUpdateReqBody body, RequestOptFn ... optFns) {
            return new TaskCommentUpdateReqCall(this, body, optFns);
        }
    }

    public static class TaskUncompleteReqCall
    extends ReqCaller<Object, EmptyData> {
        private final Tasks tasks;
        private final Map<String, Object> pathParams = new HashMap<String, Object>();
        private final List<RequestOptFn> optFns = new ArrayList<RequestOptFn>();
        private EmptyData result;

        private TaskUncompleteReqCall(Tasks tasks, RequestOptFn ... optFns) {
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new EmptyData();
            this.tasks = tasks;
        }

        public TaskUncompleteReqCall setTaskId(String taskId) {
            this.pathParams.put("task_id", taskId);
            return this;
        }

        @Override
        public Response<EmptyData> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            Request<Object, EmptyData> request = Request.newRequest("/open-apis/task/v1/tasks/:task_id/uncomplete", "POST", new AccessTokenType[]{AccessTokenType.Tenant}, null, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.tasks.service.config, request);
        }
    }

    public static class TaskPatchReqCall
    extends ReqCaller<TaskPatchReqBody, TaskPatchResult> {
        private final Tasks tasks;
        private final TaskPatchReqBody body;
        private final Map<String, Object> pathParams;
        private final Map<String, Object> queryParams;
        private final List<RequestOptFn> optFns;
        private TaskPatchResult result;

        private TaskPatchReqCall(Tasks tasks, TaskPatchReqBody body, RequestOptFn ... optFns) {
            this.body = body;
            this.pathParams = new HashMap<String, Object>();
            this.queryParams = new HashMap<String, Object>();
            this.optFns = new ArrayList<RequestOptFn>();
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new TaskPatchResult();
            this.tasks = tasks;
        }

        public TaskPatchReqCall setTaskId(String taskId) {
            this.pathParams.put("task_id", taskId);
            return this;
        }

        public TaskPatchReqCall setUserIdType(String userIdType) {
            this.queryParams.put("user_id_type", userIdType);
            return this;
        }

        @Override
        public Response<TaskPatchResult> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            this.optFns.add(Request.setQueryParams(this.queryParams));
            Request<TaskPatchReqBody, TaskPatchResult> request = Request.newRequest("/open-apis/task/v1/tasks/:task_id", "PATCH", new AccessTokenType[]{AccessTokenType.Tenant}, this.body, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.tasks.service.config, request);
        }
    }

    public static class TaskGetReqCall
    extends ReqCaller<Object, TaskGetResult> {
        private final Tasks tasks;
        private final Map<String, Object> pathParams = new HashMap<String, Object>();
        private final Map<String, Object> queryParams = new HashMap<String, Object>();
        private final List<RequestOptFn> optFns = new ArrayList<RequestOptFn>();
        private TaskGetResult result;

        private TaskGetReqCall(Tasks tasks, RequestOptFn ... optFns) {
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new TaskGetResult();
            this.tasks = tasks;
        }

        public TaskGetReqCall setTaskId(String taskId) {
            this.pathParams.put("task_id", taskId);
            return this;
        }

        public TaskGetReqCall setUserIdType(String userIdType) {
            this.queryParams.put("user_id_type", userIdType);
            return this;
        }

        @Override
        public Response<TaskGetResult> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            this.optFns.add(Request.setQueryParams(this.queryParams));
            Request<Object, TaskGetResult> request = Request.newRequest("/open-apis/task/v1/tasks/:task_id", "GET", new AccessTokenType[]{AccessTokenType.Tenant}, null, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.tasks.service.config, request);
        }
    }

    public static class TaskDeleteReqCall
    extends ReqCaller<Object, EmptyData> {
        private final Tasks tasks;
        private final Map<String, Object> pathParams = new HashMap<String, Object>();
        private final List<RequestOptFn> optFns = new ArrayList<RequestOptFn>();
        private EmptyData result;

        private TaskDeleteReqCall(Tasks tasks, RequestOptFn ... optFns) {
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new EmptyData();
            this.tasks = tasks;
        }

        public TaskDeleteReqCall setTaskId(String taskId) {
            this.pathParams.put("task_id", taskId);
            return this;
        }

        @Override
        public Response<EmptyData> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            Request<Object, EmptyData> request = Request.newRequest("/open-apis/task/v1/tasks/:task_id", "DELETE", new AccessTokenType[]{AccessTokenType.Tenant}, null, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.tasks.service.config, request);
        }
    }

    public static class TaskCreateReqCall
    extends ReqCaller<Task, TaskCreateResult> {
        private final Tasks tasks;
        private final Task body;
        private final Map<String, Object> queryParams;
        private final List<RequestOptFn> optFns;
        private TaskCreateResult result;

        private TaskCreateReqCall(Tasks tasks, Task body, RequestOptFn ... optFns) {
            this.body = body;
            this.queryParams = new HashMap<String, Object>();
            this.optFns = new ArrayList<RequestOptFn>();
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new TaskCreateResult();
            this.tasks = tasks;
        }

        public TaskCreateReqCall setUserIdType(String userIdType) {
            this.queryParams.put("user_id_type", userIdType);
            return this;
        }

        @Override
        public Response<TaskCreateResult> execute() throws Exception {
            this.optFns.add(Request.setQueryParams(this.queryParams));
            Request<Task, TaskCreateResult> request = Request.newRequest("/open-apis/task/v1/tasks", "POST", new AccessTokenType[]{AccessTokenType.Tenant}, this.body, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.tasks.service.config, request);
        }
    }

    public static class TaskCompleteReqCall
    extends ReqCaller<Object, EmptyData> {
        private final Tasks tasks;
        private final Map<String, Object> pathParams = new HashMap<String, Object>();
        private final List<RequestOptFn> optFns = new ArrayList<RequestOptFn>();
        private EmptyData result;

        private TaskCompleteReqCall(Tasks tasks, RequestOptFn ... optFns) {
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new EmptyData();
            this.tasks = tasks;
        }

        public TaskCompleteReqCall setTaskId(String taskId) {
            this.pathParams.put("task_id", taskId);
            return this;
        }

        @Override
        public Response<EmptyData> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            Request<Object, EmptyData> request = Request.newRequest("/open-apis/task/v1/tasks/:task_id/complete", "POST", new AccessTokenType[]{AccessTokenType.Tenant}, null, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.tasks.service.config, request);
        }
    }

    public static class Tasks {
        private final TaskService service;

        public Tasks(TaskService service) {
            this.service = service;
        }

        public TaskCompleteReqCall complete(RequestOptFn ... optFns) {
            return new TaskCompleteReqCall(this, optFns);
        }

        public TaskCreateReqCall create(Task body, RequestOptFn ... optFns) {
            return new TaskCreateReqCall(this, body, optFns);
        }

        public TaskDeleteReqCall delete(RequestOptFn ... optFns) {
            return new TaskDeleteReqCall(this, optFns);
        }

        public TaskGetReqCall get(RequestOptFn ... optFns) {
            return new TaskGetReqCall(this, optFns);
        }

        public TaskPatchReqCall patch(TaskPatchReqBody body, RequestOptFn ... optFns) {
            return new TaskPatchReqCall(this, body, optFns);
        }

        public TaskUncompleteReqCall uncomplete(RequestOptFn ... optFns) {
            return new TaskUncompleteReqCall(this, optFns);
        }
    }
}

