/*
 * Decompiled with CFR 0.152.
 */
package com.larksuite.oapi.service.tenant.v2;

import com.larksuite.oapi.core.Config;
import com.larksuite.oapi.core.api.AccessTokenType;
import com.larksuite.oapi.core.api.Api;
import com.larksuite.oapi.core.api.ReqCaller;
import com.larksuite.oapi.core.api.request.Request;
import com.larksuite.oapi.core.api.request.RequestOptFn;
import com.larksuite.oapi.core.api.response.Response;
import com.larksuite.oapi.service.tenant.v2.model.TenantQueryResult;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class TenantService {
    private final Config config;
    private final Tenants tenants;

    public TenantService(Config config) {
        this.config = config;
        this.tenants = new Tenants(this);
    }

    public Tenants getTenants() {
        return this.tenants;
    }

    public static class TenantQueryReqCall
    extends ReqCaller<Object, TenantQueryResult> {
        private final Tenants tenants;
        private final List<RequestOptFn> optFns = new ArrayList<RequestOptFn>();
        private TenantQueryResult result;

        private TenantQueryReqCall(Tenants tenants, RequestOptFn ... optFns) {
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new TenantQueryResult();
            this.tenants = tenants;
        }

        @Override
        public Response<TenantQueryResult> execute() throws Exception {
            Request<Object, TenantQueryResult> request = Request.newRequest("/open-apis/tenant/v2/tenant/query", "GET", new AccessTokenType[]{AccessTokenType.Tenant}, null, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.tenants.service.config, request);
        }
    }

    public static class Tenants {
        private final TenantService service;

        public Tenants(TenantService service) {
            this.service = service;
        }

        public TenantQueryReqCall query(RequestOptFn ... optFns) {
            return new TenantQueryReqCall(this, optFns);
        }
    }
}

