/*
 * Decompiled with CFR 0.152.
 */
package com.larksuite.oapi.service.translation.v1;

import com.larksuite.oapi.core.Config;
import com.larksuite.oapi.core.api.AccessTokenType;
import com.larksuite.oapi.core.api.Api;
import com.larksuite.oapi.core.api.ReqCaller;
import com.larksuite.oapi.core.api.request.Request;
import com.larksuite.oapi.core.api.request.RequestOptFn;
import com.larksuite.oapi.core.api.response.Response;
import com.larksuite.oapi.service.translation.v1.model.TextDetectReqBody;
import com.larksuite.oapi.service.translation.v1.model.TextDetectResult;
import com.larksuite.oapi.service.translation.v1.model.TextTranslateReqBody;
import com.larksuite.oapi.service.translation.v1.model.TextTranslateResult;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class TranslationService {
    private final Config config;
    private final Texts texts;

    public TranslationService(Config config) {
        this.config = config;
        this.texts = new Texts(this);
    }

    public Texts getTexts() {
        return this.texts;
    }

    public static class TextDetectReqCall
    extends ReqCaller<TextDetectReqBody, TextDetectResult> {
        private final Texts texts;
        private final TextDetectReqBody body;
        private final List<RequestOptFn> optFns;
        private TextDetectResult result;

        private TextDetectReqCall(Texts texts, TextDetectReqBody body, RequestOptFn ... optFns) {
            this.body = body;
            this.optFns = new ArrayList<RequestOptFn>();
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new TextDetectResult();
            this.texts = texts;
        }

        @Override
        public Response<TextDetectResult> execute() throws Exception {
            Request<TextDetectReqBody, TextDetectResult> request = Request.newRequest("/open-apis/translation/v1/text/detect", "POST", new AccessTokenType[]{AccessTokenType.Tenant}, this.body, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.texts.service.config, request);
        }
    }

    public static class TextTranslateReqCall
    extends ReqCaller<TextTranslateReqBody, TextTranslateResult> {
        private final Texts texts;
        private final TextTranslateReqBody body;
        private final List<RequestOptFn> optFns;
        private TextTranslateResult result;

        private TextTranslateReqCall(Texts texts, TextTranslateReqBody body, RequestOptFn ... optFns) {
            this.body = body;
            this.optFns = new ArrayList<RequestOptFn>();
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new TextTranslateResult();
            this.texts = texts;
        }

        @Override
        public Response<TextTranslateResult> execute() throws Exception {
            Request<TextTranslateReqBody, TextTranslateResult> request = Request.newRequest("/open-apis/translation/v1/text/translate", "POST", new AccessTokenType[]{AccessTokenType.Tenant}, this.body, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.texts.service.config, request);
        }
    }

    public static class Texts {
        private final TranslationService service;

        public Texts(TranslationService service) {
            this.service = service;
        }

        public TextTranslateReqCall translate(TextTranslateReqBody body, RequestOptFn ... optFns) {
            return new TextTranslateReqCall(this, body, optFns);
        }

        public TextDetectReqCall detect(TextDetectReqBody body, RequestOptFn ... optFns) {
            return new TextDetectReqCall(this, body, optFns);
        }
    }
}

