// Code generated by lark suite oapi sdk gen
package com.larksuite.oapi.service.application.v1;

import com.larksuite.oapi.core.Config;
import com.larksuite.oapi.core.event.Event;
import com.larksuite.oapi.core.event.IHandler;
import com.larksuite.oapi.service.application.v1.model.*;



public class ApplicationService {

    private static final String serviceBasePath = "application/v1";

    private final Config config;
    private final String basePath;
    private final Applications applications;

    public ApplicationService(Config config) {
        this.config = config;
        this.basePath = serviceBasePath;
        this.applications = new Applications(this);
    }

    public Applications getApplications() {
        return applications;
    }

    public static class Applications {

        private final ApplicationService service;

        public Applications(ApplicationService service) {
            this.service = service;
        }
    
    }
    public void setAppOpenEventHandler(AppOpenEventHandler handler) {
        Event.setTypeHandler(this.config, "app_open", handler);
    }

    public abstract static class AppOpenEventHandler implements IHandler<AppOpenEvent> {
        @Override
        public AppOpenEvent getEvent() {
            return new AppOpenEvent();
        }
    }
    public void setAppStatusChangeEventHandler(AppStatusChangeEventHandler handler) {
        Event.setTypeHandler(this.config, "app_status_change", handler);
    }

    public abstract static class AppStatusChangeEventHandler implements IHandler<AppStatusChangeEvent> {
        @Override
        public AppStatusChangeEvent getEvent() {
            return new AppStatusChangeEvent();
        }
    }
    public void setAppUninstalledEventHandler(AppUninstalledEventHandler handler) {
        Event.setTypeHandler(this.config, "app_uninstalled", handler);
    }

    public abstract static class AppUninstalledEventHandler implements IHandler<AppUninstalledEvent> {
        @Override
        public AppUninstalledEvent getEvent() {
            return new AppUninstalledEvent();
        }
    }
    public void setOrderPaidEventHandler(OrderPaidEventHandler handler) {
        Event.setTypeHandler(this.config, "order_paid", handler);
    }

    public abstract static class OrderPaidEventHandler implements IHandler<OrderPaidEvent> {
        @Override
        public OrderPaidEvent getEvent() {
            return new OrderPaidEvent();
        }
    }

}
