// Code generated by lark suite oapi sdk gen
package com.larksuite.oapi.service.speech_to_text.v1;

import com.larksuite.oapi.core.api.AccessTokenType;
import com.larksuite.oapi.core.api.Api;
import com.larksuite.oapi.core.api.ReqCaller;
import com.larksuite.oapi.core.api.request.*;
import com.larksuite.oapi.core.api.response.*;
import com.larksuite.oapi.core.Config;
import com.larksuite.oapi.service.speech_to_text.v1.model.*;
import java.util.Arrays;
import java.util.List;
import java.util.ArrayList;

public class SpeechToTextService {

    private final Config config;
    private final Speechs speechs;

    public SpeechToTextService(Config config) {
        this.config = config;
        this.speechs = new Speechs(this);
    }

    public Speechs getSpeechs() {
        return speechs;
    }

    public static class Speechs {

        private final SpeechToTextService service;

        public Speechs(SpeechToTextService service) {
            this.service = service;
        }
    
        public SpeechFileRecognizeReqCall fileRecognize(SpeechFileRecognizeReqBody body, RequestOptFn... optFns) {
            return new SpeechFileRecognizeReqCall(this, body, optFns);
        }
    
        public SpeechStreamRecognizeReqCall streamRecognize(SpeechStreamRecognizeReqBody body, RequestOptFn... optFns) {
            return new SpeechStreamRecognizeReqCall(this, body, optFns);
        }
    
    }
    public static class SpeechFileRecognizeReqCall extends ReqCaller<SpeechFileRecognizeReqBody, SpeechFileRecognizeResult> {
        private final Speechs speechs;
        
        private final SpeechFileRecognizeReqBody body;
        private final List<RequestOptFn> optFns;
        private SpeechFileRecognizeResult result;
        
        private SpeechFileRecognizeReqCall(Speechs speechs, SpeechFileRecognizeReqBody body, RequestOptFn... optFns) {
        
            this.body = body;
            this.optFns = new ArrayList<>();
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new SpeechFileRecognizeResult();
            this.speechs = speechs;
        }
        

        @Override
        public Response<SpeechFileRecognizeResult> execute() throws Exception {
            Request<SpeechFileRecognizeReqBody, SpeechFileRecognizeResult> request = Request.newRequest("speech_to_text/v1/speech/file_recognize", "POST",
                    new AccessTokenType[]{AccessTokenType.Tenant},
                    this.body, this.result, this.optFns.toArray(new RequestOptFn[]{}));
            return Api.send(this.speechs.service.config, request);
        }
    }
    public static class SpeechStreamRecognizeReqCall extends ReqCaller<SpeechStreamRecognizeReqBody, SpeechStreamRecognizeResult> {
        private final Speechs speechs;
        
        private final SpeechStreamRecognizeReqBody body;
        private final List<RequestOptFn> optFns;
        private SpeechStreamRecognizeResult result;
        
        private SpeechStreamRecognizeReqCall(Speechs speechs, SpeechStreamRecognizeReqBody body, RequestOptFn... optFns) {
        
            this.body = body;
            this.optFns = new ArrayList<>();
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new SpeechStreamRecognizeResult();
            this.speechs = speechs;
        }
        

        @Override
        public Response<SpeechStreamRecognizeResult> execute() throws Exception {
            Request<SpeechStreamRecognizeReqBody, SpeechStreamRecognizeResult> request = Request.newRequest("speech_to_text/v1/speech/stream_recognize", "POST",
                    new AccessTokenType[]{AccessTokenType.Tenant},
                    this.body, this.result, this.optFns.toArray(new RequestOptFn[]{}));
            return Api.send(this.speechs.service.config, request);
        }
    }

}
